/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunCircle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun3dCircle
extends JunCircle {
    protected double x0;
    protected double y0;
    protected double z0;
    protected Jun3dPoint upVector;

    private Jun3dCircle() {
    }

    public Jun3dCircle(Jun3dPoint jun3dPoint, double d) {
        this(jun3dPoint, d, new Jun3dPoint(0.0, 0.0, 1.0));
    }

    public Jun3dCircle(Jun3dPoint jun3dPoint, double d, Jun3dPoint jun3dPoint2) {
        this.setCenter_(jun3dPoint);
        this.setRadius_(d);
        this.setUpVector_(jun3dPoint2);
    }

    public Jun3dCircle(double d) {
        this(new Jun3dPoint(0.0, 0.0, 0.0), d, new Jun3dPoint(0.0, 0.0, 1.0));
    }

    public Jun3dCircle(double d, Jun3dPoint jun3dPoint) {
        this(new Jun3dPoint(0.0, 0.0, 0.0), d, jun3dPoint);
    }

    public Jun3dPoint center() {
        return new Jun3dPoint(this.x0, this.y0, this.z0);
    }

    protected JunPoint _center() {
        return this.center();
    }

    public Jun3dPoint upVector() {
        return this.upVector;
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dCircle jun3dCircle = (Jun3dCircle)((Object)object);
        return this.isEqualNumber_to_(this.x0, jun3dCircle.x0) && this.isEqualNumber_to_(this.y0, jun3dCircle.y0) && this.isEqualNumber_to_(this.z0, jun3dCircle.z0) && this.uv().minus_(jun3dCircle.uv()).abs().isLessThan_(Jun3dPoint.Coerce_(this.accuracy()));
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dCircle jun3dCircle = (Jun3dCircle)((Object)object);
        return this.x0() == jun3dCircle.x0() && this.y0() == jun3dCircle.y0() && this.z0() == jun3dCircle.z0() && this.uv().equals((Object)jun3dCircle.uv());
    }

    public JunPlane[] asArrayOfPlanes() {
        return new JunPlane[]{this.asPlane()};
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.CircleBy_radius_upVector_(10.0, this.radius(), this.upVector()).translatedBy_(this.center());
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_(Jun3dCircle.this.defaultColor());
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunPlane asPlane() {
        return JunPlane.On_vertical_(this.center(), new Jun3dPoint(0.0, 0.0, 0.0).to_(this.upVector()));
    }

    public Jun3dTriangle asTriangle() {
        return Jun3dTriangle.On_normalVector_distance_(this.center(), this.upVector(), this.radius());
    }

    public Jun3dPoint[] trackPoints() {
        return this.trackPointsBy_(36);
    }

    public Jun3dPoint[] trackPointsBy_(int n) {
        ArrayList<Jun3dPoint> arrayList = new ArrayList<Jun3dPoint>();
        JunPlane junPlane = this.asPlane();
        Jun3dLine jun3dLine = this.center().to_(this.center().plus_(this.upVector()));
        Jun3dPoint jun3dPoint = this.center().to_(junPlane.p2()).normalized().atT_(this.radius());
        Jun3dLine jun3dLine2 = jun3dLine.translatedBy_(jun3dPoint.minus_(this.center()));
        for (int i = 0; i <= n; ++i) {
            double d = 360.0 * (double)i / (double)n;
            Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(d), jun3dLine);
            Jun3dLine jun3dLine3 = jun3dLine2.transform_(jun3dTransformation);
            jun3dPoint = junPlane.intersectingPointWithLine_(jun3dLine3);
            arrayList.add(jun3dPoint);
        }
        return arrayList.toArray(new Jun3dPoint[arrayList.size()]);
    }

    public Jun3dPoint uv() {
        return this.upVector();
    }

    public double x0() {
        return this.x0;
    }

    public double y0() {
        return this.y0;
    }

    public double z0() {
        return this.z0;
    }

    public void printOn_(Writer writer) throws IOException {
        if (this.upVector().equal_((Object)new Jun3dPoint(0.0, 0.0, 1.0))) {
            super.printOn_(writer);
        } else {
            writer.write(40);
            this.center().printOn_(writer);
            writer.write(" radius: ");
            writer.write(String.valueOf(this.radius()));
            writer.write(" upVector: ");
            this.upVector().printOn_(writer);
            writer.write(41);
        }
    }

    public void storeOn_(Writer writer) throws IOException {
        if (this.upVector().equals((Object)new Jun3dPoint(0.0, 0.0, 1.0))) {
            super.storeOn_(writer);
        } else {
            writer.write(40);
            writer.write(this._className().toString());
            writer.write(" center: ");
            writer.write(this.center().printString());
            writer.write(" radius: ");
            writer.write(String.valueOf(this.radius()));
            writer.write(" upVector: ");
            writer.write(this.upVector().printString());
            writer.write(41);
        }
    }

    public Jun3dCircle rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun3dTransformation.Rotate_(junAngle));
    }

    public Jun3dCircle scaledBy_(double d) {
        return this.transform_(Jun3dTransformation.Scale_(d));
    }

    public Jun3dCircle scaledBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Scale_(jun3dPoint));
    }

    public Jun3dCircle transform_(Jun3dTransformation jun3dTransformation) {
        boolean bl;
        double d = this.accuracy();
        Jun3dPoint[] jun3dPointArray = this.trackPointsBy_(4);
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray2[i] = jun3dPointArray[i].transform_(jun3dTransformation);
        }
        Jun3dPoint jun3dPoint = jun3dPointArray2[0];
        Jun3dPoint jun3dPoint2 = jun3dPointArray2[1];
        Jun3dPoint jun3dPoint3 = jun3dPointArray2[2];
        Jun3dPoint jun3dPoint4 = jun3dPointArray2[3];
        Jun3dPoint jun3dPoint5 = jun3dPoint3.minus_(jun3dPoint);
        Jun3dPoint jun3dPoint6 = jun3dPoint4.minus_(jun3dPoint2);
        if (jun3dPoint5.length() < d || jun3dPoint6.length() < d) {
            if (jun3dPoint5.length() < d && jun3dPoint6.length() < d) {
                throw new IllegalArgumentException("transformed circle too small to define upVector");
            }
            throw new IllegalArgumentException("transformation on the circle does not make a circle");
        }
        boolean bl2 = Math.abs(jun3dPoint5.unitVector().dotProduct_(jun3dPoint6.unitVector())) < d;
        boolean bl3 = bl = bl2 && Math.abs(jun3dPoint5.length() - jun3dPoint6.length()) < d;
        if (!bl) {
            throw new IllegalArgumentException("transformation on the circle does not make a circle");
        }
        Jun3dPoint jun3dPoint7 = this.center().transform_(jun3dTransformation);
        double d2 = (jun3dPoint5.length() + jun3dPoint6.length()) / 4.0;
        Jun3dPoint jun3dPoint8 = new Jun3dPoint(0.0, 0.0, 0.0).to_(this.upVector()).transform_(jun3dTransformation).normalVector();
        if (jun3dPoint8.length() < d) {
            JunPlane junPlane = new JunPlane(jun3dPointArray[0], jun3dPointArray[1], jun3dPointArray[2]);
            if (junPlane.normalVector().dotProduct_(this.upVector()) < 0.0) {
                junPlane = junPlane.reversed();
            }
            jun3dPoint8 = junPlane.transform_(jun3dTransformation).normalVector();
        }
        return new Jun3dCircle(jun3dPoint7, d2, jun3dPoint8);
    }

    public Jun3dCircle translatedBy_(double d) {
        return this.transform_(Jun3dTransformation.Translate_(d));
    }

    public Jun3dCircle translatedBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Translate_(jun3dPoint));
    }

    public boolean is3d() {
        return true;
    }

    public int whichSideOf_(JunPlane junPlane) {
        int n = this.center().whichSideOf_(junPlane);
        if (n == 0) {
            return 0;
        }
        if (junPlane.intersectingLineWithPlane_(this.asPlane()).distanceFromPoint_(this.center()) <= this.radius()) {
            return 0;
        }
        return n;
    }

    protected void setCenter_(Jun3dPoint jun3dPoint) {
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(jun3dPoint);
        this.setX0_(jun3dPoint2.x());
        this.setY0_(jun3dPoint2.y());
        this.setZ0_(jun3dPoint2.z());
    }

    protected void setUpVector_(Jun3dPoint jun3dPoint) {
        this.upVector = Jun3dPoint.Coerce_(jun3dPoint);
    }

    protected void setUV_(Jun3dPoint jun3dPoint) {
        this.setUpVector_(jun3dPoint);
    }

    protected void setX0_(double d) {
        this.x0 = d;
    }

    protected void setY0_(double d) {
        this.y0 = d;
    }

    protected void setZ0_(double d) {
        this.z0 = d;
    }
}

