/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.curves;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dPolyline;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.JunPolyline;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun3dPolyline
extends JunPolyline {
    protected Jun3dPoint[] points;
    protected Jun3dBoundingBox boundingBox;
    protected double[] segmentLengths;

    public Jun3dPolyline(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        this(new Jun3dPoint[]{jun3dPoint, jun3dPoint2});
    }

    public Jun3dPolyline(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        this(new Jun3dPoint[]{jun3dPoint, jun3dPoint2, jun3dPoint3});
    }

    public Jun3dPolyline(Jun3dPoint[] jun3dPointArray) {
        this.setPoints_(jun3dPointArray);
    }

    protected void initialize() {
        super.initialize();
        this.points = null;
        this.boundingBox = null;
        this.segmentLengths = null;
    }

    public Jun3dPoint[] points() {
        if (this.points == null) {
            this.points = new Jun3dPoint[0];
        }
        return this.points;
    }

    protected JunPoint[] _points() {
        return this.points();
    }

    public Jun3dPoint pointAt_(int n) {
        return this.points()[n];
    }

    public Jun3dPoint atT_(double d) {
        if (d <= 0.0) {
            return this.pointAt_(0);
        }
        if (1.0 <= d) {
            return this.pointAt_(this.numberOfPoints() - 1);
        }
        double d2 = this.length() * d;
        for (int i = 1; i < this.numberOfPoints(); ++i) {
            double d3 = this.segmentLengths[i - 1];
            double d4 = this.segmentLengths[i];
            if (!(d3 <= d2) || !(d2 <= d4)) continue;
            Jun3dLine jun3dLine = this.pointAt_(i - 1).to_(this.pointAt_(i));
            return jun3dLine.atT_((d2 - d3) / (d4 - d3));
        }
        throw SmalltalkException.Error((String)"unexpected error");
    }

    public Jun3dPoint atX_(double d) {
        Jun3dLine[] jun3dLineArray = this.asArrayOfLines();
        for (int i = 0; i < jun3dLineArray.length; ++i) {
            if (!(jun3dLineArray[i].from().x() <= d) || !(d <= jun3dLineArray[i].to().x())) continue;
            return jun3dLineArray[i].atX_(d);
        }
        throw SmalltalkException.Error((String)"unexpected error");
    }

    public Jun3dPoint atY_(double d) {
        Jun3dLine[] jun3dLineArray = this.asArrayOfLines();
        for (int i = 0; i < jun3dLineArray.length; ++i) {
            if (!(jun3dLineArray[i].from().y() <= d) || !(d <= jun3dLineArray[i].to().y())) continue;
            return jun3dLineArray[i].atY_(d);
        }
        throw SmalltalkException.Error((String)"unexpected error");
    }

    public Jun3dPoint atZ_(double d) {
        Jun3dLine[] jun3dLineArray = this.asArrayOfLines();
        for (int i = 0; i < jun3dLineArray.length; ++i) {
            if (!(jun3dLineArray[i].from().z() <= d) || !(d <= jun3dLineArray[i].to().z())) continue;
            return jun3dLineArray[i].atZ_(d);
        }
        throw SmalltalkException.Error((String)"unexpected error");
    }

    public Jun3dPoint from() {
        return this.atT_(0.0);
    }

    public Jun3dPoint to() {
        return this.atT_(1.0);
    }

    public int numberOfPoints() {
        return this.size();
    }

    public double length() {
        if (this.segmentLengths == null) {
            double d;
            double[] dArray = new double[this.numberOfPoints()];
            dArray[0] = d = 0.0;
            for (int i = 1; i < this.numberOfPoints(); ++i) {
                dArray[i] = d += this.pointAt_(i - 1).distance_(this.pointAt_(i));
            }
            this.segmentLengths = dArray;
        }
        return this.segmentLengths[this.segmentLengths.length - 1];
    }

    public Jun3dPoint normalVector() {
        Jun3dPoint jun3dPoint = Jun3dPoint.Zero();
        int n = this.numberOfPoints();
        for (int i = 0; i < n; ++i) {
            Jun3dPoint jun3dPoint2 = this.pointAt_(i);
            Jun3dPoint jun3dPoint3 = this.pointAt_((i + 1) % n);
            Jun3dPoint jun3dPoint4 = this.pointAt_((i + 2) % n);
            jun3dPoint = jun3dPoint.plus_(jun3dPoint3.minus_(jun3dPoint2).vectorProduct_(jun3dPoint4.minus_(jun3dPoint3)));
        }
        return jun3dPoint;
    }

    public Jun3dPoint normalUnitVector() {
        return this.normalVector().unitVector();
    }

    public int size() {
        return this.points().length;
    }

    public Jun3dBoundingBox boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = this.preferredBoundingBox();
        }
        return this.boundingBox;
    }

    protected Jun3dBoundingBox preferredBoundingBox() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        Jun3dPoint[] jun3dPointArray = this.points();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            d = Math.min(d, jun3dPointArray[i].x());
            d2 = Math.min(d2, jun3dPointArray[i].y());
            d3 = Math.min(d3, jun3dPointArray[i].z());
            d4 = Math.max(d4, jun3dPointArray[i].x());
            d5 = Math.max(d5, jun3dPointArray[i].y());
            d6 = Math.max(d6, jun3dPointArray[i].z());
        }
        if (d == Double.MAX_VALUE) {
            d = 0.0;
        }
        if (d2 == Double.MAX_VALUE) {
            d2 = 0.0;
        }
        if (d3 == Double.MAX_VALUE) {
            d3 = 0.0;
        }
        if (d4 == Double.MIN_VALUE) {
            d4 = 0.0;
        }
        if (d5 == Double.MIN_VALUE) {
            d5 = 0.0;
        }
        if (d6 == Double.MIN_VALUE) {
            d6 = 0.0;
        }
        return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(d, d2, d3), new Jun3dPoint(d4, d5, d6));
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dPolyline jun3dPolyline = (Jun3dPolyline)((Object)object);
        if (this.numberOfPoints() != jun3dPolyline.numberOfPoints()) {
            return false;
        }
        for (int i = 0; i < this.numberOfPoints(); ++i) {
            if (this.pointAt_(i).equal_((Object)jun3dPolyline.pointAt_(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dPolyline jun3dPolyline = (Jun3dPolyline)((Object)object);
        if (this.numberOfPoints() != jun3dPolyline.numberOfPoints()) {
            return false;
        }
        for (int i = 0; i < this.numberOfPoints(); ++i) {
            if (this.pointAt_(i).equals((Object)jun3dPolyline.pointAt_(i))) continue;
            return false;
        }
        return true;
    }

    public Jun2dPoint[] as2dPoints() {
        Jun3dPoint[] jun3dPointArray = this.points();
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray[i] = jun3dPointArray[i].as2dPoint();
        }
        return jun2dPointArray;
    }

    public Jun3dPoint[] as3dPoints() {
        return this.points();
    }

    public Jun3dLine[] asArrayOfLines() {
        return this.asArrayOf3dLines();
    }

    public Jun3dLine[] asArrayOf3dLines() {
        Jun3dPoint[] jun3dPointArray = this.points();
        Jun3dLine[] jun3dLineArray = new Jun3dLine[jun3dPointArray.length - 1];
        for (int i = 0; i < jun3dPointArray.length - 1; ++i) {
            jun3dLineArray[i] = jun3dPointArray[i].to_(jun3dPointArray[i + 1]);
        }
        return jun3dLineArray;
    }

    public Jun3dPoint[] asArrayOfPoints() {
        return this.points();
    }

    public Jun3dTriangle[] asArrayOfTriangles() {
        return this.asArrayOf3dTriangles();
    }

    public Jun3dPolygon asPolygon() {
        return Jun3dPolygon.Vertexes_(this.points());
    }

    public Jun3dPolyline asPolyline() {
        return this;
    }

    public Jun3dPolyline reversed() {
        Jun3dPoint[] jun3dPointArray = this.points();
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray2[jun3dPointArray2.length - 1 - i] = jun3dPointArray[i];
        }
        return new Jun3dPolyline(jun3dPointArray2);
    }

    public Jun3dTriangle[] asArrayOf3dTriangles() {
        if (this.numberOfPoints() < 3) {
            return new Jun3dTriangle[0];
        }
        return this.asArrayOf3dTrianglesOn_(JunPlane.On_normalVector_(this.from(), this.normalVector()));
    }

    public Jun3dTriangle[] asArrayOf3dTrianglesOn_(JunPlane junPlane) {
        if (this.numberOfPoints() < 3) {
            return new Jun3dTriangle[0];
        }
        Object[] objectArray = this.asArrayOf2dPointsAndTableOn_(junPlane);
        Jun2dPoint[] jun2dPointArray = (Jun2dPoint[])objectArray[0];
        Map map = (Map)objectArray[1];
        ArrayList<Jun3dTriangle> arrayList = new ArrayList<Jun3dTriangle>();
        Jun2dTriangle[] jun2dTriangleArray = new Jun2dPolyline(jun2dPointArray).asArrayOfTriangles();
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)map.get((Object)jun2dTriangleArray[i].p1()));
            Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)map.get((Object)jun2dTriangleArray[i].p2()));
            Jun3dPoint jun3dPoint3 = (Jun3dPoint)((Object)map.get((Object)jun2dTriangleArray[i].p3()));
            arrayList.add(Jun3dTriangle.On_on_on_(jun3dPoint, jun3dPoint2, jun3dPoint3));
        }
        return arrayList.toArray(new Jun3dTriangle[arrayList.size()]);
    }

    protected Object[] asArrayOf2dPointsAndTableOn_(JunPlane junPlane) {
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        HashMap<Jun2dPoint, Jun3dPoint> hashMap = new HashMap<Jun2dPoint, Jun3dPoint>();
        Jun3dPoint jun3dPoint = junPlane.normalUnitVector();
        Jun3dLine jun3dLine = junPlane.p1().to_(junPlane.p2());
        Jun3dLine jun3dLine2 = jun3dLine.transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(90.0), Jun3dPoint.Zero().to_(jun3dPoint)));
        JunPlane junPlane2 = JunPlane.On_vertical_(junPlane.p1(), jun3dLine);
        JunPlane junPlane3 = JunPlane.On_vertical_(junPlane.p1(), jun3dLine2);
        Jun3dPoint[] jun3dPointArray = this.points();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            Jun3dLine jun3dLine3 = jun3dPointArray[i].to_(jun3dPointArray[i].plus_(jun3dPoint));
            Jun3dPoint jun3dPoint2 = junPlane.intersectingPointWithLine_(jun3dLine3);
            double d = junPlane2.distanceFromPoint_(jun3dPoint2) * (double)jun3dPoint2.whichSideOf_(junPlane2);
            double d2 = junPlane3.distanceFromPoint_(jun3dPoint2) * (double)jun3dPoint2.whichSideOf_(junPlane3);
            Jun2dPoint jun2dPoint = new Jun2dPoint(d, d2);
            arrayList.add(jun2dPoint);
            hashMap.put(jun2dPoint, jun3dPointArray[i]);
        }
        return new Object[]{arrayList.toArray(new Jun2dPoint[arrayList.size()]), hashMap};
    }

    public Jun3dPolyline subdivide() {
        Jun3dPoint[] jun3dPointArray = this.points();
        ArrayList<Jun3dPoint> arrayList = new ArrayList<Jun3dPoint>(this.size() * 2 - 1);
        for (int i = 0; i < jun3dPointArray.length - 1; ++i) {
            arrayList.add(jun3dPointArray[i]);
            arrayList.add(jun3dPointArray[i].to_(jun3dPointArray[i + 1]).center());
        }
        arrayList.add(jun3dPointArray[jun3dPointArray.length - 1]);
        Jun3dPolyline jun3dPolyline = new Jun3dPolyline(arrayList.toArray(new Jun3dPoint[arrayList.size()]));
        return jun3dPolyline;
    }

    public Jun3dPolyline subdivideLevel_(int n) {
        Jun3dPolyline jun3dPolyline = (Jun3dPolyline)this.copy();
        for (int i = 0; i < n; ++i) {
            jun3dPolyline = jun3dPolyline.subdivide();
        }
        return jun3dPolyline;
    }

    public Jun3dPolyline subdivideAsSpline() {
        return new Jun3dPolyline(this.computeSplinePoints_(this.points()));
    }

    public Jun3dPolyline subdivideAsSplineLevel_(int n) {
        Jun3dPolyline jun3dPolyline = this;
        for (int i = 0; i < n; ++i) {
            jun3dPolyline = jun3dPolyline.subdivideAsSpline();
        }
        return jun3dPolyline;
    }

    public boolean is3d() {
        return true;
    }

    public Jun3dTriangle[] sew_(Jun3dPolyline jun3dPolyline) {
        return this.sew_interim_(jun3dPolyline, null);
    }

    public Jun3dTriangle[] sew_interim_(Jun3dPolyline jun3dPolyline, StBlockClosure stBlockClosure) {
        Jun3dPoint jun3dPoint;
        int n;
        Jun3dPoint jun3dPoint2;
        Jun3dPoint jun3dPoint3;
        int n2;
        ArrayList<Jun3dTriangle> arrayList = new ArrayList<Jun3dTriangle>();
        Jun3dPoint[] jun3dPointArray = jun3dPolyline.points();
        for (n2 = 1; n2 < jun3dPointArray.length; ++n2) {
            jun3dPoint3 = jun3dPointArray[n2 - 1];
            jun3dPoint2 = jun3dPointArray[n2];
            n = this.findIndexOfPoints_from_to_interim_(this.points(), jun3dPoint3, jun3dPoint2, stBlockClosure);
            if (n < 0) continue;
            jun3dPoint = this.pointAt_(n);
            arrayList.add(new Jun3dTriangle(jun3dPoint3, jun3dPoint2, jun3dPoint));
        }
        jun3dPointArray = this.points();
        for (n2 = 1; n2 < jun3dPointArray.length; ++n2) {
            jun3dPoint3 = jun3dPointArray[n2 - 1];
            jun3dPoint2 = jun3dPointArray[n2];
            n = this.findIndexOfPoints_from_to_interim_(jun3dPolyline.points(), jun3dPoint3, jun3dPoint2, stBlockClosure);
            if (n < 0) continue;
            jun3dPoint = jun3dPolyline.pointAt_(n);
            arrayList.add(new Jun3dTriangle(jun3dPoint2, jun3dPoint3, jun3dPoint));
        }
        return arrayList.toArray(new Jun3dTriangle[arrayList.size()]);
    }

    protected int findIndexOfPoints_from_to_interim_(Jun3dPoint[] jun3dPointArray, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, StBlockClosure stBlockClosure) {
        JunGeometry junGeometry;
        if (jun3dPointArray == null || jun3dPointArray.length == 0) {
            return -1;
        }
        double d = jun3dPoint.distance_(jun3dPoint2);
        TreeMap<JunAngle, double[]> treeMap = new TreeMap<JunAngle, double[]>(new Comparator(){

            public int compare(Object object, Object object2) {
                double d = ((JunAngle)object).rad() - ((JunAngle)object2).rad();
                return d < 0.0 ? 1 : (d > 0.0 ? -1 : 0);
            }
        });
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            junGeometry = jun3dPointArray[i];
            double d2 = ((Jun3dPoint)junGeometry).distance_(jun3dPoint);
            double d3 = ((Jun3dPoint)junGeometry).distance_(jun3dPoint2);
            JunAngle junAngle = jun3dPoint.to_((JunPoint)junGeometry).angleWithLine_(jun3dPoint2.to_((JunPoint)junGeometry));
            double[] dArray = new double[]{d2, d3, i};
            treeMap.put(junAngle, dArray);
            if (stBlockClosure == null) continue;
            stBlockClosure.valueWithArguments_(new Object[]{new Jun3dPoint[]{jun3dPoint, jun3dPoint2, junGeometry}, Jun3dPolyline.$((String)"pending")});
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            junGeometry = (JunAngle)iterator.next();
            double[] dArray = (double[])treeMap.get((Object)junGeometry);
            double d4 = dArray[0];
            double d5 = dArray[1];
            int n = (int)dArray[2];
            if (!(((JunAngle)junGeometry).rad() > Jun3dPolyline.Accuracy()) || !(Math.abs(d + d4 - d5) > Jun3dPolyline.Accuracy()) || !(Math.abs(d + d5 - d4) > Jun3dPolyline.Accuracy())) continue;
            if (stBlockClosure != null) {
                stBlockClosure.valueWithArguments_(new Object[]{new Jun3dPoint[]{jun3dPoint, jun3dPoint2, jun3dPointArray[n]}, Jun3dPolyline.$((String)"decided")});
            }
            return n;
        }
        return -1;
    }

    protected void setPoints_(Jun3dPoint[] jun3dPointArray) {
        this.points = jun3dPointArray;
        this.boundingBox = null;
        this.segmentLengths = null;
    }

    protected Jun3dPoint[] computeSplinePoints_(Jun3dPoint[] jun3dPointArray) {
        int n;
        Jun3dPoint[] jun3dPointArray2;
        int n2;
        int n3 = jun3dPointArray.length;
        if (n3 < 3) {
            Jun3dPoint[] jun3dPointArray3 = new Jun3dPoint[n3];
            System.arraycopy(jun3dPointArray, 0, jun3dPointArray3, 0, n3);
            return jun3dPointArray3;
        }
        int n4 = 0;
        Jun3dPoint[] jun3dPointArray4 = jun3dPointArray;
        if (this.size() > 3 && this.from().equals((Object)this.to())) {
            n4 = 2;
            jun3dPointArray4 = new Jun3dPoint[2 * n4 + n3];
            for (int i = 0; i < n4; ++i) {
                jun3dPointArray4[i] = this.points()[n3 - n4 + i - 1];
                jun3dPointArray4[n3 + n4 + i] = this.points()[i + 1];
            }
            System.arraycopy(jun3dPointArray, 0, jun3dPointArray4, n4, n3);
        }
        Jun3dPoint[][] jun3dPointArrayArray = new Jun3dPoint[3][];
        for (n2 = 0; n2 < jun3dPointArrayArray.length; ++n2) {
            jun3dPointArrayArray[n2] = new Jun3dPoint[jun3dPointArray4.length];
        }
        n2 = jun3dPointArray4.length;
        if (n2 > 2) {
            int n5;
            double[] dArray = new double[n2];
            dArray[0] = 4.0;
            jun3dPointArray2 = new Jun3dPoint[n2];
            jun3dPointArray2[0] = jun3dPointArray4[0].minus_(jun3dPointArray4[1].multipliedBy_(2.0)).plus_(jun3dPointArray4[2]).multipliedBy_(6.0);
            for (n5 = 1; n5 <= n2 - 3; ++n5) {
                dArray[n5] = 4.0 - 1.0 / dArray[n5 - 1];
                jun3dPointArray2[n5] = jun3dPointArray4[n5].minus_(jun3dPointArray4[n5 + 1].multipliedBy_(2.0)).plus_(jun3dPointArray4[n5 + 2]).multipliedBy_(6.0).minus_(jun3dPointArray2[n5 - 1].dividedBy_(dArray[n5 - 1]));
            }
            jun3dPointArrayArray[1][n2 - 2] = jun3dPointArray2[n2 - 3].dividedBy_(dArray[n2 - 3]);
            for (n5 = n2 - 3; n5 >= 1; --n5) {
                jun3dPointArrayArray[1][n5] = jun3dPointArray2[n5 - 1].minus_(jun3dPointArrayArray[1][n5 + 1]).dividedBy_(dArray[n5 - 1]);
            }
        }
        jun3dPointArrayArray[1][0] = Jun3dPoint.Zero();
        jun3dPointArrayArray[1][n2 - 1] = Jun3dPoint.Zero();
        for (n = 0; n <= n2 - 2; ++n) {
            jun3dPointArrayArray[0][n] = jun3dPointArray4[n + 1].minus_(jun3dPointArray4[n]).minus_(jun3dPointArrayArray[1][n].multipliedBy_(2.0).plus_(jun3dPointArrayArray[1][n + 1]).dividedBy_(6.0));
            jun3dPointArrayArray[2][n] = jun3dPointArrayArray[1][n + 1].minus_(jun3dPointArrayArray[1][n]);
        }
        if (n4 > 0) {
            for (n = 0; n < 3; ++n) {
                jun3dPointArray2 = new Jun3dPoint[n3];
                System.arraycopy(jun3dPointArrayArray[n], n4, jun3dPointArray2, 0, n3);
                jun3dPointArrayArray[n] = jun3dPointArray2;
            }
        }
        LinkedList<Jun3dPoint> linkedList = new LinkedList<Jun3dPoint>();
        linkedList.add(this.from());
        for (int i = 0; i < this.size() - 1; ++i) {
            Jun3dPoint jun3dPoint = jun3dPointArray[i];
            Jun3dPoint jun3dPoint2 = jun3dPointArrayArray[0][i];
            Jun3dPoint jun3dPoint3 = jun3dPointArrayArray[1][i].dividedBy_(2.0);
            Jun3dPoint jun3dPoint4 = jun3dPointArrayArray[2][i].dividedBy_(6.0);
            Jun3dPoint jun3dPoint5 = jun3dPointArrayArray[1][i].abs().plus_(jun3dPointArrayArray[1][i + 1].abs());
            int n6 = (int)Math.max(4.0, Math.floor((jun3dPoint5.x() + jun3dPoint5.y()) / 100.0));
            for (int j = 1; j <= n6; ++j) {
                double d = (double)j / (double)n6;
                jun3dPoint5 = jun3dPoint4.multipliedBy_(d).plus_(jun3dPoint3).multipliedBy_(d).plus_(jun3dPoint2).multipliedBy_(d).plus_(jun3dPoint);
                if (jun3dPoint5.equal_(linkedList.getLast())) continue;
                linkedList.add(jun3dPoint5);
            }
            jun3dPoint5 = jun3dPointArray[i + 1];
            if (jun3dPoint5.equal_(linkedList.getLast())) continue;
            linkedList.add(jun3dPoint5);
        }
        return linkedList.toArray(new Jun3dPoint[linkedList.size()]);
    }
}

