/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boxtree;

import java.awt.Color;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boxtree.Jun2dBoundingBoxNode;
import jp.co.sra.jun.geometry.boxtree.JunBoundingBoxTree;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;

public class Jun2dBoundingBoxTree
extends JunBoundingBoxTree {
    protected Jun2dBoundingBoxNode rootNode;
    protected Jun2dBoundingBoxNode[] subdividedNodes;

    protected Jun2dBoundingBoxTree() {
    }

    public Jun2dBoundingBoxTree(Jun2dLine[] jun2dLineArray) {
        this();
        this.rootNode_(new Jun2dBoundingBoxNode(jun2dLineArray));
    }

    public Jun2dBoundingBoxTree(Jun2dPoint[] jun2dPointArray) {
        this();
        this.rootNode_(new Jun2dBoundingBoxNode(jun2dPointArray));
    }

    public Jun2dBoundingBoxTree(Jun2dTriangle[] jun2dTriangleArray) {
        this();
        this.rootNode_(new Jun2dBoundingBoxNode(jun2dTriangleArray));
    }

    protected void initialize() {
        super.initialize();
        this.rootNode = null;
        this.subdividedNodes = null;
    }

    public Jun2dBoundingBox boundingBox() {
        return this.rootNode().boundingBox();
    }

    public JunGeometry[] containedObjects() {
        return this.rootNode().containedObjects();
    }

    public Jun2dBoundingBoxNode rootNode() {
        return this.rootNode;
    }

    public void rootNode_(Jun2dBoundingBoxNode jun2dBoundingBoxNode) {
        this.rootNode = jun2dBoundingBoxNode;
    }

    public Jun2dBoundingBoxNode[] subdividedNodes() {
        if (this.subdividedNodes == null) {
            this.subdividedNodesLevel_(1);
        }
        return this.subdividedNodes;
    }

    public Jun2dBoundingBoxNode[] subdividedNodesLevel_(int n) {
        this.levelNumber = n;
        this.subdividedNodes = this.rootNode().subdividedNodesLevel_(this.levelNumber);
        this.rootNode().flushSubdividedNodes();
        return this.subdividedNodes;
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this.boundingBox().equal_((Object)((Jun2dBoundingBoxTree)((Object)object)).boundingBox());
    }

    public Jun2dBoundingBox asBoundingBox() {
        return this.boundingBox();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun2dBoundingBoxNode[] jun2dBoundingBoxNodeArray = this.subdividedNodes();
        for (int i = 0; i < jun2dBoundingBoxNodeArray.length; ++i) {
            junOpenGL3dCompoundObject.add_(jun2dBoundingBoxNodeArray[i].asJunOpenGL3dObjectColor_alpha_(Color.getHSBColor((float)i / (float)jun2dBoundingBoxNodeArray.length, 1.0f, 1.0f), 0.25f));
            Jun2dPoint[][] jun2dPointArray = jun2dBoundingBoxNodeArray[i].boundingBox().pps();
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray[j].length];
                for (int k = 0; k < jun3dPointArray.length; ++k) {
                    jun3dPointArray[k] = jun2dPointArray[j][k].as3dPoint();
                }
                JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArray);
                junOpenGL3dPolylineLoop.paint_(Color.gray);
                junOpenGL3dPolylineLoop.lineWidth_(1.0f);
                junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop);
            }
        }
        return junOpenGL3dCompoundObject;
    }

    public boolean is2d() {
        return true;
    }
}

