/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.gl4jun;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import jp.co.sra.gl4jun.GLjInterface;
import jp.co.sra.gl4jun.GLjRenderingContext;
import jp.co.sra.smalltalk.SmalltalkException;

public class GLjJCanvas
extends JComponent {
    protected int renderingMode;
    protected transient GLjRenderingContext renderingContext;
    protected transient boolean resizeRequest;
    protected transient boolean moveRequest;

    public GLjJCanvas() {
        this.initialize();
    }

    protected void initialize() {
        this.setPreferredSize(new Dimension(256, 256));
        this.setRenderingMode(2);
    }

    public void removeNotify() {
        if (this.renderingContext != null) {
            Container container;
            for (container = this.getParent(); container != null && !(container instanceof Applet); container = container.getParent()) {
            }
            this.renderingContext.gljDelete(container != null);
            this.renderingContext = null;
        }
        super.removeNotify();
    }

    public void setRenderingMode(int n) {
        switch (n) {
            case 0: 
            case 2: {
                this.renderingMode = n;
                RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.renderingMode = n;
                RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
                break;
            }
            default: {
                throw new SmalltalkException("Invalid rendering mode : " + n);
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        if (rectangle.x != n || rectangle.y != n2) {
            this.moveRequest = true;
        }
        if (rectangle.width != n3 || rectangle.height != n4) {
            this.resizeRequest = true;
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected GLjRenderingContext defaultRenderingContext() {
        Component component = SwingUtilities.getRoot(this);
        return new GLjRenderingContext(this, (JFrame)component);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.render(graphics);
        this.superimposeOn(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        GLjInterface gLjInterface = GLjInterface.Current();
        synchronized (gLjInterface) {
            if (this.renderingContext == null) {
                this.renderingContext = this.defaultRenderingContext();
                this.renderingContext.setMode(this.renderingMode);
                this.resizeRequest = false;
                this.moveRequest = true;
                this.renderingContext.gljInitialize();
            }
        }
        if (this.renderingContext.getMode() != 0) {
            gLjInterface = GLjRenderingContext.OpenGLInterface;
            synchronized (gLjInterface) {
                Object object;
                if (this.resizeRequest) {
                    this.renderingContext.gljResize(this.getSize());
                    this.resizeRequest = false;
                }
                if (this.moveRequest) {
                    object = this.getRootPane().getLocationOnScreen();
                    Point point = this.getLocationOnScreen();
                    Point point2 = new Point(point.x - ((Point)object).x, point.y - ((Point)object).y);
                    this.renderingContext.gljSetLocation(point2);
                    this.moveRequest = false;
                }
                this.renderingContext.gljCurrent();
                this.render(this.renderingContext);
                if (this.renderingContext.getMode() == 2) {
                    object = this.renderingContext.gljImageRGB();
                    graphics.drawImage((Image)object, 0, 0, null);
                }
                this.renderingContext.gljFlush();
            }
        }
    }

    protected void render(GLjRenderingContext gLjRenderingContext) {
        this.render(GLjRenderingContext.OpenGLInterface);
    }

    protected void render(GLjInterface gLjInterface) {
    }

    protected void superimposeOn(Graphics graphics) {
    }
}

