/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;

public class WindowSpecLayout
implements LayoutManager2 {
    protected Hashtable positions = new Hashtable();

    public static Position Position(float f, int n, float f2, int n2) {
        return WindowSpecLayout.Position(f, n, f2, n2, Float.NaN, 0, Float.NaN, 0);
    }

    public static Position Position(float f, int n, float f2, int n2, float f3, int n3, float f4, int n4) {
        return new Position(f, n, f2, n2, f3, n3, f4, n4);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof Position) {
            this.positions.put(component, object);
        } else if (object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a WindowSpecLayout.Position");
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Position position = (Position)this.positions.get(componentArray[i]);
            if (position == null) continue;
            position.setBoundsFor(container, componentArray[i]);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(10, 10);
    }

    public Dimension preferredLayoutSize(Container container) {
        return container.getSize();
    }

    public void removeLayoutComponent(Component component) {
        this.positions.remove(component);
    }

    public static class Position {
        float[] proportion = new float[4];
        int[] offset = new int[4];

        public Position(float f, int n, float f2, int n2, float f3, int n3, float f4, int n4) {
            this.proportion[0] = f;
            this.offset[0] = n;
            this.proportion[1] = f2;
            this.offset[1] = n2;
            this.proportion[2] = f3;
            this.offset[2] = n3;
            this.proportion[3] = f4;
            this.offset[3] = n4;
        }

        public float leftProportion() {
            return this.proportion[0];
        }

        public int leftOffset() {
            return this.offset[0];
        }

        public float topProportion() {
            return this.proportion[1];
        }

        public int topOffset() {
            return this.offset[1];
        }

        public float rightProportion() {
            return this.proportion[2];
        }

        public int rightOffset() {
            return this.offset[2];
        }

        public float bottomProportion() {
            return this.proportion[3];
        }

        public int bottomOffset() {
            return this.offset[3];
        }

        public Rectangle getBoundsFor(int n, int n2) {
            int n3 = (int)((float)n * this.proportion[0] + (float)this.offset[0]);
            int n4 = (int)((float)n2 * this.proportion[1] + (float)this.offset[1]);
            if (Float.isNaN(this.proportion[2]) || Float.isNaN(this.proportion[3])) {
                return new Rectangle(n3, n4, Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            int n5 = (int)((float)n * this.proportion[2]) - 1 + this.offset[2];
            int n6 = (int)((float)n2 * this.proportion[3]) - 1 + this.offset[3];
            return new Rectangle(n3, n4, n5 - n3 + 1, n6 - n4 + 1);
        }

        protected void setBoundsFor(Container container, Component component) {
            Insets insets = container.getInsets();
            int n = container.getWidth() - insets.left - insets.right;
            int n2 = container.getHeight() - insets.top - insets.bottom;
            Rectangle rectangle = this.getBoundsFor(n, n2);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            if (rectangle.width == Integer.MIN_VALUE || rectangle.height == Integer.MIN_VALUE) {
                Dimension dimension = component.getPreferredSize();
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
            }
            component.setBounds(rectangle);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Position)) {
                return false;
            }
            Position position = (Position)object;
            for (int i = 0; i < 4; ++i) {
                if (this.proportion[i] != position.proportion[i]) {
                    return false;
                }
                if (this.offset[i] == position.offset[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LayoutPosition (");
            stringBuffer.append(this.leftProportion());
            stringBuffer.append(',');
            stringBuffer.append(this.leftOffset());
            stringBuffer.append(',');
            stringBuffer.append(this.topProportion());
            stringBuffer.append(',');
            stringBuffer.append(this.topOffset());
            stringBuffer.append(',');
            stringBuffer.append(this.rightProportion());
            stringBuffer.append(',');
            stringBuffer.append(this.rightOffset());
            stringBuffer.append(',');
            stringBuffer.append(this.bottomProportion());
            stringBuffer.append(',');
            stringBuffer.append(this.bottomOffset());
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

