/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;

public class SystemResourceSupport {
    protected static Frame systemFrame;
    protected static Window systemWindow;

    public static Point _getStringExtentFor_(BufferedReader bufferedReader, Font font) {
        FontMetrics fontMetrics = SystemResourceSupport.getFontMetrics(font);
        Point point = new Point(0, 0);
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                Point point2 = new Point(fontMetrics.stringWidth(string), fontMetrics.getHeight());
                point = new Point(Math.max(point.x, point2.x), point.y + point2.y);
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException.getMessage());
            iOException.printStackTrace();
            point = null;
        }
        return point;
    }

    public static Point _getStringExtentFor_(String string, Font font) {
        FontMetrics fontMetrics = SystemResourceSupport.getFontMetrics(font);
        return new Point(fontMetrics.stringWidth(string), fontMetrics.getHeight());
    }

    public static Image createImage(int n, int n2) {
        return SystemResourceSupport.getWindow().createImage(n, n2);
    }

    public static Image createImage(Dimension dimension) {
        return SystemResourceSupport.createImage(dimension.width, dimension.height);
    }

    public static Image createImage(Point point) {
        return SystemResourceSupport.createImage(point.x, point.y);
    }

    public static Image createImage(String string) {
        try {
            Class<?> clazz = Class.forName("jp.co.sra.smalltalk.SystemResourceSupport");
            URL uRL = clazz.getResource(string);
            return SystemResourceSupport.createImage(uRL);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public static Image createImage(URL uRL) {
        try {
            Frame frame = new Frame();
            Toolkit toolkit = frame.getToolkit();
            Image image = toolkit.getImage(uRL);
            MediaTracker mediaTracker = new MediaTracker(frame);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("image load interrupted.");
                return null;
            }
            int n = mediaTracker.statusAll(false);
            if ((n & 2) != 0 || (n & 4) != 0) {
                System.err.println("could not load image.");
                return null;
            }
            return image;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public static Font getFont() {
        return SystemResourceSupport.getWindow().getFont();
    }

    public static FontMetrics getFontMetrics(Font font) {
        Font font2 = font;
        if (font2 == null) {
            font2 = SystemResourceSupport.getFont();
        }
        return SystemResourceSupport.getWindow().getFontMetrics(font2);
    }

    public static Frame getFrame() {
        return systemFrame;
    }

    public static Graphics getGraphics() {
        return SystemResourceSupport.getWindow().getGraphics();
    }

    public static Window getWindow() {
        return systemWindow;
    }

    protected static void Initialize() {
        systemFrame = new Frame();
        systemWindow = new Window(systemFrame);
        systemWindow.pack();
        systemWindow.setVisible(true);
        systemWindow.setVisible(false);
    }

    static {
        SystemResourceSupport.Initialize();
    }
}

