/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Hashtable;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StByteArray;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.SystemInterface;

public class StImage
extends StObject
implements StDisplayable,
Serializable {
    private static final long serialVersionUID = -7647941984469789820L;
    public static final int WriteZeros = 0;
    public static final int And = 1;
    public static final int Over = 3;
    public static final int Erase = 4;
    public static final int Reverse = 6;
    public static final int Under = 7;
    public static final int ReverseUnder = 13;
    public static final int WriteOnes = 15;
    public static final int Paint = 16;
    protected static IndexColorModel MonoMaskColorModel;
    protected transient BufferedImage image;
    protected transient int rowByteSize;
    protected transient byte[] bits;

    public StImage(int n, int n2) {
        this(n, n2, ColorModel.getRGBdefault());
        int[] nArray = new int[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        this.setPixels(nArray);
    }

    public StImage(int n, int n2, ColorModel colorModel) {
        this.image = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), false, null);
        this.rowByteSize = n * this.bitsPerPixel() + 31 >> 5 << 2;
    }

    public StImage(int n, int n2, byte[] byArray) {
        this(n, n2, byArray, ColorModel.getRGBdefault());
    }

    public StImage(int n, int n2, byte[] byArray, ColorModel colorModel) {
        this(n, n2, colorModel);
        if (byArray != null) {
            if (this.rowByteSize * n2 > byArray.length) {
                throw SmalltalkException.Error("Bitmap array has incorrect size.");
            }
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.setPixel(j, i, this._getPixelFromBits(j, i, byArray));
                }
            }
            this.bits = byArray;
        }
    }

    public StImage(int n, int n2, int[] nArray) {
        this(n, n2, nArray, ColorModel.getRGBdefault());
    }

    public StImage(int n, int n2, int[] nArray, ColorModel colorModel) {
        this(n, n2, colorModel);
        this.setPixels(nArray);
    }

    public StImage(int n, int n2, StByteArray stByteArray, ColorModel colorModel) {
        this(n, n2, stByteArray._asBytes(), colorModel);
    }

    public StImage(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            this.image = bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        } else {
            Canvas canvas = new Canvas();
            int n = image.getWidth(canvas);
            int n2 = image.getHeight(canvas);
            int[] nArray = new int[n * n2];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.image = new StImage(n, n2, nArray).image();
            this.setPixels(nArray);
        }
        this.rowByteSize = this.width() * this.bitsPerPixel() + 31 >> 5 << 2;
    }

    public StImage(Point point) {
        this(point.x, point.y);
    }

    public StImage(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public static IndexColorModel MonoMaskColorModel() {
        if (MonoMaskColorModel == null) {
            byte[] byArray = new byte[]{-1, 0};
            MonoMaskColorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
        }
        return MonoMaskColorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StImage _FromUser() {
        int[] nArray;
        SystemInterface systemInterface = SystemInterface.Current();
        int[] nArray2 = new int[2];
        SystemInterface systemInterface2 = systemInterface;
        synchronized (systemInterface2) {
            nArray = systemInterface.utilImageFromUser(nArray2);
        }
        if (nArray != null) {
            return new StImage(nArray2[0], nArray2[1], nArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StImage _OfArea(Rectangle rectangle) {
        int[] nArray;
        SystemInterface systemInterface;
        SystemInterface systemInterface2 = systemInterface = SystemInterface.Current();
        synchronized (systemInterface2) {
            nArray = systemInterface.utilImageOfArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (nArray != null) {
            return new StImage(rectangle.width, rectangle.height, nArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StImage _OfWholeScreen() {
        int[] nArray;
        SystemInterface systemInterface = SystemInterface.Current();
        int[] nArray2 = new int[2];
        SystemInterface systemInterface2 = systemInterface;
        synchronized (systemInterface2) {
            nArray = systemInterface.utilImageOfWholeScreen(nArray2);
        }
        if (nArray != null) {
            return new StImage(nArray2[0], nArray2[1], nArray);
        }
        return null;
    }

    public static int _IndexOfNearestColor(Color color, IndexColorModel indexColorModel) {
        int n = StColorValue._MaxDistanceSquared() + 1;
        int n2 = -1;
        for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
            int n3 = indexColorModel.getRGB(i);
            Color color2 = new Color(n3);
            Integer n4 = StColorValue._DistanceSquaredFrom_ifLessThan_(color2, color, n);
            if (n4 == null) continue;
            n = n4;
            n2 = i;
        }
        return n2;
    }

    public static void Display_(StImage stImage) {
        Frame frame = new Frame();
        frame.setTitle("Display");
        frame.setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        final StImage stImage2 = stImage;
        Canvas canvas = new Canvas(){

            public void paint(Graphics graphics) {
                stImage2.displayOn_(graphics);
            }
        };
        canvas.setBounds(0, 0, stImage.width(), stImage.height());
        frame.add(canvas);
        frame.pack();
        StApplicationModel._ShowAtMousePoint(frame);
    }

    public int bitsPerPixel() {
        return this.colorModel().getPixelSize();
    }

    public ColorModel colorModel() {
        return this.image().getColorModel();
    }

    public Point extent() {
        return new Point(this.width(), this.height());
    }

    public int height() {
        return this.image().getHeight();
    }

    public BufferedImage image() {
        return this.image;
    }

    public int width() {
        return this.image().getWidth();
    }

    public Rectangle bounds() {
        return new Rectangle(0, 0, this.width(), this.height());
    }

    public int atPoint_(Point point) {
        return this.getPixel(point.x, point.y);
    }

    public void atPoint_put_(Point point, int n) {
        this.setPixel(point.x, point.y, n);
    }

    public int getPixel(int n, int n2) {
        if (n >= this.width() || n2 >= this.height()) {
            throw new ArrayIndexOutOfBoundsException("Index out of Image Bounds Exception at (" + n + ", " + n2 + ")");
        }
        return this.image().getRGB(n, n2);
    }

    public int[] getPixels() {
        int n = this.width();
        int n2 = this.height();
        return this.image().getRGB(0, 0, n, n2, null, 0, n);
    }

    protected int _getPixelFromBits(int n, int n2, byte[] byArray) {
        int n3 = this.bitsPerPixel();
        if (n3 == 32) {
            return this._getPixel32FromBits(n, n2, byArray);
        }
        if (n3 == 24) {
            return this._getPixel24FromBits(n, n2, byArray);
        }
        if (n3 == 8) {
            return this._getPixel8FromBits(n, n2, byArray);
        }
        if (n3 == 1) {
            return this._getPixel1FromBits(n, n2, byArray);
        }
        throw new SmalltalkException("can't handle an " + n3 + "-color image");
    }

    protected int _getPixel1FromBits(int n, int n2, byte[] byArray) {
        int n3 = byArray[n2 * this.rowByteSize + (n >> 3)] & 0xFF;
        n3 >>= 7 - (n & 7);
        return this.image().getColorModel().getRGB(n3 &= 1);
    }

    protected int _getPixel8FromBits(int n, int n2, byte[] byArray) {
        int n3 = byArray[n2 * this.rowByteSize + n] & 0xFF;
        return this.image().getColorModel().getRGB(n3);
    }

    protected int _getPixel24FromBits(int n, int n2, byte[] byArray) {
        int n3 = n2 * this.rowByteSize + n + n + n;
        int n4 = byArray[n3 + 0] & 0xFF;
        int n5 = byArray[n3 + 1] & 0xFF;
        int n6 = byArray[n3 + 2] & 0xFF;
        return this.image().getColorModel().getRGB(new Color(n4, n5, n6).getRGB());
    }

    protected int _getPixel32FromBits(int n, int n2, byte[] byArray) {
        int n3 = n2 * this.rowByteSize + n + n + n + n;
        int n4 = 255 - (byArray[n3 + 0] & 0xFF);
        int n5 = byArray[n3 + 1] & 0xFF;
        int n6 = byArray[n3 + 2] & 0xFF;
        int n7 = byArray[n3 + 3] & 0xFF;
        return this.image().getColorModel().getRGB(new Color(n5, n6, n7, n4).getRGB());
    }

    public void setPixel(int n, int n2, int n3) {
        this.image().setRGB(n, n2, n3);
        this._flushBits();
    }

    public void setPixels(int[] nArray) {
        int n = this.width();
        int n2 = this.height();
        if (nArray == null) {
            nArray = new int[n * n2];
        } else if (n * n2 > nArray.length) {
            throw SmalltalkException.Error("Pixel array has incorrect size.");
        }
        this.image().setRGB(0, 0, n, n2, nArray, 0, n);
        this._flushBits();
    }

    protected int _setPixelIntoBits(int n, int n2, byte[] byArray) {
        int n3 = this.bitsPerPixel();
        if (n3 == 32) {
            return this._setPixel32IntoBits(n, n2, byArray);
        }
        if (n3 == 24) {
            return this._setPixel24IntoBits(n, n2, byArray);
        }
        if (n3 == 8) {
            return this._setPixel8IntoBits(n, n2, byArray);
        }
        if (n3 == 1) {
            return this._setPixel1IntoBits(n, n2, byArray);
        }
        throw new SmalltalkException("can't handle an " + n3 + "-color image");
    }

    protected int _setPixel1IntoBits(int n, int n2, byte[] byArray) {
        ColorModel colorModel = this.image().getColorModel();
        int n3 = colorModel.getRGB(this.getPixel(n, n2) & 0xFF);
        int n4 = n2 * this.rowByteSize + (n >> 3);
        int n5 = 7 - (n & 7);
        int n6 = n3 == 0 ? byArray[n4] & -1 - (1 << n5) : byArray[n4] | 1 << n5;
        byArray[n4] = (byte)n6;
        return n3;
    }

    protected int _setPixel8IntoBits(int n, int n2, byte[] byArray) {
        IndexColorModel indexColorModel = (IndexColorModel)this.image().getColorModel();
        int n3 = this.getPixel(n, n2);
        int n4 = indexColorModel.getTransparentPixel();
        n3 = n4 >= 0 && indexColorModel.getRGB(n4) == n3 ? n4 : StImage._IndexOfNearestColor(new Color(n3), indexColorModel);
        byArray[n2 * this.rowByteSize + n] = (byte)(n3 & 0xFF);
        return n3;
    }

    protected int _setPixel24IntoBits(int n, int n2, byte[] byArray) {
        ColorModel colorModel = this.image().getColorModel();
        int n3 = this.getPixel(n, n2);
        int n4 = n2 * this.rowByteSize + n + n + n;
        byArray[n4 + 0] = (byte)colorModel.getRed(n3);
        byArray[n4 + 1] = (byte)colorModel.getGreen(n3);
        byArray[n4 + 2] = (byte)colorModel.getBlue(n3);
        return n3;
    }

    protected int _setPixel32IntoBits(int n, int n2, byte[] byArray) {
        ColorModel colorModel = this.image().getColorModel();
        int n3 = this.getPixel(n, n2);
        int n4 = n2 * this.rowByteSize + n + n + n + n;
        byArray[n4 + 0] = (byte)(255 - colorModel.getAlpha(n3));
        byArray[n4 + 1] = (byte)colorModel.getRed(n3);
        byArray[n4 + 2] = (byte)colorModel.getGreen(n3);
        byArray[n4 + 3] = (byte)colorModel.getBlue(n3);
        return n3;
    }

    public Color valueAtPoint_(Point point) {
        return new Color(this.getPixel(point.x, point.y), this.colorModel().hasAlpha());
    }

    public void valueAtPoint_put_(Point point, Color color) {
        this.setPixel(point.x, point.y, color.getRGB());
    }

    public byte[] getBits() {
        byte[] byArray = new byte[this.bits().length];
        System.arraycopy(this.bits(), 0, byArray, 0, byArray.length);
        return byArray;
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_(graphics, new Point(0, 0));
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        graphics.drawImage(this.image(), point.x, point.y, null);
    }

    public Object clone() {
        return new StImage(this.width(), this.height(), this.getPixels(), this.image().getColorModel());
    }

    public StImage copyEmpty() {
        return this.copyEmpty_(this.extent());
    }

    public StImage copyEmpty_(Point point) {
        return new StImage(point.x, point.y);
    }

    public StImage asImage() {
        return this;
    }

    public StImage convertToPalette_(IndexColorModel indexColorModel) {
        return this._convertToPalette_RenderedByNearistPaint(indexColorModel);
    }

    public StImage _convertToPalette_RenderedByErrorDiffusion(IndexColorModel indexColorModel) {
        int n = this.width();
        int n2 = this.height();
        StImage stImage = new StImage(n, n2, indexColorModel);
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Serializable serializable;
                Color color;
                Integer n3 = new Integer(this.getPixel(j, i));
                Color color2 = new Color(n3);
                if (hashtable.containsKey(n3)) {
                    stImage.setPixel(j, i, (Integer)hashtable.get(n3));
                } else {
                    int n4 = StColorValue._MaxDistanceSquared() + 1;
                    int n5 = -16777216;
                    for (int k = 0; k < indexColorModel.getMapSize(); ++k) {
                        int n6 = indexColorModel.getRGB(k);
                        color = new Color(n6);
                        serializable = StColorValue._DistanceSquaredFrom_ifLessThan_(color, color2, n4);
                        if (serializable == null) continue;
                        n4 = (Integer)serializable;
                        n5 = n6;
                    }
                    hashtable.put(n3, new Integer(n5));
                    stImage.setPixel(j, i, n5);
                }
                Color color3 = new Color(this.getPixel(j, i));
                float f = (float)(color2.getRed() - color3.getRed()) / 16.0f;
                float f2 = (float)(color2.getGreen() - color3.getGreen()) / 16.0f;
                float f3 = (float)(color2.getBlue() - color3.getBlue()) / 16.0f;
                if (j < n - 1) {
                    color = new Color(this.getPixel(j + 1, i));
                    color = new Color(Math.min(255, Math.max(0, color.getRed() + (int)(f * 7.0f))), Math.min(255, Math.max(0, color.getGreen() + (int)(f2 * 7.0f))), Math.min(255, Math.max(0, color.getBlue() + (int)(f3 * 7.0f))));
                    stImage.setPixel(j + 1, i, color.getRGB());
                }
                if (i >= n2 - 1) continue;
                if (j > 0) {
                    color = new Color(this.getPixel(j - 1, i + 1));
                    color = new Color(Math.min(255, Math.max(0, color.getRed() + (int)(f * 3.0f))), Math.min(255, Math.max(0, color.getGreen() + (int)(f2 * 3.0f))), Math.min(255, Math.max(0, color.getBlue() + (int)(f3 * 3.0f))));
                    stImage.setPixel(j - 1, i + 1, color.getRGB());
                }
                color = new Color(this.getPixel(j, i + 1));
                color = new Color(Math.min(255, Math.max(0, color.getRed() + (int)(f * 5.0f))), Math.min(255, Math.max(0, color.getGreen() + (int)(f2 * 5.0f))), Math.min(255, Math.max(0, color.getBlue() + (int)(f3 * 5.0f))));
                stImage.setPixel(j, i + 1, color.getRGB());
                if (j >= stImage.width() - 1) continue;
                serializable = new Color(this.getPixel(j + 1, i + 1));
                serializable = new Color(Math.min(255, Math.max(0, ((Color)serializable).getRed() + (int)f)), Math.min(255, Math.max(0, ((Color)serializable).getGreen() + (int)f2)), Math.min(255, Math.max(0, ((Color)serializable).getBlue() + (int)f3)));
                stImage.setPixel(j + 1, i + 1, ((Color)serializable).getRGB());
            }
        }
        return stImage;
    }

    public StImage _convertToPalette_RenderedByNearistPaint(IndexColorModel indexColorModel) {
        int n = this.width();
        int n2 = this.height();
        StImage stImage = new StImage(n, n2, indexColorModel);
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Integer n3 = new Integer(this.getPixel(j, i));
                if (hashtable.containsKey(n3)) {
                    stImage.setPixel(j, i, (Integer)hashtable.get(n3));
                    continue;
                }
                int n4 = StColorValue._MaxDistanceSquared() + 1;
                int n5 = -16777216;
                Color color = new Color(n3);
                for (int k = 0; k < indexColorModel.getMapSize(); ++k) {
                    int n6 = indexColorModel.getRGB(k);
                    Color color2 = new Color(n6);
                    Integer n7 = StColorValue._DistanceSquaredFrom_ifLessThan_(color2, color, n4);
                    if (n7 == null) continue;
                    n4 = n7;
                    n5 = n6;
                }
                hashtable.put(n3, new Integer(n5));
                stImage.setPixel(j, i, n5);
            }
        }
        return stImage;
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write("(Image extent: ");
        writer.write(String.valueOf(this.width()));
        writer.write(64);
        writer.write(String.valueOf(this.height()));
        writer.write(" depth: ");
        writer.write(String.valueOf(this.bitsPerPixel()));
        writer.write(" bitsPerPixel: ");
        writer.write(String.valueOf(this.bitsPerPixel()));
        writer.write(" palette: ");
        this.storePaletteOn_(writer);
        writer.write(" usingBits: ");
        new StByteArray(this.bits()).storeOn_(writer);
        writer.write(41);
    }

    protected void storePaletteOn_(Writer writer) throws IOException {
        ColorModel colorModel = this.image().getColorModel();
        if (colorModel instanceof DirectColorModel) {
            writer.write("(FixedPalette redShift: ");
            writer.write(String.valueOf((int)(Math.log(((DirectColorModel)colorModel).getRedMask() / 255) / Math.log(2.0))));
            writer.write(" redMask: 255 greenShift: ");
            writer.write(String.valueOf((int)(Math.log(((DirectColorModel)colorModel).getGreenMask() / 255) / Math.log(2.0))));
            writer.write(" greenMask: 255 blueShift: ");
            writer.write(String.valueOf((int)(Math.log(((DirectColorModel)colorModel).getBlueMask() / 255) / Math.log(2.0))));
            writer.write(" blueMask: 255)");
        } else if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n = indexColorModel.getMapSize();
            writer.write("(MappedPalette withColors: ");
            writer.write("((Array new: " + n + ") ");
            for (int i = 0; i < n; ++i) {
                writer.write("at: " + (i + 1) + " put: ");
                writer.write(StColorValue._StoreStringOf(new Color(indexColorModel.getRGB(i))));
                writer.write("; ");
            }
            writer.write(" yourself))");
        } else {
            throw new SmalltalkException("The color model [" + colorModel.getClass() + "] is not supported yet.");
        }
    }

    public StImage copy_from_in_rule_(Rectangle rectangle, Point point, StImage stImage, int n) {
        if (!this.bounds().contains(rectangle.x, rectangle.y)) {
            return null;
        }
        if (!this.bounds().contains(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1)) {
            return null;
        }
        if (!stImage.bounds().contains(point.x, point.y)) {
            return null;
        }
        if (!stImage.bounds().contains(point.x + rectangle.width - 1, point.y + rectangle.height - 1)) {
            return null;
        }
        for (int i = 0; i < rectangle.height; ++i) {
            for (int j = 0; j < rectangle.width; ++j) {
                int n2 = point.x + j;
                int n3 = point.y + i;
                int n4 = rectangle.x + j;
                int n5 = rectangle.y + i;
                int n6 = this._combinationedColorFrom_to_in_(stImage.getPixel(n2, n3), this.getPixel(n4, n5), n);
                this.setPixel(n4, n5, n6);
            }
        }
        return this;
    }

    public StImage tile_from_in_rule_(Rectangle rectangle, Point point, StImage stImage, int n) {
        if (!this.bounds().contains(rectangle.x, rectangle.y)) {
            return null;
        }
        if (!this.bounds().contains(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1)) {
            return null;
        }
        int n2 = stImage.width();
        int n3 = stImage.height();
        for (int i = 0; i < rectangle.height; ++i) {
            for (int j = 0; j < rectangle.width; ++j) {
                int n4 = (point.x + j) % n2;
                int n5 = (point.y + i) % n3;
                int n6 = rectangle.x + j;
                int n7 = rectangle.y + i;
                int n8 = this._combinationedColorFrom_to_in_(stImage.getPixel(n4, n5), this.getPixel(n6, n7), n);
                this.setPixel(n6, n7, n8);
            }
        }
        return this;
    }

    protected int _combinationedColorFrom_to_in_(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0xFF000000 | (n | n2);
            }
            case 2: {
                return 0xFF000000 | (n | ~n2);
            }
            case 3: {
                return 0xFF000000 | n;
            }
            case 4: {
                return 0xFF000000 | (~n | n2);
            }
            case 5: {
                return 0xFF000000 | n2;
            }
            case 6: {
                return 0xFF000000 | ~(~n ^ ~n2);
            }
            case 7: {
                return 0xFF000000 | n & n2;
            }
            case 8: {
                return 0xFF000000 | ~(n & n2);
            }
            case 9: {
                return 0xFF000000 | ~n ^ ~n2;
            }
            case 10: {
                return 0xFF000000 | ~n2;
            }
            case 11: {
                return 0xFF000000 | ~(~n | n2);
            }
            case 12: {
                return 0xFF000000 | ~n;
            }
            case 13: {
                return 0xFF000000 | ~(n | ~n2);
            }
            case 14: {
                return 0xFF000000 | ~(n | n2);
            }
            case 15: {
                return -16777216;
            }
        }
        throw new SmalltalkException("unknown combination rule - " + n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage rotateByQuadrants_to_(int n, StImage stImage) {
        if (stImage == this) {
            return ((StImage)this.copy()).rotateByQuadrants_to_(n, stImage);
        }
        int n2 = n & 3;
        if (n2 == 0) {
            return stImage.copy_from_in_rule_(this.bounds(), new Point(0, 0), this, 3);
        }
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)stImage.image().getGraphics();
            if (n2 == 1) {
                graphics2D.translate(stImage.width(), 0);
            } else if (n2 == 2) {
                graphics2D.translate(stImage.width(), stImage.height());
            } else {
                graphics2D.translate(0, stImage.height());
            }
            AffineTransform affineTransform = AffineTransform.getRotateInstance((double)n2 * Math.PI / 2.0);
            graphics2D.drawImage(this.image(), affineTransform, null);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return stImage;
    }

    public StImage rotatedByQuadrants_(int n) {
        StImage stImage = n % 2 == 0 ? this.copyEmpty() : this.copyEmpty_(new Point(this.extent().y, this.extent().x));
        return this.rotateByQuadrants_to_(n, stImage);
    }

    public void _display() {
        StImage.Display_(this);
    }

    public int atX_y_(int n, int n2) {
        return this.getPixel(n, n2);
    }

    public void atX_y_put_(int n, int n2, int n3) {
        this.setPixel(n, n2, n3);
    }

    protected void _flushBits() {
        this.bits = null;
    }

    protected byte[] bits() {
        if (this.bits == null) {
            int n = this.width();
            int n2 = this.height();
            this.bits = new byte[this.rowByteSize * n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this._setPixelIntoBits(j, i, this.bits);
                }
            }
        }
        return this.bits;
    }

    public Point scaledExtent_(double d, double d2) {
        Double d3 = new Double((double)this.width() * 1.0 / d);
        Double d4 = new Double((double)this.height() * 1.0 / d2);
        return new Point(d3.intValue(), d4.intValue());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int[] nArray = (int[])objectInputStream.readObject();
        String string = objectInputStream.readUTF();
        Object object = null;
        if (string.equals("DirectColorModel")) {
            int n3 = objectInputStream.readInt();
            int n4 = objectInputStream.readInt();
            int n5 = objectInputStream.readInt();
            int n6 = objectInputStream.readInt();
            int n7 = objectInputStream.readInt();
            object = new DirectColorModel(n3, n4, n5, n6, n7);
        } else if (string.equals("IndexColorModel")) {
            int n8;
            int n9 = objectInputStream.readInt();
            int n10 = objectInputStream.readInt();
            byte[] byArray = new byte[n10];
            byte[] byArray2 = new byte[n10];
            byte[] byArray3 = new byte[n10];
            byte[] byArray4 = new byte[n10];
            for (n8 = 0; n8 < n10; ++n8) {
                byArray[n8] = (byte)objectInputStream.read();
            }
            for (n8 = 0; n8 < n10; ++n8) {
                byArray2[n8] = (byte)objectInputStream.read();
            }
            for (n8 = 0; n8 < n10; ++n8) {
                byArray3[n8] = (byte)objectInputStream.read();
            }
            for (n8 = 0; n8 < n10; ++n8) {
                byArray4[n8] = (byte)objectInputStream.read();
            }
            object = new IndexColorModel(n9, n10, byArray, byArray2, byArray3, byArray4);
        } else {
            throw new IOException("The color model [" + object.getClass() + "] is not supported yet.");
        }
        this.image = new BufferedImage((ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(n, n2), false, null);
        this.rowByteSize = n * this.bitsPerPixel() + 31 >> 5 << 2;
        this.setPixels(nArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.width());
        objectOutputStream.writeInt(this.height());
        objectOutputStream.writeObject(this.getPixels());
        ColorModel colorModel = this.image().getColorModel();
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            objectOutputStream.writeUTF("DirectColorModel");
            objectOutputStream.writeInt(directColorModel.getPixelSize());
            objectOutputStream.writeInt(directColorModel.getRedMask());
            objectOutputStream.writeInt(directColorModel.getGreenMask());
            objectOutputStream.writeInt(directColorModel.getBlueMask());
            objectOutputStream.writeInt(directColorModel.getAlphaMask());
        } else if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            objectOutputStream.writeUTF("IndexColorModel");
            objectOutputStream.writeInt(indexColorModel.getPixelSize());
            objectOutputStream.writeInt(indexColorModel.getMapSize());
            byte[] byArray = new byte[indexColorModel.getMapSize()];
            indexColorModel.getReds(byArray);
            objectOutputStream.write(byArray, 0, byArray.length);
            indexColorModel.getGreens(byArray);
            objectOutputStream.write(byArray, 0, byArray.length);
            indexColorModel.getBlues(byArray);
            objectOutputStream.write(byArray, 0, byArray.length);
            indexColorModel.getAlphas(byArray);
            objectOutputStream.write(byArray, 0, byArray.length);
        } else {
            throw new IOException("The color model [" + colorModel.getClass() + "] is not supported yet.");
        }
    }
}

