/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import jp.co.sra.smalltalk.SystemInterface;
import jp.co.sra.smalltalk.SystemResourceSupport;

public class StDialog
implements ActionListener {
    protected static String lastDirectory = null;
    protected Dialog dialog;
    protected boolean accepted;
    protected String value;
    protected TextField textField;

    public StDialog() {
        this(SystemResourceSupport.getFrame());
    }

    public StDialog(Frame frame) {
        this.dialog = new Dialog(frame, "", true);
    }

    public static boolean Confirm_(String string) {
        return StDialog.Confirm_(string, StDialog._getDefaultPoint());
    }

    public static boolean Confirm_(String string, Point point) {
        return StDialog.Confirm_(string, true, point);
    }

    public static boolean Confirm_(String string, boolean bl) {
        return StDialog.Confirm_(string, bl, StDialog._getDefaultPoint());
    }

    public static boolean Confirm_(String string, boolean bl, Point point) {
        StDialog stDialog = new StDialog();
        return stDialog.confirm_(string, bl, point);
    }

    public static File OpenFileDialog() {
        return StDialog.OpenFileDialog_default_("", null);
    }

    public static File OpenFileDialog_(String string) {
        return StDialog.OpenFileDialog_default_(string, null);
    }

    public static File OpenFileDialog_default_(String string, String string2) {
        FileDialog fileDialog = new FileDialog(SystemResourceSupport.getFrame(), string);
        if (lastDirectory != null) {
            fileDialog.setDirectory(lastDirectory);
        }
        if (string2 != null && string2.length() > 0) {
            fileDialog.setFile(string2);
        }
        fileDialog.setVisible(true);
        String string3 = fileDialog.getDirectory();
        String string4 = fileDialog.getFile();
        if (string3 == null || string4 == null) {
            return null;
        }
        lastDirectory = string3;
        return new File(string3, string4);
    }

    public static String Request_(String string) {
        return StDialog.Request_(string, StDialog._getDefaultPoint());
    }

    public static String Request_(String string, Point point) {
        return StDialog.Request_(string, "", point);
    }

    public static String Request_(String string, String string2) {
        return StDialog.Request_(string, string2, StDialog._getDefaultPoint());
    }

    public static String Request_(String string, String string2, Point point) {
        StDialog stDialog = new StDialog();
        return stDialog.request_(string, string2, point);
    }

    public static File SaveFileDialog() {
        return StDialog.SaveFileDialog_default_("", null);
    }

    public static File SaveFileDialog_(String string) {
        return StDialog.SaveFileDialog_default_(string, null);
    }

    public static File SaveFileDialog_default_(String string, String string2) {
        FileDialog fileDialog = new FileDialog(SystemResourceSupport.getFrame(), "", 1);
        if (lastDirectory != null) {
            fileDialog.setDirectory(lastDirectory);
        }
        if (string2 != null && string2.length() > 0) {
            fileDialog.setFile(string2);
        }
        fileDialog.setVisible(true);
        String string3 = fileDialog.getDirectory();
        String string4 = fileDialog.getFile();
        if (string3 == null || string4 == null) {
            return null;
        }
        lastDirectory = string3;
        return new File(string3, string4);
    }

    public static void Warn_(String string) {
        StDialog.Warn_(string, StDialog._getDefaultPoint());
    }

    public static void Warn_(String string, Point point) {
        StDialog stDialog = new StDialog();
        stDialog.warn_(string, point);
    }

    protected static Point _getCenterPoint() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(dimension.width / 2, dimension.height / 2);
    }

    protected static Point _getDefaultPoint() {
        Point point = null;
        try {
            point = SystemInterface._MousePoint();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            point = new Point(0, 0);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            point = new Point(0, 0);
        }
        return point;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Yes") || string.equals("OK")) {
            this.accepted = true;
            this.value = this.textField != null ? this.textField.getText() : null;
        } else if (string.equals("No") || string.equals("Cancel")) {
            this.accepted = false;
        }
        this.dialog.dispose();
    }

    public boolean confirm_(String string, boolean bl, Point point) {
        this.dialog.add("Center", new Label(string, 1));
        this.dialog.add("South", this._yesNoButtons());
        this._showDialog(point);
        return this.accepted;
    }

    public String request_(String string, String string2, Point point) {
        this.dialog.setLayout(new GridLayout(3, 1));
        this.textField = new TextField(20);
        this.textField.setText(string2);
        this.dialog.add(new Label(string, 1));
        this.dialog.add(this.textField);
        this.dialog.add(this._okCancelButtons());
        this._showDialog(point);
        return this.value;
    }

    public void warn_(String string, Point point) {
        this.dialog.add("Center", new Label(string, 1));
        this.dialog.add("South", this._closeOKButton());
        this._showDialog(point);
    }

    protected Button _closeCancelButton() {
        Button button = new Button("Cancel");
        button.addActionListener(this);
        return button;
    }

    protected Button _closeOKButton() {
        Button button = new Button("OK");
        button.addActionListener(this);
        return button;
    }

    protected Panel _okCancelButtons() {
        Button button = new Button("OK");
        button.addActionListener(this);
        Button button2 = new Button("Cancel");
        button2.addActionListener(this);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(button);
        panel.add(button2);
        return panel;
    }

    protected void _showDialog(Point point) {
        this.dialog.pack();
        Rectangle rectangle = this.dialog.getBounds();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.max(0, Math.min(point.x - rectangle.width / 2, dimension.width - rectangle.width));
        int n2 = Math.max(0, Math.min(point.y - rectangle.height / 2, dimension.height - rectangle.height));
        this.dialog.setBounds(n, n2, rectangle.width, rectangle.height);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        this.dialog.setVisible(true);
    }

    protected Panel _yesNoButtons() {
        Button button = new Button("Yes");
        button.addActionListener(this);
        Button button2 = new Button("No");
        button2.addActionListener(this);
        Panel panel = new Panel();
        panel.add("West", button);
        panel.add("East", button2);
        return panel;
    }
}

