/*
 * This file is part of jDiffChaser.
 *
 *  jDiffChaser is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  jDiffChaser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with jDiffChaser; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package org.jdiffchaser.scenarihandling;

import org.jdiffchaser.scenarihandling.events.RecordableEvent;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.logging.Logger;
import javax.swing.JFileChooser;


public class ScenarioViewer {
    
    private static final Logger LOGGER = Logger.getLogger(ScenarioViewer.class.getName());
    
    public ScenarioViewer() {
    }
    
    public static void main(String args[]){
          
        JFileChooser chooser = new JFileChooser(".");
        chooser.showOpenDialog(null);
        
        File file = chooser.getSelectedFile();
         
        try{
           
           parse(file);
            
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    
    public static void parse(File file) throws PlayerException{
        ObjectInputStream in = null;
        try{
            in = new ObjectInputStream(new FileInputStream(file));

            RecordableEvent recEvent = null;

            Object obj = in.readObject();
            while( obj!=null ){
                recEvent = (RecordableEvent) obj;
                System.out.println(recEvent.toString());
                try{
                    obj = in.readObject();
                }catch(EOFException eofe){
                    obj = null;
                }
            }
            System.out.println("Finished playing");
        }catch(Exception e){
            e.printStackTrace();
        }finally{
            try{
                in.close();
            }catch(Exception e){
                e.printStackTrace();
            }   
            System.exit(0);
        }
    }
    
    
}
