/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;

public class OpenMBeanInfoSupport
extends MBeanInfo
implements OpenMBeanInfo,
Serializable {
    static final long serialVersionUID = 4349395935420511492L;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanInfoSupport(String className, String description, OpenMBeanAttributeInfo[] openAttributes, OpenMBeanConstructorInfo[] openConstructors, OpenMBeanOperationInfo[] openOperations, MBeanNotificationInfo[] notifications) {
        super(className, description, openAttributes == null ? null : OpenMBeanInfoSupport.attributesArrayCopyCast(openAttributes), openConstructors == null ? null : OpenMBeanInfoSupport.constructorsArrayCopyCast(openConstructors), openOperations == null ? null : OpenMBeanInfoSupport.operationsArrayCopyCast(openOperations), notifications == null ? null : OpenMBeanInfoSupport.notificationsArrayCopy(notifications));
    }

    private static MBeanAttributeInfo[] attributesArrayCopyCast(OpenMBeanAttributeInfo[] src) throws ArrayStoreException {
        MBeanAttributeInfo[] dst = new MBeanAttributeInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private static MBeanConstructorInfo[] constructorsArrayCopyCast(OpenMBeanConstructorInfo[] src) throws ArrayStoreException {
        MBeanConstructorInfo[] dst = new MBeanConstructorInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private static MBeanOperationInfo[] operationsArrayCopyCast(OpenMBeanOperationInfo[] src) throws ArrayStoreException {
        MBeanOperationInfo[] dst = new MBeanOperationInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private static MBeanNotificationInfo[] notificationsArrayCopy(MBeanNotificationInfo[] src) {
        MBeanNotificationInfo[] dst = new MBeanNotificationInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public boolean equals(Object obj) {
        OpenMBeanInfo other;
        if (obj == null) {
            return false;
        }
        try {
            other = (OpenMBeanInfo)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getClassName().equals(other.getClassName())) {
            return false;
        }
        if (!new HashSet<MBeanAttributeInfo>(Arrays.asList(this.getAttributes())).equals(new HashSet<MBeanAttributeInfo>(Arrays.asList(other.getAttributes())))) {
            return false;
        }
        if (!new HashSet<MBeanConstructorInfo>(Arrays.asList(this.getConstructors())).equals(new HashSet<MBeanConstructorInfo>(Arrays.asList(other.getConstructors())))) {
            return false;
        }
        if (!new HashSet<MBeanOperationInfo>(Arrays.asList(this.getOperations())).equals(new HashSet<MBeanOperationInfo>(Arrays.asList(other.getOperations())))) {
            return false;
        }
        return new HashSet<MBeanNotificationInfo>(Arrays.asList(this.getNotifications())).equals(new HashSet<MBeanNotificationInfo>(Arrays.asList(other.getNotifications())));
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getClassName().hashCode();
            value += new HashSet<MBeanAttributeInfo>(Arrays.asList(this.getAttributes())).hashCode();
            value += new HashSet<MBeanConstructorInfo>(Arrays.asList(this.getConstructors())).hashCode();
            value += new HashSet<MBeanOperationInfo>(Arrays.asList(this.getOperations())).hashCode();
            this.myHashCode = new Integer(value += new HashSet<MBeanNotificationInfo>(Arrays.asList(this.getNotifications())).hashCode());
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(mbean_class_name=" + this.getClassName() + ",attributes=" + Arrays.asList(this.getAttributes()).toString() + ",constructors=" + Arrays.asList(this.getConstructors()).toString() + ",operations=" + Arrays.asList(this.getOperations()).toString() + ",notifications=" + Arrays.asList(this.getNotifications()).toString() + ")";
        }
        return this.myToString;
    }
}

