/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeType
extends OpenType
implements Serializable {
    static final long serialVersionUID = -5366242454346948798L;
    private TreeMap nameToDescription;
    private TreeMap nameToType;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    private transient Set myNamesSet = null;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;

    public CompositeType(String typeName, String description, String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        super((class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = CompositeType.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData).getName(), typeName, description);
        CompositeType.checkForNullElement(itemNames, "itemNames");
        CompositeType.checkForNullElement(itemDescriptions, "itemDescriptions");
        CompositeType.checkForNullElement(itemTypes, "itemTypes");
        CompositeType.checkForEmptyString(itemNames, "itemNames");
        CompositeType.checkForEmptyString(itemDescriptions, "itemDescriptions");
        if (itemNames.length != itemDescriptions.length || itemNames.length != itemTypes.length) {
            throw new IllegalArgumentException("Array arguments itemNames[], itemDescriptions[] and itemTypes[] should be of same length (got " + itemNames.length + ", " + itemDescriptions.length + " and " + itemTypes.length + ").");
        }
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        for (int i = 0; i < itemNames.length; ++i) {
            String key = itemNames[i].trim();
            if (this.nameToDescription.containsKey(key)) {
                throw new OpenDataException("Argument's element itemNames[" + i + "]=\"" + itemNames[i] + "\" duplicates a previous item names.");
            }
            this.nameToDescription.put(key, itemDescriptions[i].trim());
            this.nameToType.put(key, itemTypes[i]);
        }
    }

    private static void checkForNullElement(Object[] arg, String argName) {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("Argument " + argName + "[] cannot be null or empty.");
        }
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] arg, String argName) {
        for (int i = 0; i < arg.length; ++i) {
            if (!arg[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be an empty string.");
        }
    }

    public boolean containsKey(String itemName) {
        if (itemName == null) {
            return false;
        }
        return this.nameToDescription.containsKey(itemName);
    }

    public String getDescription(String itemName) {
        if (itemName == null) {
            return null;
        }
        return (String)this.nameToDescription.get(itemName);
    }

    public OpenType getType(String itemName) {
        if (itemName == null) {
            return null;
        }
        return (OpenType)this.nameToType.get(itemName);
    }

    public Set keySet() {
        if (this.myNamesSet == null) {
            this.myNamesSet = Collections.unmodifiableSet(this.nameToDescription.keySet());
        }
        return this.myNamesSet;
    }

    public boolean isValue(Object obj) {
        CompositeData value;
        if (obj == null) {
            return false;
        }
        try {
            value = (CompositeData)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.equals(value.getCompositeType());
    }

    public boolean equals(Object obj) {
        CompositeType other;
        if (obj == null) {
            return false;
        }
        try {
            other = (CompositeType)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        return this.nameToType.equals(other.nameToType);
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getTypeName().hashCode();
            Iterator k = this.nameToDescription.keySet().iterator();
            while (k.hasNext()) {
                String key = (String)k.next();
                value += key.hashCode();
                value += this.nameToType.get(key).hashCode();
            }
            this.myHashCode = new Integer(value);
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            StringBuffer result = new StringBuffer();
            result.append(this.getClass().getName());
            result.append("(name=");
            result.append(this.getTypeName());
            result.append(",items=(");
            int i = 0;
            Iterator k = this.nameToType.keySet().iterator();
            while (k.hasNext()) {
                String key = (String)k.next();
                if (i > 0) {
                    result.append(",");
                }
                result.append("(itemName=");
                result.append(key);
                result.append(",itemType=");
                result.append(this.nameToType.get(key).toString() + ")");
                ++i;
            }
            result.append("))");
            this.myToString = result.toString();
        }
        return this.myToString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

