/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private List observedObjects = new ArrayList();
    private String observedAttribute = null;
    private long granularityPeriod = 10000L;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server = null;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected String dbgTag = "Monitor";
    transient boolean isActive = false;
    transient long sequenceNumber = 0L;

    boolean isTraceOn() {
        return Trace.isSelected(1, 4);
    }

    void trace(String clz, String func, String info) {
        Trace.send(1, 4, clz, func, info);
    }

    void trace(String func, String info) {
        this.trace(this.dbgTag, func, info);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 4);
    }

    void debug(String clz, String func, String info) {
        Trace.send(2, 4, clz, func, info);
    }

    void debug(String func, String info) {
        this.debug(this.dbgTag, func, info);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.isTraceOn()) {
            this.trace("preRegister", "initialize the reference on the MBean server");
        }
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        if (this.isTraceOn()) {
            this.trace("preDeregister", "stop the monitor");
        }
        this.stop();
    }

    public void postDeregister() {
    }

    public abstract void start();

    public abstract void stop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getObservedObject() {
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.observedObjects.isEmpty()) {
                return null;
            }
            return (ObjectName)this.observedObjects.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservedObject(ObjectName object) throws IllegalArgumentException {
        Monitor monitor = this;
        synchronized (monitor) {
            while (!this.observedObjects.isEmpty()) {
                this.removeObservedObject((ObjectName)this.observedObjects.get(0));
            }
            this.addObservedObject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObservedObject(ObjectName object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("The object to observe cannot be null.");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.observedObjects.contains(object)) {
                return;
            }
            this.observedObjects.add(object);
            int value = 0;
            value &= 0xFFFFFFFE;
            value &= 0xFFFFFFFD;
            this.insertintElementAt(this.alreadyNotifieds, value &= 0xFFFFFFFB, this.elementCount);
            this.updateDeprecatedAlreadyNotified();
            this.insertSpecificElementAt(this.elementCount);
            ++this.elementCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObservedObject(ObjectName object) {
        Monitor monitor = this;
        synchronized (monitor) {
            int index = this.observedObjects.indexOf(object);
            if (index >= 0) {
                this.observedObjects.remove(index);
                this.removeintElementAt(this.alreadyNotifieds, index);
                this.updateDeprecatedAlreadyNotified();
                this.removeSpecificElementAt(index);
                --this.elementCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObservedObject(ObjectName object) {
        Monitor monitor = this;
        synchronized (monitor) {
            return this.observedObjects.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getObservedObjects() {
        ObjectName[] objects;
        Monitor monitor = this;
        synchronized (monitor) {
            objects = new ObjectName[this.elementCount];
            for (int i = 0; i < this.elementCount; ++i) {
                objects[i] = (ObjectName)this.observedObjects.get(i);
            }
        }
        return objects;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservedAttribute(String attribute) throws IllegalArgumentException {
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute to observe cannot be null.");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            this.observedAttribute = attribute;
            for (int i = 0; i < this.elementCount; ++i) {
                this.resetAlreadyNotified(i, 6);
            }
        }
    }

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void setGranularityPeriod(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("The granularity period must be greater than zero.");
        }
        this.granularityPeriod = period;
    }

    public boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectName getObservedObject(int index) throws ArrayIndexOutOfBoundsException {
        Monitor monitor = this;
        synchronized (monitor) {
            return (ObjectName)this.observedObjects.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDeprecatedAlreadyNotified() {
        Monitor monitor = this;
        synchronized (monitor) {
            this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAlreadyNotified(int index, int mask) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n = index;
            this.alreadyNotifieds[n] = this.alreadyNotifieds[n] | mask;
            if (index == 0) {
                this.updateDeprecatedAlreadyNotified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAlreadyNotified(int index, int mask) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n = index;
            this.alreadyNotifieds[n] = this.alreadyNotifieds[n] & ~mask;
            if (index == 0) {
                this.updateDeprecatedAlreadyNotified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAllAlreadyNotified(int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.alreadyNotifieds[index] = 0;
            if (index == 0) {
                this.updateDeprecatedAlreadyNotified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertintElementAt(int[] array, int value, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensureintCapacity(array, this.elementCount + 1);
            System.arraycopy(array, index, array, index + 1, this.elementCount - index);
            array[index] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertlongElementAt(long[] array, long value, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensurelongCapacity(array, this.elementCount + 1);
            System.arraycopy(array, index, array, index + 1, this.elementCount - index);
            array[index] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertbooleanElementAt(boolean[] array, boolean value, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensurebooleanCapacity(array, this.elementCount + 1);
            System.arraycopy(array, index, array, index + 1, this.elementCount - index);
            array[index] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertNumberElementAt(Number[] array, Number value, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensureNumberCapacity(array, this.elementCount + 1);
            System.arraycopy(array, index, array, index + 1, this.elementCount - index);
            array[index] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertStringElementAt(String[] array, String value, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            this.ensureStringCapacity(array, this.elementCount + 1);
            System.arraycopy(array, index, array, index + 1, this.elementCount - index);
            array[index] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeintElementAt(int[] array, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (index < 0 || index >= this.elementCount) {
                return;
            }
            int j = this.elementCount - index - 1;
            if (j > 0) {
                System.arraycopy(array, index + 1, array, index, j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removelongElementAt(long[] array, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (index < 0 || index >= this.elementCount) {
                return;
            }
            int j = this.elementCount - index - 1;
            if (j > 0) {
                System.arraycopy(array, index + 1, array, index, j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removebooleanElementAt(boolean[] array, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (index < 0 || index >= this.elementCount) {
                return;
            }
            int j = this.elementCount - index - 1;
            if (j > 0) {
                System.arraycopy(array, index + 1, array, index, j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNumberElementAt(Number[] array, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (index < 0 || index >= this.elementCount) {
                return;
            }
            int j = this.elementCount - index - 1;
            if (j > 0) {
                System.arraycopy(array, index + 1, array, index, j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStringElementAt(String[] array, int index) {
        Monitor monitor = this;
        synchronized (monitor) {
            if (index < 0 || index >= this.elementCount) {
                return;
            }
            int j = this.elementCount - index - 1;
            if (j > 0) {
                System.arraycopy(array, index + 1, array, index, j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureintCapacity(int[] array, int minCapacity) {
        Monitor monitor = this;
        synchronized (monitor) {
            int oldCapacity = array.length;
            if (minCapacity > oldCapacity) {
                int[] oldArray = array;
                int newCapacity = oldCapacity + 16;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                array = new int[newCapacity];
                System.arraycopy(oldArray, 0, array, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensurelongCapacity(long[] array, int minCapacity) {
        Monitor monitor = this;
        synchronized (monitor) {
            int oldCapacity = array.length;
            if (minCapacity > oldCapacity) {
                long[] oldArray = array;
                int newCapacity = oldCapacity + 16;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                array = new long[newCapacity];
                System.arraycopy(oldArray, 0, array, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensurebooleanCapacity(boolean[] array, int minCapacity) {
        Monitor monitor = this;
        synchronized (monitor) {
            int oldCapacity = array.length;
            if (minCapacity > oldCapacity) {
                boolean[] oldArray = array;
                int newCapacity = oldCapacity + 16;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                array = new boolean[newCapacity];
                System.arraycopy(oldArray, 0, array, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureNumberCapacity(Number[] array, int minCapacity) {
        Monitor monitor = this;
        synchronized (monitor) {
            int oldCapacity = array.length;
            if (minCapacity > oldCapacity) {
                Number[] oldArray = array;
                int newCapacity = oldCapacity + 16;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                array = new Number[newCapacity];
                System.arraycopy(oldArray, 0, array, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureStringCapacity(String[] array, int minCapacity) {
        Monitor monitor = this;
        synchronized (monitor) {
            int oldCapacity = array.length;
            if (minCapacity > oldCapacity) {
                String[] oldArray = array;
                int newCapacity = oldCapacity + 16;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                array = new String[newCapacity];
                System.arraycopy(oldArray, 0, array, 0, this.elementCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int indexOf(ObjectName object) {
        Monitor monitor = this;
        synchronized (monitor) {
            return this.observedObjects.indexOf(object);
        }
    }

    abstract void insertSpecificElementAt(int var1);

    abstract void removeSpecificElementAt(int var1);

    void sendNotification(String type, long timeStamp, String msg, Object derGauge, Object trigger, int index) {
        if (this.isTraceOn()) {
            this.trace("sendNotification", "send notification:\n\tNotification observed object = " + this.getObservedObject(index) + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + derGauge);
        }
        this.sendNotification(new MonitorNotification(type, this, this.sequenceNumber++, timeStamp, msg, this.getObservedObject(index), this.observedAttribute, derGauge, trigger));
    }
}

