/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.ClientCommunicatorAdmin;
import com.sun.jmx.remote.internal.ClientListenerInfo;
import com.sun.jmx.remote.internal.ClientNotifForwarder;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.NotificationResult;
import javax.management.remote.rmi.NoCallStackClassLoader;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class RMIConnector
implements JMXConnector,
Serializable {
    private static final ClassLogger logger;
    private static final long serialVersionUID = 817323035842634473L;
    private static final String rmiConnectionImplStubClassName;
    private static final Class rmiConnectionImplStubClass;
    private static final String pRefClassName = "com.sun.jmx.remote.internal.PRef";
    private static final Constructor proxyRefConstructor;
    private static final String iiopConnectionStubClassName = "org.omg.stub.javax.management.remote.rmi._RMIConnection_Stub";
    private static final String proxyStubClassName = "com.sun.jmx.remote.internal.ProxyStub";
    private static final String pInputStreamClassName = "com.sun.jmx.remote.internal.PInputStream";
    private static final Class proxyStubClass;
    private static final byte[] base64ToInt;
    private final RMIServer rmiServer;
    private final JMXServiceURL jmxServiceURL;
    private transient Map env;
    private transient ClassLoader defaultClassLoader;
    private transient RMIConnection connection;
    private transient String connectionId;
    private long clientNotifID = 0L;
    private transient WeakHashMap rmbscMap;
    private transient RMINotifClient rmiNotifClient;
    private transient long clientNotifCounter = 0L;
    private transient boolean connected;
    private transient boolean terminated;
    private transient int[] terminationLock;
    private transient Exception closeException;
    private transient NotificationBroadcasterSupport connectionBroadcaster;
    private transient ClientCommunicatorAdmin communicatorAdmin;
    private static WeakReference orb;
    private static final ObjectName delegateName;
    static /* synthetic */ Class class$javax$management$remote$rmi$RMIServer;
    static /* synthetic */ Class class$javax$management$remote$rmi$RMIConnection;
    static /* synthetic */ Class class$javax$management$remote$rmi$RMIConnector;
    static /* synthetic */ Class class$com$sun$jmx$remote$internal$ProxyRef;
    static /* synthetic */ Class class$java$rmi$server$RemoteRef;
    static /* synthetic */ Class class$com$sun$jmx$remote$internal$ProxyInputStream;

    private RMIConnector(RMIServer rmiServer, JMXServiceURL address, Map environment) {
        if (rmiServer == null && address == null) {
            throw new IllegalArgumentException("rmiServer and jmxServiceURL both null");
        }
        this.initTransients();
        this.rmiServer = rmiServer;
        this.jmxServiceURL = address;
        if (environment == null) {
            this.env = Collections.EMPTY_MAP;
        } else {
            EnvHelp.checkAttributes(environment);
            this.env = Collections.unmodifiableMap(environment);
        }
    }

    public RMIConnector(JMXServiceURL url, Map environment) {
        this(null, url, environment);
    }

    public RMIConnector(RMIServer rmiServer, Map environment) {
        this(rmiServer, null, environment);
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.getClass().getName());
        b.append(":");
        if (this.rmiServer != null) {
            b.append(" rmiServer=").append(this.rmiServer.toString());
        }
        if (this.jmxServiceURL != null) {
            if (this.rmiServer != null) {
                b.append(",");
            }
            b.append(" jmxServiceURL=").append(this.jmxServiceURL.toString());
        }
        return b.toString();
    }

    public void connect() throws IOException {
        this.connect(null);
    }

    public synchronized void connect(Map environment) throws IOException {
        String idstr;
        boolean tracing = logger.traceOn();
        String string = idstr = tracing ? "[" + this.toString() + "]" : null;
        if (this.terminated) {
            logger.trace("connect", idstr + " already closed.");
            throw new IOException("Connector closed");
        }
        if (this.connected) {
            logger.trace("connect", idstr + " already connected.");
            return;
        }
        try {
            RMIServer stub;
            if (tracing) {
                logger.trace("connect", idstr + " connecting...");
            }
            HashMap<String, ClassLoader> usemap = new HashMap<String, ClassLoader>(this.env == null ? Collections.EMPTY_MAP : this.env);
            if (environment != null) {
                EnvHelp.checkAttributes(environment);
                usemap.putAll(environment);
            }
            if (tracing) {
                logger.trace("connect", idstr + " finding stub...");
            }
            RMIServer rMIServer = stub = this.rmiServer != null ? this.rmiServer : this.findRMIServer(this.jmxServiceURL, usemap);
            if (tracing) {
                logger.trace("connect", idstr + " connecting stub...");
            }
            stub = RMIConnector.connectStub(stub, usemap);
            String string2 = idstr = tracing ? "[" + this.toString() + "]" : null;
            if (tracing) {
                logger.trace("connect", idstr + " getting connection...");
            }
            java.lang.Object credentials = usemap.get("jmx.remote.credentials");
            this.connection = RMIConnector.getConnection(stub, credentials);
            if (tracing) {
                logger.trace("connect", idstr + " getting class loader...");
            }
            this.defaultClassLoader = EnvHelp.resolveClientClassLoader(usemap);
            usemap.put("jmx.remote.default.class.loader", this.defaultClassLoader);
            this.rmiNotifClient = new RMINotifClient(this.defaultClassLoader, usemap);
            this.env = usemap;
            long checkPeriod = EnvHelp.getConnectionCheckPeriod(usemap);
            this.communicatorAdmin = new RMIClientCommunicatorAdmin(checkPeriod);
            this.connected = true;
            this.connectionId = this.getConnectionId();
            JMXConnectionNotification connectedNotif = new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.clientNotifID++, "Successful connection", null);
            this.sendNotification(connectedNotif);
            if (tracing) {
                logger.trace("connect", idstr + " done...");
            }
        }
        catch (IOException e) {
            if (tracing) {
                logger.trace("connect", idstr + " failed to connect: " + e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (tracing) {
                logger.trace("connect", idstr + " failed to connect: " + e);
            }
            throw e;
        }
        catch (NamingException e) {
            String msg = "Failed to retrieve RMIServer stub: " + e;
            if (tracing) {
                logger.trace("connect", idstr + " " + msg);
            }
            throw (IOException)EnvHelp.initCause(new IOException(msg), e);
        }
    }

    public synchronized String getConnectionId() throws IOException {
        if (this.terminated || !this.connected) {
            if (logger.traceOn()) {
                logger.trace("getConnectionId", "[" + this.toString() + "] not connected.");
            }
            throw new IOException("Not connected");
        }
        return this.connection.getConnectionId();
    }

    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    public synchronized MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        if (this.terminated) {
            if (logger.traceOn()) {
                logger.trace("getMBeanServerConnection", "[" + this.toString() + "] already closed.");
            }
            throw new IOException("Connection closed");
        }
        if (!this.connected) {
            if (logger.traceOn()) {
                logger.trace("getMBeanServerConnection", "[" + this.toString() + "] is not connected.");
            }
            throw new IOException("Not connected");
        }
        MBeanServerConnection mbsc = (MBeanServerConnection)this.rmbscMap.get(delegationSubject);
        if (mbsc != null) {
            return mbsc;
        }
        mbsc = new RemoteMBeanServerConnection(delegationSubject);
        this.rmbscMap.put(delegationSubject, mbsc);
        return mbsc;
    }

    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, java.lang.Object handback) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.removeNotificationListener(listener);
    }

    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, java.lang.Object handback) throws ListenerNotFoundException {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    private void sendNotification(Notification n) {
        this.connectionBroadcaster.sendNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        boolean tracing = logger.traceOn();
        boolean debug = logger.debugOn();
        String idstr = tracing ? "[" + this.toString() + "]" : null;
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            String savedConnectionId;
            block28: {
                block27: {
                    if (this.terminated) {
                        if (this.closeException == null) {
                            if (tracing) {
                                logger.trace("close", idstr + " already closed.");
                            }
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return;
                        }
                    } else {
                        this.terminated = true;
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    if (this.closeException != null && tracing && tracing) {
                        logger.trace("close", idstr + " had failed: " + this.closeException);
                        logger.trace("close", idstr + " attempting to close again.");
                    }
                    savedConnectionId = null;
                    if (this.connected) {
                        savedConnectionId = this.connectionId;
                    }
                    this.closeException = null;
                    if (tracing) {
                        logger.trace("close", idstr + " closing.");
                    }
                    if (this.communicatorAdmin != null) {
                        this.communicatorAdmin.terminate();
                    }
                    if (this.rmiNotifClient != null) {
                        try {
                            this.rmiNotifClient.terminate();
                            if (tracing) {
                                logger.trace("close", idstr + " RMI Notification client terminated.");
                            }
                        }
                        catch (RuntimeException x) {
                            this.closeException = x;
                            if (tracing) {
                                logger.trace("close", idstr + " Failed to terminate RMI Notification client: " + x);
                            }
                            if (!debug) break block27;
                            logger.debug("close", x);
                        }
                    }
                }
                if (this.connection != null) {
                    try {
                        this.connection.close();
                        if (tracing) {
                            logger.trace("close", idstr + " closed.");
                        }
                    }
                    catch (NoSuchObjectException nse) {
                    }
                    catch (IOException e) {
                        this.closeException = e;
                        if (tracing) {
                            logger.trace("close", idstr + " Failed to close RMIServer: " + e);
                        }
                        if (!debug) break block28;
                        logger.debug("close", e);
                    }
                }
            }
            this.rmbscMap.clear();
            if (savedConnectionId != null) {
                JMXConnectionNotification closedNotif = new JMXConnectionNotification("jmx.remote.connection.closed", this, savedConnectionId, this.clientNotifID++, "Client has been closed", null);
                this.sendNotification(closedNotif);
            }
            if (this.closeException != null) {
                if (tracing) {
                    logger.trace("close", idstr + " failed to close: " + this.closeException);
                }
                if (this.closeException instanceof IOException) {
                    throw (IOException)this.closeException;
                }
                if (this.closeException instanceof RuntimeException) {
                    throw (RuntimeException)this.closeException;
                }
                IOException x = new IOException("Failed to close: " + this.closeException);
                throw (IOException)EnvHelp.initCause(x, this.closeException);
            }
            return;
        }
    }

    private Integer addListenerWithSubject(ObjectName name, MarshalledObject filter, Subject delegationSubject, boolean reconnect) throws InstanceNotFoundException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("addListenerWithSubject", "(ObjectName,MarshalledObject,Subject)");
        }
        ClassLoader old = this.pushDefaultClassLoader();
        ObjectName[] names = new ObjectName[]{name};
        MarshalledObject[] filters = new MarshalledObject[]{filter};
        Subject[] delegationSubjects = new Subject[]{delegationSubject};
        Integer[] listenerIDs = this.addListenersWithSubjects(names, filters, delegationSubjects, reconnect);
        if (debug) {
            logger.debug("addListenerWithSubject", "listenerID=" + listenerIDs[0]);
        }
        return listenerIDs[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer[] addListenersWithSubjects(ObjectName[] names, MarshalledObject[] filters, Subject[] delegationSubjects, boolean reconnect) throws InstanceNotFoundException, IOException {
        Integer[] listenerIDs;
        boolean debug;
        block10: {
            debug = logger.debugOn();
            if (debug) {
                logger.debug("addListenersWithSubjects", "(ObjectName[],MarshalledObject[],Subject[])");
            }
            ClassLoader old = this.pushDefaultClassLoader();
            listenerIDs = null;
            try {
                listenerIDs = this.connection.addNotificationListeners(names, filters, delegationSubjects);
            }
            catch (NoSuchObjectException noe) {
                if (reconnect) {
                    this.communicatorAdmin.gotIOException(noe);
                    listenerIDs = this.connection.addNotificationListeners(names, filters, delegationSubjects);
                    break block10;
                }
                throw noe;
            }
            catch (IOException ioe) {
                this.communicatorAdmin.gotIOException(ioe);
            }
            finally {
                this.popDefaultClassLoader(old);
            }
        }
        if (debug) {
            logger.debug("addListenersWithSubjects", "registered " + listenerIDs.length + " listener(s)");
        }
        return listenerIDs;
    }

    static RMIServer connectStub(RMIServer rmiServer, Map environment) throws IOException {
        if (rmiServer instanceof Stub) {
            Stub stub = (Stub)rmiServer;
            try {
                stub._orb();
            }
            catch (BAD_OPERATION x) {
                stub.connect(RMIConnector.resolveOrb(environment));
            }
        }
        return rmiServer;
    }

    static ORB resolveOrb(Map environment) throws IOException {
        java.lang.Object orb;
        if (environment != null) {
            orb = environment.get("java.naming.corba.orb");
            if (orb != null && !(orb instanceof ORB)) {
                throw new IllegalArgumentException("java.naming.corba.orb must be an instance of org.omg.CORBA.ORB.");
            }
            if (orb != null) {
                return (ORB)orb;
            }
        }
        java.lang.Object v0 = (orb = RMIConnector.orb == null ? null : RMIConnector.orb.get());
        if (orb != null) {
            return (ORB)orb;
        }
        ORB newOrb = ORB.init((String[])null, (Properties)null);
        RMIConnector.orb = new WeakReference<ORB>(newOrb);
        return newOrb;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.rmiServer == null && this.jmxServiceURL == null) {
            throw new InvalidObjectException("rmiServer and jmxServiceURL both null");
        }
        this.initTransients();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.rmiServer == null && this.jmxServiceURL == null) {
            throw new InvalidObjectException("rmiServer and jmxServiceURL both null.");
        }
        RMIConnector.connectStub(this.rmiServer, this.env);
        s.defaultWriteObject();
    }

    private void initTransients() {
        this.rmbscMap = new WeakHashMap();
        this.connected = false;
        this.terminated = false;
        this.terminationLock = new int[0];
        this.connectionBroadcaster = new NotificationBroadcasterSupport();
    }

    private RMIServer findRMIServer(JMXServiceURL directoryURL, Map environment) throws NamingException, IOException {
        String path;
        boolean isIiop = RMIConnectorServer.isIiopURL(directoryURL, true);
        if (isIiop) {
            environment.put("java.naming.corba.orb", RMIConnector.resolveOrb(environment));
        }
        if ((path = directoryURL.getURLPath()).startsWith("/jndi/")) {
            return this.findRMIServerJNDI(path.substring(6), environment, isIiop);
        }
        if (path.startsWith("/stub/")) {
            return this.findRMIServerJRMP(path.substring(6), environment, isIiop);
        }
        if (path.startsWith("/ior/")) {
            return this.findRMIServerIIOP(path.substring(5), environment, isIiop);
        }
        String msg = "URL path must begin with /jndi/ or /stub/ or /ior/: " + path;
        throw new MalformedURLException(msg);
    }

    private RMIServer findRMIServerJNDI(String jndiURL, Map env, boolean isIiop) throws NamingException {
        InitialContext ctx = new InitialContext(EnvHelp.mapToHashtable(env));
        java.lang.Object objref = ctx.lookup(jndiURL);
        ctx.close();
        if (isIiop) {
            return RMIConnector.narrowIIOPServer(objref);
        }
        return RMIConnector.narrowJRMPServer(objref);
    }

    private static RMIServer narrowJRMPServer(java.lang.Object objref) {
        return (RMIServer)objref;
    }

    private static RMIServer narrowIIOPServer(java.lang.Object objref) {
        try {
            return (RMIServer)PortableRemoteObject.narrow((java.lang.Object)objref, (Class)(class$javax$management$remote$rmi$RMIServer == null ? (class$javax$management$remote$rmi$RMIServer = RMIConnector.class$("javax.management.remote.rmi.RMIServer")) : class$javax$management$remote$rmi$RMIServer));
        }
        catch (ClassCastException e) {
            if (logger.traceOn()) {
                logger.trace("narrowIIOPServer", "Failed to narrow objref=" + objref + ": " + e);
            }
            if (logger.debugOn()) {
                logger.debug("narrowIIOPServer", e);
            }
            return null;
        }
    }

    private RMIServer findRMIServerIIOP(String ior, Map env, boolean isIiop) {
        ORB orb = (ORB)env.get("java.naming.corba.orb");
        Object stub = orb.string_to_object(ior);
        return (RMIServer)PortableRemoteObject.narrow((java.lang.Object)stub, (Class)(class$javax$management$remote$rmi$RMIServer == null ? (class$javax$management$remote$rmi$RMIServer = RMIConnector.class$("javax.management.remote.rmi.RMIServer")) : class$javax$management$remote$rmi$RMIServer));
    }

    private RMIServer findRMIServerJRMP(String base64, Map env, boolean isIiop) throws IOException {
        java.lang.Object stub;
        byte[] serialized;
        try {
            serialized = RMIConnector.base64ToByteArray(base64);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Bad BASE64 encoding: " + e.getMessage());
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        ClassLoader loader = EnvHelp.resolveClientClassLoader(env);
        ObjectInputStream oin = loader == null ? new ObjectInputStream(bin) : new ObjectInputStreamWithLoader(bin, loader);
        try {
            stub = oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new MalformedURLException("Class not found: " + e);
        }
        return (RMIServer)PortableRemoteObject.narrow((java.lang.Object)stub, (Class)(class$javax$management$remote$rmi$RMIServer == null ? (class$javax$management$remote$rmi$RMIServer = RMIConnector.class$("javax.management.remote.rmi.RMIServer")) : class$javax$management$remote$rmi$RMIServer));
    }

    private static RMIConnection shadowJrmpStub(RemoteObject stub) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        RemoteRef ref = stub.getRef();
        RemoteRef proxyRef = (RemoteRef)proxyRefConstructor.newInstance(ref);
        Class[] constrTypes = new Class[]{class$java$rmi$server$RemoteRef == null ? (class$java$rmi$server$RemoteRef = RMIConnector.class$("java.rmi.server.RemoteRef")) : class$java$rmi$server$RemoteRef};
        Constructor rmiConnectionImplStubConstructor = rmiConnectionImplStubClass.getConstructor(constrTypes);
        java.lang.Object[] args = new java.lang.Object[]{proxyRef};
        RMIConnection proxyStub = (RMIConnection)rmiConnectionImplStubConstructor.newInstance(args);
        return proxyStub;
    }

    private static RMIConnection shadowIiopStub(Stub stub) throws InstantiationException, IllegalAccessException {
        Stub proxyStub = (Stub)proxyStubClass.newInstance();
        proxyStub._set_delegate(stub._get_delegate());
        return (RMIConnection)proxyStub;
    }

    private static RMIConnection getConnection(RMIServer server, java.lang.Object credentials) throws IOException {
        RMIConnection c = server.newClient(credentials);
        try {
            if (c.getClass() == rmiConnectionImplStubClass) {
                return RMIConnector.shadowJrmpStub((RemoteObject)((java.lang.Object)c));
            }
            if (c.getClass().getName().equals(iiopConnectionStubClassName)) {
                return RMIConnector.shadowIiopStub((Stub)c);
            }
            logger.trace("getConnection", "Did not wrap " + c.getClass() + " to foil " + "stack search for classes: class loading semantics " + "may be incorrect");
        }
        catch (Exception e) {
            logger.error("getConnection", "Could not wrap " + c.getClass() + " to foil " + "stack search for classes: class loading semantics " + "may be incorrect: " + e);
            logger.debug("getConnection", e);
        }
        return c;
    }

    private static byte[] base64ToByteArray(String s) {
        int sLen = s.length();
        int numGroups = sLen / 4;
        if (4 * numGroups != sLen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int missingBytesInLastGroup = 0;
        int numFullGroups = numGroups;
        if (sLen != 0) {
            if (s.charAt(sLen - 1) == '=') {
                ++missingBytesInLastGroup;
                --numFullGroups;
            }
            if (s.charAt(sLen - 2) == '=') {
                ++missingBytesInLastGroup;
            }
        }
        byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
        int inCursor = 0;
        int outCursor = 0;
        for (int i = 0; i < numFullGroups; ++i) {
            int ch0 = RMIConnector.base64toInt(s.charAt(inCursor++));
            int ch1 = RMIConnector.base64toInt(s.charAt(inCursor++));
            int ch2 = RMIConnector.base64toInt(s.charAt(inCursor++));
            int ch3 = RMIConnector.base64toInt(s.charAt(inCursor++));
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            result[outCursor++] = (byte)(ch2 << 6 | ch3);
        }
        if (missingBytesInLastGroup != 0) {
            int ch0 = RMIConnector.base64toInt(s.charAt(inCursor++));
            int ch1 = RMIConnector.base64toInt(s.charAt(inCursor++));
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            if (missingBytesInLastGroup == 1) {
                int ch2 = RMIConnector.base64toInt(s.charAt(inCursor++));
                result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            }
        }
        return result;
    }

    private static int base64toInt(char c) {
        int result = c >= base64ToInt.length ? -1 : base64ToInt[c];
        if (result < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return result;
    }

    private ClassLoader pushDefaultClassLoader() {
        final Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        if (this.defaultClassLoader != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    t.setContextClassLoader(RMIConnector.this.defaultClassLoader);
                    return null;
                }
            });
        }
        return old;
    }

    private void popDefaultClassLoader(final ClassLoader old) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                Thread.currentThread().setContextClassLoader(old);
                return null;
            }
        });
    }

    private static String objects(java.lang.Object[] objs) {
        if (objs == null) {
            return "null";
        }
        return Arrays.asList(objs).toString();
    }

    private static String strings(String[] strs) {
        return RMIConnector.objects(strs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class stubClass;
        Constructor constr;
        Class<?> stubClass2;
        logger = new ClassLogger("javax.management.remote.rmi", "RMIConnector");
        rmiConnectionImplStubClassName = (class$javax$management$remote$rmi$RMIConnection == null ? (class$javax$management$remote$rmi$RMIConnection = RMIConnector.class$("javax.management.remote.rmi.RMIConnection")) : class$javax$management$remote$rmi$RMIConnection).getName() + "Impl_Stub";
        String pRefByteCodeString = "\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0017\n\u0000\u0005\u0000\r\t\u0000\u0004\u0000\u000e\u000b\u0000\u000f\u0000\u0010\u0007\u0000\u0011\u0007\u0000\u0012\u0001\u0000\u0006<init>\u0001\u0000\u001e(Ljava/rmi/server/RemoteRef;)V\u0001\u0000\u0004Code\u0001\u0000\u0006invoke\u0001\u0000S(Ljava/rmi/Remote;Ljava/lang/reflect/Method;[Ljava/lang/Object;J)Ljava/lang/Object;\u0001\u0000\nExceptions\u0007\u0000\u0013\f\u0000\u0006\u0000\u0007\f\u0000\u0014\u0000\u0015\u0007\u0000\u0016\f\u0000\t\u0000\n\u0001\u0000 com/sun/jmx/remote/internal/PRef\u0001\u0000$com/sun/jmx/remote/internal/ProxyRef\u0001\u0000\u0013java/lang/Exception\u0001\u0000\u0003ref\u0001\u0000\u001bLjava/rmi/server/RemoteRef;\u0001\u0000\u0019java/rmi/server/RemoteRef\u0000!\u0000\u0004\u0000\u0005\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0007\u0000\u0001\u0000\b\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\t\u0000\n\u0000\u0002\u0000\b\u0000\u0000\u0000\u001b\u0000\u0006\u0000\u0006\u0000\u0000\u0000\u000f*\u00b4\u0000\u0002+,-\u0016\u0004\u00b9\u0000\u0003\u0006\u0000\u00b0\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0004\u0000\u0001\u0000\f\u0000\u0000";
        final byte[] pRefByteCode = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0017\n\u0000\u0005\u0000\r\t\u0000\u0004\u0000\u000e\u000b\u0000\u000f\u0000\u0010\u0007\u0000\u0011\u0007\u0000\u0012\u0001\u0000\u0006<init>\u0001\u0000\u001e(Ljava/rmi/server/RemoteRef;)V\u0001\u0000\u0004Code\u0001\u0000\u0006invoke\u0001\u0000S(Ljava/rmi/Remote;Ljava/lang/reflect/Method;[Ljava/lang/Object;J)Ljava/lang/Object;\u0001\u0000\nExceptions\u0007\u0000\u0013\f\u0000\u0006\u0000\u0007\f\u0000\u0014\u0000\u0015\u0007\u0000\u0016\f\u0000\t\u0000\n\u0001\u0000 com/sun/jmx/remote/internal/PRef\u0001\u0000$com/sun/jmx/remote/internal/ProxyRef\u0001\u0000\u0013java/lang/Exception\u0001\u0000\u0003ref\u0001\u0000\u001bLjava/rmi/server/RemoteRef;\u0001\u0000\u0019java/rmi/server/RemoteRef\u0000!\u0000\u0004\u0000\u0005\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0007\u0000\u0001\u0000\b\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\t\u0000\n\u0000\u0002\u0000\b\u0000\u0000\u0000\u001b\u0000\u0006\u0000\u0006\u0000\u0000\u0000\u000f*\u00b4\u0000\u0002+,-\u0016\u0004\u00b9\u0000\u0003\u0006\u0000\u00b0\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0004\u0000\u0001\u0000\f\u0000\u0000");
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public java.lang.Object run() throws Exception {
                Class thisClass = class$javax$management$remote$rmi$RMIConnector == null ? (class$javax$management$remote$rmi$RMIConnector = RMIConnector.class$("javax.management.remote.rmi.RMIConnector")) : class$javax$management$remote$rmi$RMIConnector;
                ClassLoader thisLoader = thisClass.getClassLoader();
                ProtectionDomain thisProtectionDomain = thisClass.getProtectionDomain();
                String[] otherClassNames = new String[]{(class$com$sun$jmx$remote$internal$ProxyRef == null ? (class$com$sun$jmx$remote$internal$ProxyRef = RMIConnector.class$("com.sun.jmx.remote.internal.ProxyRef")) : class$com$sun$jmx$remote$internal$ProxyRef).getName()};
                NoCallStackClassLoader cl = new NoCallStackClassLoader(RMIConnector.pRefClassName, pRefByteCode, otherClassNames, thisLoader, thisProtectionDomain);
                Class<?> c = cl.loadClass(RMIConnector.pRefClassName);
                return c.getConstructor(class$java$rmi$server$RemoteRef == null ? (class$java$rmi$server$RemoteRef = RMIConnector.class$("java.rmi.server.RemoteRef")) : class$java$rmi$server$RemoteRef);
            }
        };
        try {
            stubClass2 = Class.forName(rmiConnectionImplStubClassName);
            constr = (Constructor)AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            logger.error("<clinit>", "Failed to initialize proxy reference consructor for " + rmiConnectionImplStubClassName + ": " + e);
            logger.debug("<clinit>", e);
            stubClass2 = null;
            constr = null;
        }
        rmiConnectionImplStubClass = stubClass2;
        proxyRefConstructor = constr;
        String proxyStubByteCodeString = "\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000)\n\u0000\f\u0000\u0016\u0007\u0000\u0017\n\u0000\f\u0000\u0018\n\u0000\u0002\u0000\u0019\u0007\u0000\u001a\n\u0000\u0005\u0000\u001b\n\u0000\u0005\u0000\u001c\n\u0000\u0005\u0000\u001d\n\u0000\u0002\u0000\u001e\n\u0000\f\u0000\u001f\u0007\u0000 \u0007\u0000!\u0001\u0000\u0006<init>\u0001\u0000\u0003()V\u0001\u0000\u0004Code\u0001\u0000\u0007_invoke\u0001\u0000K(Lorg/omg/CORBA/portable/OutputStream;)Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\nExceptions\u0007\u0000\"\u0001\u0000\r_releaseReply\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\f\u0000\r\u0000\u000e\u0001\u0000(com/sun/jmx/remote/internal/PInputStream\f\u0000\u0010\u0000\u0011\f\u0000\r\u0000\u0015\u0001\u0000+org/omg/CORBA/portable/ApplicationException\f\u0000#\u0000$\f\u0000%\u0000&\f\u0000\r\u0000'\f\u0000(\u0000$\f\u0000\u0014\u0000\u0015\u0001\u0000%com/sun/jmx/remote/internal/ProxyStub\u0001\u0000<org/omg/stub/javax/management/remote/rmi/_RMIConnection_Stub\u0001\u0000)org/omg/CORBA/portable/RemarshalException\u0001\u0000\u000egetInputStream\u0001\u0000&()Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\u0005getId\u0001\u0000\u0014()Ljava/lang/String;\u0001\u00009(Ljava/lang/String;Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0015getProxiedInputStream\u0000!\u0000\u000b\u0000\f\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\u000f\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0001\u0000\u0000\u0000\u0005*\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0010\u0000\u0011\u0000\u0002\u0000\u000f\u0000\u0000\u0000;\u0000\u0004\u0000\u0004\u0000\u0000\u0000'\u00bb\u0000\u0002Y*+\u00b7\u0000\u0003\u00b7\u0000\u0004\u00b0M\u00bb\u0000\u0002Y,\u00b6\u0000\u0006\u00b7\u0000\u0004N\u00bb\u0000\u0005Y,\u00b6\u0000\u0007-\u00b7\u0000\b\u00bf\u0000\u0001\u0000\u0000\u0000\f\u0000\r\u0000\u0005\u0000\u0000\u0000\u0012\u0000\u0000\u0000\u0006\u0000\u0002\u0000\u0005\u0000\u0013\u0000\u0001\u0000\u0014\u0000\u0015\u0000\u0001\u0000\u000f\u0000\u0000\u0000\u001e\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0012+\u00c6\u0000\u000b+\u00c0\u0000\u0002\u00b6\u0000\tL*+\u00b7\u0000\n\u00b1\u0000\u0000\u0000\u0000\u0000\u0000";
        String pInputStreamByteCodeString = "\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u001e\n\u0000\u0007\u0000\u000f\t\u0000\u0006\u0000\u0010\n\u0000\u0011\u0000\u0012\n\u0000\u0006\u0000\u0013\n\u0000\u0014\u0000\u0015\u0007\u0000\u0016\u0007\u0000\u0017\u0001\u0000\u0006<init>\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0004Code\u0001\u0000\bread_any\u0001\u0000\u0015()Lorg/omg/CORBA/Any;\u0001\u0000\nread_value\u0001\u0000)(Ljava/lang/Class;)Ljava/io/Serializable;\f\u0000\b\u0000\t\f\u0000\u0018\u0000\u0019\u0007\u0000\u001a\f\u0000\u000b\u0000\f\f\u0000\u001b\u0000\u001c\u0007\u0000\u001d\f\u0000\r\u0000\u000e\u0001\u0000(com/sun/jmx/remote/internal/PInputStream\u0001\u0000,com/sun/jmx/remote/internal/ProxyInputStream\u0001\u0000\u0002in\u0001\u0000$Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\"org/omg/CORBA/portable/InputStream\u0001\u0000\u0006narrow\u0001\u0000*()Lorg/omg/CORBA_2_3/portable/InputStream;\u0001\u0000&org/omg/CORBA_2_3/portable/InputStream\u0000!\u0000\u0006\u0000\u0007\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\b\u0000\t\u0000\u0001\u0000\n\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u000b\u0000\f\u0000\u0001\u0000\n\u0000\u0000\u0000\u0014\u0000\u0001\u0000\u0001\u0000\u0000\u0000\b*\u00b4\u0000\u0002\u00b6\u0000\u0003\u00b0\u0000\u0000\u0000\u0000\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\n\u0000\u0000\u0000\u0015\u0000\u0002\u0000\u0002\u0000\u0000\u0000\t*\u00b6\u0000\u0004+\u00b6\u0000\u0005\u00b0\u0000\u0000\u0000\u0000\u0000\u0000";
        byte[] proxyStubByteCode = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000)\n\u0000\f\u0000\u0016\u0007\u0000\u0017\n\u0000\f\u0000\u0018\n\u0000\u0002\u0000\u0019\u0007\u0000\u001a\n\u0000\u0005\u0000\u001b\n\u0000\u0005\u0000\u001c\n\u0000\u0005\u0000\u001d\n\u0000\u0002\u0000\u001e\n\u0000\f\u0000\u001f\u0007\u0000 \u0007\u0000!\u0001\u0000\u0006<init>\u0001\u0000\u0003()V\u0001\u0000\u0004Code\u0001\u0000\u0007_invoke\u0001\u0000K(Lorg/omg/CORBA/portable/OutputStream;)Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\nExceptions\u0007\u0000\"\u0001\u0000\r_releaseReply\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\f\u0000\r\u0000\u000e\u0001\u0000(com/sun/jmx/remote/internal/PInputStream\f\u0000\u0010\u0000\u0011\f\u0000\r\u0000\u0015\u0001\u0000+org/omg/CORBA/portable/ApplicationException\f\u0000#\u0000$\f\u0000%\u0000&\f\u0000\r\u0000'\f\u0000(\u0000$\f\u0000\u0014\u0000\u0015\u0001\u0000%com/sun/jmx/remote/internal/ProxyStub\u0001\u0000<org/omg/stub/javax/management/remote/rmi/_RMIConnection_Stub\u0001\u0000)org/omg/CORBA/portable/RemarshalException\u0001\u0000\u000egetInputStream\u0001\u0000&()Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\u0005getId\u0001\u0000\u0014()Ljava/lang/String;\u0001\u00009(Ljava/lang/String;Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0015getProxiedInputStream\u0000!\u0000\u000b\u0000\f\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\u000f\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0001\u0000\u0000\u0000\u0005*\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0010\u0000\u0011\u0000\u0002\u0000\u000f\u0000\u0000\u0000;\u0000\u0004\u0000\u0004\u0000\u0000\u0000'\u00bb\u0000\u0002Y*+\u00b7\u0000\u0003\u00b7\u0000\u0004\u00b0M\u00bb\u0000\u0002Y,\u00b6\u0000\u0006\u00b7\u0000\u0004N\u00bb\u0000\u0005Y,\u00b6\u0000\u0007-\u00b7\u0000\b\u00bf\u0000\u0001\u0000\u0000\u0000\f\u0000\r\u0000\u0005\u0000\u0000\u0000\u0012\u0000\u0000\u0000\u0006\u0000\u0002\u0000\u0005\u0000\u0013\u0000\u0001\u0000\u0014\u0000\u0015\u0000\u0001\u0000\u000f\u0000\u0000\u0000\u001e\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0012+\u00c6\u0000\u000b+\u00c0\u0000\u0002\u00b6\u0000\tL*+\u00b7\u0000\n\u00b1\u0000\u0000\u0000\u0000\u0000\u0000");
        byte[] pInputStreamByteCode = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u001e\n\u0000\u0007\u0000\u000f\t\u0000\u0006\u0000\u0010\n\u0000\u0011\u0000\u0012\n\u0000\u0006\u0000\u0013\n\u0000\u0014\u0000\u0015\u0007\u0000\u0016\u0007\u0000\u0017\u0001\u0000\u0006<init>\u0001\u0000'(Lorg/omg/CORBA/portable/InputStream;)V\u0001\u0000\u0004Code\u0001\u0000\bread_any\u0001\u0000\u0015()Lorg/omg/CORBA/Any;\u0001\u0000\nread_value\u0001\u0000)(Ljava/lang/Class;)Ljava/io/Serializable;\f\u0000\b\u0000\t\f\u0000\u0018\u0000\u0019\u0007\u0000\u001a\f\u0000\u000b\u0000\f\f\u0000\u001b\u0000\u001c\u0007\u0000\u001d\f\u0000\r\u0000\u000e\u0001\u0000(com/sun/jmx/remote/internal/PInputStream\u0001\u0000,com/sun/jmx/remote/internal/ProxyInputStream\u0001\u0000\u0002in\u0001\u0000$Lorg/omg/CORBA/portable/InputStream;\u0001\u0000\"org/omg/CORBA/portable/InputStream\u0001\u0000\u0006narrow\u0001\u0000*()Lorg/omg/CORBA_2_3/portable/InputStream;\u0001\u0000&org/omg/CORBA_2_3/portable/InputStream\u0000!\u0000\u0006\u0000\u0007\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0000\b\u0000\t\u0000\u0001\u0000\n\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u000b\u0000\f\u0000\u0001\u0000\n\u0000\u0000\u0000\u0014\u0000\u0001\u0000\u0001\u0000\u0000\u0000\b*\u00b4\u0000\u0002\u00b6\u0000\u0003\u00b0\u0000\u0000\u0000\u0000\u0000\u0001\u0000\r\u0000\u000e\u0000\u0001\u0000\n\u0000\u0000\u0000\u0015\u0000\u0002\u0000\u0002\u0000\u0000\u0000\t*\u00b6\u0000\u0004+\u00b6\u0000\u0005\u00b0\u0000\u0000\u0000\u0000\u0000\u0000");
        final String[] classNames = new String[]{proxyStubClassName, pInputStreamClassName};
        final byte[][] byteCodes = new byte[][]{proxyStubByteCode, pInputStreamByteCode};
        final String[] otherClassNames = new String[]{iiopConnectionStubClassName, (class$com$sun$jmx$remote$internal$ProxyInputStream == null ? (class$com$sun$jmx$remote$internal$ProxyInputStream = RMIConnector.class$("com.sun.jmx.remote.internal.ProxyInputStream")) : class$com$sun$jmx$remote$internal$ProxyInputStream).getName()};
        PrivilegedExceptionAction action2 = new PrivilegedExceptionAction(){

            public java.lang.Object run() throws Exception {
                Class thisClass = class$javax$management$remote$rmi$RMIConnector == null ? (class$javax$management$remote$rmi$RMIConnector = RMIConnector.class$("javax.management.remote.rmi.RMIConnector")) : class$javax$management$remote$rmi$RMIConnector;
                ClassLoader thisLoader = thisClass.getClassLoader();
                ProtectionDomain thisProtectionDomain = thisClass.getProtectionDomain();
                NoCallStackClassLoader cl = new NoCallStackClassLoader(classNames, byteCodes, otherClassNames, thisLoader, thisProtectionDomain);
                return cl.loadClass(RMIConnector.proxyStubClassName);
            }
        };
        try {
            stubClass = (Class)AccessController.doPrivileged(action2);
        }
        catch (Exception e) {
            logger.error("<clinit>", "Unexpected exception making shadow IIOP stub class: " + e);
            logger.debug("<clinit>", e);
            stubClass = null;
        }
        proxyStubClass = stubClass;
        base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
        orb = null;
        try {
            delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            Error error = new Error("Can't initialize delegateName");
            EnvHelp.initCause(error, e);
            throw error;
        }
    }

    private static final class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private final ClassLoader loader;

        ObjectInputStreamWithLoader(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.loader = cl;
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            return Class.forName(classDesc.getName(), false, this.loader);
        }
    }

    private class RMIClientCommunicatorAdmin
    extends ClientCommunicatorAdmin {
        public RMIClientCommunicatorAdmin(long period) {
            super(period);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gotIOException(IOException ioe) throws IOException {
            if (ioe instanceof NoSuchObjectException) {
                super.gotIOException(ioe);
                return;
            }
            try {
                RMIConnector.this.connection.getDefaultDomain(null);
            }
            catch (IOException ioexc) {
                int[] nArray = RMIConnector.this.terminationLock;
                synchronized (nArray) {
                    if (!RMIConnector.this.terminated) {
                        JMXConnectionNotification failedNotif = new JMXConnectionNotification("jmx.remote.connection.failed", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifID++, "Failed to communicate with the server: " + ioe.toString(), ioe);
                        RMIConnector.this.sendNotification(failedNotif);
                        try {
                            RMIConnector.this.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (ioe instanceof ServerException) {
                Throwable tt = ((ServerException)ioe).detail;
                if (tt instanceof IOException) {
                    throw (IOException)tt;
                }
                if (tt instanceof RuntimeException) {
                    throw (RuntimeException)tt;
                }
            }
            throw ioe;
        }

        public void reconnectNotificationListeners(ClientListenerInfo[] old) throws IOException {
            int i;
            int len = old.length;
            ClientListenerInfo[] clis = new ClientListenerInfo[len];
            Subject[] subjects = new Subject[len];
            ObjectName[] names = new ObjectName[len];
            NotificationListener[] listeners = new NotificationListener[len];
            NotificationFilter[] filters = new NotificationFilter[len];
            MarshalledObject[] mFilters = new MarshalledObject[len];
            java.lang.Object[] handbacks = new java.lang.Object[len];
            for (i = 0; i < len; ++i) {
                subjects[i] = old[i].getDelegationSubject();
                names[i] = old[i].getObjectName();
                listeners[i] = old[i].getListener();
                filters[i] = old[i].getNotificationFilter();
                mFilters[i] = new MarshalledObject<NotificationFilter>(filters[i]);
                handbacks[i] = old[i].getHandback();
            }
            try {
                Integer[] ids = RMIConnector.this.addListenersWithSubjects(names, mFilters, subjects, false);
                for (i = 0; i < len; ++i) {
                    clis[i] = new ClientListenerInfo(ids[i], names[i], listeners[i], filters[i], handbacks[i], subjects[i]);
                }
                RMIConnector.this.rmiNotifClient.postReconnection(clis);
                return;
            }
            catch (InstanceNotFoundException infe) {
                int j = 0;
                for (i = 0; i < len; ++i) {
                    try {
                        Integer id = RMIConnector.this.addListenerWithSubject(names[i], new MarshalledObject<NotificationFilter>(filters[i]), subjects[i], false);
                        clis[j++] = new ClientListenerInfo(id, names[i], listeners[i], filters[i], handbacks[i], subjects[i]);
                        continue;
                    }
                    catch (InstanceNotFoundException infe2) {
                        logger.warning("reconnectNotificationListeners", "Can't reconnect listener for " + names[i]);
                    }
                }
                if (j != len) {
                    ClientListenerInfo[] tmp = clis;
                    clis = new ClientListenerInfo[j];
                    System.arraycopy(tmp, 0, clis, 0, j);
                }
                RMIConnector.this.rmiNotifClient.postReconnection(clis);
                return;
            }
        }

        protected void checkConnection() throws IOException {
            if (logger.debugOn()) {
                logger.debug("RMIClientCommunicatorAdmin-checkConnection", "Calling the method getDefaultDomain.");
            }
            RMIConnector.this.connection.getDefaultDomain(null);
        }

        protected void doStart() throws IOException {
            RMIServer stub = null;
            try {
                stub = RMIConnector.this.rmiServer != null ? RMIConnector.this.rmiServer : RMIConnector.this.findRMIServer(RMIConnector.this.jmxServiceURL, RMIConnector.this.env);
            }
            catch (NamingException ne) {
                throw new IOException("Failed to get a RMI stub: " + ne);
            }
            stub = RMIConnector.connectStub(stub, RMIConnector.this.env);
            java.lang.Object credentials = RMIConnector.this.env.get("jmx.remote.credentials");
            RMIConnector.this.connection = stub.newClient(credentials);
            ClientListenerInfo[] old = RMIConnector.this.rmiNotifClient.preReconnection();
            this.reconnectNotificationListeners(old);
            RMIConnector.this.connectionId = RMIConnector.this.getConnectionId();
            JMXConnectionNotification reconnectedNotif = new JMXConnectionNotification("jmx.remote.connection.opened", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifID++, "Reconnected to server", null);
            RMIConnector.this.sendNotification(reconnectedNotif);
        }

        protected void doStop() {
            try {
                RMIConnector.this.close();
            }
            catch (IOException ioe) {
                logger.warning("RMIClientCommunicatorAdmin-doStop", "Failed to call the method close():" + ioe);
                logger.debug("RMIClientCommunicatorAdmin-doStop", ioe);
            }
        }
    }

    private class RMINotifClient
    extends ClientNotifForwarder {
        public RMINotifClient(ClassLoader cl, Map env) {
            super(cl, env);
        }

        protected NotificationResult fetchNotifs(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException, ClassNotFoundException {
            while (true) {
                try {
                    return RMIConnector.this.connection.fetchNotifications(clientSequenceNumber, maxNotifications, timeout);
                }
                catch (IOException ioe) {
                    IOException org = ioe;
                    try {
                        RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                    }
                    catch (IOException ee) {
                        if (org instanceof UnmarshalException) {
                            UnmarshalException ume = (UnmarshalException)org;
                            if (ume.detail instanceof ClassNotFoundException) {
                                throw (ClassNotFoundException)ume.detail;
                            }
                            if (ume.detail instanceof WriteAbortedException) {
                                WriteAbortedException wae = (WriteAbortedException)ume.detail;
                                if (wae.detail instanceof IOException) {
                                    throw (IOException)wae.detail;
                                }
                            }
                        } else if (org instanceof MarshalException) {
                            MarshalException me = (MarshalException)org;
                            if (me.detail instanceof NotSerializableException) {
                                throw (NotSerializableException)me.detail;
                            }
                        }
                        throw org;
                    }
                }
            }
        }

        protected Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException {
            Integer[] listenerIDs;
            MarshalledObject<NotificationFilterSupport> sFilter = null;
            NotificationFilterSupport clientFilter = new NotificationFilterSupport();
            clientFilter.enableType("JMX.mbean.unregistered");
            sFilter = new MarshalledObject<NotificationFilterSupport>(clientFilter);
            ObjectName[] names = new ObjectName[]{delegateName};
            MarshalledObject[] filters = new MarshalledObject[]{sFilter};
            Subject[] subjects = new Subject[]{null};
            try {
                listenerIDs = RMIConnector.this.connection.addNotificationListeners(names, filters, subjects);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                listenerIDs = RMIConnector.this.connection.addNotificationListeners(names, filters, subjects);
            }
            return listenerIDs[0];
        }

        protected void removeListenerForMBeanRemovedNotif(Integer id) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
            try {
                RMIConnector.this.connection.removeNotificationListeners(delegateName, new Integer[]{id}, null);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(delegateName, new Integer[]{id}, null);
            }
        }

        protected void lostNotifs(String message, long number) {
            String notifType = "jmx.remote.connection.notifs.lost";
            JMXConnectionNotification n = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", RMIConnector.this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifCounter++, message, new Long(number));
            RMIConnector.this.sendNotification(n);
        }
    }

    private class RemoteMBeanServerConnection
    implements MBeanServerConnection {
        private Subject delegationSubject;

        public RemoteMBeanServerConnection() {
            this(null);
        }

        public RemoteMBeanServerConnection(Subject delegationSubject) {
            this.delegationSubject = delegationSubject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName)", "className=" + className + ", name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName)", "className=" + className + ", name=" + name + ", loaderName=" + loaderName + ")");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String className, ObjectName name, java.lang.Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,Object[],String[])", "className=" + className + ", name=" + name + ", params=" + RMIConnector.objects(params) + ", signature=" + RMIConnector.strings(signature));
            }
            MarshalledObject<java.lang.Object[]> sParams = new MarshalledObject<java.lang.Object[]>(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, java.lang.Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "className=" + className + ", name=" + name + ", loaderName=" + loaderName + ", params=" + RMIConnector.objects(params) + ", signature=" + RMIConnector.strings(signature));
            }
            MarshalledObject<java.lang.Object[]> sParams = new MarshalledObject<java.lang.Object[]>(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            if (logger.debugOn()) {
                logger.debug("unregisterMBean", "name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.unregisterMBean(name, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.unregisterMBean(name, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("getObjectInstance", "name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.getObjectInstance(name, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.getObjectInstance(name, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
            if (logger.debugOn()) {
                logger.debug("queryMBeans", "name=" + name + ", query=" + query);
            }
            MarshalledObject<QueryExp> sQuery = new MarshalledObject<QueryExp>(query);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Set set = RMIConnector.this.connection.queryMBeans(name, sQuery, this.delegationSubject);
                return set;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Set set = RMIConnector.this.connection.queryMBeans(name, sQuery, this.delegationSubject);
                return set;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set queryNames(ObjectName name, QueryExp query) throws IOException {
            if (logger.debugOn()) {
                logger.debug("queryNames", "name=" + name + ", query=" + query);
            }
            MarshalledObject<QueryExp> sQuery = new MarshalledObject<QueryExp>(query);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Set set = RMIConnector.this.connection.queryNames(name, sQuery, this.delegationSubject);
                return set;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Set set = RMIConnector.this.connection.queryNames(name, sQuery, this.delegationSubject);
                return set;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRegistered(ObjectName name) throws IOException {
            if (logger.debugOn()) {
                logger.debug("isRegistered", "name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                boolean bl = RMIConnector.this.connection.isRegistered(name, this.delegationSubject);
                return bl;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                boolean bl = RMIConnector.this.connection.isRegistered(name, this.delegationSubject);
                return bl;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer getMBeanCount() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getMBeanCount", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Integer n = RMIConnector.this.connection.getMBeanCount(this.delegationSubject);
                return n;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Integer n = RMIConnector.this.connection.getMBeanCount(this.delegationSubject);
                return n;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public java.lang.Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getAttribute", "name=" + name + ", attribute=" + attribute);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                java.lang.Object object = RMIConnector.this.connection.getAttribute(name, attribute, this.delegationSubject);
                return object;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                java.lang.Object object = RMIConnector.this.connection.getAttribute(name, attribute, this.delegationSubject);
                return object;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getAttributes", "name=" + name + ", attributes=" + RMIConnector.strings(attributes));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                AttributeList attributeList = RMIConnector.this.connection.getAttributes(name, attributes, this.delegationSubject);
                return attributeList;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                AttributeList attributeList = RMIConnector.this.connection.getAttributes(name, attributes, this.delegationSubject);
                return attributeList;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("setAttribute", "name=" + name + ", attribute=" + attribute);
            }
            MarshalledObject<Attribute> sAttribute = new MarshalledObject<Attribute>(attribute);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.setAttribute(name, sAttribute, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.setAttribute(name, sAttribute, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("setAttributes", "name=" + name + ", attributes=" + attributes);
            }
            MarshalledObject<AttributeList> sAttributes = new MarshalledObject<AttributeList>(attributes);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                AttributeList attributeList = RMIConnector.this.connection.setAttributes(name, sAttributes, this.delegationSubject);
                return attributeList;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                AttributeList attributeList = RMIConnector.this.connection.setAttributes(name, sAttributes, this.delegationSubject);
                return attributeList;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public java.lang.Object invoke(ObjectName name, String operationName, java.lang.Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("invoke", "name=" + name + ", operationName=" + operationName + ", params=" + RMIConnector.objects(params) + ", signature=" + RMIConnector.strings(signature));
            }
            MarshalledObject<java.lang.Object[]> sParams = new MarshalledObject<java.lang.Object[]>(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                java.lang.Object object = RMIConnector.this.connection.invoke(name, operationName, sParams, signature, this.delegationSubject);
                return object;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                java.lang.Object object = RMIConnector.this.connection.invoke(name, operationName, sParams, signature, this.delegationSubject);
                return object;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDefaultDomain() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getDefaultDomain", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                String string = RMIConnector.this.connection.getDefaultDomain(this.delegationSubject);
                return string;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                String string = RMIConnector.this.connection.getDefaultDomain(this.delegationSubject);
                return string;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getDomains() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getDomains", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                String[] stringArray = RMIConnector.this.connection.getDomains(this.delegationSubject);
                return stringArray;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                String[] stringArray = RMIConnector.this.connection.getDomains(this.delegationSubject);
                return stringArray;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getMBeanInfo", "name=" + name);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                MBeanInfo mBeanInfo = RMIConnector.this.connection.getMBeanInfo(name, this.delegationSubject);
                return mBeanInfo;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                MBeanInfo mBeanInfo = RMIConnector.this.connection.getMBeanInfo(name, this.delegationSubject);
                return mBeanInfo;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("isInstanceOf", "name=" + name + ", className=" + className);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                boolean bl = RMIConnector.this.connection.isInstanceOf(name, className, this.delegationSubject);
                return bl;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                boolean bl = RMIConnector.this.connection.isInstanceOf(name, className, this.delegationSubject);
                return bl;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, java.lang.Object handback) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "name=" + name + ", listener=" + listener + ", filter=" + filter + ", handback=" + handback);
            }
            MarshalledObject<NotificationFilter> sFilter = new MarshalledObject<NotificationFilter>(filter);
            MarshalledObject<java.lang.Object> sHandback = new MarshalledObject<java.lang.Object>(handback);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.addNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.addNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName)", "name=" + name + ", listener=" + listener);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListener(name, listener, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListener(name, listener, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, java.lang.Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "name=" + name + ", listener=" + listener + ", filter=" + filter + ", handback=" + handback);
            }
            MarshalledObject<NotificationFilter> sFilter = new MarshalledObject<NotificationFilter>(filter);
            MarshalledObject<java.lang.Object> sHandback = new MarshalledObject<java.lang.Object>(handback);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, java.lang.Object handback) throws InstanceNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("addNotificationListener(ObjectName,NotificationListener,NotificationFilter,Object)", "name=" + name + ", listener=" + listener + ", filter=" + filter + ", handback=" + handback);
            }
            Integer listenerID = RMIConnector.this.addListenerWithSubject(name, new MarshalledObject<NotificationFilter>(filter), this.delegationSubject, true);
            RMIConnector.this.rmiNotifClient.addNotificationListener(listenerID, name, listener, filter, handback, this.delegationSubject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("removeNotificationListener(ObjectName,NotificationListener)", "name=" + name + ", listener=" + listener);
            }
            java.lang.Object[] ret = RMIConnector.this.rmiNotifClient.removeNotificationListener(name, listener);
            if (debug) {
                logger.debug("removeNotificationListener", "listenerIDs=" + RMIConnector.objects(ret));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListeners(name, (Integer[])ret, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(name, (Integer[])ret, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, java.lang.Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("removeNotificationListener(ObjectName,NotificationListener,NotificationFilter,Object)", "name=" + name + ", listener=" + listener + ", filter=" + filter + ", handback=" + handback);
            }
            Integer ret = RMIConnector.this.rmiNotifClient.removeNotificationListener(name, listener, filter, handback);
            if (debug) {
                logger.debug("removeNotificationListener", "listenerID=" + ret);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListeners(name, new Integer[]{ret}, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(name, new Integer[]{ret}, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }
    }
}

