/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.ServerCommunicatorAdmin;
import com.sun.jmx.remote.internal.ServerNotifForwarder;
import com.sun.jmx.remote.internal.Unmarshal;
import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.security.SubjectDelegator;
import com.sun.jmx.remote.util.ClassLoaderWithRepository;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import com.sun.jmx.remote.util.OrderClassLoaders;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.UnmarshalException;
import java.rmi.server.Unreferenced;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.JMXServerErrorException;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.management.remote.rmi.NoCallStackClassLoader;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;

public class RMIConnectionImpl
implements RMIConnection,
Unreferenced {
    private static final String unmarshalClassName = "com.sun.jmx.remote.internal.MOGet";
    private static boolean bootstrapLoaded = (class$javax$management$remote$rmi$RMIConnectionImpl == null ? (class$javax$management$remote$rmi$RMIConnectionImpl = RMIConnectionImpl.class$("javax.management.remote.rmi.RMIConnectionImpl")) : class$javax$management$remote$rmi$RMIConnectionImpl).getClassLoader() == (class$java$lang$Object == null ? (class$java$lang$Object = RMIConnectionImpl.class$("java.lang.Object")) : class$java$lang$Object).getClassLoader();
    private static final Unmarshal unmarshal;
    private static final Object[] NO_OBJECTS;
    private static final String[] NO_STRINGS;
    private final Subject subject;
    private final SubjectDelegator subjectDelegator;
    private final AccessControlContext acc;
    private final RMIServerImpl rmiServer;
    private final MBeanServer mbeanServer;
    private final ClassLoader defaultClassLoader;
    private final ClassLoaderWithRepository classLoaderWithRepository;
    private boolean terminated = false;
    private final String connectionId;
    private final ServerCommunicatorAdmin serverCommunicatorAdmin;
    private static final int ADD_NOTIFICATION_LISTENERS = 1;
    private static final int ADD_NOTIFICATION_LISTENER_OBJECTNAME = 2;
    private static final int CREATE_MBEAN = 3;
    private static final int CREATE_MBEAN_PARAMS = 4;
    private static final int CREATE_MBEAN_LOADER = 5;
    private static final int CREATE_MBEAN_LOADER_PARAMS = 6;
    private static final int GET_ATTRIBUTE = 7;
    private static final int GET_ATTRIBUTES = 8;
    private static final int GET_DEFAULT_DOMAIN = 9;
    private static final int GET_DOMAINS = 10;
    private static final int GET_MBEAN_COUNT = 11;
    private static final int GET_MBEAN_INFO = 12;
    private static final int GET_OBJECT_INSTANCE = 13;
    private static final int INVOKE = 14;
    private static final int IS_INSTANCE_OF = 15;
    private static final int IS_REGISTERED = 16;
    private static final int QUERY_MBEANS = 17;
    private static final int QUERY_NAMES = 18;
    private static final int REMOVE_NOTIFICATION_LISTENER = 19;
    private static final int REMOVE_NOTIFICATION_LISTENER_FILTER_HANDBACK = 20;
    private static final int REMOVE_NOTIFICATION_LISTENER_OBJECTNAME = 21;
    private static final int REMOVE_NOTIFICATION_LISTENER_OBJECTNAME_FILTER_HANDBACK = 22;
    private static final int SET_ATTRIBUTE = 23;
    private static final int SET_ATTRIBUTES = 24;
    private static final int UNREGISTER_MBEAN = 25;
    private ServerNotifForwarder serverNotifForwarder;
    private Map env;
    private static final ClassLogger logger;
    static /* synthetic */ Class class$javax$management$remote$rmi$RMIConnectionImpl;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sun$jmx$remote$internal$Unmarshal;

    public RMIConnectionImpl(RMIServerImpl rmiServer, String connectionId, ClassLoader defaultClassLoader, Subject subject, Map env) {
        if (rmiServer == null || connectionId == null) {
            throw new NullPointerException("Illegal null argument");
        }
        if (env == null) {
            env = Collections.EMPTY_MAP;
        }
        this.rmiServer = rmiServer;
        this.connectionId = connectionId;
        this.defaultClassLoader = defaultClassLoader;
        this.subjectDelegator = new SubjectDelegator();
        this.subject = subject;
        this.acc = subject == null ? null : new AccessControlContext(AccessController.getContext(), new JMXSubjectDomainCombiner(subject));
        this.mbeanServer = rmiServer.getMBeanServer();
        final ClassLoader dcl = defaultClassLoader;
        this.classLoaderWithRepository = (ClassLoaderWithRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ClassLoaderWithRepository(RMIConnectionImpl.this.getClassLoaderRepository(), dcl);
            }
        });
        this.serverCommunicatorAdmin = new RMIServerCommunicatorAdmin(EnvHelp.getServerConnectionTimeout(env));
        this.env = env;
    }

    private synchronized ServerNotifForwarder getServerNotifFwd() {
        if (this.serverNotifForwarder == null) {
            this.serverNotifForwarder = new ServerNotifForwarder(this.mbeanServer, this.env, this.rmiServer.getNotifBuffer());
        }
        return this.serverNotifForwarder;
    }

    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    public synchronized void close() throws IOException {
        String idstr;
        boolean debug = logger.debugOn();
        String string = idstr = debug ? "[" + this.toString() + "]" : null;
        if (this.terminated) {
            if (debug) {
                logger.debug("close", idstr + " already terminated.");
            }
            return;
        }
        if (debug) {
            logger.debug("close", idstr + " closing.");
        }
        this.terminated = true;
        if (this.serverCommunicatorAdmin != null) {
            this.serverCommunicatorAdmin.terminate();
        }
        if (this.serverNotifForwarder != null) {
            this.serverNotifForwarder.terminate();
        }
        this.rmiServer.clientClosed(this);
        if (debug) {
            logger.debug("close", idstr + " closed.");
        }
    }

    public void unreferenced() {
        logger.debug("unreferenced", "called");
        try {
            this.close();
            logger.debug("unreferenced", "done");
        }
        catch (IOException e) {
            logger.fine("unreferenced", e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            Object[] params = new Object[]{className, name};
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName)", "connectionId=" + this.connectionId + ", className=" + className + ", name=" + name);
            }
            return (ObjectInstance)this.doPrivilegedOperation(3, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            Object[] params = new Object[]{className, name, loaderName};
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName)", "connectionId=" + this.connectionId + ", className=" + className + ", name=" + name + ", loaderName=" + loaderName);
            }
            return (ObjectInstance)this.doPrivilegedOperation(5, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, MarshalledObject params, String[] signature, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("createMBean(String,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", unwrapping parameters using classLoaderWithRepository.");
        }
        Object[] values = RMIConnectionImpl.nullIsEmpty((Object[])RMIConnectionImpl.unwrap(params, this.classLoaderWithRepository));
        try {
            Object[] params2 = new Object[]{className, name, values, RMIConnectionImpl.nullIsEmpty(signature)};
            if (debug) {
                logger.debug("createMBean(String,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", className=" + className + ", name=" + name + ", params=" + RMIConnectionImpl.objects(values) + ", signature=" + RMIConnectionImpl.strings(signature));
            }
            return (ObjectInstance)this.doPrivilegedOperation(4, params2, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, MarshalledObject params, String[] signature, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", unwrapping params with MBean extended ClassLoader.");
        }
        Object[] values = RMIConnectionImpl.nullIsEmpty((Object[])RMIConnectionImpl.unwrap(params, this.getClassLoader(loaderName), this.defaultClassLoader));
        try {
            Object[] params2 = new Object[]{className, name, loaderName, values, RMIConnectionImpl.nullIsEmpty(signature)};
            if (debug) {
                logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", className=" + className + ", name=" + name + ", loaderName=" + loaderName + ", params=" + RMIConnectionImpl.objects(values) + ", signature=" + RMIConnectionImpl.strings(signature));
            }
            return (ObjectInstance)this.doPrivilegedOperation(6, params2, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public void unregisterMBean(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            Object[] params = new Object[]{name};
            if (logger.debugOn()) {
                logger.debug("unregisterMBean", "connectionId=" + this.connectionId + ", name=" + name);
            }
            this.doPrivilegedOperation(25, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", name);
        try {
            Object[] params = new Object[]{name};
            if (logger.debugOn()) {
                logger.debug("getObjectInstance", "connectionId=" + this.connectionId + ", name=" + name);
            }
            return (ObjectInstance)this.doPrivilegedOperation(13, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public Set queryMBeans(ObjectName name, MarshalledObject query, Subject delegationSubject) throws IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("queryMBeans", "connectionId=" + this.connectionId + " unwrapping query with defaultClassLoader.");
        }
        QueryExp queryValue = (QueryExp)RMIConnectionImpl.unwrap(query, this.defaultClassLoader);
        try {
            Object[] params = new Object[]{name, queryValue};
            if (debug) {
                logger.debug("queryMBeans", "connectionId=" + this.connectionId + ", name=" + name + ", query=" + query);
            }
            return (Set)this.doPrivilegedOperation(17, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public Set queryNames(ObjectName name, MarshalledObject query, Subject delegationSubject) throws IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("queryNames", "connectionId=" + this.connectionId + " unwrapping query with defaultClassLoader.");
        }
        QueryExp queryValue = (QueryExp)RMIConnectionImpl.unwrap(query, this.defaultClassLoader);
        try {
            Object[] params = new Object[]{name, queryValue};
            if (debug) {
                logger.debug("queryNames", "connectionId=" + this.connectionId + ", name=" + name + ", query=" + query);
            }
            return (Set)this.doPrivilegedOperation(18, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public boolean isRegistered(ObjectName name, Subject delegationSubject) throws IOException {
        try {
            Object[] params = new Object[]{name};
            return (Boolean)this.doPrivilegedOperation(16, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public Integer getMBeanCount(Subject delegationSubject) throws IOException {
        try {
            Object[] params = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getMBeanCount", "connectionId=" + this.connectionId);
            }
            return (Integer)this.doPrivilegedOperation(11, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public Object getAttribute(ObjectName name, String attribute, Subject delegationSubject) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            Object[] params = new Object[]{name, attribute};
            if (logger.debugOn()) {
                logger.debug("getAttribute", "connectionId=" + this.connectionId + ", name=" + name + ", attribute=" + attribute);
            }
            return this.doPrivilegedOperation(7, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes, Subject delegationSubject) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            Object[] params = new Object[]{name, attributes};
            if (logger.debugOn()) {
                logger.debug("getAttributes", "connectionId=" + this.connectionId + ", name=" + name + ", attributes=" + RMIConnectionImpl.strings(attributes));
            }
            return (AttributeList)this.doPrivilegedOperation(8, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public void setAttribute(ObjectName name, MarshalledObject attribute, Subject delegationSubject) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("setAttribute", "connectionId=" + this.connectionId + " unwrapping attribute with MBean extended ClassLoader.");
        }
        Attribute attr = (Attribute)RMIConnectionImpl.unwrap(attribute, this.getClassLoaderFor(name), this.defaultClassLoader);
        try {
            Object[] params = new Object[]{name, attr};
            if (debug) {
                logger.debug("setAttribute", "connectionId=" + this.connectionId + ", name=" + name + ", attribute=" + attr);
            }
            this.doPrivilegedOperation(23, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public AttributeList setAttributes(ObjectName name, MarshalledObject attributes, Subject delegationSubject) throws InstanceNotFoundException, ReflectionException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("setAttributes", "connectionId=" + this.connectionId + " unwrapping attributes with MBean extended ClassLoader.");
        }
        AttributeList attrlist = (AttributeList)RMIConnectionImpl.unwrap(attributes, this.getClassLoaderFor(name), this.defaultClassLoader);
        try {
            Object[] params = new Object[]{name, attrlist};
            if (debug) {
                logger.debug("setAttributes", "connectionId=" + this.connectionId + ", name=" + name + ", attributes=" + attrlist);
            }
            return (AttributeList)this.doPrivilegedOperation(24, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public Object invoke(ObjectName name, String operationName, MarshalledObject params, String[] signature, Subject delegationSubject) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", name);
        RMIConnectionImpl.checkNonNull("Operation name", operationName);
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("invoke", "connectionId=" + this.connectionId + " unwrapping params with MBean extended ClassLoader.");
        }
        Object[] values = RMIConnectionImpl.nullIsEmpty((Object[])RMIConnectionImpl.unwrap(params, this.getClassLoaderFor(name), this.defaultClassLoader));
        try {
            Object[] params2 = new Object[]{name, operationName, values, RMIConnectionImpl.nullIsEmpty(signature)};
            if (debug) {
                logger.debug("invoke", "connectionId=" + this.connectionId + ", name=" + name + ", operationName=" + operationName + ", params=" + RMIConnectionImpl.objects(values) + ", signature=" + RMIConnectionImpl.strings(signature));
            }
            return this.doPrivilegedOperation(14, params2, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public String getDefaultDomain(Subject delegationSubject) throws IOException {
        try {
            Object[] params = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getDefaultDomain", "connectionId=" + this.connectionId);
            }
            return (String)this.doPrivilegedOperation(9, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public String[] getDomains(Subject delegationSubject) throws IOException {
        try {
            Object[] params = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getDomains", "connectionId=" + this.connectionId);
            }
            return (String[])this.doPrivilegedOperation(10, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", name);
        try {
            Object[] params = new Object[]{name};
            if (logger.debugOn()) {
                logger.debug("getMBeanInfo", "connectionId=" + this.connectionId + ", name=" + name);
            }
            return (MBeanInfo)this.doPrivilegedOperation(12, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IntrospectionException) {
                throw (IntrospectionException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public boolean isInstanceOf(ObjectName name, String className, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", name);
        try {
            Object[] params = new Object[]{name, className};
            if (logger.debugOn()) {
                logger.debug("isInstanceOf", "connectionId=" + this.connectionId + ", name=" + name + ", className=" + className);
            }
            return (Boolean)this.doPrivilegedOperation(15, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public Integer[] addNotificationListeners(ObjectName[] names, MarshalledObject[] filters, Subject[] delegationSubjects) throws InstanceNotFoundException, IOException {
        int i;
        Subject[] sbjs;
        if (names == null || filters == null) {
            throw new IllegalArgumentException("Got null arguments.");
        }
        Subject[] subjectArray = sbjs = delegationSubjects != null ? delegationSubjects : new Subject[names.length];
        if (names.length != filters.length || filters.length != sbjs.length) {
            String msg = "The value lengths of 3 parameters are not same.";
            throw new IllegalArgumentException("The value lengths of 3 parameters are not same.");
        }
        for (i = 0; i < names.length; ++i) {
            if (names[i] != null) continue;
            throw new IllegalArgumentException("Null Object name.");
        }
        NotificationFilter[] filterValues = new NotificationFilter[names.length];
        Integer[] ids = new Integer[names.length];
        boolean debug = logger.debugOn();
        try {
            for (i = 0; i < names.length; ++i) {
                ClassLoader targetCl = this.getClassLoaderFor(names[i]);
                if (debug) {
                    logger.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
                }
                filterValues[i] = (NotificationFilter)RMIConnectionImpl.unwrap(filters[i], targetCl, this.defaultClassLoader);
                if (debug) {
                    logger.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.connectionId + ", name=" + names[i] + ", filter=" + filterValues[i]);
                }
                ids[i] = (Integer)this.doPrivilegedOperation(1, new Object[]{names[i], filterValues[i]}, sbjs[i]);
            }
            return ids;
        }
        catch (Exception e) {
            for (int j = 0; j < i; ++j) {
                try {
                    this.getServerNotifFwd().removeNotificationListener(names[j], ids[j]);
                    continue;
                }
                catch (Exception eee) {
                    // empty catch block
                }
            }
            if (e instanceof PrivilegedActionException) {
                e = RMIConnectionImpl.extractException(e);
            }
            if (e instanceof ClassCastException) {
                throw (ClassCastException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, MarshalledObject filter, MarshalledObject handback, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", name);
        RMIConnectionImpl.checkNonNull("Listener MBean name", listener);
        boolean debug = logger.debugOn();
        ClassLoader targetCl = this.getClassLoaderFor(name);
        if (debug) {
            logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
        }
        NotificationFilter filterValue = (NotificationFilter)RMIConnectionImpl.unwrap(filter, targetCl, this.defaultClassLoader);
        if (debug) {
            logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping handback with target extended ClassLoader.");
        }
        Object handbackValue = RMIConnectionImpl.unwrap(handback, targetCl, this.defaultClassLoader);
        try {
            Object[] params = new Object[]{name, listener, filterValue, handbackValue};
            if (debug) {
                logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + ", name=" + name + ", listenerName=" + listener + ", filter=" + filterValue + ", handback=" + handbackValue);
            }
            this.doPrivilegedOperation(2, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public void removeNotificationListeners(ObjectName name, Integer[] listenerIDs, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (name == null || listenerIDs == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        for (int i = 0; i < listenerIDs.length; ++i) {
            if (listenerIDs[i] != null) continue;
            throw new IllegalArgumentException("Null listener ID");
        }
        try {
            Object[] params = new Object[]{name, listenerIDs};
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,Integer[])", "connectionId=" + this.connectionId + ", name=" + name + ", listenerIDs=" + RMIConnectionImpl.objects(listenerIDs));
            }
            this.doPrivilegedOperation(19, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", name);
        RMIConnectionImpl.checkNonNull("Listener MBean name", listener);
        try {
            Object[] params = new Object[]{name, listener};
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName)", "connectionId=" + this.connectionId + ", name=" + name + ", listenerName=" + listener);
            }
            this.doPrivilegedOperation(21, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, MarshalledObject filter, MarshalledObject handback, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", name);
        RMIConnectionImpl.checkNonNull("Listener MBean name", listener);
        boolean debug = logger.debugOn();
        ClassLoader targetCl = this.getClassLoaderFor(name);
        if (debug) {
            logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
        }
        NotificationFilter filterValue = (NotificationFilter)RMIConnectionImpl.unwrap(filter, targetCl, this.defaultClassLoader);
        if (debug) {
            logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping handback with target extended ClassLoader.");
        }
        Object handbackValue = RMIConnectionImpl.unwrap(handback, targetCl, this.defaultClassLoader);
        try {
            Object[] params = new Object[]{name, listener, filterValue, handbackValue};
            if (debug) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + ", name=" + name + ", listenerName=" + listener + ", filter=" + filterValue + ", handback=" + handbackValue);
            }
            this.doPrivilegedOperation(22, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationResult fetchNotifications(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException {
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", "connectionId=" + this.connectionId + ", timeout=" + timeout);
        }
        if (maxNotifications < 0 || timeout < 0L) {
            throw new IllegalArgumentException("Illegal negative argument");
        }
        boolean serverTerminated = this.serverCommunicatorAdmin.reqIncoming();
        try {
            if (serverTerminated) {
                NotificationResult notificationResult = new NotificationResult(0L, 0L, new TargetedNotification[0]);
                return notificationResult;
            }
            NotificationResult notificationResult = this.getServerNotifFwd().fetchNotifs(clientSequenceNumber, timeout, maxNotifications);
            return notificationResult;
        }
        finally {
            this.serverCommunicatorAdmin.rspOutgoing();
        }
    }

    public String toString() {
        return super.toString() + ": connectionId=" + this.connectionId;
    }

    private ClassLoaderRepository getClassLoaderRepository() {
        return (ClassLoaderRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return RMIConnectionImpl.this.mbeanServer.getClassLoaderRepository();
            }
        });
    }

    private ClassLoader getClassLoader(final ObjectName name) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return RMIConnectionImpl.this.mbeanServer.getClassLoader(name);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            throw (InstanceNotFoundException)RMIConnectionImpl.extractException(pe);
        }
    }

    private ClassLoader getClassLoaderFor(final ObjectName name) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return RMIConnectionImpl.this.mbeanServer.getClassLoaderFor(name);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            throw (InstanceNotFoundException)RMIConnectionImpl.extractException(pe);
        }
    }

    private Object doPrivilegedOperation(int operation, Object[] params, Subject delegationSubject) throws PrivilegedActionException, IOException {
        this.serverCommunicatorAdmin.reqIncoming();
        try {
            AccessControlContext reqACC;
            if (delegationSubject == null) {
                reqACC = this.acc;
            } else {
                if (this.subject == null) {
                    String msg = "Subject delegation cannot be enabled unless an authenticated subject is put in place";
                    throw new SecurityException("Subject delegation cannot be enabled unless an authenticated subject is put in place");
                }
                reqACC = this.subjectDelegator.delegatedContext(this.acc, delegationSubject);
            }
            PrivilegedOperation op = new PrivilegedOperation(operation, params);
            if (reqACC == null) {
                try {
                    Object object = op.run();
                    return object;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new PrivilegedActionException(e);
                }
            }
            Object t = AccessController.doPrivileged(op, reqACC);
            return t;
        }
        catch (Error e) {
            throw new JMXServerErrorException(e.toString(), e);
        }
        finally {
            this.serverCommunicatorAdmin.rspOutgoing();
        }
    }

    private Object doOperation(int operation, Object[] params) throws Exception {
        switch (operation) {
            case 3: {
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1]);
            }
            case 5: {
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (ObjectName)params[2]);
            }
            case 4: {
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (Object[])params[2], (String[])params[3]);
            }
            case 6: {
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (ObjectName)params[2], (Object[])params[3], (String[])params[4]);
            }
            case 7: {
                return this.mbeanServer.getAttribute((ObjectName)params[0], (String)params[1]);
            }
            case 8: {
                return this.mbeanServer.getAttributes((ObjectName)params[0], (String[])params[1]);
            }
            case 9: {
                return this.mbeanServer.getDefaultDomain();
            }
            case 10: {
                return this.mbeanServer.getDomains();
            }
            case 11: {
                return this.mbeanServer.getMBeanCount();
            }
            case 12: {
                return this.mbeanServer.getMBeanInfo((ObjectName)params[0]);
            }
            case 13: {
                return this.mbeanServer.getObjectInstance((ObjectName)params[0]);
            }
            case 14: {
                return this.mbeanServer.invoke((ObjectName)params[0], (String)params[1], (Object[])params[2], (String[])params[3]);
            }
            case 15: {
                return this.mbeanServer.isInstanceOf((ObjectName)params[0], (String)params[1]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.mbeanServer.isRegistered((ObjectName)params[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.mbeanServer.queryMBeans((ObjectName)params[0], (QueryExp)params[1]);
            }
            case 18: {
                return this.mbeanServer.queryNames((ObjectName)params[0], (QueryExp)params[1]);
            }
            case 23: {
                this.mbeanServer.setAttribute((ObjectName)params[0], (Attribute)params[1]);
                return null;
            }
            case 24: {
                return this.mbeanServer.setAttributes((ObjectName)params[0], (AttributeList)params[1]);
            }
            case 25: {
                this.mbeanServer.unregisterMBean((ObjectName)params[0]);
                return null;
            }
            case 1: {
                return this.getServerNotifFwd().addNotificationListener((ObjectName)params[0], (NotificationFilter)params[1]);
            }
            case 2: {
                this.mbeanServer.addNotificationListener((ObjectName)params[0], (ObjectName)params[1], (NotificationFilter)params[2], params[3]);
                return null;
            }
            case 19: {
                this.getServerNotifFwd().removeNotificationListener((ObjectName)params[0], (Integer[])params[1]);
                return null;
            }
            case 21: {
                this.mbeanServer.removeNotificationListener((ObjectName)params[0], (ObjectName)params[1]);
                return null;
            }
            case 22: {
                this.mbeanServer.removeNotificationListener((ObjectName)params[0], (ObjectName)params[1], (NotificationFilter)params[2], params[3]);
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid operation");
    }

    private static Object unwrap(final MarshalledObject mo, final ClassLoader cl) throws IOException {
        if (mo == null) {
            return null;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ClassLoader old = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    try {
                        if (bootstrapLoaded) {
                            Object t = mo.get();
                            return t;
                        }
                        Object object = unmarshal.get(mo);
                        return object;
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new UnmarshalException(cnfe.toString(), cnfe);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw new UnmarshalException(e.toString(), e);
            }
            logger.warning("unwrap", "Failed to unmarshall object: " + e);
            logger.debug("unwrap", e);
            return null;
        }
    }

    private static Object unwrap(final MarshalledObject mo, final ClassLoader cl1, final ClassLoader cl2) throws IOException {
        if (mo == null) {
            return null;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return RMIConnectionImpl.unwrap(mo, new OrderClassLoaders(cl1, cl2));
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw new UnmarshalException(e.toString(), e);
            }
            logger.warning("unwrap", "Failed to unmarshall object: " + e);
            logger.debug("unwrap", e);
            return null;
        }
    }

    private static IOException newIOException(String message, Throwable cause) {
        IOException x = new IOException(message);
        return (IOException)EnvHelp.initCause(x, cause);
    }

    private static Exception extractException(Exception e) {
        while (e instanceof PrivilegedActionException) {
            e = ((PrivilegedActionException)e).getException();
        }
        return e;
    }

    private static Object[] nullIsEmpty(Object[] array) {
        return array == null ? NO_OBJECTS : array;
    }

    private static String[] nullIsEmpty(String[] array) {
        return array == null ? NO_STRINGS : array;
    }

    private static void checkNonNull(String what, Object x) {
        if (x == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException(what + " must not be null");
            throw new RuntimeOperationsException(wrapped);
        }
    }

    private static String objects(Object[] objs) {
        if (objs == null) {
            return "null";
        }
        return Arrays.asList(objs).toString();
    }

    private static String strings(String[] strs) {
        return RMIConnectionImpl.objects(strs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String byteCodeString = "\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0018\n\u0000\u0004\u0000\u000e\n\u0000\u000f\u0000\u0010\u0007\u0000\u0011\u0007\u0000\u0012\u0007\u0000\u0013\u0001\u0000\u0006<init>\u0001\u0000\u0003()V\u0001\u0000\u0004Code\u0001\u0000\u0003get\u0001\u0000/(Ljava/rmi/MarshalledObject;)Ljava/lang/Object;\u0001\u0000\nExceptions\u0007\u0000\u0014\u0007\u0000\u0015\f\u0000\u0006\u0000\u0007\u0007\u0000\u0016\f\u0000\t\u0000\u0017\u0001\u0000!com/sun/jmx/remote/internal/MOGet\u0001\u0000\u0010java/lang/Object\u0001\u0000%com/sun/jmx/remote/internal/Unmarshal\u0001\u0000\u0013java/io/IOException\u0001\u0000 java/lang/ClassNotFoundException\u0001\u0000\u0019java/rmi/MarshalledObject\u0001\u0000\u0014()Ljava/lang/Object;\u0000!\u0000\u0003\u0000\u0004\u0000\u0001\u0000\u0005\u0000\u0000\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0007\u0000\u0001\u0000\b\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0001\u0000\u0000\u0000\u0005*\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\t\u0000\n\u0000\u0002\u0000\b\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0002\u0000\u0000\u0000\u0005+\u00b6\u0000\u0002\u00b0\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0006\u0000\u0002\u0000\f\u0000\r\u0000\u0000";
        if (bootstrapLoaded) {
            unmarshal = null;
        } else {
            final byte[] byteCode = NoCallStackClassLoader.stringToBytes("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0018\n\u0000\u0004\u0000\u000e\n\u0000\u000f\u0000\u0010\u0007\u0000\u0011\u0007\u0000\u0012\u0007\u0000\u0013\u0001\u0000\u0006<init>\u0001\u0000\u0003()V\u0001\u0000\u0004Code\u0001\u0000\u0003get\u0001\u0000/(Ljava/rmi/MarshalledObject;)Ljava/lang/Object;\u0001\u0000\nExceptions\u0007\u0000\u0014\u0007\u0000\u0015\f\u0000\u0006\u0000\u0007\u0007\u0000\u0016\f\u0000\t\u0000\u0017\u0001\u0000!com/sun/jmx/remote/internal/MOGet\u0001\u0000\u0010java/lang/Object\u0001\u0000%com/sun/jmx/remote/internal/Unmarshal\u0001\u0000\u0013java/io/IOException\u0001\u0000 java/lang/ClassNotFoundException\u0001\u0000\u0019java/rmi/MarshalledObject\u0001\u0000\u0014()Ljava/lang/Object;\u0000!\u0000\u0003\u0000\u0004\u0000\u0001\u0000\u0005\u0000\u0000\u0000\u0002\u0000\u0001\u0000\u0006\u0000\u0007\u0000\u0001\u0000\b\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0001\u0000\u0000\u0000\u0005*\u00b7\u0000\u0001\u00b1\u0000\u0000\u0000\u0000\u0000\u0001\u0000\t\u0000\n\u0000\u0002\u0000\b\u0000\u0000\u0000\u0011\u0000\u0001\u0000\u0002\u0000\u0000\u0000\u0005+\u00b6\u0000\u0002\u00b0\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0006\u0000\u0002\u0000\f\u0000\r\u0000\u0000");
            final String[] otherClassNames = new String[]{(class$com$sun$jmx$remote$internal$Unmarshal == null ? (class$com$sun$jmx$remote$internal$Unmarshal = RMIConnectionImpl.class$("com.sun.jmx.remote.internal.Unmarshal")) : class$com$sun$jmx$remote$internal$Unmarshal).getName()};
            final Class thisClass = class$javax$management$remote$rmi$RMIConnectionImpl == null ? (class$javax$management$remote$rmi$RMIConnectionImpl = RMIConnectionImpl.class$("javax.management.remote.rmi.RMIConnectionImpl")) : class$javax$management$remote$rmi$RMIConnectionImpl;
            final ClassLoader thisClassLoader = thisClass.getClassLoader();
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ProtectionDomain thisProtectionDomain = thisClass.getProtectionDomain();
                    NoCallStackClassLoader cl = new NoCallStackClassLoader(RMIConnectionImpl.unmarshalClassName, byteCode, otherClassNames, thisClassLoader, thisProtectionDomain);
                    Class<?> c = cl.loadClass(RMIConnectionImpl.unmarshalClassName);
                    return c.newInstance();
                }
            };
            try {
                unmarshal = (Unmarshal)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Error error = new Error("Internal error: " + e);
                EnvHelp.initCause(error, e);
                throw error;
            }
        }
        NO_OBJECTS = new Object[0];
        NO_STRINGS = new String[0];
        logger = new ClassLogger("javax.management.remote.rmi", "RMIConnectionImpl");
    }

    private class RMIServerCommunicatorAdmin
    extends ServerCommunicatorAdmin {
        public RMIServerCommunicatorAdmin(long timeout) {
            super(timeout);
        }

        protected void doStop() {
            try {
                RMIConnectionImpl.this.close();
            }
            catch (IOException ie) {
                logger.warning("RMIServerCommunicatorAdmin-doStop", "Failed to close: " + ie);
                logger.debug("RMIServerCommunicatorAdmin-doStop", ie);
            }
        }
    }

    private class PrivilegedOperation
    implements PrivilegedExceptionAction {
        private int operation;
        private Object[] params;

        public PrivilegedOperation(int operation, Object[] params) {
            this.operation = operation;
            this.params = params;
        }

        public Object run() throws Exception {
            return RMIConnectionImpl.this.doOperation(this.operation, this.params);
        }
    }
}

