/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;

public class JMXConnectorServerFactory {
    public static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    public static final String DEFAULT_CLASS_LOADER_NAME = "jmx.remote.default.class.loader.name";
    public static final String PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String PROTOCOL_PROVIDER_CLASS_LOADER = "jmx.remote.protocol.provider.class.loader";
    private static final String PROTOCOL_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.protocol";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXConnectorServerFactory");
    static /* synthetic */ Class class$javax$management$remote$JMXConnectorServerProvider;
    static /* synthetic */ Class class$javax$management$remote$JMXConnectorFactory;

    private JMXConnectorServerFactory() {
    }

    private static JMXConnectorServer getConnectorServerAsService(ClassLoader loader, JMXServiceURL url, Map map, MBeanServer mbs) throws IllegalArgumentException, JMXProviderException {
        Iterator providers = JMXConnectorFactory.getProviderIterator(class$javax$management$remote$JMXConnectorServerProvider == null ? (class$javax$management$remote$JMXConnectorServerProvider = JMXConnectorServerFactory.class$("javax.management.remote.JMXConnectorServerProvider")) : class$javax$management$remote$JMXConnectorServerProvider, loader);
        JMXConnectorServerProvider provider = null;
        JMXConnectorServer connection = null;
        while (providers.hasNext()) {
            provider = (JMXConnectorServerProvider)providers.next();
            try {
                connection = provider.newJMXConnectorServer(url, map, mbs);
                return connection;
            }
            catch (JMXProviderException e) {
                throw e;
            }
            catch (Exception e) {
                if (!logger.traceOn()) continue;
                logger.trace("getConnectorAsService", "URL[" + url + "] Service provider exception " + e);
            }
        }
        return null;
    }

    public static JMXConnectorServer newJMXConnectorServer(JMXServiceURL serviceURL, Map environment, MBeanServer mbeanServer) throws IOException {
        if (environment == null) {
            environment = new HashMap();
        } else {
            EnvHelp.checkAttributes(environment);
            environment = new HashMap(environment);
        }
        Class targetInterface = class$javax$management$remote$JMXConnectorServerProvider == null ? (class$javax$management$remote$JMXConnectorServerProvider = JMXConnectorServerFactory.class$("javax.management.remote.JMXConnectorServerProvider")) : class$javax$management$remote$JMXConnectorServerProvider;
        ClassLoader loader = JMXConnectorFactory.resolveClassLoader(environment);
        String protocol = serviceURL.getProtocol();
        String providerClassName = "ServerProvider";
        JMXConnectorServerProvider provider = (JMXConnectorServerProvider)JMXConnectorFactory.getProvider(serviceURL, environment, "ServerProvider", targetInterface, loader);
        if (provider == null) {
            JMXConnectorServer connection;
            if (loader != null && (connection = JMXConnectorServerFactory.getConnectorServerAsService(loader, serviceURL, environment, mbeanServer)) != null) {
                return connection;
            }
            provider = (JMXConnectorServerProvider)JMXConnectorFactory.getProvider(protocol, PROTOCOL_PROVIDER_DEFAULT_PACKAGE, (class$javax$management$remote$JMXConnectorFactory == null ? (class$javax$management$remote$JMXConnectorFactory = JMXConnectorServerFactory.class$("javax.management.remote.JMXConnectorFactory")) : class$javax$management$remote$JMXConnectorFactory).getClassLoader(), "ServerProvider", targetInterface);
        }
        if (provider == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        environment = Collections.unmodifiableMap(environment);
        return provider.newJMXConnectorServer(serviceURL, environment, mbeanServer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

