/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.dom;

import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.impl.xs.dom.ElementNSImpl;

public final class DOMNodePool {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private ElementNSImpl[][] fElements = new ElementNSImpl[4][];
    private int fElementIndex = 0;
    private TextImpl[][] fTextNode = new TextImpl[4][];
    private int fTextNodeIndex = 0;
    private AttrNSImpl[][] fAttrNode = new AttrNSImpl[4][];
    private int fAttrNodeIndex = 0;

    public final ElementNSImpl getElementNode() {
        int chunk = this.fElementIndex >> 8;
        int index = this.fElementIndex & 0xFF;
        this.ensureElementsCapacity(chunk);
        if (this.fElements[chunk][index] == null) {
            this.fElements[chunk][index] = new ElementNSImpl();
        }
        ++this.fElementIndex;
        return this.fElements[chunk][index];
    }

    private boolean ensureElementsCapacity(int chunk) {
        try {
            return this.fElements[chunk][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fElements = DOMNodePool.resize(this.fElements, this.fElements.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fElements[chunk] = new ElementNSImpl[256];
        return true;
    }

    private static ElementNSImpl[][] resize(ElementNSImpl[][] array, int newsize) {
        ElementNSImpl[][] newarray = new ElementNSImpl[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    public final TextImpl getTextNode() {
        int chunk = this.fTextNodeIndex >> 8;
        int index = this.fTextNodeIndex & 0xFF;
        this.ensureTextCapacity(chunk);
        if (this.fTextNode[chunk][index] == null) {
            this.fTextNode[chunk][index] = new TextImpl();
        }
        ++this.fTextNodeIndex;
        return this.fTextNode[chunk][index];
    }

    private boolean ensureTextCapacity(int chunk) {
        try {
            return this.fTextNode[chunk][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fTextNode = DOMNodePool.resize(this.fTextNode, this.fTextNode.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fTextNode[chunk] = new TextImpl[256];
        return true;
    }

    private static TextImpl[][] resize(TextImpl[][] array, int newsize) {
        TextImpl[][] newarray = new TextImpl[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    public final AttrNSImpl getAttrNode() {
        int chunk = this.fAttrNodeIndex >> 8;
        int index = this.fAttrNodeIndex & 0xFF;
        this.ensureAttrsCapacity(chunk);
        if (this.fAttrNode[chunk][index] == null) {
            this.fAttrNode[chunk][index] = new AttrNSImpl();
        }
        ++this.fAttrNodeIndex;
        return this.fAttrNode[chunk][index];
    }

    private boolean ensureAttrsCapacity(int chunk) {
        try {
            return this.fAttrNode[chunk][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fAttrNode = DOMNodePool.resize(this.fAttrNode, this.fAttrNode.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fAttrNode[chunk] = new AttrNSImpl[256];
        return true;
    }

    private static AttrNSImpl[][] resize(AttrNSImpl[][] array, int newsize) {
        AttrNSImpl[][] newarray = new AttrNSImpl[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    public void reset() {
        this.fElementIndex = 0;
        this.fTextNodeIndex = 0;
        this.fAttrNodeIndex = 0;
    }
}

