/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.socket;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.Message;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;

public class SocketConnection
implements SocketConnectionIf,
MessageConnection {
    private Subject subject;
    private String connectionId;
    private Socket sock;
    private InputStream in;
    private ObjectInputStream oin;
    private OutputStream out;
    private ObjectOutputStream oout;
    private boolean replaceInputStreamFlag = false;
    private boolean replaceOutputStreamFlag = false;
    private String addr;
    private int port;
    private ClassLoader defaultClassLoader;
    private final String defaultConnectionId = "Uninitialized connection id";
    private final int[] replaceLock = new int[0];
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 4;
    private static final int FAILED = 8;
    private static final int TERMINATED = 16;
    private int state = 1;
    private int[] stateLock = new int[0];
    private long waitConnectedState = 1000L;
    private final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SocketConnection");

    public SocketConnection(Socket socket, Map env) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("Constructor", "Creating with a socket " + socket);
        }
        this.sock = socket;
        this.addr = "jmxclient";
        this.port = this.sock.getPort();
        int socketTimeout = SocketConnection.getSocketTimeout(env);
        this.sock.setSoTimeout(socketTimeout);
        this.replaceStreams(socket.getInputStream(), socket.getOutputStream());
    }

    public SocketConnection(String addr, int port) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("Constructor", "Creating with a socket address: " + addr + " " + port);
        }
        this.addr = addr;
        this.port = port;
    }

    private static final int getSocketTimeout(Map env) {
        int timeout = 30000;
        try {
            timeout = Integer.parseInt((String)env.get("jmx.socket.timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }

    private static Socket createAndConnectSocket(String host, int port, Map env) throws SocketException, IOException {
        Socket socket = new Socket(host, port);
        int socketTimeout = SocketConnection.getSocketTimeout(env);
        socket.setSoTimeout(socketTimeout);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map env) throws IOException {
        this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(env);
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 1) {
                if (this.logger.traceOn()) {
                    this.logger.trace("connect", "First time to connect to the server.");
                }
                this.state = 2;
                this.stateLock.notifyAll();
                if (this.sock == null) {
                    this.sock = SocketConnection.createAndConnectSocket(this.addr, this.port, env);
                }
                this.replaceStreams(this.sock.getInputStream(), this.sock.getOutputStream());
                if (env != null) {
                    this.defaultClassLoader = (ClassLoader)env.get("jmx.remote.default.class.loader");
                }
                this.state = 4;
                this.stateLock.notifyAll();
            } else if (this.state == 8 || this.state == 4) {
                if (this.logger.traceOn()) {
                    this.logger.trace("connect", "Try to re-connect to the server.");
                }
                if (this.state == 4) {
                    this.state = 8;
                    this.stateLock.notifyAll();
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.state = 2;
                this.stateLock.notifyAll();
                this.sock = SocketConnection.createAndConnectSocket(this.addr, this.port, env);
                this.replaceStreams(this.sock.getInputStream(), this.sock.getOutputStream());
                this.state = 4;
                this.stateLock.notifyAll();
            } else {
                if (this.state == 16) {
                    throw new IllegalStateException("The connection has been closed.");
                }
                if (this.logger.traceOn()) {
                    this.logger.trace("connect", "Waiting the state changing.");
                }
                this.checkState();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Socket getSocket() {
        return this.sock;
    }

    public void setSocket(Socket s) throws IOException {
        this.sock = s;
        this.replaceStreams(this.sock.getInputStream(), this.sock.getOutputStream());
    }

    public void replaceStreams(InputStream is, OutputStream os) throws IOException {
        this.in = is;
        this.out = os;
        this.replaceInputStreamFlag = true;
        this.replaceOutputStreamFlag = true;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Message readMessage() throws IOException, ClassNotFoundException {
        this.checkState();
        if (this.logger.debugOn()) {
            this.logger.debug("readMessage", "Read a message ...");
        }
        if (this.replaceInputStreamFlag) {
            this.oin = this.in instanceof BufferedInputStream ? new ObjectInputStreamWithLoader(this.in, this.defaultClassLoader) : new ObjectInputStreamWithLoader(new BufferedInputStream(this.in), this.defaultClassLoader);
            this.replaceInputStreamFlag = false;
        }
        return (Message)this.oin.readObject();
    }

    public void writeMessage(Message msg) throws IOException {
        if (this.logger.debugOn()) {
            this.logger.debug("writeMessage", "Write a message ...");
        }
        this.checkState();
        if (this.replaceOutputStreamFlag) {
            this.oout = this.out instanceof BufferedOutputStream ? new ObjectOutputStream(this.out) : new ObjectOutputStream(new BufferedOutputStream(this.out));
            this.replaceOutputStreamFlag = false;
        }
        this.oout.writeObject(msg);
        this.oout.flush();
        this.oout.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.logger.traceOn()) {
            this.logger.trace("close", "Close the socket connection.");
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            block16: {
                block15: {
                    block14: {
                        if (this.state == 16) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        this.state = 16;
                        if (this.sock instanceof SSLSocket) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ire) {
                                // empty catch block
                            }
                        }
                        try {
                            this.oin.close();
                        }
                        catch (Exception e) {
                            if (!this.logger.debugOn()) break block14;
                            this.logger.debug("close", e);
                        }
                    }
                    try {
                        this.oout.close();
                    }
                    catch (Exception e) {
                        if (!this.logger.debugOn()) break block15;
                        this.logger.debug("close", e);
                    }
                }
                try {
                    this.sock.close();
                }
                catch (Exception e) {
                    if (!this.logger.debugOn()) break block16;
                    this.logger.debug("close", e);
                }
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getConnectionId() {
        if (this.sock == null) {
            return "Uninitialized connection id";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("jmxmp://" + this.addr + ":" + this.sock.getPort() + " ");
        if (this.subject != null) {
            Set<Principal> principals = this.subject.getPrincipals();
            String sep = "";
            Iterator<Principal> it = principals.iterator();
            while (it.hasNext()) {
                Principal p = it.next();
                String n = p.getName().replace(' ', '_').replace(';', ':');
                buf.append(sep).append(n);
                sep = ";";
            }
        }
        buf.append(" ").append(System.identityHashCode(this));
        this.connectionId = buf.toString();
        return this.connectionId;
    }

    private void checkState() throws IllegalStateException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 4) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 16) {
                throw new IllegalStateException("The connection has been closed.");
            }
            long waitingTime = this.waitConnectedState;
            long endTime = System.currentTimeMillis() + waitingTime;
            while (this.state != 4 && this.state != 16 && waitingTime > 0L) {
                try {
                    this.stateLock.wait(waitingTime);
                }
                catch (InterruptedException ire) {
                    break;
                }
                waitingTime = endTime - System.currentTimeMillis();
            }
            if (this.state == 4) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            throw new IllegalStateException("The connection is not currently established.");
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.addr;
    }

    private static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private final ClassLoader cloader;

        public ObjectInputStreamWithLoader(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.cloader = cl;
        }

        protected Class resolveClass(ObjectStreamClass aClass) throws IOException, ClassNotFoundException {
            return this.cloader == null ? super.resolveClass(aClass) : Class.forName(aClass.getName(), false, this.cloader);
        }
    }
}

