/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileClient;
import com.sun.jmx.remote.opt.security.SASLInputStream;
import com.sun.jmx.remote.opt.security.SASLOutputStream;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.SASLMessage;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

public class SASLClientHandler
implements ProfileClient {
    private SaslClient saslClnt = null;
    private boolean completed = false;
    private boolean initialResponse = true;
    private byte[] blob = null;
    private Map env = null;
    private MessageConnection mc = null;
    private Socket socket = null;
    private String mechanism = null;
    private String profile = null;
    private static final byte[] EMPTY = new byte[0];
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SASLClientHandler");

    public SASLClientHandler(String profile, Map env) {
        this.env = env;
        this.profile = profile;
    }

    public void initialize(MessageConnection mc) throws IOException {
        logger.trace("initialize", "starts");
        this.mc = mc;
        if (!(mc instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        this.socket = ((SocketConnectionIf)((Object)mc)).getSocket();
        String mech = this.profile.substring(this.profile.indexOf("SASL/") + 5);
        String[] mechs = SASLClientHandler.getSaslMechanismNames(mech);
        String authzId = (String)this.env.get("jmx.remote.sasl.authorization.id");
        String server = (String)this.env.get("jmx.remote.x.sasl.server.name");
        if (server == null) {
            server = ((SocketConnectionIf)((Object)mc)).getHost();
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "mech=" + mech + "; mechs=" + Arrays.asList(mechs) + "; authzId=" + authzId + "; server=" + server);
        }
        CallbackHandler cbh = null;
        if (this.env.containsKey("jmx.remote.sasl.callback.handler")) {
            cbh = (CallbackHandler)this.env.get("jmx.remote.sasl.callback.handler");
            if (logger.traceOn()) {
                logger.trace("initialize", "found callback.handler property: " + cbh);
            }
        } else if (this.env.containsKey("jmx.remote.credentials")) {
            logger.trace("initialize", "found jmx.remote.credentials property");
            Object credso = this.env.get("jmx.remote.credentials");
            if (!(credso instanceof String[])) {
                if (logger.traceOn()) {
                    logger.trace("initialize", "...but it is not a String[]: " + credso);
                }
            } else {
                String[] creds = (String[])credso;
                if (creds.length != 2) {
                    if (logger.traceOn()) {
                        logger.trace("initialize", "...but it does not have 2 elements: " + Arrays.asList(creds));
                    }
                } else {
                    cbh = new UserPasswordCallbackHandler(creds[0], creds[1]);
                }
            }
        }
        this.saslClnt = Sasl.createSaslClient(mechs, authzId, "jmxmp", server, this.env, cbh);
        if (this.saslClnt == null) {
            String detail = "Unable to create SASL client connection for authentication mechanism [" + mech + "]";
            throw new IOException(detail);
        }
        this.mechanism = this.saslClnt.getMechanismName();
    }

    public ProfileMessage produceMessage() throws IOException {
        if (this.initialResponse) {
            this.blob = this.saslClnt.hasInitialResponse() ? this.saslClnt.evaluateChallenge(EMPTY) : EMPTY;
            this.initialResponse = false;
        }
        SASLMessage response = new SASLMessage(this.mechanism, 1, this.blob);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> SASL client message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + response.getProfileName());
            logger.trace("produceMessage", "Status : " + response.getStatus());
        }
        return response;
    }

    public void consumeMessage(ProfileMessage pm) throws IOException {
        if (!(pm instanceof SASLMessage)) {
            throw new IOException("Unexpected profile message type: " + pm.getClass().getName());
        }
        SASLMessage challenge = (SASLMessage)pm;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> SASL server message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + challenge.getProfileName());
            logger.trace("consumeMessage", "Status : " + challenge.getStatus());
        }
        if (challenge.getStatus() != 1 && challenge.getStatus() != 2) {
            throw new IOException("Unexpected SASL status [" + challenge.getStatus() + "]");
        }
        if (this.saslClnt.isComplete() && challenge.getStatus() == 2) {
            this.completed = true;
            return;
        }
        if (this.saslClnt.isComplete() && challenge.getStatus() != 2) {
            throw new IOException("SASL authentication complete despite the server claim for non-completion");
        }
        if (!this.saslClnt.isComplete() && challenge.getStatus() == 2) {
            this.blob = this.saslClnt.evaluateChallenge(challenge.getBlob());
            if (this.saslClnt.isComplete()) {
                this.completed = true;
                return;
            }
            throw new IOException("SASL authentication not complete despite the server claim for completion");
        }
        if (!this.saslClnt.isComplete() && challenge.getStatus() != 2) {
            this.blob = this.saslClnt.evaluateChallenge(challenge.getBlob());
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public void activate() throws IOException {
        String qop = (String)this.saslClnt.getNegotiatedProperty("javax.security.sasl.qop");
        if (qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
            SASLInputStream saslis = new SASLInputStream(this.saslClnt, this.socket.getInputStream());
            SASLOutputStream saslos = new SASLOutputStream(this.saslClnt, this.socket.getOutputStream());
            ((SocketConnectionIf)((Object)this.mc)).replaceStreams(saslis, saslos);
        }
    }

    public void terminate() throws IOException {
        this.saslClnt.dispose();
    }

    public String getName() {
        return this.profile;
    }

    private static String[] getSaslMechanismNames(String str) {
        StringTokenizer parser = new StringTokenizer(str);
        Vector<String> mechanisms = new Vector<String>(10);
        while (parser.hasMoreTokens()) {
            mechanisms.addElement(parser.nextToken());
        }
        String[] mechs = new String[mechanisms.size()];
        for (int i = 0; i < mechanisms.size(); ++i) {
            mechs[i] = (String)mechanisms.elementAt(i);
        }
        return mechs;
    }

    private static class UserPasswordCallbackHandler
    implements CallbackHandler {
        private String user;
        private char[] pwchars;

        UserPasswordCallbackHandler(String user, String password) {
            this.user = user;
            this.pwchars = password.toCharArray();
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)callbacks[i];
                    ncb.setName(this.user);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)callbacks[i];
                    pcb.setPassword(this.pwchars);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        }

        private void clearPassword() {
            if (this.pwchars != null) {
                for (int i = 0; i < this.pwchars.length; ++i) {
                    this.pwchars[i] = '\u0000';
                }
                this.pwchars = null;
            }
        }

        protected void finalize() {
            this.clearPassword();
        }
    }
}

