package sample;

import jaxcent.*;

/**
  * Jaxcent sample.
  *
  * Simply displays the server time, continuously updating the time once a second.
  * Uses a thread that starts on onLoad, and is terminated during onUnload.
  *
  * The HTML page has a P tag identified as "clock".  The inner HTML of this
  * tag is updated by the thread.
  */

public class ClockSample extends jaxcent.JaxcentPage {

    HtmlPara clockPara = new HtmlPara( this, "clock" );    // Reference to the P tag with id "clock"

    Thread clockThread = null;
    boolean update = false;

    // Start the thread in the page constructor.

    public ClockSample() {
        update = true;
        clockThread = new Thread() {
            public void run() {
                updateClock();
            }
        };
        clockThread.start();
    }

    // Stop the thread on page unloading.

    protected void onUnload()
    {
        update = false;
        clockThread.interrupt();
    }

    // The updater method.

    void updateClock()
    {
        try {
            while ( update ) {
                clockPara.setInnerHTML( "<FONT SIZE=16>" + new java.util.Date() + "</FONT>" );
                Thread.sleep( 1000 );
            }
        } catch (Exception ex) {
            // Exit thread on interrupted exception
        }
    }
}
