/*
 * $Id:SpinnerEditorRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.swing.editor;

import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import net.sf.jame.core.swing.util.GUIFactory;
import net.sf.jame.core.tree.NodeEditor;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.core.tree.NumberNodeEditor;
import net.sf.jame.twister.swing.NodeEditorComponent;
import net.sf.jame.twister.swing.editor.extension.EditorExtensionRuntime;

/**
 * @author Andrea Medeghini
 */
public abstract class SpinnerEditorRuntime extends EditorExtensionRuntime {
	/**
	 * @see net.sf.jame.twister.swing.editor.extension.EditorExtensionRuntime#createEditor(net.sf.jame.core.tree.NodeEditor)
	 */
	@Override
	public NodeEditorComponent createEditor(final NodeEditor nodeEditor) {
		return new EditorComponent((NumberNodeEditor) nodeEditor);
	}

	private class EditorComponent extends JPanel implements NodeEditorComponent {
		private static final long serialVersionUID = 1L;
		private final NumberNodeEditor nodeEditor;
		private final SpinnerNumberModel model;

		/**
		 * @param nodeEditor
		 */
		public EditorComponent(final NumberNodeEditor nodeEditor) {
			this.nodeEditor = nodeEditor;
			setLayout(new FlowLayout(FlowLayout.CENTER));
			model = new SpinnerNumberModel(nodeEditor.getNumberValue(), nodeEditor.getMinimum(), nodeEditor.getMaximum(), nodeEditor.getStep());
			final JSpinner spinner = GUIFactory.createSpinner(model, null);
			spinner.setMinimumSize(new Dimension(80, GUIFactory.DEFAULT_HEIGHT));
			spinner.setMaximumSize(new Dimension(80, GUIFactory.DEFAULT_HEIGHT));
			spinner.setPreferredSize(new Dimension(80, GUIFactory.DEFAULT_HEIGHT));
			this.add(GUIFactory.createLabel(nodeEditor.getNodeLabel(), SwingConstants.CENTER));
			this.add(spinner);
			this.add(GUIFactory.createLabel("[" + nodeEditor.getMinimum() + ", " + nodeEditor.getMaximum() + "]", SwingConstants.CENTER));
			model.addChangeListener(new NodeEditorChangeListener(nodeEditor));
		}

		/**
		 * @see net.sf.jame.twister.swing.NodeEditorComponent#getComponent()
		 */
		public JComponent getComponent() {
			return this;
		}

		/**
		 * @see net.sf.jame.twister.swing.NodeEditorComponent#reloadValue()
		 */
		public void reloadValue() {
			if (nodeEditor.getNodeValue() != null) {
				model.setValue(nodeEditor.getNumberValue());
			}
		}
	}

	protected abstract NodeValue<?> createNodeValue(Number value);

	private class NodeEditorChangeListener implements ChangeListener {
		private final NodeEditor nodeEditor;

		/**
		 * @param nodeEditor
		 */
		public NodeEditorChangeListener(final NodeEditor nodeEditor) {
			this.nodeEditor = nodeEditor;
		}

		/**
		 * @see javax.swing.event.ChangeListener#stateChanged(javax.swing.event.ChangeEvent)
		 */
		public void stateChanged(final ChangeEvent e) {
			final SpinnerNumberModel model = (SpinnerNumberModel) e.getSource();
			if (!model.getNumber().equals(nodeEditor.getNodeValue().getValue())) {
				nodeEditor.setNodeValue(createNodeValue(model.getNumber()));
			}
		}
	}
}
