/*
 * $Id:TwisterClipController.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister;

import java.util.List;

import net.sf.jame.core.config.DefaultConfigContext;
import net.sf.jame.core.tree.NodeAction;
import net.sf.jame.core.tree.NodeActionValue;

/**
 * @author Andrea Medeghini
 */
public class TwisterClipController extends AbstractTwisterController {
	private final TwisterClip clip;

	/**
	 * @param clip
	 */
	public TwisterClipController(final TwisterClip clip) {
		this.clip = clip;
	}

	/**
	 * @see net.sf.jame.twister.TwisterController#init()
	 */
	public void init() {
		commands.clear();
		clipTimestamp = 0;
		clipDuration = 0;
		commandIndex = 0;
		undone = false;
		redone = false;
		// commands.add(new NullCommand(0));
		// redone = true;
		loadCommands(commands);
		if (commands.size() > 0) {
			commands.get(0).redo();
			commandIndex = 1;
			redone = true;
		}
		else {
			if (clip.getSequenceCount() > 0) {
				if (clip.getSequence(0).getInitialConfig() != null) {
					final TwisterConfig configClone = clip.getSequence(0).getInitialConfig().clone();
					configClone.setContext(new DefaultConfigContext());
					updateConfig(configClone);
				}
				else if (clip.getSequence(0).getFinalConfig() != null) {
					final TwisterConfig configClone = clip.getSequence(0).getFinalConfig().clone();
					configClone.setContext(new DefaultConfigContext());
					updateConfig(configClone);
				}
			}
		}
	}

	private void loadCommands(final List<ControllerCommand> commands) {
		long timestamp = 0;
		for (int i = 0; i < clip.getSequenceCount(); i++) {
			final TwisterSequence sequence = clip.getSequence(i);
			if (sequence.getDuration() > 0) {
				if (sequence.getInitialConfig() != null) {
					commands.add(new InitialConfigCommand(sequence.getInitialConfig(), timestamp));
				}
				// else {
				// commands.add(new LoadCommand(sequence.getFinalConfig().clone(), timestamp) {
				// public void redo() {
				// updateConfig(config);
				// }
				// });
				// }
				for (int j = 0; j < sequence.getActionCount(); j++) {
					final NodeActionValue actionValue = sequence.getAction(j).toActionValue();
					actionValue.setTimestamp(actionValue.getTimestamp() + timestamp);
					commands.add(new ActionCommand(new NodeAction(actionValue)));
				}
				clipDuration += sequence.getDuration();
				timestamp += sequence.getDuration();
				if (sequence.getFinalConfig() != null) {
					commands.add(new FinalConfigCommand(sequence.getFinalConfig(), timestamp));
				}
				// else {
				// commands.add(new LoadCommand(sequence.getInitialConfig().clone(), timestamp) {
				// public void undo() {
				// updateConfig(config);
				// }
				// });
				// }
			}
		}
	}

	private class InitialConfigCommand extends LoadCommand {
		/**
		 * @param config
		 * @param timestamp
		 */
		public InitialConfigCommand(final TwisterConfig config, final long timestamp) {
			super(config, timestamp);
		}

		@Override
		public void redo() {
			final TwisterConfig configClone = config.clone();
			configClone.setContext(new DefaultConfigContext());
			updateConfig(configClone);
		}
	}

	private class FinalConfigCommand extends LoadCommand {
		/**
		 * @param config
		 * @param timestamp
		 */
		public FinalConfigCommand(final TwisterConfig config, final long timestamp) {
			super(config, timestamp);
		}

		@Override
		public void undo() {
			final TwisterConfig configClone = config.clone();
			configClone.setContext(new DefaultConfigContext());
			updateConfig(configClone);
		}
	}
}
