/*
 * $Id:EditClipDialog.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;

import net.sf.jame.core.swing.util.GUIFactory;
import net.sf.jame.service.AsyncService;
import net.sf.jame.service.AsyncService.ServiceVoidCallback;
import net.sf.jame.service.clip.MovieClipDataRow;

/**
 * @author Andrea Medeghini
 */
public class EditClipDialog extends JDialog {
	private static final long serialVersionUID = 1L;
	private static final String EDIT_CLIP_FRAME_TITLE = "editClipFrame.title";
	// private static final String EDIT_CLIP_FRAME_WIDTH = "editClipFrame.width";
	// private static final String EDIT_CLIP_FRAME_HEIGHT = "editClipFrame.height";
	// private static final String EDIT_CLIP_FRAME_ICON = "editClipFrame.icon";
	private final MovieClipDataRow clip;
	private final AsyncService service;
	private JTextField nameTextField;
	private JTextField descriptionTextField;

	/**
	 * @param service
	 * @param clip
	 */
	public EditClipDialog(final AsyncService service, final MovieClipDataRow clip) {
		this.clip = clip;
		this.service = service;
		// final int defaultWidth = Integer.parseInt(ServiceResources.getInstance().getString(EditClipDialog.EDIT_CLIP_FRAME_WIDTH));
		// final int defaultHeight = Integer.parseInt(ServiceResources.getInstance().getString(EditClipDialog.EDIT_CLIP_FRAME_HEIGHT));
		// final int width = Integer.getInteger(EditClipFrame.EDIT_CLIP_FRAME_WIDTH, defaultWidth);
		// final int height = Integer.getInteger(EditClipFrame.EDIT_CLIP_FRAME_HEIGHT, defaultHeight);
		setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
		setTitle(ServiceSwingResources.getInstance().getString(EditClipDialog.EDIT_CLIP_FRAME_TITLE));
		getContentPane().add(createClipPanel());
		addWindowListener(new DialogListener());
		// setSize(new Dimension(width, height));
		pack();
		final Point p = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
		p.x -= getWidth() / 2;
		p.y -= getHeight() / 2;
		setLocation(p);
		setResizable(false);
		setModal(true);
	}

	private Box createClipPanel() {
		final Box namePanel = Box.createHorizontalBox();
		final Box descriptionPanel = Box.createHorizontalBox();
		nameTextField = GUIFactory.createTextField(clip.getClipName(), null, 20);
		final Dimension labelSize = new Dimension(80, 20);
		final JLabel nameLabel = GUIFactory.createLabel(ServiceSwingResources.getInstance().getString("label.name"), SwingConstants.RIGHT);
		nameLabel.setPreferredSize(labelSize);
		namePanel.add(nameLabel);
		namePanel.add(Box.createHorizontalStrut(8));
		namePanel.add(nameTextField);
		namePanel.add(Box.createHorizontalStrut(200));
		namePanel.add(Box.createHorizontalGlue());
		descriptionTextField = GUIFactory.createTextField(clip.getDescription(), null, 40);
		final JLabel descriptionLabel = GUIFactory.createLabel(ServiceSwingResources.getInstance().getString("label.description"), SwingConstants.RIGHT);
		descriptionLabel.setPreferredSize(labelSize);
		descriptionPanel.add(descriptionLabel);
		descriptionPanel.add(Box.createHorizontalStrut(8));
		descriptionPanel.add(descriptionTextField);
		final JPanel buttonsPanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttonsPanel.add(GUIFactory.createButton(new SaveAction(), null));
		buttonsPanel.add(GUIFactory.createButton(new CloseAction(), null));
		final Box panel = Box.createVerticalBox();
		panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
		panel.add(namePanel);
		panel.add(Box.createVerticalStrut(8));
		panel.add(descriptionPanel);
		panel.add(Box.createVerticalStrut(8));
		panel.add(buttonsPanel);
		return panel;
	}

	private class SaveAction extends AbstractAction {
		private static final long serialVersionUID = 1L;

		/**
		 * 
		 */
		public SaveAction() {
			super(ServiceSwingResources.getInstance().getString("action.save"));
		}

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(final ActionEvent e) {
			boolean error = false;
			if (nameTextField.getText().trim().length() == 0) {
				nameTextField.setBackground(Color.RED);
				error = true;
			}
			if (!error) {
				clip.setClipName(nameTextField.getText());
				clip.setDescription(descriptionTextField.getText());
				service.saveClip(new ServiceVoidCallback() {
					public void executed() {
						SwingUtilities.invokeLater(new DialogClose());
					}

					public void failed(final Throwable throwable) {
						JOptionPane.showMessageDialog(EditClipDialog.this, ServiceSwingResources.getInstance().getString("error.saveClip"), ServiceSwingResources.getInstance().getString("label.saveClip"), JOptionPane.ERROR_MESSAGE);
					}
				}, clip);
			}
			else {
				JOptionPane.showMessageDialog(EditClipDialog.this, ServiceSwingResources.getInstance().getString("error.saveClip"), ServiceSwingResources.getInstance().getString("label.saveClip"), JOptionPane.ERROR_MESSAGE);
			}
		}
	}

	private class CloseAction extends AbstractAction {
		private static final long serialVersionUID = 1L;

		/**
		 * 
		 */
		public CloseAction() {
			super(ServiceSwingResources.getInstance().getString("action.close"));
		}

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(final ActionEvent e) {
			SwingUtilities.invokeLater(new DialogClose());
		}
	}

	private class DialogListener extends WindowAdapter {
		/**
		 * @see java.awt.event.WindowAdapter#windowClosing(java.awt.event.WindowEvent)
		 */
		@Override
		public void windowClosing(final WindowEvent e) {
			SwingUtilities.invokeLater(new DialogClose());
		}
	}

	private class DialogClose implements Runnable {
		/**
		 * @see java.lang.Runnable#run()
		 */
		public void run() {
			setVisible(false);
		}
	}
}
