/*
 * $Id:SpoolJobServiceServerTest.java 491 2008-01-28 21:59:31Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking.test.spool;

import java.io.File;

import net.sf.jame.networking.jxta.JXTANetworkService;
import net.sf.jame.networking.spool.DistributedServiceProcessor;
import net.sf.jame.service.spool.DefaultJobService;
import net.sf.jame.service.spool.impl.DistributedJob;
import net.sf.jame.service.spool.impl.DistributedJobFactory;
import net.sf.jame.twister.renderer.Surface;

import org.apache.log4j.Logger;
import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class SpoolJobServiceServerTest {
	private static final Logger logger = Logger.getLogger(SpoolJobServiceServerTest.class);

	private void deleteFiles(final File path) {
		final File[] files = path.listFiles();
		for (final File file : files) {
			if (file.isDirectory()) {
				deleteFiles(file);
			}
			file.delete();
		}
	}

	@Test
	public void testSpool() throws Exception {
		final Surface surface = new Surface(200, 200);
		final File tmpDir = new File("workdir/tmp");
		tmpDir.mkdirs();
		deleteFiles(tmpDir);
		final DistributedServiceProcessor processor = new DistributedServiceProcessor(new DefaultJobService<DistributedJob>(new DistributedJobFactory(tmpDir)), 10);
		final JXTANetworkService service = new JXTANetworkService(tmpDir, "http://jame.sf.net", "JAME-Service", "Andrea Medeghini", "1.0", processor);
		service.start();
		processor.start();
		try {
			while (true) {
				logger.info("Server running...");
				Thread.sleep(10000);
			}
		}
		catch (final InterruptedException e) {
		}
		processor.stop();
		service.stop();
	}
}
