/*
 * $Id:Application.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking.jxta;

import java.util.Properties;

import net.sf.jame.launcher.Launcher;
import net.sf.jame.runtime.LauncherContext;
import net.sf.jame.runtime.LauncherContextListener;
import net.sf.jame.runtime.LauncherThreadFactory;
import net.sf.jame.twister.renderer.Surface;

import org.apache.log4j.PropertyConfigurator;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

/**
 * Application implementation.
 * 
 * @author Andrea Medeghini
 */
public class Application implements IApplication {
	private final Launcher<DefaultLauncherContext> launcher = new Launcher<DefaultLauncherContext>(new DefaultLauncherContext(), new DefaultLauncherThreadFactory());
	private LauncherContextListener listener;
	
	/**
	 * @see org.eclipse.equinox.app.IApplication#start(org.eclipse.equinox.app.IApplicationContext)
	 */
	public Object start(final IApplicationContext context) throws Exception {
		final Surface surface = new Surface(200, 200);
		Properties log4jProperties = new Properties();
		log4jProperties.put("log4j.rootLogger", "INFO, console");
		log4jProperties.put("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
		log4jProperties.put("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
		log4jProperties.put("log4j.appender.console.layout.ConversionPattern", "%d{HH:mm:ss,SSS} %-5p %c - %m%n");
		log4jProperties.put("log4j.logger.net.sf.jame", "INFO");
		log4jProperties.put("log4j.logger.org.apache.derby", "INFO");
		PropertyConfigurator.configure(log4jProperties);
		boolean restart = false;
		try {
			launcher.init();
			launcher.start();
			if (listener != null) {
				listener.started();
			}
			context.applicationRunning();
			restart = launcher.dispatch();
			if (listener != null) {
				listener.stopped();
			}
			launcher.dispose();
		}
		catch (final Exception e) {
			e.printStackTrace();
		}
		if (restart) {
			return IApplication.EXIT_RESTART;
		}
		return IApplication.EXIT_OK;
	}

	/**
	 * @see org.eclipse.equinox.app.IApplication#stop()
	 */
	public void stop() {
		launcher.stop();
	}

	private class DefaultLauncherContext implements LauncherContext {
		/**
		 * @see net.sf.jame.runtime.LauncherContext#exit()
		 */
		public void exit() {
			launcher.stop();
		}

		/**
		 * @see net.sf.jame.runtime.LauncherContext#restart()
		 */
		public void restart() {
			launcher.restart();
		}

		/**
		 * @see net.sf.jame.runtime.LauncherContext#setContextListener(net.sf.jame.runtime.LauncherContextListener)
		 */
		public void setContextListener(LauncherContextListener listener) {
			Application.this.listener = listener;
		}
	}

	private class DefaultLauncherThreadFactory implements LauncherThreadFactory<DefaultLauncherContext> {
		/**
		 * @see net.sf.jame.networking.jxta.spool.LauncherThreadFactory#createThread(net.sf.jame.launcher.LauncherContext)
		 */
		public Thread createThread(final DefaultLauncherContext context) {
			return new ServiceLauncherThread(context);
		}
	}
}
