/*
 * $Id:Scene.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is based on code from idx3dIII
 * Copyright (C) 1999, 2000 Peter Walser, pwalser@idx3d.ch
 * http://www.idx3d.ch/idx3d/idx3d.html
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.media.g3d;

import java.util.Enumeration;
import java.util.Hashtable;

public final class Scene extends Assembly {
	private Environment environment;
	private final Lightmap lightmap;
	private final Hashtable cameras;
	private final Hashtable lights;

	public Scene(final String name, final Environment environment) {
		super(name);
		if (environment == null) {
			throw new IllegalArgumentException("illegal argument ! [environment == null]");
		}
		lightmap = new Lightmap(environment.ambient);
		this.environment = environment;
		cameras = new Hashtable();
		lights = new Hashtable();
		parent = null;
	}

	public void removeCamera(final Camera camera) {
		cameras.remove(camera.getName());
	}

	public void addCamera(final Camera camera) {
		if (camera.getName() != null) {
			cameras.put(camera.getName(), camera);
		}
	}

	public Camera getCamera(final String name) {
		return ((Camera) cameras.get(name));
	}

	public Enumeration getCameras() {
		return (cameras.elements());
	}

	public void removeLight(final Light light) {
		lights.remove(light.getName());
		lightmap.removeLight(light);
	}

	public void addLight(final Light light) {
		if (light.getName() != null) {
			lights.put(light.getName(), light);
			lightmap.addLight(light);
		}
	}

	public Light getLight(final String name) {
		return ((Light) lights.get(name));
	}

	public Enumeration getLights() {
		return (lights.elements());
	}

	public Lightmap getLightmap() {
		return (lightmap);
	}

	public void rebuildLightmap() {
		lightmap.rebuildLightmap();
	}

	public void build() {
		rebuild();
	}

	public void setEnvironment(final Environment environment) {
		if (environment == null) {
			throw new IllegalArgumentException("illegal argument ! [environment == null]");
		}
		lightmap.setAmbient(environment.ambient);
		this.environment = environment;
	}

	public Environment getEnvironment() {
		return (environment);
	}

	@Override
	public String toString() {
		final StringBuffer s = new StringBuffer("scene: " + name + "\r\n");
		Solid solid = null;
		final Enumeration solids = getSolids();
		while (solids.hasMoreElements()) {
			solid = (Solid) solids.nextElement();
			s.append(solid.toString());
		}
		return (s.toString());
	}
}
