/*
 * $Id:ColorRendererElementTest.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.test.color;

import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.tree.Node;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.mandelbrot.MandelbrotRegistry;
import net.sf.jame.mandelbrot.color.ColorRendererExtensionReferenceNodeValue;
import net.sf.jame.mandelbrot.color.extension.ColorRendererExtensionConfig;
import net.sf.jame.mandelbrot.extensions.color.COSConfig;
import net.sf.jame.mandelbrot.extensions.color.SINConfig;
import net.sf.jame.test.AbstractConfigurableExtensionConfigElementTest;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElement;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLExporter;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLImporter;
import net.sf.jame.twister.util.ConfigurableExtensionReferenceNode;

import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class ColorRendererElementTest extends AbstractConfigurableExtensionConfigElementTest<ColorRendererExtensionConfig> {
	@Override
	protected Node createElementNode() {
		return new ConfigurableExtensionReferenceNode<ColorRendererExtensionConfig>("reference", getConfigElement()) {
			@Override
			protected NodeValue<?> createNodeValue(final ConfigurableExtensionReference<ColorRendererExtensionConfig> value) {
				return new ColorRendererExtensionReferenceNodeValue(value);
			}
		};
	}

	@Override
	protected ConfigurableExtensionConfigElement<ColorRendererExtensionConfig> createConfigElement(final ConfigurableExtensionReference<ColorRendererExtensionConfig> defaultValue) {
		final ConfigurableExtensionConfigElement<ColorRendererExtensionConfig> configElement = new ConfigurableExtensionConfigElement<ColorRendererExtensionConfig>();
		configElement.setReference(defaultValue);
		return configElement;
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLExporter<ColorRendererExtensionConfig> createXMLExporter() {
		return new ConfigurableExtensionConfigElementXMLExporter<ColorRendererExtensionConfig>();
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLImporter<ColorRendererExtensionConfig> createXMLImporter() {
		return new ConfigurableExtensionConfigElementXMLImporter<ColorRendererExtensionConfig>(MandelbrotRegistry.getInstance().getColorRendererRegistry());
	}

	@Override
	protected ConfigurableExtensionReference<ColorRendererExtensionConfig> getFirstReference() {
		final ConfigurableExtensionReference<ColorRendererExtensionConfig> reference = new ConfigurableExtensionReference<ColorRendererExtensionConfig>("twister.mandelbrot.color.renderer.sin", "SIN", new SINConfig());
		return reference;
	}

	@Override
	protected ConfigurableExtensionReference<ColorRendererExtensionConfig> getSecondReference() {
		final ConfigurableExtensionReference<ColorRendererExtensionConfig> reference = new ConfigurableExtensionReference<ColorRendererExtensionConfig>("twister.mandelbrot.color.renderer.cos", "COS", new COSConfig());
		return reference;
	}

	@Override
	@Test
	public void testSetReference() {
		super.testSetReference();
	}

	@Override
	@Test
	public void testNode() {
		super.testNode();
	}

	@Override
	@Test
	public void testClone() {
		super.testClone();
	}

	@Override
	@Test
	public void testSerialization() {
		super.testSerialization();
	}

	@Override
	@Test
	public void testXML() {
		super.testXML();
	}
}
