/*
 * $Id:FractalRenderer.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.renderer;

import java.awt.Graphics2D;
import java.util.Map;

import net.sf.jame.mandelbrot.fractal.MandelbrotFractalRuntimeElement;
import net.sf.jame.twister.DoubleVector2D;
import net.sf.jame.twister.ImageTile;
import net.sf.jame.twister.View;

/**
 * @author Andrea Medeghini
 */
public interface FractalRenderer {
	/**
	 * 
	 */
	public static final int MODE_CALCULATE = 0x01;
	/**
	 * 
	 */
	public static final int MODE_REFRESH = 0x02;

	/**
	 * @param g the destination.
	 */
	public void drawImage(Graphics2D g);

	/**
	 * @param g
	 * @param x
	 * @param y
	 * @param w
	 * @param h
	 */
	public void drawImage(Graphics2D g, int x, int y, int w, int h);

	/**
	 * 
	 */
	public void startRenderer();

	/**
	 * 
	 */
	public void abortRenderer();

	/**
	 * @throws InterruptedException
	 */
	public void joinRenderer() throws InterruptedException;

	/**
	 * @return true if is interrupted.
	 */
	public boolean isInterrupted();

	/**
	 * @return the status.
	 */
	public int getRenderingStatus();

	/**
	 * @param mode
	 */
	public void setMode(int mode);

	/**
	 * @return
	 */
	public int getMode();

	/**
	 * @return the fractal.
	 */
	public MandelbrotFractalRuntimeElement getFractal();

	/**
	 * @param fractal the fractal.
	 */
	public void setFractal(MandelbrotFractalRuntimeElement fractal);

	/**
	 * @param hints
	 */
	public void setRenderingHints(Map<Object, Object> hints);

	/**
	 * @param view
	 */
	public void setView(View view);

	/**
	 * @param view
	 * @param constant
	 * @param imageMode
	 */
	public void setView(final View view, final DoubleVector2D constant, final int imageMode);

	/**
	 * @param tile
	 */
	public void setTile(ImageTile tile);

	/**
	 * @return
	 */
	public ImageTile getTile();

	/**
	 * @param mode
	 */
	public void setMandelbrotMode(Integer mode);

	/**
	 * @param constant
	 */
	public void setConstant(DoubleVector2D constant);

	/**
	 * @return
	 */
	public boolean isDynamic();

	/**
	 * @return
	 */
	public boolean isViewChanged();

	/**
	 * 
	 */
	public void dispose();
}
