/*
 * $Id:COSZRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.extensions.fractal.rendering;

import java.util.ArrayList;
import java.util.List;

import net.sf.jame.core.math.Complex;
import net.sf.jame.mandelbrot.renderer.RenderedPoint;

/**
 * @author Andrea Medeghini
 */
public class COSZRuntime extends AbstractRenderingFormulaRuntime<COSZConfig> {
	private double ta;
	private double tb;
	private double tc;
	private double td;
	private double te;
	private double tf;

	/**
	 * @see net.sf.jame.mandelbrot.extensions.fractal.rendering.AbstractRenderingFormulaRuntime#isHorizontalSymetryAllowed()
	 */
	@Override
	public boolean isHorizontalSymetryAllowed() {
		return true;
	}

	/**
	 * @see net.sf.jame.mandelbrot.extensions.fractal.rendering.AbstractRenderingFormulaRuntime#isVerticalSymetryAllowed()
	 */
	@Override
	public boolean isVerticalSymetryAllowed() {
		return true;
	}

	/**
	 * @see net.sf.jame.mandelbrot.fractal.rendering.extension.RenderingFormulaExtensionRuntime#renderPoint(net.sf.jame.mandelbrot.renderer.RenderedPoint)
	 */
	@Override
	public int renderPoint(final RenderedPoint cp) {
		cp.time = 0;
		cp.zr = cp.xr;
		cp.zi = cp.xi;
		for (int k = 1; k <= iterations; k++) {
			ta = Math.cos(cp.zr);
			tb = Math.sin(cp.zr);
			tc = Math.exp(+cp.zi);
			td = Math.exp(-cp.zi);
			te = ta * 0.5d * (tc + td);
			tf = tb * 0.5d * (tc - td);
			cp.zr = (cp.wr * te) + (cp.wi * tf);
			cp.zi = (cp.wi * te) - (cp.wr * tf);
			tc = Math.abs(cp.zi);
			if (tc > threshold) {
				cp.time = k;
				break;
			}
		}
		return cp.time;
	}

	/**
	 * @see net.sf.jame.mandelbrot.fractal.rendering.extension.RenderingFormulaExtensionRuntime#renderOrbit(net.sf.jame.mandelbrot.renderer.RenderedPoint)
	 */
	@Override
	public List<Complex> renderOrbit(final RenderedPoint cp) {
		final ArrayList<Complex> orbit = new ArrayList<Complex>();
		double ta = 0.0;
		double tb = 0.0;
		double tc = 0.0;
		double td = 0.0;
		double te = 0.0;
		double tf = 0.0;
		cp.zr = cp.xr;
		cp.zi = cp.xi;
		for (int k = 0; k < iterations; k++) {
			ta = Math.cos(cp.zr);
			tb = Math.sin(cp.zr);
			tc = Math.exp(+cp.zi);
			td = Math.exp(-cp.zi);
			te = ta * 0.5d * (tc + td);
			tf = tb * 0.5d * (tc - td);
			cp.zr = (cp.wr * te) + (cp.wi * tf);
			cp.zi = (cp.wi * te) - (cp.wr * tf);
			orbit.add(new Complex(cp.zr, cp.zi));
			tc = Math.abs(cp.zi);
			if (tc > threshold) {
				break;
			}
		}
		return orbit;
	}
}
