/*
 * $Id:Launcher.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.launcher;

import java.awt.Frame;
import java.lang.management.ManagementFactory;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import net.sf.jame.runtime.LauncherContext;
import net.sf.jame.runtime.LauncherThreadFactory;

import org.eclipse.swt.widgets.Display;

/**
 * @author Andrea Medeghini
 */
public class Launcher<T extends LauncherContext> {
	private final LauncherThreadFactory<T> factory;
	private T context;
	private final Display display = new Display();
	private final boolean[] runEventLoop = new boolean[] { true };
	private boolean restart;

	/**
	 * @param context
	 * @param factory
	 */
	public Launcher(final T context, final LauncherThreadFactory<T> factory) {
		this.context = context;
		this.factory = factory;
	}

	/**
	 * @throws Exception
	 */
	public void init() throws Exception {
//		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		Display.setAppName("JAME");
		display.disposeExec(new Runnable() {
			/**
			 * @see java.lang.Runnable#run()
			 */
			public void run() {
				context.exit();
			}
		});
	}

	/**
	 * @throws Exception
	 */
	public void start() throws Exception {
		runEventLoop[0] = true;
		final String version = ManagementFactory.getRuntimeMXBean().getVmVersion();
		if (version.length() > 2  && "1.5".compareTo(version.substring(0, 3)) > 0) {
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					JOptionPane.showMessageDialog(new Frame(), "Could not launch the application because\nit requires Java 1.5 or later!", "Error", JOptionPane.ERROR_MESSAGE);
					stop();
				}
			});
		}
		else {
			final Thread thread = factory.createThread(context);
			thread.start();
		}
	}

	/**
	 * 
	 */
	public void stop() {
		runEventLoop[0] = false;
	}

	/**
	 * 
	 */
	public boolean dispatch() {
		while (runEventLoop[0]) {
			try {
				if (!display.readAndDispatch()) {
					display.sleep();
				}
			}
			catch (final Throwable t) {
				t.printStackTrace();
			}
		}
		return restart;
	}

	/**
	 * 
	 */
	public void dispose() {
		context = null;
	}

	/**
	 * 
	 */
	public void restart() {
		restart = true;
		stop();
	}
}
