/*
 * $Id:Files.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * Utility class for files manipulation.
 * 
 * @author Andrea Medeghini
 */
public class Files {
	private Files() {
	}

	/**
	 * Copyes a file.
	 * 
	 * @param srcFileName
	 * @param dstFileName
	 * @throws IOException
	 */
	public static void copyFile(final String srcFileName, final String dstFileName) throws IOException {
		Files.copyFile(new File(srcFileName), new File(dstFileName));
	}

	/**
	 * Copyes a file.
	 * 
	 * @param srcFile
	 * @param dstFile
	 * @throws IOException
	 */
	public static void copyFile(final File srcFile, final File dstFile) throws IOException {
		FileInputStream fis = null;
		FileOutputStream fos = null;
		try {
			fis = new FileInputStream(srcFile);
			fos = new FileOutputStream(dstFile);
			final byte[] buffer = new byte[4096];
			int length = 0;
			while ((length = fis.read(buffer)) > 0) {
				fos.write(buffer, 0, length);
			}
		}
		finally {
			if (fis != null) {
				try {
					fis.close();
				}
				catch (final Exception e) {
				}
			}
			if (fos != null) {
				try {
					fos.close();
				}
				catch (final Exception e) {
				}
			}
		}
	}

	/**
	 * @param path
	 */
	public static void deleteFiles(final File path) {
		final File[] files = path.listFiles();
		for (final File file : files) {
			if (file.isDirectory()) {
				deleteFiles(file);
			}
			file.delete();
		}
	}
}
