/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private transient boolean alreadycounting = false;
    private long bytesWritten = 0L;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    public String toString() {
        if (null == this.out) {
            return "closed/" + super.toString();
        }
        return this.out.toString() + "/" + super.toString();
    }

    public synchronized void write(int b) throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        super.write(b);
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            ++this.bytesWritten;
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        super.write(b, off, len);
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            this.bytesWritten += (long)len;
        }
    }

    public synchronized long getBytesWritten() {
        return this.bytesWritten;
    }
}

