/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleSpecID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PeerGroupAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private PeerGroupID gid = null;
    private ModuleSpecID specId = null;
    private String name = null;
    private Element description = null;
    private final Map<ID, StructuredDocument> serviceParams = new HashMap<ID, StructuredDocument>();

    public static String getAdvertisementType() {
        return "jxta:PGA";
    }

    @Override
    public final String getBaseAdvType() {
        return PeerGroupAdvertisement.getAdvertisementType();
    }

    @Override
    public PeerGroupAdvertisement clone() {
        PeerGroupAdvertisement clone;
        try {
            clone = (PeerGroupAdvertisement)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
        clone.setPeerGroupID(this.getPeerGroupID());
        clone.setModuleSpecID(this.getModuleSpecID());
        clone.setName(this.getName());
        clone.setDesc(this.getDesc());
        clone.setServiceParams(this.getServiceParams());
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModuleSpecID getModuleSpecID() {
        return this.specId;
    }

    public void setModuleSpecID(ModuleSpecID sid) {
        this.specId = sid;
    }

    public PeerGroupID getPeerGroupID() {
        return this.gid;
    }

    public void setPeerGroupID(PeerGroupID gid) {
        this.gid = gid;
    }

    @Override
    public ID getID() {
        return this.gid;
    }

    public String getDescription() {
        if (null != this.description) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Desc", description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }

    public void setServiceParams(Hashtable<ID, ? extends Element> params) {
        this.serviceParams.clear();
        if (params == null) {
            return;
        }
        for (Map.Entry<ID, ? extends Element> anEntry : params.entrySet()) {
            Element e = anEntry.getValue();
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            this.serviceParams.put(anEntry.getKey(), newDoc);
        }
    }

    public Hashtable<ID, StructuredDocument> getServiceParams() {
        Hashtable<ID, StructuredDocument> copy = new Hashtable<ID, StructuredDocument>();
        for (Map.Entry<ID, StructuredDocument> anEntry : this.serviceParams.entrySet()) {
            Element e = anEntry.getValue();
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            copy.put(anEntry.getKey(), newDoc);
        }
        return copy;
    }

    public void putServiceParam(ID key, Element param) {
        if (param == null) {
            this.serviceParams.remove(key);
            return;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        this.serviceParams.put(key, newDoc);
    }

    public StructuredDocument getServiceParam(ID key) {
        StructuredDocument param = this.serviceParams.get(key);
        if (param == null) {
            return null;
        }
        return StructuredDocumentUtils.copyAsDocument(param);
    }

    public StructuredDocument removeServiceParam(ID key) {
        Element param = this.serviceParams.remove(key);
        if (param == null) {
            return null;
        }
        return StructuredDocumentUtils.copyAsDocument(param);
    }
}

