/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public class RouteAdv
extends RouteAdvertisement
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(RouteAdv.class.getName());
    private static final String[] INDEX_FIELDS = new String[]{"DstPID"};

    private RouteAdv() {
    }

    private RouteAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(RouteAdv.getAdvertisementType()) && !RouteAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
        this.setDestPeerID(this.getDestPeerID());
        if (this.hasALoop()) {
            throw new IllegalArgumentException("Route contains a loop!");
        }
    }

    public RouteAdv clone() {
        return (RouteAdv)super.clone();
    }

    public String getAdvType() {
        return RouteAdv.getAdvertisementType();
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if ("DstPID".equals(elem.getName())) {
            try {
                URI pID = new URI(elem.getTextValue());
                this.setDestPeerID((PeerID)IDFactory.fromURI(pID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad PeerID in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("ID in advertisement is not a peer id");
            }
            return true;
        }
        if ("Dst".equals(elem.getName())) {
            Enumeration eachXpt = elem.getChildren();
            while (eachXpt.hasMoreElements()) {
                XMLElement aXpt = (XMLElement)eachXpt.nextElement();
                AccessPointAdvertisement xptAdv = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                this.setDest(xptAdv);
            }
            return true;
        }
        if ("Hops".equals(elem.getName())) {
            Vector<AccessPointAdvertisement> hops = new Vector<AccessPointAdvertisement>();
            Enumeration eachXpt = elem.getChildren();
            while (eachXpt.hasMoreElements()) {
                XMLElement aXpt = (XMLElement)eachXpt.nextElement();
                AccessPointAdvertisement xptAdv = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                hops.addElement(xptAdv);
            }
            this.setHops(hops);
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        AccessPointAdvertisement dest;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (this.hasALoop()) {
            throw new IllegalStateException("I won't write a doc for a route with a loop");
        }
        PeerID pid = this.getDestPeerID();
        if (null != pid) {
            Object e0 = adv.createElement("DstPID", pid.toString());
            adv.appendChild(e0);
        }
        Object e1 = adv.createElement("Dst");
        adv.appendChild(e1);
        AccessPointAdvertisement destAPA = dest = this.getDest();
        if (null != dest.getPeerID()) {
            destAPA = dest.clone();
            destAPA.setPeerID(null);
        }
        StructuredDocument xptDoc = (StructuredDocument)destAPA.getDocument(encodeAs);
        StructuredDocumentUtils.copyElements(adv, e1, xptDoc);
        Enumeration<AccessPointAdvertisement> eachHop = this.getHops();
        if (eachHop.hasMoreElements()) {
            Object e2 = adv.createElement("Hops");
            adv.appendChild(e2);
            while (eachHop.hasMoreElements()) {
                AccessPointAdvertisement hop = eachHop.nextElement();
                if (null == hop.getPeerID()) continue;
                xptDoc = (StructuredDocument)hop.getDocument(encodeAs);
                StructuredDocumentUtils.copyElements(adv, e2, xptDoc);
            }
        }
        return adv;
    }

    public String[] getIndexFields() {
        return INDEX_FIELDS;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return RouteAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new RouteAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getAdvertisementType() + " only supports XLMElement");
            }
            return new RouteAdv((XMLElement)root);
        }
    }
}

