/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdPeerGroup
extends GenericPeerGroup {
    private static final transient Logger LOG;
    public static final XMLDocument STD_COMPAT;
    public static final String MODULE_IMPL_STD_URI = "http://jxta-jxse.dev.java.net/download/jxta.jar";
    public static final String MODULE_IMPL_STD_PROVIDER = "sun.com";
    protected static final String STD_COMPAT_FORMAT = "Efmt";
    protected static final String STD_COMPAT_FORMAT_VALUE = "JDK1.4.1";
    protected static final String STD_COMPAT_BINDING = "Bind";
    protected static final String STD_COMPAT_BINDING_VALUE = "V2.0 Ref Impl";
    private volatile boolean started = false;
    private final List<ModuleClassID> moduleStartOrder = new ArrayList<ModuleClassID>();
    private final Map<ModuleClassID, Object> messageTransports = new HashMap<ModuleClassID, Object>();
    private final Map<ModuleClassID, Object> applications = new HashMap<ModuleClassID, Object>();
    private Cm cm = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerFromFile(URL providers) {
        boolean registeredSomething = false;
        InputStream urlStream = null;
        try {
            String provider;
            urlStream = providers.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream, "UTF-8"));
            while ((provider = reader.readLine()) != null) {
                int comment = provider.indexOf(35);
                if (comment != -1) {
                    provider = provider.substring(0, comment);
                }
                if (0 == (provider = provider.trim()).length()) continue;
                try {
                    String[] parts = provider.split("\\s", 3);
                    if (3 == parts.length) {
                        ModuleImplAdvertisement moduleImplAdv;
                        ModuleSpecID msid = ModuleSpecID.create(URI.create(parts[0]));
                        String code = parts[1];
                        String description = parts[2];
                        try {
                            Class<?> moduleClass = Class.forName(code);
                            Method getImplAdvMethod = moduleClass.getMethod("getDefaultModuleImplAdvertisement", new Class[0]);
                            moduleImplAdv = (ModuleImplAdvertisement)getImplAdvMethod.invoke(null, new Object[0]);
                        }
                        catch (Exception failed) {
                            moduleImplAdv = StdPeerGroup.mkImplAdvBuiltin(msid, code, description);
                        }
                        StdPeerGroup.getJxtaLoader().defineClass(moduleImplAdv);
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("Registered Module " + msid + " : " + parts[1]);
                        continue;
                    }
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Failed to register '" + provider + "'");
                }
                catch (Exception allElse) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Failed to register '" + provider + "'", allElse);
                }
            }
        }
        catch (IOException ex) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to read provider list " + providers, ex);
            }
        }
        finally {
            if (null != urlStream) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return registeredSomething;
    }

    private static XMLDocument mkCS() {
        XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Comp");
        Object e = doc.createElement(STD_COMPAT_FORMAT, STD_COMPAT_FORMAT_VALUE);
        doc.appendChild(e);
        e = doc.createElement(STD_COMPAT_BINDING, STD_COMPAT_BINDING_VALUE);
        doc.appendChild(e);
        return doc;
    }

    static ModuleImplAdvertisement mkImplAdvBuiltin(ModuleSpecID specID, String code, String descr) {
        ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        implAdv.setModuleSpecID(specID);
        implAdv.setCompat(STD_COMPAT);
        implAdv.setCode(code);
        implAdv.setUri(MODULE_IMPL_STD_URI);
        implAdv.setProvider(MODULE_IMPL_STD_PROVIDER);
        implAdv.setDescription(descr);
        return implAdv;
    }

    private static ModuleImplAdvertisement getDefaultModuleImplAdvertisement() {
        ModuleImplAdvertisement implAdv = StdPeerGroup.mkImplAdvBuiltin(PeerGroup.allPurposePeerGroupSpecID, StdPeerGroup.class.getName(), "General Purpose Peer Group Implementation");
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv();
        JxtaLoader loader = StdPeerGroup.getJxtaLoader();
        ModuleImplAdvertisement moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refEndpointSpecID);
        paramAdv.addService(PeerGroup.endpointClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refResolverSpecID);
        paramAdv.addService(PeerGroup.resolverClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refMembershipSpecID);
        paramAdv.addService(PeerGroup.membershipClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refAccessSpecID);
        paramAdv.addService(PeerGroup.accessClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refDiscoverySpecID);
        paramAdv.addService(PeerGroup.discoveryClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refRendezvousSpecID);
        paramAdv.addService(PeerGroup.rendezvousClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refPipeSpecID);
        paramAdv.addService(PeerGroup.pipeClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refPeerinfoSpecID);
        paramAdv.addService(PeerGroup.peerinfoClassID, moduleAdv);
        moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refShellSpecID);
        if (null != moduleAdv) {
            paramAdv.addApp(PeerGroup.applicationClassID, moduleAdv);
        }
        XMLElement paramElement = (XMLElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    @Override
    public boolean compatible(Element compat) {
        return StdPeerGroup.isCompatible(compat);
    }

    static boolean isCompatible(Element compat) {
        boolean formatOk = false;
        boolean bindingOk = false;
        if (!(compat instanceof TextElement)) {
            return false;
        }
        try {
            Enumeration hisChildren = ((TextElement)compat).getChildren();
            int i = 0;
            while (hisChildren.hasMoreElements()) {
                if (++i > 2) {
                    return false;
                }
                TextElement e = (TextElement)hisChildren.nextElement();
                String key = e.getKey();
                String val = e.getValue().trim();
                if (STD_COMPAT_FORMAT.equals(key)) {
                    String version;
                    boolean specMatches;
                    Package javaLangPackage = Package.getPackage("java.lang");
                    if (val.startsWith("JDK") || val.startsWith("JRE")) {
                        specMatches = true;
                        version = val.substring(3).trim();
                    } else if (val.startsWith(javaLangPackage.getSpecificationTitle())) {
                        specMatches = true;
                        version = val.substring(javaLangPackage.getSpecificationTitle().length()).trim();
                    } else {
                        specMatches = false;
                        version = null;
                    }
                    formatOk = specMatches && javaLangPackage.isCompatibleWith(version);
                    continue;
                }
                if (STD_COMPAT_BINDING.equals(key) && STD_COMPAT_BINDING_VALUE.equals(val)) {
                    bindingOk = true;
                    continue;
                }
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Bad element in compatibility statement : " + key);
                }
                return false;
            }
        }
        catch (Exception any) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failure handling compatibility statement", any);
            }
            return false;
        }
        return formatOk && bindingOk;
    }

    protected void loadAllModules(Map<ModuleClassID, Object> modules, boolean privileged) {
        Iterator<Map.Entry<ModuleClassID, Object>> eachModule = modules.entrySet().iterator();
        while (eachModule.hasNext()) {
            Map.Entry<ModuleClassID, Object> anEntry = eachModule.next();
            ModuleClassID classID = anEntry.getKey();
            Object value = anEntry.getValue();
            if (value instanceof Module) continue;
            try {
                Module theModule = null;
                if (value instanceof ModuleImplAdvertisement) {
                    theModule = this.loadModule((ID)classID, (ModuleImplAdvertisement)value, privileged);
                } else if (value instanceof ModuleSpecID) {
                    theModule = this.loadModule(classID, (ModuleSpecID)value, 1, privileged);
                } else {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Skipping: " + classID + " Unsupported module descriptor : " + value.getClass().getName());
                    }
                    eachModule.remove();
                    continue;
                }
                if (theModule == null) {
                    throw new PeerGroupException("Could not find a loadable implementation for : " + classID);
                }
                anEntry.setValue(theModule);
            }
            catch (Exception e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Could not load module for class ID : " + classID, e);
                    if (value instanceof ModuleImplAdvertisement) {
                        LOG.log(Level.WARNING, "Will be missing from peer group : " + ((ModuleImplAdvertisement)value).getDescription());
                    } else {
                        LOG.log(Level.WARNING, "Will be missing from peer group: " + value);
                    }
                }
                eachModule.remove();
            }
        }
    }

    @Override
    public int startApp(String[] arg) {
        if (!this.initComplete) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Group has not been initialized or init failed.");
            }
            return -1;
        }
        if (this.started) {
            return 0;
        }
        this.started = true;
        int res = super.startApp(arg);
        if (0 != res) {
            return res;
        }
        this.loadAllModules(this.applications, false);
        res = this.startModules(this.applications);
        return res;
    }

    @Override
    public void stopApp() {
        Collections.reverse(this.moduleStartOrder);
        for (ModuleClassID aModule : this.moduleStartOrder) {
            try {
                if (this.messageTransports.containsKey(aModule)) {
                    Module theMessageTransport = (Module)this.messageTransports.remove(aModule);
                    theMessageTransport.stopApp();
                    continue;
                }
                this.removeService(aModule);
            }
            catch (Exception any) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Failed to stop module: " + aModule, any);
            }
        }
        this.moduleStartOrder.clear();
        if (!this.messageTransports.isEmpty()) {
            LOG.warning(this.messageTransports.size() + " message transports could not be shut down during peer group stop.");
        }
        this.messageTransports.clear();
        super.stopApp();
        if (this.cm != null) {
            this.cm.stop();
            this.cm = null;
        }
    }

    private int startModules(Map<ModuleClassID, Module> services) {
        int iterations = 0;
        int maxIterations = services.size() * services.size() + iterations + 1;
        boolean progress = true;
        while (!services.isEmpty() && (progress || iterations < maxIterations)) {
            progress = false;
            ++iterations;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessageFormat.format("Service startApp() round {0} of {1}(max)", iterations, maxIterations));
            }
            Iterator<Map.Entry<ModuleClassID, Module>> eachService = services.entrySet().iterator();
            block9: while (eachService.hasNext()) {
                int res;
                Map.Entry<ModuleClassID, Module> anEntry = eachService.next();
                ModuleClassID mcid = anEntry.getKey();
                Module aModule = anEntry.getValue();
                try {
                    res = aModule.startApp(null);
                }
                catch (Throwable all) {
                    if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Exception in startApp() : " + aModule, all);
                    }
                    res = -1;
                }
                switch (res) {
                    case 0: {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Module started : " + aModule);
                        }
                        if (aModule instanceof Service) {
                            this.addService(mcid, (Service)aModule);
                        } else {
                            this.messageTransports.put(mcid, aModule);
                        }
                        this.moduleStartOrder.add(mcid);
                        eachService.remove();
                        progress = true;
                        continue block9;
                    }
                    case 1: {
                        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                            LOG.finer("Service made progress during start : " + aModule);
                        }
                        progress = true;
                        continue block9;
                    }
                    case 2: {
                        if (!Logging.SHOW_FINER || !LOG.isLoggable(Level.FINER)) continue block9;
                        LOG.finer("Service stalled during start : " + aModule);
                        continue block9;
                    }
                    case -2147483548: {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Service declined to start : " + aModule);
                        }
                        eachService.remove();
                        progress = true;
                        continue block9;
                    }
                }
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Service failed to start (" + res + ") : " + aModule);
                }
                eachService.remove();
                progress = true;
            }
            if (!progress) continue;
            maxIterations = services.size() * services.size() + iterations + 1;
        }
        if (!services.isEmpty()) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                StringBuilder failed = new StringBuilder("No progress is being made in starting services after " + iterations + " iterations. Giving up.");
                failed.append("\nThe following services could not be started : ");
                for (Map.Entry<ModuleClassID, Module> aService : services.entrySet()) {
                    failed.append("\n\t");
                    failed.append(aService.getKey());
                    failed.append(" : ");
                    failed.append(aService.getValue());
                }
                LOG.severe(failed.toString());
            }
            return -1;
        }
        return 0;
    }

    @Override
    protected synchronized void initFirst(PeerGroup parent, ID assignedID, Advertisement impl) throws PeerGroupException {
        block17: {
            ModuleClassID aModule;
            Iterator<Object> eachModule;
            if (this.initComplete) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("You cannot initialize a PeerGroup more than once !");
                }
                return;
            }
            super.initFirst(parent, assignedID, impl);
            assignedID = this.getPeerGroupID();
            try {
                this.cm = new Cm(this.getHomeThreadGroup(), this.getStoreHome(), assignedID.getUniqueValue().toString(), 3600000L, false);
            }
            catch (Exception e) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Error during creation of local store", e);
                }
                throw new PeerGroupException("Error during creation of local store", e);
            }
            SrdiIndex.clearSrdi(this);
            StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(this.implAdvertisement.getParam());
            HashMap<ModuleClassID, Object> initServices = new HashMap<ModuleClassID, Object>(paramAdv.getServices());
            initServices.putAll(paramAdv.getProtos());
            ConfigParams conf = this.getConfigAdvertisement();
            if (null != conf) {
                eachModule = initServices.keySet().iterator();
                while (eachModule.hasNext()) {
                    aModule = (ModuleClassID)eachModule.next();
                    if (conf.isSvcEnabled(aModule)) continue;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Module disabled in configuration : " + aModule);
                    }
                    eachModule.remove();
                }
            }
            this.applications.putAll(paramAdv.getApps());
            if (null != conf) {
                eachModule = this.applications.keySet().iterator();
                while (eachModule.hasNext()) {
                    aModule = (ModuleClassID)eachModule.next();
                    if (conf.isSvcEnabled(aModule)) continue;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Application disabled in configuration : " + aModule);
                    }
                    eachModule.remove();
                }
            }
            this.loadAllModules(initServices, true);
            int res = this.startModules(initServices);
            if (0 != res) {
                throw new PeerGroupException("Failed to start peer group services. res : " + res);
            }
            try {
                this.checkServices();
            }
            catch (ServiceNotFoundException e) {
                LOG.log(Level.SEVERE, "Missing peer group service", e);
                throw new PeerGroupException("Missing peer group service", e);
            }
            DiscoveryService discoveryService = this.getDiscoveryService();
            if (discoveryService != null) {
                try {
                    discoveryService.publish(discoveryService.getImplAdvertisement(), 31536000000L, 1209600000L);
                    discoveryService.publish(this.implAdvertisement, 31536000000L, 1209600000L);
                }
                catch (Exception nevermind) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block17;
                    LOG.log(Level.WARNING, "Failed to publish Impl adv within group.", nevermind);
                }
            }
        }
    }

    @Override
    protected synchronized void initLast() throws PeerGroupException {
        super.initLast();
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Group : " + this.getPeerGroupID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tCompatibility Statement :\n\t\t\t");
            StringBuilder indent = new StringBuilder(STD_COMPAT.toString().trim());
            int from = indent.length();
            while (from > 0) {
                int returnAt = indent.lastIndexOf("\n", from);
                from = returnAt - 1;
                if (returnAt < 0 || returnAt == indent.length()) continue;
                indent.insert(returnAt + 1, "\t\t\t");
            }
            configInfo.append((CharSequence)indent);
            Iterator<Map.Entry<ModuleClassID, Object>> eachProto = this.messageTransports.entrySet().iterator();
            if (eachProto.hasNext()) {
                configInfo.append("\n\t\tMessage Transports :");
            }
            while (eachProto.hasNext()) {
                Map.Entry<ModuleClassID, Object> anEntry = eachProto.next();
                ModuleClassID aMCID = anEntry.getKey();
                Module anMT = (Module)anEntry.getValue();
                configInfo.append("\n\t\t\t").append(aMCID).append("\t").append(anMT instanceof MessageTransport ? ((MessageTransport)((Object)anMT)).getProtocolName() : anMT.getClass().getName());
            }
            Iterator<Map.Entry<ModuleClassID, Object>> eachApp = this.applications.entrySet().iterator();
            if (eachApp.hasNext()) {
                configInfo.append("\n\t\tApplications :");
            }
            while (eachApp.hasNext()) {
                Map.Entry<ModuleClassID, Object> anEntry = eachApp.next();
                ModuleClassID aMCID = anEntry.getKey();
                Object anApp = anEntry.getValue();
                if (anApp instanceof ModuleImplAdvertisement) {
                    ModuleImplAdvertisement adv = (ModuleImplAdvertisement)anApp;
                    configInfo.append("\n\t\t\t").append(aMCID).append("\t").append(adv.getCode());
                    continue;
                }
                configInfo.append("\n\t\t\t").append(aMCID).append("\t").append(anApp.getClass().getName());
            }
            LOG.config(configInfo.toString());
        }
    }

    @Override
    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() {
        JxtaLoader loader = StdPeerGroup.getJxtaLoader();
        ModuleImplAdvertisement implAdv = loader.findModuleImplAdvertisement(PeerGroup.allPurposePeerGroupSpecID);
        return implAdv;
    }

    public Cm getCacheManager() {
        return this.cm;
    }

    public Map<ModuleClassID, Object> getApplications() {
        return Collections.unmodifiableMap(this.applications);
    }

    static {
        block3: {
            LOG = Logger.getLogger(StdPeerGroup.class.getName());
            STD_COMPAT = StdPeerGroup.mkCS();
            try {
                Enumeration<URL> allProviderLists = GenericPeerGroup.class.getClassLoader().getResources("META-INF/services/net.jxta.platform.Module");
                for (URL providers : Collections.list(allProviderLists)) {
                    StdPeerGroup.registerFromFile(providers);
                }
            }
            catch (IOException ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block3;
                LOG.log(Level.WARNING, "Failed to locate provider lists", ex);
            }
        }
        StdPeerGroup.getJxtaLoader().defineClass(StdPeerGroup.getDefaultModuleImplAdvertisement());
    }
}

