/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.exception.PeerGroupException;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.PSEPeerSecurityEngine;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.logging.Logging;

public abstract class PSESecurityEngineFactory {
    private static PSESecurityEngineFactory defaultSecurityEngine = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPSESecurityEngineManager(PSESecurityEngineFactory newSecurityEngine) {
        Class<PSESecurityEngineFactory> clazz = PSESecurityEngineFactory.class;
        synchronized (PSESecurityEngineFactory.class) {
            defaultSecurityEngine = newSecurityEngine;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PSESecurityEngineFactory getDefault() {
        Class<PSESecurityEngineFactory> clazz = PSESecurityEngineFactory.class;
        synchronized (PSESecurityEngineFactory.class) {
            if (defaultSecurityEngine == null) {
                defaultSecurityEngine = new PSESecurityEngineDefaultFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultSecurityEngine;
        }
    }

    public abstract PSEPeerSecurityEngine getInstance(PSEMembershipService var1, PSEConfigAdv var2) throws PeerGroupException;

    private static class PSEPeerSecurityEngineDefault
    implements PSEPeerSecurityEngine {
        private static final Logger LOG = Logger.getLogger(PSEPeerSecurityEngineDefault.class.getName());

        private PSEPeerSecurityEngineDefault() {
        }

        public byte[] sign(String algorithm, PSECredential credential, InputStream bis) throws InvalidKeyException, SignatureException, IOException {
            if (null == algorithm) {
                algorithm = this.getSignatureAlgorithm();
            }
            return PSEUtils.computeSignature(algorithm, credential.getPrivateKey(), bis);
        }

        public boolean verify(String algorithm, PSECredential credential, byte[] signature, InputStream bis) throws InvalidKeyException, SignatureException, IOException {
            if (null == algorithm) {
                algorithm = this.getSignatureAlgorithm();
            }
            return PSEUtils.verifySignature(algorithm, credential.getCertificate(), signature, bis);
        }

        public PSEUtils.IssuerInfo generateCertificate(PSECredential credential) throws SecurityException {
            PSEUtils.IssuerInfo info = new PSEUtils.IssuerInfo();
            info.cert = credential.getCertificate();
            info.subjectPkey = credential.getPrivateKey();
            String cname = PSEUtils.getCertSubjectCName(info.cert);
            if (null != cname && cname.endsWith("-CA")) {
                cname = cname.substring(0, cname.length() - 3);
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Generating new service cert for '" + cname + "'");
            }
            PSEUtils.IssuerInfo serviceinfo = PSEUtils.genCert(cname, info);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Generated new service cert for '" + cname + "'");
            }
            return serviceinfo;
        }

        public String getSignatureAlgorithm() {
            return "SHA1withRSA";
        }
    }

    private static class PSESecurityEngineDefaultFactory
    extends PSESecurityEngineFactory {
        private PSESecurityEngineDefaultFactory() {
        }

        public PSEPeerSecurityEngine getInstance(PSEMembershipService service, PSEConfigAdv config) throws PeerGroupException {
            return new PSEPeerSecurityEngineDefault();
        }
    }
}

