/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.id.ID;
import net.jxta.logging.Logging;

public class EndpointAddress {
    private static final Logger LOG = Logger.getLogger(EndpointAddress.class.getName());
    private static final boolean IDS_USE_JXTA_URL_FORM = true;
    private static final String JXTA_ID_PROTOCOL = "urn:jxta";
    private boolean hierarchical = true;
    private String protocol = null;
    private String protocolAddress = null;
    private String service = null;
    private String serviceParam = null;
    private transient int cachedHashCode = 0;
    private transient SoftReference<String> cachedToString = null;

    @Deprecated
    public static EndpointAddress unmodifiableEndpointAddress(EndpointAddress address) {
        return address;
    }

    public EndpointAddress(String address) {
        this.parseURI(address);
    }

    public EndpointAddress(URI address) {
        this(address.toString());
    }

    public EndpointAddress(EndpointAddress base, String service, String serviceParam) {
        this.setProtocolName(base.getProtocolName());
        this.setProtocolAddress(base.getProtocolAddress());
        this.setServiceName(service);
        this.setServiceParameter(serviceParam);
    }

    public EndpointAddress(String protocol, String address, String service, String serviceParam) {
        this.setProtocolName(protocol);
        this.setProtocolAddress(address);
        this.setServiceName(service);
        this.setServiceParameter(serviceParam);
    }

    public EndpointAddress(ID id, String service, String serviceParam) {
        this.setProtocolName(JXTA_ID_PROTOCOL);
        this.setProtocolAddress(id.getUniqueValue().toString());
        this.setServiceName(service);
        this.setServiceParameter(serviceParam);
    }

    @Deprecated
    public EndpointAddress clone() {
        return this;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof EndpointAddress) {
            EndpointAddress likeMe = (EndpointAddress)target;
            boolean result = this.hierarchical == likeMe.hierarchical && this.protocol.equalsIgnoreCase(likeMe.protocol) && this.protocolAddress.equalsIgnoreCase(likeMe.protocolAddress) && (this.service != null ? likeMe.service != null && this.service.equals(likeMe.service) : likeMe.service == null) && (this.serviceParam != null ? likeMe.serviceParam != null && this.serviceParam.equals(likeMe.serviceParam) : likeMe.serviceParam == null);
            return result;
        }
        return false;
    }

    public int hashCode() {
        if (0 == this.cachedHashCode) {
            int calcedHashCode = this.protocol.toLowerCase().hashCode();
            calcedHashCode += this.protocolAddress.hashCode() * 5741;
            calcedHashCode += (this.service != null ? this.service.hashCode() : 1) * 7177;
            this.cachedHashCode = 0 == (calcedHashCode += (this.serviceParam != null ? this.serviceParam.hashCode() : 1) * 6733) ? 1 : calcedHashCode;
        }
        return this.cachedHashCode;
    }

    public synchronized String toString() {
        String result;
        if (null != this.cachedToString && null != (result = this.cachedToString.get())) {
            return result;
        }
        StringBuilder newResult = new StringBuilder(this.protocol.length() + this.protocolAddress.length() + 64);
        newResult.append(this.protocol);
        if (this.hierarchical) {
            newResult.append("://");
        } else {
            newResult.append(':');
        }
        newResult.append(this.protocolAddress);
        if (null != this.service) {
            if (this.hierarchical) {
                newResult.append('/');
            } else {
                newResult.append('#');
            }
            newResult.append(this.service);
            if (null != this.serviceParam) {
                newResult.append('/');
                newResult.append(this.serviceParam);
            }
        }
        result = newResult.toString();
        this.cachedToString = new SoftReference<String>(result);
        return result;
    }

    public URI toURI() {
        return URI.create(this.toString());
    }

    public String getProtocolName() {
        return this.protocol;
    }

    public String getProtocolAddress() {
        return this.protocolAddress;
    }

    public String getServiceName() {
        return this.service;
    }

    public String getServiceParameter() {
        return this.serviceParam;
    }

    private void setProtocolName(String name) {
        int colonAt;
        if (null == name || 0 == name.length()) {
            throw new IllegalArgumentException("name must be non-null and contain at least one character");
        }
        if (-1 != name.indexOf("/")) {
            throw new IllegalArgumentException("name may not contain '/' character");
        }
        if (JXTA_ID_PROTOCOL.equals(name)) {
            name = "jxta";
        }
        if (-1 == (colonAt = name.indexOf(58))) {
            this.hierarchical = true;
        } else {
            if (!"urn".equalsIgnoreCase(name.substring(0, colonAt))) {
                throw new IllegalArgumentException("Only urn may contain colon");
            }
            if (colonAt == name.length() - 1) {
                throw new IllegalArgumentException("empty urn namespace!");
            }
            this.hierarchical = false;
        }
        this.protocol = name;
        this.cachedToString = null;
    }

    private void setProtocolAddress(String address) {
        if (null == address || 0 == address.length()) {
            throw new IllegalArgumentException("address must be non-null and contain at least one character");
        }
        if (-1 != address.indexOf("/")) {
            throw new IllegalArgumentException("address may not contain '/' character");
        }
        this.protocolAddress = address;
        this.cachedToString = null;
    }

    private void setServiceName(String name) {
        if (null != name && -1 != name.indexOf("/")) {
            throw new IllegalArgumentException("service name may not contain '/' character");
        }
        this.service = name;
        this.cachedToString = null;
    }

    private void setServiceParameter(String param) {
        this.serviceParam = param;
        this.cachedToString = null;
    }

    private void parseURI(String addr) {
        int index = addr.indexOf("://");
        if (index == -1) {
            this.parseURN(addr);
        } else {
            this.parseURL(addr);
        }
    }

    private void parseURN(String addr) {
        int protocolEnd = addr.indexOf(58);
        if (-1 == protocolEnd) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Address is not a valid URI: " + addr);
            }
            throw new IllegalArgumentException("Address is not a valid URI: " + addr);
        }
        if (!"urn".equalsIgnoreCase(addr.substring(0, protocolEnd))) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Address is unrecognized URI form: " + addr);
            }
            throw new IllegalArgumentException("Address is unrecognized URI form: " + addr);
        }
        if (addr.length() - 1 == protocolEnd) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Address URN does not have a namespace: " + addr);
            }
            throw new IllegalArgumentException("Address URN does not have a namespace: " + addr);
        }
        int namespaceEnd = addr.indexOf(58, protocolEnd + 1);
        if (-1 == namespaceEnd) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Address URN does not have a namespace: " + addr);
            }
            throw new IllegalArgumentException("Address URN does not have a namespace: " + addr);
        }
        this.setProtocolName(addr.substring(0, namespaceEnd));
        if (addr.length() - 1 == namespaceEnd) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Address URN does not have a NSS portion: " + addr);
            }
            throw new IllegalArgumentException("Address URN does not have a NSS portion: " + addr);
        }
        int nssEnd = addr.indexOf(35, namespaceEnd + 1);
        if (-1 == nssEnd) {
            this.setProtocolAddress(addr.substring(namespaceEnd + 1));
        } else {
            this.setProtocolAddress(addr.substring(namespaceEnd + 1, nssEnd));
            int serviceEnd = addr.indexOf(47, nssEnd + 1);
            if (-1 == serviceEnd) {
                this.setServiceName(addr.substring(nssEnd + 1));
            } else {
                this.setServiceName(addr.substring(nssEnd + 1, serviceEnd));
                this.setServiceParameter(addr.substring(serviceEnd + 1));
            }
        }
    }

    private void parseURL(String addr) {
        String remainder;
        int index = addr.indexOf("://");
        if (index == -1) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Address is not in absolute form: " + addr);
            }
            throw new IllegalArgumentException("Address is not in absolute form: " + addr);
        }
        if (0 == index) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Protocol is missing: " + addr);
            }
            throw new IllegalArgumentException("Protocol is missing: " + addr);
        }
        try {
            this.setProtocolName(addr.substring(0, index));
            remainder = addr.substring(index + 3);
        }
        catch (Exception e) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Protocol address is missing: " + addr);
            }
            throw new IllegalArgumentException("Protocol address is missing: " + addr);
        }
        index = remainder.indexOf("/");
        if (index == -1) {
            this.setProtocolAddress(remainder);
            return;
        }
        this.setProtocolAddress(remainder.substring(0, index));
        remainder = remainder.substring(index + 1);
        index = remainder.indexOf("/");
        if (index == -1) {
            this.setServiceName(remainder);
            return;
        }
        this.setServiceName(remainder.substring(0, index));
        remainder = remainder.substring(index + 1);
        this.setServiceParameter(remainder);
    }
}

