program menuExport;
        uses crt,dos,gentypes,configrt,skashit;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
{$I ANSIS.SKA}
var
 mInFile   : file;
 mOutFile  : text;
 mMenuData : menuRec;
 mCommandz : commandRec;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure mAddFile(fileName : string);
var mTotalCommands : word;
    mCount         : word;
 begin
 assign(mInFile,cfg.menuDir+fileName);
 reset(mInFile,1);
 blockRead(mInFile,mMenuData,sizeOf(mMenuData));
 writeLn(mOutFile);
 writeLn(mOutFile,'***************************************************************************');
 writeLn(mOutFile,'<< Start of menu exportation for '+mMenuData.title+' ..');
 writeLn(mOutFile,'***************************************************************************');
 writeLn(mOutFile,'.---------------------------------------------------------.');
 writeLn(mOutFile,' :: Menu Filename - '+fileName);
 writeLn(mOutFile,' :: Menu Title    - '+mMenuData.title);
 writeLn(mOutFile,' :: Menu Ansi     - '+mMenuData.helpMenu);
 writeLn(mOutFile,' :: Pullbar Menu  - ',mMenuData.usePullBar);
 writeLn(mOutFile,'.---------------------------------------------------------.');
 writeLn(mOutFile);
 mTotalCommands := ((fileSize(mInFile)-sizeOf(mMenuData)) div sizeOf(mCommandz));
 for mCount := 1 to mTotalCommands do
  begin
  blockRead(mInFile,mCommandz,sizeOf(mCommandz));
  writeLn(mOutFile,'|---------------------------------------------------------|');
  writeLn(mOutFile,' -- Pullbar IDNum   - ',mCommandz.IDNumber);
  writeLn(mOutFile,' -- Command Number  - ',mCount);
  writeLn(mOutFile,' -- Command Title   - '+mCommandz.descrip);
  writeLn(mOutFile,' -- Command Key(s)  - '+mCommandz.keys);
  writeLn(mOutFile,' -- Menu Command(s) - '+mCommandz.command);
  writeLn(mOutFile,' -- Command X/Y Pos - ',mCommandz.barX,' / ',mCommandz.barY);
  writeLn(mOutFile,'|---------------------------------------------------------|');
  end;
 writeLn(mOutFile,'***************************************************************************');
 writeLn(mOutFile,'<< End of menu exportation for '+mMenuData.title+' ..');
 writeLn(mOutFile,'***************************************************************************');
 close(mInFile);
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure mFileLoader;
var mFileInfo : searchRec;
 begin
 findFirst(cfg.menuDir+'*.MNU',archive,mFileInfo);
 while (dosError=0) do
  begin
  mAddFile(mFileInfo.name);
  findNext(mFileInfo);
  end;
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure mInitFiles(init : boolean);
 begin
 if (init=true) then
  begin
  readCfg(false);
  fillChar(mMenuData,sizeOf(mMenuData),0);
  fillChar(mCommandz,sizeOf(mCommandz),0);
  assign(mOutFile,paramStr(1));
  rewrite(mOutFile);
  writeLn(mOutFile,'<< Infusion Bulletin Board Software, (c) Copyright Grant Passmore (skaboy101) 1997-98');
  writeLn(mOutFile,'<< External menu exporter released with version '+versionNum);
  writeLn(mOutFile);
  end else
   begin
   writeLn(mOutFile);
   writeLn(mOutFile,'<< End of file');
   close(mOutFile);
   end;
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure show(s : string);
 begin
 gotoxy(3,wherey);
 skawrite('|07.,:$%'' |07'+S);
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
begin
 clrScr;
 move(header12,mem[$b800:0],sizeOf(header12));
 gotoXY(8,9); skaWrite('|07infusion bbs software menu exporter, (c)copyright skaboy101 1998|CR|CR');
  if (paramCount<>1) then
   begin
   show('error, usage is '+paramStr(0)+' <export_to_file>|CR');
   halt(5);
   end;
 mInitFiles(true);
 mFileLoader;
 mInitFiles(false);
 show('infusion menus succesfully exported to '+paramstr(1)+'..|CR');
end.