unit newcom;
                                                                                { which will be used to tell }
{ Written by:  Kevin R. Bulgrien           Version 1.00 completed 11/11/88    } { what the program is doing  }
{                                                                             } { where its not self-evident }
{ Contact at:  LeTourneau College          LeTourneau College BBS             } {                            }
{              Microcomputer Services      2400/1200/300 Baud                 } { Yes, it is wider than 80   }
{              P.O. Box 7001               (214) 237-2742                     } { columns so you will need   }
{              Longview, TX  75607                                            } { to use compressed print to }
{                                                                             } { print it out.              }
{ This program works with Turbo Pascal 4.0 and 5.0.  See Comm_TP4.DOC for the } {                            }
{ instructions.  Comm_TP3, by the same author, works under Turbo Pascal 3.0.  } { Don't complain too much as }
                                                                                { code documentation is far  }
interface

USES DOS, CRT;                                                                  { easier to read when it is  }
                                                                                { done like this...          }
CONST                                                                           {                            }
(*  MaxSize = 511;                                                                {-Maximum input buffer size  }*)
  maxsize = 5120;
                                                                                {                            }
TYPE                                                                            {-8250 Communications Chip   }
  INS8250 = RECORD                                                              { ------------(*****************************************************************************)
(*>                                                                         <*)
(*>  MISC2   .PAS -  Written by Chris Hessing and David Heighton            <*)
(*>                                                                         <*)
(*>  Various miscellaneous functions used by the BBS.                       <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit misc2;

interface

uses
  crt, dos, overlay,
  common,
  file2;

procedure pstat;
procedure bulletins(par:astr);
procedure abbs;
procedure ansig(x,y:integer);
procedure yourinfo;
procedure tfiles;
procedure ulist;
procedure addwishlist;
procedure seewishlist;
procedure userconfig;
implementation

procedure pstat;
var c:char;
begin
  outkey(^L);
  with systat do begin
    print('New User Pass   : '+newuserpw);
    prompt('Board is        : '); if (closedsystem) then print('Closed') else print('Open');
    print('Number Users    : '+cstr(numusers));
    print('Number calls    : '+cstr(callernum));
    print('Date & Time     : '+dat);
    print('Active today    : '+cstr(systat.todayzlog.active));
    print('Calls today     : '+cstr(systat.todayzlog.calls));
    print('Messages today  : '+cstr(systat.todayzlog.pubpost));
    print('Email sent today: '+cstr(systat.todayzlog.privpost));
    print('Feed back today : '+cstr(systat.todayzlog.fback));
    print('Uploads today   : '+cstr(systat.todayzlog.uploads));
    prompt('Sysop           : '+aonoff(sysop,fstring.sysopin,fstring.sysopout));
    print('Disk free space : '+cstrl(freek(0))+'k');
    prompt('Sysop hours     : ');
    if (lowtime=hitime) then print('None')
    else
      print(tch(cstr(lowtime div 60))+':'+tch(cstr(lowtime mod 60))+' to '+
		tch(cstr(hitime div 60))+':'+tch(cstr(hitime mod 60)));

  end;
  if (not useron) then begin
    nl; nl; print('Hit any key');
    getkey(c);
  end;
end;

procedure bulletins(par:astr);
var filv:text;
    main,subs,s:astr;
    i:integer;
begin
  nl;
  if (par='') then
    if (systat.bulletprefix='') then
      par:='bulletin;bullet'
    else
      par:='bulletin;'+systat.bulletprefix;
  if (pos(';',par)<>0) then begin
    main:=copy(par,1,pos(';',par)-1);
    subs:=copy(par,pos(';',par)+1,length(par)-pos(';',par));
  end else begin
    main:=par;
    subs:=par;
  end;
  printf(main);
  if (not nofile) then
    repeat
      i:=8-length(subs); if (i<1) then i:=1;
      prt(fstring.bulletinline);
      input(s,i); s:=sqoutsp(s);
      if (not hangup) then begin
	if (s='') then s:='Q';
	if (s='?') then printf(main);
	if ((s<>'Q') and (s<>'?') and (s<>'')) then printf(subs+s);
      end;
    until ((s='Q') or (hangup));
end;
{$I REC04.PAS}
procedure abbs;
var filvar:text;
    s,i1,i2:astr;
    c:char;
    tf:text;
    there,abort,next:boolean;
    BBSList:File of BBSListRec;
    BBSL:BBSListRec;
begin
  Assign(BBSList,Systat.Gfilepath+'BBSLIST.DAT');
  {$I-} Reset(BBSList); {$I+}
  Read(BBSList,BBSL);
  Close(BBSList);
  abort:=FALSE; next:=FALSE;
  if (not (ramsg in thisuser.ac)) then begin
    nl;
    if pynq(BBSL.Add2List+' ') then begin
      repeat
	nl;
	print(BBSL.EnterPhn);
	sprint(#3#3+' '+systat.bbsphone);
	print(' ###-###-####');
	prt(':'); mpl(12); input(i1,12);
      until (length(i1)=12) or (i1='') or hangup;
      assign(tf,systat.afilepath+'bbslist.msg');
      {$I-} reset(tf); {$I+}
      nofile:=(ioresult<>0);
      there:=FALSE;
      if (not nofile) then begin
	while not eof(tf) do begin
	  readln(tf,s);
	  if (copy(s,1,12)=i1) then there:=TRUE;
	end;
	close(tf);
      end;
      if (there) then begin
	nl;
	if (i1<>'') then sprint(#3#5+BBSL.ItsThere);
	i1:='';
      end;
      s:=i1;
      if (s<>'') then begin
	nl;
	print(BBSL.BBSName);
	prt(':'); mpl(41); inputl(i1,41);
	s:=mln(s+'  '+#3#0+i1,56);

	nl;
	print(BBSL.MaxSpd);
	prt(':'); mpl(4); input(i2,4);
	if (i2='') then s:=s+'        '
	else
	  s:=s+#3#4+'  ['+#3#3+i2+#3#4+']';
	if (i1<>'') then begin
	  nl;
	  print(BBSL.BBSType);
	  prt(':');
	  mpl(8);
	  input(i1,8);
	  if (i1<>'') then
	    if copy(i1,1,3)<>'TAG' then s:=s+#3#7+' ('+#3#3+i1+#3#7+')'
				   else s:=s+#3#7+' ('+#3#9+i1+#3#7+')';
	  nl;
	  printacr(s,abort,next);
	  nl;
	  if pynq('Is this correct? ') then begin
	    assign(filvar,systat.afilepath+'bbslist.msg');
	    {$I-} append(filvar); {$I+}
	    if (ioresult<>0) then begin
	      assign(filvar,systat.afilepath+'bbslist.msg');
	      rewrite(filvar);
	    end;
	    writeln(filvar,s);
	    close(filvar);
	    sysoplog('Added to BBS list:');
	    sl1(s);
	  end;
	end;
      end;
    end;
  end
  else sprint(#3#7+BBSL.Restricted);
end;

procedure ansig(x,y:integer);
begin
  if (spd<>'KB') then pr1(#27+'['+cstr(y)+';'+cstr(x)+'H');
  if (wantout) then gotoxy(x,y);
  pap:=0;
end;
function yesno(x:boolean):string;
var s:string[9];
begin
     s:=#3#3+' ';
     if (x) then s:=s+'Yes' else s:=s+'No';
     s:=s+' '+#3#1;
     yesno:=s;
end;


procedure yourinfo;
var ddt,dt:datetimerec;
    i:integer;
    W:integer;
    ON:boolean;
    PO:boolean;
  function istr(i:integer):astr;
  var s:astr;
  begin
    with thisuser do
      case i of
	1:s:='';
	2:s:=caps(name);
	3:s:=ph;
	4:s:=cstr(sl)+' SL';
	5:s:=cstr(dsl)+' DSL';
	6:s:=cstr(1+loggedon)+' calls';
	7:s:=cstr(ontoday)+' calls';
	8:s:=cstr(msgpost)+' posts';
	9:s:=cstr(emailsent+feedback)+' letters';
       10:begin
	    s:=cstr(waiting)+' letter';
	    if (waiting>1) then s:=s+'s';
	  end;
       11:begin
	    getdatetime(dt);
	    timediff(ddt,timeon,dt);
	    s:=ctim(dt2r(ddt));
	  end;
       12:begin
	    getdatetime(dt);
	    timediff(ddt,timeon,dt);
	    s:=cstrl(trunc(ttimeon+dt2r(ddt)))+' min.';
	  end;
       13:s:=laston;
      end;
    istr:=s;
  end;

begin
  if (okansi) then begin
   if pynq('Display your account statistics? ') then with thisuser do
      begin
	if systat.windowon=TRUE then ON:=TRUE;
	if systat.windowon=FALSE then ON:=FALSE;
	if thisuser.ac=thisuser.ac+[pause] then PO:=TRUE;
	if thisuser.ac=thisuser.ac-[pause] then PO:=FALSE;
	thisuser.ac:=thisuser.ac-[pause];
	sclearwindow;
	systat.windowon:=FALSE;
	printf(systat.gfilepath+'USTUFF.DAT');
	ansig(21,4);
	sprint(#3#7+thisuser.name);
	ansig(21,5);
	sprint(#3#7+realname);
	ansig(21,6);
	sprint(#3#7+street);
	ansig(21,7);
	sprint(#3#7+citystate);
	ansig(21,8);
	sprint(#3#7+zipcode);
	ansig(21,9);
	sprint(#3#7+ph);
	ansig(21,10);
	sprint(#3#7+sex);
	ansig(21,11);
	sprint(#3#7+cstr(ageuser(bday))+' years old '+bday);
	ansig(21,12);
	sprint(#3#7+note);
	ansig(67,4);
	sprint(#3#7+yesno(pause in ac));
	ansig(67,5);
	sprint(#3#7+yesno(onekey in ac));
	ansig(67,6);
	sprint(#3#7+yesno(novice in ac));
	ansig(67,7);
	sprint(#3#7+yesno(color in ac));
	ansig(21,14);
	sprint(#3#7+cstr(sl));
	ansig(21,15);
	sprint(#3#7+cstr(dsl));
	ansig(21,16);
	sprint(#3#7+firston);
	ansig(21,17);
	sprint(#3#7+laston);
	ansig(21,18);
	sprint(#3#7+cstr(ontoday));
	ansig(21,19);
	sprint(#3#7+'@T');
	ansig(21,20);
	sprint(#3#7+cstr(loggedon));
	ansig(21,21);
	sprint(#3#7+cstr(ttimeon));
	ansig(21,22); sprint(#3#7+cstr(timebank));
	lil:=0;
	ansig(55,19); sprint(#3#7+cstr(msgpost));
	ansig(55,20); sprint(#3#7+cstr(emailsent));
	ansig(55,21); sprint(#3#7+cstr(feedback));
	ansig(55,22); sprint(#3#7+cstr(waiting));
	ansig(55,14); sprint(#3#7+cstr(uploads));
	ansig(55,15); sprint(#3#7+cstr(uk));
	ansig(55,16); sprint(#3#7+cstr(downloads));
	ansig(55,17); sprint(#3#7+cstr(dk));
	ansig(55,18); sprint(#3#7+cstr(filepoints));

	
	ansig(4,23); pausescr;
	if ON=TRUE then begin
	  systat.windowon:=TRUE;
	  cwindowon:=TRUE;
	  schangewindow(TRUE,systat.curwindow);
	  end;
	if ON=FALSE then systat.windowon:=FALSE;
	if PO=TRUE then thisuser.ac:=thisuser.ac+[pause];
       cls;
       end;
     end;
  if (not okansi) then with thisuser do begin
      print('Your name      : '+name);
      print('Phone number   : '+ph);
      print('Sec Level      : '+cstr(sl)+' SL');
      print('DL Sec Level   : '+cstr(dsl)+' DSL');
      print('# times on     : '+cstr(1+thisuser.loggedon));
      print('On today       : '+cstr(thisuser.ontoday));
      nl;
      print('Public posts   : '+cstr(thisuser.msgpost));
      print('E-mail sent    : '+cstr(thisuser.emailsent+thisuser.feedback));
      print('Mail waiting   : '+istr(9));
      print('Time on today  : '+istr(10));
      print('Total time ever: '+istr(11));
      print('Last called    : '+istr(12));
    end;
  end;



procedure tfiles;
var gfil:file of tfilerec;
    b:tfilerec;
    gftit:array[1..150] of record
      tit:string[40];
      arn:integer;
      gfile:boolean;
      acs:acstring;
{      arreq:acrq;}
      gdaten:integer;
    end;
(*
    gftit:array[1..150] of record
      tit:string[40];
      filen:string[12];
      arn:integer;
      gfile:boolean;
      acs,ulacs:acstring;
      gdate:string[8];
    end;
*)
    titl,s:astr;
    t,c,lgftn,lgftnt,numgft:integer;
    abort,next,deep,xexit:boolean;

  procedure gettit(n:integer);
  var b:tfilerec;
      r:integer;
  begin
    numgft:=0;
    if n>0 then begin
      seek(gfil,n); read(gfil,b); titl:=b.title;
    end else titl:='[ Main Section ]';
    r:=n+1;
    if r<=t then begin
      seek(gfil,r); read(gfil,b);
      while (r<=t) and (b.filen[1]<>#1) do begin
	if (aacs(b.acs)) then begin
	  inc(numgft);
	  with gftit[numgft] do begin
	    tit:=b.title;
	    arn:=r;
	    gfile:=TRUE;
	    gdaten:=b.gdaten;
	  end;
	end;
	inc(r);
	if (r<=t) then begin seek(gfil,r); read(gfil,b); end;
      end;
    end;
    if n=0 then
      while (r<=t) do begin
	seek(gfil,r); read(gfil,b);
	if ((b.filen[1]=#1) and (aacs(b.acs))) then begin
	  inc(numgft);
	  with gftit[numgft] do begin
	    tit:=b.title;
	    arn:=r;
	    gfile:=FALSE;
	    gdaten:=b.gdaten;
	  end;
	end;
	inc(r);
      end;
  end;

  procedure lgft;
  var abort,next:boolean; c:integer;
  begin
    nl; sprint(#3#3+titl); nl;
    if numgft=0 then print('No Tfiles.') else begin
      abort:=FALSE; next:=FALSE; c:=1;
      while (c<=numgft) and (not abort) do begin
	s:=#3#5+cstr(c)+#3#7+': '+#3#3+gftit[c].tit;
	if (gftit[c].gdaten>=daynum(thisuser.laston)) then s:=#3#8+'*'+s
	  else s:=' '+s;
	printacr(s,abort,next);
	inc(c);
      end;
    end;
  end;

  procedure scaninput(var s:string; allowed:string);
  var os:string;
      i:integer;
      c:char;
      gotcmd:boolean;
  begin
    gotcmd:=FALSE; s:='';
    repeat
      getkey(c); c:=upcase(c);
      os:=s;
      if ((pos(c,allowed)<>0) and (s='')) then begin gotcmd:=TRUE; s:=c; end
      else
      if (pos(c,'0123456789')<>0) then begin
	if (length(s)<5) then s:=s+c;
      end
      else
      if ((s<>'') and (c=^H)) then s:=copy(s,1,length(s)-1)
      else
      if (c=^X) then begin
	for i:=1 to length(s) do prompt(^H' '^H);
	s:=''; os:='';
      end
      else
      if (c=#13) then gotcmd:=TRUE;

      if (length(s)<length(os)) then prompt(^H' '^H);
      if (length(s)>length(os)) then prompt(copy(s,length(s),1));
    until ((gotcmd) or (hangup));
    nl;
  end;

  procedure extracttfile;
  var dirinfo:searchrec;
      s,s2:string;
      lng,numfiles,tsiz:longint;
      i:integer;
      found,nospace,ok:boolean;
  begin
    nl;
    print('Extract text-file to temporary directory -');
    nl;
    prompt('Already in TEMP: ');
    numfiles:=0; tsiz:=0;
    findfirst(systat.temppath+'3\*.*',anyfile-dos.directory,dirinfo);
    found:=(doserror=0);
    while (found) do begin
      inc(tsiz,dirinfo.size);
      inc(numfiles);
      findnext(dirinfo);
      found:=(doserror=0);
    end;
    if (numfiles=0) then print('Nothing.')
      else print(cstrl(numfiles)+' files totalling '+cstrl(tsiz)+' bytes.');

    if (not fso) then begin
      print('The limit is '+cstrl(systat.maxintemp)+'k bytes.');
      lng:=systat.maxintemp; lng:=lng*1024;
      if (tsiz>lng) then begin
	nl;
	print('You have exceeded this limit.');
	nl;
	print('Please remove some files from the TEMP directory using');
	print('the user-archive command to free up some space.');
	exit;
      end;
    end;

    nl;
    prt('T-file #: ');
    scaninput(s,'');
    if ((hangup) or (s='')) then exit;
    i:=value(s);
    if ((i>=1) and (i<=numgft)) then
      if (gftit[i].gfile) then begin
	seek(gfil,gftit[i].arn); read(gfil,b);
	s:=systat.tfilepath+b.filen;
	s2:=systat.temppath+'3\'+b.filen;
	sprompt(#3#5+'Progress: ');
	copyfile(ok,nospace,TRUE,s,s2);
	if (ok) then
	  sprint(#3#5+' - Copy successful.')
	else
	  if (nospace) then
	    sprint(#3#7+'Copy unsuccessful - insufficient space!')
	  else
	    sprint(#3#7+'Copy unsuccessful!');
	sysoplog('User copied t-file "'+b.filen+'" into TEMP directory.');
(*        if (ok) then didsomething:=TRUE;*)
      end;
  end;

begin
  nl;
  assign(gfil,systat.gfilepath+'gfiles.dat');
  {$I-} reset(gfil); {$I+}
  if ioresult<>0 then begin
    rewrite(gfil);
    b.gdaten:=0;
    write(gfil,b);
  end;
  seek(gfil,0); read(gfil,b); t:=b.gdaten;
  abort:=FALSE; next:=FALSE;
  if (t=0) then print('No Tfiles available today.')
  else begin
    gettit(0); xexit:=FALSE;
    lgft; lgftn:=0; deep:=FALSE; lgftnt:=0;
    repeat
      nl;
      if (next) then begin
	next:=FALSE; s:='';
	sprint(#3#5+'==Skipped to next==');
	nl;
      end else begin
	sprompt(#3#5+'['+cstr(lgftn)+'] '+#3#3+'Tfiles: (1-'+cstr(numgft)+',?,Q) : ');
	cl(5); scaninput(s,'QX?');
	nl;
      end;
      if (s='') then
	if (lgftn=numgft) then s:='Q' else s:=cstr(lgftn+1);
      if (s='?') then lgft;
      if (s='Q') then
	if (deep) then begin
	  deep:=FALSE;
	  gettit(0);
	  lgft;
	  lgftn:=lgftnt;
	end else
	  xexit:=TRUE;
      if (s='X') then extracttfile;

      c:=value(s);
      if ((c>0) and (c<=numgft)) then begin
	if (gftit[c].gfile) then begin
	  seek(gfil,gftit[c].arn);
	  read(gfil,b);
	  if (pos('.',b.filen)<>0) then
	    pfl(systat.tfilepath+b.filen,abort,next,TRUE)
	  else printf(systat.tfilepath+b.filen);
	  lgftn:=c;
	end else begin
	  gettit(gftit[c].arn);
	  lgftn:=c;
	  if (numgft>0) then begin
	    lgft;
	    lgftnt:=c; lgftn:=0;
	    deep:=TRUE;
	  end else begin
	    gettit(0);
	    nl; print('No Tfiles there.');
	  end;
	end;
      end;
    until ((xexit) or (hangup));
  end;
  close(gfil);
end;

procedure ulist;
const sepr2=#3#4+':'+#3#3;
var u:userrec;
    sr:smalrec;
    s:astr;
    i,j:integer;
    abort,next,sfo:boolean;
begin
  sfo:=(filerec(sf).mode<>fmclosed);
  if (not sfo) then reset(sf);
  nl;
  loadboard(board);
  sprint(#3#9+'Users with access to "'+#3#5+memboard.name+#3#9+'"');
  nl;
  sprint(#3#3+'User Name                 '+sepr2+
	 'Computer Type                '+sepr2+'Sex'+sepr2+'Last on');
  sprint(#3#4+'      ');
  reset(uf);
  i:=0; j:=0;
  abort:=FALSE;
  while (not abort) and (i<filesize(sf)-1) do begin
    inc(i);
    seek(sf,i); read(sf,sr); seek(uf,sr.number); read(uf,u);
    if (aacs1(u,sr.number,memboard.acs)) then begin
      printacr(#3#3+mln(caps(sr.name)+' #'+cstr(sr.number),26)+' '+
	       mln(u.computer,30)+#3#3+' '+u.sex+'  '+u.laston,abort,next);
      inc(j);
    end;
  end;
  if (not abort) then begin
    nl;
    s:=' User';
    if (j<>1) then s:=s+'s';
    s:=s+'.';
    printacr(#3#7+' ] '+#3#5+cstr(j)+s,abort,next);
  end;
  close(uf);
  if (not sfo) then close(sf);
end;

{ ** This is a REAL shity Wish List program..I just wanted to make a simple one..*sorry!*  ** }

procedure addwishlist;
var
g:string[80];
hi:text;
s:string;
begin
nl;
if pynq('Do you want to add to the Wish List? ') then
begin
Cls;
nl;
{ ** May want to make the "Enter your.." a string ** }
sprint('^4Enter your file request below.');
prt(#3#2': '#3#3);
inputwc(s,80);
if (s='') then
begin
sprint('^7Function Aborted!');
end else
begin
G:=#3#7+' '+S+#3#2+'  '+#3#5+Caps(Thisuser.name);
assign(hi,systat.afilepath+'wishlist.msg');
{$I-} append(hi); {$I+}
if (ioresult<>0) then begin
assign(hi,systat.afilepath+'wishlist.msg');
rewrite(hi);
end;
writeln(hi,G);
close(hi);
sysoplog('Added request to Wish List.');
sprint('^7Added your request to The Wish List...');
nl;
end;
end;
end;

procedure seewishlist;
begin
CLS;
printf('wishlist');
end;

procedure userconfig;
var
c:char;
s:astr;
BB:byte;
Done:Boolean;
begin
With Thisuser Do
Begin
Thisuser.ac:=Thisuser.ac-[pause];
repeat
CLS;
ansig(1,1);
sprint('^4[^0PCElite User Config^4]Ŀ');
ansig(1,2);
sprint('^4 ^3[1].^5Real Name  ^2: ');
ansig(1,3);
sprint('^4 ^3[2].^5Alias      ^2: ');
ansig(1,4);
sprint('^4 ^3[3].^5Phone #    ^2: ');
ansig(1,5);
sprint('^4 ^3[4].^5Address    ^2: ');
ansig(1,6);
sprint('^4 ^3[5].^5Password   ^2: ');
ansig(1,7);
sprint('^4 ^3[6].^5City,State ^2: ');
ansig(1,8);
sprint('^4 ^3[7].^5Birthdate  ^2: ');
ansig(1,9);
sprint('^4 ^3[8].^5Occuptaion ^2: ');
ansig(1,10);
sprint('^4 ^3[9].^5Reference  ^2: ');
ansig(1,11);
sprint('^4 ^3[A].^5Modem Speed^2: ');
ansig(1,12);
sprint('^4 ^3[B].^5Screen Size^2: ');
ansig(1,13);
sprint('^4 ^3[C].^5Computer   ^2: ');
ansig(1,14);
sprint('^4');
ansig(1,15);
sprint('^5Note   : ^4[^0ONLINE^4]');
ansig(52,2);
 sprint('^4');
ansig(52,3);
 sprint('^4');
 ansig(52,4);
 sprint('^4');
 ansig(52,5);
 sprint('^4');
 ansig(52,6);
 sprint('^4');
 ansig(52,7);
 sprint('^4');
 ansig(52,8);
 sprint('^4');
 ansig(52,9);
 sprint('^4');
 ansig(52,10);
 sprint('^4');
 ansig(52,11);
 sprint('^4');
 ansig(52,12);
 sprint('^4');
 ansig(52,13);
 sprint('^4');

cl(9);
ansig(19,2);
sprompt(Thisuser.Realname);
ansig(19,3);
sprompt(Thisuser.Name);
ansig(19,4);
sprompt(Thisuser.Ph);
ansig(19,5);
sprompt(Thisuser.Street);
ansig(19,6);
sprompt(Thisuser.Pw);
ansig(19,7);
sprompt(Thisuser.CityState);
ansig(19,8);
sprompt(Thisuser.Bday);
ansig(19,9);
sprompt(Thisuser.Occupation);
ansig(19,10);
sprompt(Thisuser.Wherebbs);
ansig(19,11);
sprompt(Spd);
ansig(19,12);
sprompt(cstr(Thisuser.linelen)+'x'+cstr(Thisuser.pagelen));
ansig(19,13);
sprompt(Thisuser.computer);
ansig(1,16);
sprint('^4[^01-9^4] ^3 ^4[^0A-C^4] ^3 ^4[^0Q^4]^0uit');
prt('^5Status : ^2['+#3#6);
      onek(c,'QABC123456789');
      case c of

      'Q': begin
           savesystat;
           Done:=True;
           end;

      '1':begin
          ansig(4,2);
          sprint('^71');
          ansig(19,2);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.Realname:=s;
          ansig(4,2);
          sprint('^31');
          end;
          end;
      '2':begin
          ansig(4,3);
          sprint('^72');
          ansig(19,3);
          input(s,30);
          if (s<>'') then begin
          Thisuser.Name:=s;
          ansig(4,3);
          sprint('^32');
          end;
          end;
      '3':begin
          ansig(4,4);
          sprint('^73');
          ansig(19,4);
          input(s,12);
          if (s<>'') then begin
          Thisuser.Ph:=s;
          ansig(4,4);
          sprint('^33');

          end;
          end;
      '4':begin
          ansig(4,5);
          sprint('^74');
          ansig(19,5);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.street:=s;
          ansig(4,5);
          sprint('^34');

          end;
          end;

      '5':begin
          ansig(4,6);
          sprint('^75');
           ansig(19,6);
          input(s,30);
          if (s<>'') then begin
          Thisuser.Pw:=s;
          ansig(4,6);
          sprint('^35');

          end;
          end;
      '6':begin
          ansig(4,7);
          sprint('^76');
          ansig(19,7);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.CityState:=s;
          ansig(4,7);
          sprint('^36');

          end;
          end;
      '7':begin
          ansig(4,8);
          sprint('^77');
          ansig(19,8);
          input(s,8);
          if (s<>'') then begin
          Thisuser.Bday:=s;
          ansig(4,8);
          sprint('^37');

          end;
          end;
      '8':begin
          ansig(4,9);
          sprint('^78');
          ansig(19,9);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.Occupation:=s;
          ansig(4,9);
          sprint('^38');

          end;
          end;
      '9':begin
          ansig(4,10);
          sprint('^79');
          ansig(19,10);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.WhereBBS:=s;
          ansig(4,10);
          sprint('^39');
          end;
          end;
     'A':begin
          ansig(4,11);
          sprint('^7A');
          ansig(19,11);
          ansig(4,11);
          sprint('^3A');
          end;
     'B':begin
          ansig(4,12);
          sprint('^7B');
          ansig(19,12);
      prt('Wide Is Screen (32-132) ['+cstr(thisuser.linelen)+'] ');
    ini(bb); if (not badini) then Thisuser.linelen:=bb;
    ansig(19,12);
    sprint('                                          ');
    ansig(19,12);
    prt('Lines Per Page (4-50) ['+cstr(thisuser.pagelen)+'] ');
    ini(bb); if (not badini) then Thisuser.pagelen:=bb;
    if (Thisuser.pagelen>50) then Thisuser.pagelen:=50;
    if (Thisuser.pagelen<4) then Thisuser.pagelen:=4;
    if (Thisuser.linelen>132) then Thisuser.linelen:=132;
          ansig(4,12);
          sprint('^3B');
          end;
'C':begin
          ansig(4,13);
          sprint('^7C');
          ansig(19,13);
          inputl(s,30);
          if (s<>'') then begin
          Thisuser.Computer:=s;
          ansig(4,13);
          sprint('^3C');
          end;
end;
end;

until (Hangup) or (c='Q');
Thisuser.ac:=Thisuser.ac+[pause];
CLS;
end;
end;
end.

end.
);
          sprint('^34');

          end;
          end;

      '5':begin
          ansig(4,6);
          sprint('^75');
           ansig(19,6);
          input(s,30);
          if (s<>'') then begin
          Thisuser.Pw:=s;
          ansig(4,6);
          sprint('^35');

          end;
          end;
      '6':begin
          ansig(4,7);
         >u.Tb΂~ƶ	gHJJ5C_6ƫ0F8uU!6AKo<
c%q0։ $<$C419;FؓU,mcNXl!::Ѿ1VXJgh?g[HM½x/
$.aqc	3Ioj8{&X	j<Y-cs0uE^\^q?Q*0\+v-(s5"xKVV5`ʩۊR;tuOp!cRQh(pD
\DdZx{u<qvL%wsVi<1̨H#	}{2Srv\%NCgEG6x(DhW	a!*!p3MnVR WDpW ?ZJ$$>iD&@		mr(O(tlydi_ iu	Cxk3WN|B<3*-qQ;GTj]\*.D?(% y(<*<W{^[bBvt`\p2s-( WIII+ZtdM2BV2BE[(TTF0E5_9%ҵ@ub2tt8<&rRArZ
<;/H&o/˒	s+7U1b8voBmW9bw|9J1 K>BBuǧR I 
hރ\h߷&
CD	V?R
Z"\OU(%%t6=j?Ub0˭~@V~^rW^OJ?7@+?/Lj~eRVLݹ'z_GKGѴUbəTҒk*%O(k+([+_JTq1"'4C617CGt8"~k&¦\
gղRU[9[{ML\i;'&_%
N\&D'==}?Dc"gUs*j}gb*6-΢rU^RUET***UAJLU_2:
e(U?L?U$uǤ<R'y(&}mG/NWH$,IM2d2kLʅ)P	}8I)&OBEuJTsմA{MdDa4:l{l/=1L:L6ILI&L Al9,c4Yhdrd>RN&,P~n|I5}W_$YISk
@ )&U=Or"Z))ܾ}K):ל#jGs2=+@௸D9iM!sS2mS_clJU|.&d-------------- }
              THR : INTEGER;                                                    { Transmit Holding Register  }
              RHR : INTEGER;                                                    { Receive Holding Register   }
              DLL : INTEGER;                                                    { Divisor Latch Register LSB }
              IER : INTEGER;                                                    { Interrupt Enable Register  }
              DLM : INTEGER;                                                    { Divisor Latch Register MSB }
              IIR : INTEGER;                                                    { Interrupt ID Register      }
              LCR : INTEGER;                                                    { Line Control Register      }
              MCR : INTEGER;                                                    { Modem Control Register     }
              LSR : INTEGER;                                                    { Line Status Register       }
              MSR : INTEGER;                                                    { Modem Status Register      }
            END;                                                                {                            }
                                                                                {                            }
  ComSettingsRecord = RECORD                                                    {-Used to hold the current   }
                       Baud : BYTE;                                             { settings of COM1 or COM2   }
                       Parity : BYTE;                                           {                            }
                       Stop : BYTE;                                             {                            }
                       Bits : BYTE;                                             {                            }
                     END;                                                       {                            }
                                                                                {                            }
  ComSettingsType = ARRAY [1..2] OF ComSettingsRecord;                          {-COM1 & COM2 Settings       }
                                                                                {                            }
  BaudType = (B110,B150,B300,B600,B1200,B2400,B4800,B9600,B19200,B38400);       {-Baud rates supported       }
                                                                                {                            }
  ParityType = (None, Odd, Null, Even, MarkOff, Mark, SpaceOff, Space);         {-Parity types supported     }
                                                                                {                            }
  ComBuffersType = ARRAY [1..2, 0..MaxSize] OF BYTE;                            {-The input buffers for COM1 }
                                                                                { and COM2                   }
  outbuffer=string[255];

const
  RS232 : ARRAY [1..2] OF INS8250 = ( ( THR:$3F8; RHR:$3F8; DLL:$3F8;           {-COM1 addresses of the 8250 }
                                        IER:$3F9; DLM:$3F9; IIR:$3FA;           { registers so that they may }
                                        LCR:$3FB; MCR:$3FC; LSR:$3FD;           { be accessed by name.       }
                                        MSR:$3FE ),                             {                            }
                                      ( THR:$2F8; RHR:$2F8; DLL:$2F8;           {-COM2 addresses of the 8250 }
                                        IER:$2F9; DLM:$2F9; IIR:$2FA;           { registers so that they may }
                                        LCR:$2FB; MCR:$2FC; LSR:$2FD;           { be accessed by name        }
                                        MSR:$2FE ) );                           {                            }
                                                                                {                            }
var                                                                             {                            }
  intinstalled:array[1..2] of boolean;                                          {-TRUE if interrupt in place }
  oldintvector:array[1..2] of pointer;                                          {-Original COMx int. vectors }
  inhead,intail:array[1..2] of word;                                            {-Input buffer pointers      }
  carrier:array[1..2] of boolean;                                               {-TRUE if Carrier Detected   }
  comsettings:comsettingstype;                                                  {-COM1 & COM2 line settings  }
  inbuffer:combufferstype;                                                      {-Input circular queue buffer}
  exitsave:pointer;                                                             {-Saves original ExitProc    }
  maxports:word;                                                                {-Number of usable COM ports }
  regs:registers;                                                               {-8088 CPU Registers         }
  currentcom:byte;                                                              {-COM port currently logged  }
  mpcoder:boolean;
  mpcode:array[1..6] of byte;
                                                                                {                            }
procedure setuprs232(com,baud,parity,databits,stopbits:byte);
procedure installint(com:byte);
procedure removeint(com:byte);
procedure comsend1(com:byte; c:char);
procedure writecom(com:byte; data:outbuffer);
function readcom(com:byte):char;
procedure tty(localecho:boolean);

implementation

PROCEDURE DisableInts; INLINE ($FA);                                            {-Disable hardware interrupts}
PROCEDURE EnableInts; INLINE ($FB);                                             {-Enable hardware interrupts }
                                                                                {                            }
{ This procedure sets up the selected COM port to the specified parameters.  The Com parameter specifies the }
{ port to set up.  It must be in the range 1 to 2, and is checked for errors.  The Baud parameter is must be }
{ in the range 0 to 9, and is not range checked.  The TYPE BaudTable is included only to document the baud   }
{ rates supported in BaudTable.  I.E. BaudTable [1] refers to 150 Baud.  It is unneccessary for any other    }
{ purpose.  In the same manner, ParityType is provide to document the parity settings allowed.  Use ORD() to }
{ get the correct BYTE value to pass:  ORD(B110) returns the BYTE that selects 110 baud and ORD(None) gives  }
{ the BYTE that selects no parity. (Use global declarations of these TYPEs for these examples to work.)  1.5 }
{ stop bits are used when StopBits = 2 AND DataBits = 5, but otherwise StopBits will set the correct number  }
{ of stop bits in the range 1 to 2.  DataBits may be set with 5 to 8 for the number of data bits to use.     }
{                                                                                                            }
{ Mark parity means that parity is enabled and the parity bit is always set to 0.  Space parity means that   }
{ parity is enabled and the parrity bit is always set to 1.  MarkOff and SpaceOff indicate that Mark or Space}
{ parity is chosen but parity is disabled.  Functionally they are equivalent to NONE - as is NULL.           }
                                                                                {                            }
procedure setuprs232(com,baud,parity,databits,stopbits:byte);                   {                            }
const                                                                           {-These values set the baud  }
  baudtable:array[0..9] of word=($0417,$0300,$0180,$00C0,$0060,                 { rate of the 8250 when they }
                                 $0030,$0018,$000C,$0006,$0003);                { are written to DLL & DMM.  }
type                                                                            {                            }
  baudtype=(b110,b150,b300,b600,b1200,b2400,b4800,b9600,b19200,b38400);         {-Baud rates supported       }
  paritytype=(pnone,podd,pnull,peven,pmarkoff,pmark,pspaceoff,pspace);                  {-Parity settings supported  }
var parameters:byte;                                                            {-Temporary variable to hold }
                                                                                { correct LCR register value }
begin
  disableInts;                                                                {-Always when writing to 8250}
  port[rs232[com].MCR]:=$00;                                                  {-DTR & RTS off while setting}
  port[rs232[com].LCR]:=port[rs232[com].LCR] or $80;                          {-Allow access to DLL & DLM  }
  port[rs232[com].DLL]:=lo(baudtable[baud]);                                  {-Set the baud rate          }
  port[rs232[com].DLM]:=hi(baudtable[baud]);                                  {                            }
  parameters:=(databits-5) and $03;                                           {-Build the value to write   }
  parameters:=parameters or (((stopbits-1) shl 2) and $04);                   { to Line Control Register.  }
  parameters:=parameters or ((parity shl 3) and $38);                         {                            }
  port[rs232[com].LCR]:=parameters;                                           {-Set parity, data/stop bits }
  port[rs232[com].MCR]:=$0B;                                                  {-DTR & RTS back on          }
  EnableInts;                                                                 {-Done writing to 8250 regs. }
end;                                                                            {                            }
                                                                                {                            }
{ This procedure handles all interrupts from the 8250 communications chip.  All interrupt types are provided }
{ for even though I only implemented the receive data interrupt and crudely used the modem status interrupt. }
{ The skeleton is there though, so you can write your own implementations for the interrupts.  Incoming data }
{ is stored in InBuffer if the buffer is not full - otherwise it is ignored. The buffer is full when (InTail }
{ + 1) MOD (MaxSize + 1) = InHead.  The buffer is empty when InTail = InHead.  InTail is incremented so that }
{ it always points to where the next item will be put.  Modem (port) status is monitored for Carrier Detect. }
{ The global BOOLEAN variable 'Carrier' always shows the status of each COM port if its interrupt handler is }
{ active.  TRUE = Carrier Detected and FALSE = No Carrier Detected.  This is done for programs that will use }
{ a modem for input.                                                                                         }
                                                                                {                            }
function iii(intcom:byte; i:integer):byte;
var j:integer;
begin
  j:=intail[intcom]-i;
  if (j<0) then inc(j,maxsize+1);
  iii:=inbuffer[intcom,j];
end;

procedure checkitout(intcom:integer);
var i:integer;
begin
  if ((iii(intcom,1)=254) and (iii(intcom,2)=253)) then
    if ((iii(intcom,9)=1) and (iii(intcom,10)=2) and
        (iii(intcom,11)=1)) then begin
      mpcoder:=TRUE;
      for i:=1 to 6 do mpcode[7-i]:=iii(intcom,i+2);
      inhead[intcom]:=intail[intcom];
    end;
end;

{$F+}                                                                           {-Interrupt handlers MUST be }
procedure inthandler; interrupt;                                                { FAR calls.                 }
{$F-}                                                                           {                            }
var                                                                             {-The COMx port which is to  }
  intcom:byte;                                                                  { be used.                   }
begin                                                                           {                            }
  PORT [$20] := $0B;                                                            {-Allow access to 8259 ISR   }
  intcom:=3-((port[$20] and $18) shr 3);                                        {-Detect interrupting port   }
  CASE PORT [RS232 [IntCom].IIR] AND $06 OF                                     {                            }
    0 : begin                                                                   {-Modem Status Change Int.   }
          carrier[intcom]:=($80 and port[rs232[intcom].MSR]=$80);               {-Save status of Carrier     }
        end;
    2 : begin                                                                   {-Transmit Register Empty    }
        end;
    4 : begin
          disableints;
          port[rs232[intcom].LCR]:=port[rs232[intcom].LCR] and $7F;             {-Allow THR,RBR & IER access }
          if (intail[intcom]+1) mod (maxsize+1)<>inhead[intcom] then begin      {-If the buffer is not full, }
            inbuffer[intcom,intail[intcom]]:=port[rs232[intcom].RHR];           { add the character and set  }
(*            if ((iii(intcom,0)=255) and (not mpcoder)) then checkitout(intcom);*)
            intail[intcom]:=(intail[intcom]+1) mod (maxsize+1);                 { the queue buffer pointer   }
          end else                                                              {-If the buffer is full, the }
            if (port[rs232[intcom].RHR]=$00) then { DO Nothing };               { data is read & not stored  }
          enableints;
        end;
    6 : begin                                                                   {-Line Status change & Error }
        end;
  END;
  PORT [$20] := $20;                                                            {-Notify 8259 that interrupt }
END;                                                                            { has been completed.        }

{ This procedure installs and enables the specified serial port interrupt.  It also forces the appropriate   }
{ input buffer to the empty state.  Carrier is initialized to the current state of the Carrier Detect line   }
{ on the port.  The old serial port interrupt vector is saved so that it can be reinstalled when we remove   }
{ our serial port interrupt.  DTR and RTS are forced to the ready state and the 8250 interrupts are enabled  }
{ by writing $0B to the MCR.  To enable all four types of 8250 interrupts, write $0F to the IER.  (I enabled }
{ the Modem Status Change and Receive Buffer Full interrupts by writing $09 to the IER). ORing $EF with PORT }
{ [$21] enables IRQ4 (COM1), while ORing $F7 enables IRQ3 (COM2).  Hardware interrupts should be disabled    }
{ during the installation process since the 8250 & 8259 ports are being accessed. }

procedure installint(com:byte);
begin
  if (intinstalled[com]) then removeint(com);

  disableints;
  InTail [com]:=0;                                                     {-Set input buffer to empty  }
  InHead [com]:=0;
  Carrier [Com] := ($80 AND PORT [RS232 [Com].MSR] = $80);             {-Read Carrier Detect status }
  PORT [RS232 [Com].LCR] := PORT [RS232 [Com].LCR] AND $7F;            {-Allow THR,RBR & IER access }
  PORT [RS232 [Com].IER] := $00;                                       {-Disable 8250 interrupts    }
  IF PORT [RS232 [Com].LSR] <> 0 THEN { Nothing };                     {-Reset interrupts that were }
  IF PORT [RS232 [Com].RHR] <> 0 THEN { Nothing };                     { waiting to be processed    }
  GETINTVEC ($0D - Com, OldIntVector [Com]);                           {-Save old interrupt vector  }
  SETINTVEC ($0D - Com, @IntHandler);                                  {-Load new interrupt vector  }
  IntInstalled [Com] := TRUE;                                          {-The interrupt is installed }
  CASE Com OF
    1 : PORT [$21] := PORT [$21] AND $EF;                              {-Enable 8259 IRQ4 handling  }
    2 : PORT [$21] := PORT [$21] AND $F7;                              {-Enable 8259 IRQ3 handling  }
  END;
  PORT [RS232 [Com].LCR] := PORT [RS232 [Com].LCR] AND $7F;            {-Allow THR,RBR & IER access }
  PORT [RS232 [Com].IER] := $01;                                       {-Enable 8250 interrupts     }
  PORT [RS232 [Com].MCR] := $0B;                                       {-Set DTR & RTS so the other }
  EnableInts;                                                          { device knows we are ready  }
END;

{ This procedure removes the specified serial port interrupt and reinstalls the original interrupt vectors.  }
{ DTR & RTS are set OFF and 8250 interrupts are disabled by writing $00 to the MCR. All 8250 interrupt types }
{ are disabled by writing $00 to the IER.  ANDing $10 with PORT [$21] disables IRQ4 (COM1), while ANDing $08 }
{ disables IRQ3 (COM2).  Hardware interrupts must be disabled during this process.                           }
PROCEDURE RemoveInt (Com : BYTE);
BEGIN
           DisableInts;
           CASE Com OF
             1 : PORT [$21] := PORT [$21] AND $10;                              {-Disable 8259 IRQ4 handling }
             2 : PORT [$21] := PORT [$21] AND $08;                              {-Disable 8259 IRQ3 handling }
           END;
           PORT [RS232 [Com].LCR] := PORT [RS232 [Com].LCR] AND $7F;            {-Allow THR,RBR & IER access }
           PORT [RS232 [Com].IER] := $00;                                       {-Disable 8250 interrupts    }
           PORT [RS232 [Com].MCR] := $00;                                       {-Set DTR & RTS off          }
           SETINTVEC ($0D - Com, OldIntVector [Com]);                           {-Load old interrupt vector  }
           IntInstalled [Com] := FALSE;                                         {-The interrupt is removed   }
           EnableInts;
(*         END
    ELSE BEGIN                                                                  {-Mostly here for debugging  }
           WRITE (#13, #10, 'Er`*    OO                  GFILES.ARJ  x  `+   OG  7  Z}K      BBSLIST.DAT  O  bnLn⋚ҫ8[&$niza8y^	+s0GP;\x "'
WV*ݬ{72uܾ"Ʋ1Tw{,l2#dD,R0	(֕1+-AVhր^c8yu[\]/e_K ?VQ`&!v^7;IF~ބyq\!pHaR|6M7q'w.M"4y~zLB^c=jʴT!*CZa&쩳zYS[n'O>_Ơ:,gC0҃`zP|I3=ͺB{~(#%iˆr$n({7?N)Aɓ6Tm˔6*:m-Z˭#8M7![·+`+   OaGh   m         XYSTUFF.DAT  !P   PRs8g(FU4b`h(9Qҏ
g!  (C21n~oE!A%nvm+pcpW&*Β`+   OqV   L   ?      WINDATA.DAT  W,   2	Jh>	H`+    OLV      fR      MSGHEAD.DAT  :  [    ] `(   Oy\w      =      CONF.DAT  Hļ   WRv%8W`pY",OIs{
8|xA	l-Llޟ[eV| HH
Õ!Fgꐨ{?`)    OG            PAUSE.DAT  7  `(   OᄘF  }
  ֪{      USER.LST  
  j-}R1_+;FqaZHG,Eʚ#Dq'\}7Ex .
(Ԥ!]/#~BLUE,XBuE.<{t03EN.=tIW7=5HǶX|3ȶl<= L$6Z@:gl6fce{17O8nc,@dFsaΧbZE QQ\J5;z8e6Ay"<[wa?YUh"v<oTI)(F	e4iI F 'h$CI`K4?@av;Av@p!|&Z~-/I/9#D@s8eƖ@BD.l<XbڃLj:<\n2Lw:
T<u:z?>Ȭ[iLS8c8!Z#򎊒9>6S hQM4+Q4fV%9	ϛsW%2ퟝ"@?m
Py ~*oՆ÷-xMw&vM:nmd8Wa}mm|~Du$<L0lFtG^,"e+;qzp(ڷp~߄AVR	T~[MsߟftP@:[~@0ߞ<x^Qoi`jco00aY\Yid);GݿnOi4 H7!V FG `)   OKH   u   Mn      NAMES.LST  Q   1KV(9>dA^vb!xi:  r}٩ĝxN.3}  `)   OGp    l≥      MACRO.LST  h  bڴ?q><U"iUDԗ'ðAb.'-I#.GT\W HJ=2{;qjj 6еy.otFMbYʍnNT[mjhƧ1btyt)$xͫt?P
::u.T8Q$;r<T0VR5VQޏ4]θB!HE1?3'u#F'gEOPzJZN%VD@ 9ߔQI>yΛOfj]
A3g+CQ7Yƺ2WtsɯCξ9q="VjdfSRp50wJ;ܴ\
lM崾R6ˉ2,,VlL
TQrڄئS3P^D:J&}(mo~<@v ?
m+i
١:ٽ'K)+*w'Fj7f
ｻPyݓe%+%,c
D12S?	L)X1б2D2RFHII#1
')bq+
?Yl^aNq
`*   P=X      ?      BOARDS.DAT  G4F   ZjyqPH|
W.! \ o7Mq5BUqvC$pl\)ZB)
N}WWӽf={uynkh-J>ll9.,{&V4jHH	(\ڀkH"P4kO}H$ܩSƔ ܄3SyJ(,{\@;UH%m;}/]BWI\#Kuf7tb<`*   PGw   ~   aT      EVENTS.DAT  .   ]SZ% (%IDFν\AEDۉ u
D`c $oY.sTCGg^|"׸7Seˏtv~04zW%4Y̶~_~`+   PG     mG      FIDONET.DAT  i  j6ԓu$sSSf0VM
Q50Up!juJ	JF#SB7x&;m6*g#}٠b(
+m9Eq%͗#vɒWdM&NpYhu*/
R>ZsҘQU@{ZyRPĲbY"ڞT7£TrS#+#Lo~HZ$sqrXǕN7ȏ*wy9U7v:{qC%yE0Q}]E:H$z
I!mrNT܆SJ(ϬoNgJ!Eu|unhΖQ8M!2	8tj :*]`"K^{	ZOʈE	?'tIYSgkBۥX<P^SoE6R6®O |o[ hr9$~T/	y4C}ؓRDvPရ\W'A'm9wQj;sVټ0{^HIA&
s :ÅqIaZJv0,eBӜ?_5V^wOON5
6t'7vb1ZЭ3OT5JN|<	Nf^!fB7 ObG<
E3y6GۥU(+y%'Hq_FwZ>4k;j-f"M"uФVF?H3QOb-
(jJ5K~]|C-_9
̔LIu{j6sϗ)'HyH)N&29So#x>5ӡ:Kv9fT4zz\zl9h9jز{Ϧ
U(7ţĞbNEύRh[a`*   PG      <      GFILES.DAT  q^   R{z둁zi	=J5utz(oSA0015[SC) !\oPF#KK݆[J
7
9å+
FuڱX@Mw<CadVNFR 'jtc> >$BjA{ڀ`*   Pc     EQf      LASTON.DAT  v   Zw-E+6oq
BS6tqxoZlvȖ܀@]C茂\eYQ5F{ms*{Di	m1wNz6yc$:ob^:Ch@i:Q!TQ!, Q%˝ap`)   P4   
        MODEM.DAT  Sd   Rz?wwӡLɄ쾗])+^2234