PAGE  80,132
TITLE STRHEX  Decimal to Hex String Routine, Ver 6.20

; STRHEX.ASM - StrHex
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine converts numbers to hex strings.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrHex

Result       EQU     DWORD PTR [bp+0Ch]
Num          EQU     DWORD PTR [bp+8]
Field        EQU     BYTE  PTR [bp+6]


; StrHex - Converts numbers to hex strings.
;  . If the field is larger than the resulting string, the field is balanced
;    with leading zeros.
;  . If no leading zeros are desired, set Field to 0.
;  . Maximum field is 8.
;  . No leading '$' character is inserted.
; function StrHex (Num: longint; Field: byte): string;

StrHex       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       les   bx,Num           ; Get Lo word into BX
       mov   dx,es            ; Get Hi word into DX
       les   di,Result        ; Point to dest string
       push  di               ; Save length offset
       mov   ah,Field         ; Set AH to Field
       inc   di               ; Start at first char
       cld                    ; Set DF to increment
       mov   cx,8             ; Count all 8 nibbles
       EVEN                   ; Align for speed
L1:    mov   si,cx            ; Save counter
       mov   cl,4             ; Set to shift one nibble
       mov   al,dh            ; Copy byte 3 in AL
       shr   al,cl            ; Isolate nibble 7
       rol   bx,cl            ; x16 but keep nibble 4
       shl   dx,cl            ; x16 but zero low nibble 4
       mov   cl,bl            ; Copy byte with nibble 1 and 4
       and   cl,1111b         ; Isolate nibble 4
       or    dl,cl            ; Insert nibble 4
       mov   cx,si            ; Restore counter
       add   al,'0'           ; Set AL to char value
       cmp   al,'0'           ; ='0'?
       jne   NonZ             ;   no, a non-zero value
       cmp   cl,ah            ; Count<=Field?
       ja    NoChar           ;   no, no char yet
NonZ:  cmp   al,'9'           ; AL<='9'?
       jbe   Deci             ;   yes, a decimal number
       add   al,7             ; Add for A..F
Deci:  stosb                  ; Save char
       mov   ah,cl            ; Reset field
NoChar:loop  L1               ;
       test  ah,ah            ; Final length=0?
       jnz   NZ               ;   no, bits were found
       stosb                  ; Save '0' char
NZ:    xchg  ax,di            ; Get final DI
       dec   ax               ; Last char offset
       pop   di               ; Restore length offset
       sub   ax,di            ; Calc length (AL)
       stosb                  ; Save length
       pop   bp               ; Restore Pascal's BP
       ret   6                ; Clear all parameters
StrHex       ENDP

CODE   ENDS

       END
