PAGE  80,132
TITLE STRENUM  String Enumerate routine, Ver 6.20

; STRENUM.ASM - StrEnum
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine enumerates a string of characters from First to Last.  For
; example:
;    StrEnum (S,'a','f');
;    StrEnum (T,'f','a');
; produces the string 'abcdef' in S and 'fedcba' in T.  Enumeration truncates
; at 255;


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrEnum

S            EQU     DWORD PTR SS:[bx+8]
First        EQU     BYTE  PTR SS:[bx+6]
Last         EQU     BYTE  PTR SS:[bx+4]

; StrEnum - Enumerates a string of characters starting from First to Last.
; procedure StrEnum (VAR S: string; First,Last: char);

StrEnum      PROC FAR
       mov   bx,sp            ; Set up stack base
       cld                    ; Set DF to increment
       les   di,S             ; Point to S
       xor   cx,cx            ; Zero extend AL
       mov   al,First         ; Get First char
       mov   cl,Last          ; Get Last char
       sub   cl,al            ; Calc Count in AL
       lahf                   ; Save flags
       ja    Asc              ; Jump if ascending order
       neg   cl               ; Make positive count
Asc:   inc   cl               ; 1-based
       cmp   ch,cl            ; Count=0? (CF=0?)
       adc   cl,-1            ;   yes, decrement to 255
       mov   es:[di],cl       ; Save length
       inc   di               ; To S[1]
       sahf                   ; Reset test (First>Last?)
       jb    LDesc            ;   yes, do descending
; -- Do ascending enumeration --
       EVEN                   ; Align for speed
LAsc:  stosb                  ; Store char
       inc   ax               ; Next char
       loop  LAsc             ; Do more ...
       jmp   SHORT Exit       ; All done

; -- Do descending enumeration --
       EVEN                   ; Align for speed
LDesc: stosb                  ; Store char
       dec   ax               ; Next char
       loop  LDesc            ; Do more ...
Exit:  ret   8                ; Clear all parameters

StrEnum      ENDP

CODE   ENDS

       END
