PAGE  80,132
TITLE STRCATX  String CatX Procedure, Ver 6.20

; STRCATX.ASM - StrCatX
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine combines a copy and concatenation in one step.
; As in all move-type procedures, make sure your destination is large enough.
; The Source and Dest strings can be the same address.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrCatX
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR [bp+16]
S            EQU     DWORD PTR [bp+12]
Index        EQU     BYTE  PTR [bp+10]
Count        EQU     BYTE  PTR [bp+8]
MaxLen       EQU     BYTE  PTR [bp+6]

; StrCatX - Concatenates a substring from one string to another.
; procedure StrCatX (VAR Dest: string; S: string; indeX,Count,MaxLen: byte);

; Quit if:
;   Count=0
;   Length=0
;   Index>Length
;   MaxLen<=DestLength

StrCatX      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Check S length --
       lds   si,S             ; Point to source string
       cld                    ; Set DF to increment
       lodsb                  ; Get length  (SI+1)
       xor   ah,ah            ; Zero extend AL
       mov   cx,ax            ; Save in CX
       jcxz  Exit2            ; Quit if null string
; -- Check Index>Length --
       mov   al,Index         ; Get index
       cmp   ah,al            ; indeX>0?
       sbb   al,ah            ;   yes, decrement
       sub   cx,ax            ; Index>Length?  (CX=Trailing length)
       jle   Exit2            ;   yes, null string
       add   si,ax            ; Source offset
       les   di,Dest          ; Point to Dest
; -- Check Count>0 --
       mov   al,Count         ; Get Count
       cmp   ax,cx            ; Count>=Trailing>?
       jge   C1               ;   yes, use trailing count
       xchg  ax,cx            ;   no, use Count
       jcxz  Exit2            ; Quit if null substring
; -- Check maximum length --
C1:    mov   al,es:[di]       ; Get current length
       mov   bx,ax            ; Save dest index
       mov   ah,MaxLen        ; Get maximum length
       cmp   ah,al            ; Dest[0]>=MaxLen?
       jbe   Exit2            ;   yes, no room
       add   al,cl            ; Calc new Dest length
       sub   ah,al            ; Calc difference, MaxLen>NewLength
       ja    Exit1            ;   yes, append full substring
       add   al,ah            ;   no, truncate substring
       add   cl,ah            ; Truncate count
; -- Append substring --
Exit1: stosb                  ; Save count
       add   di,bx            ; At Dest[L+1]
       call  RepMovsB         ; Do fast move of bytes
Exit2: pop   bp               ; Restore Pascal's BP
       mov   ds,dx            ; Restore Pascal's DS
       ret   14               ; Clear all parameters

StrCatX      ENDP

CODE   ENDS

       END
