PAGE  80,132
TITLE STRCASE  String Casing Routines, Ver 6.20

; STRCASE.ASM - StrUpr, StrLwr
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; These two procedures operate on a string to convert it completely to
; upper or lower case.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrUpr, StrLwr


S            EQU     DWORD PTR ss:[bx+4]

; StrLwr - Converts full string to lower case.
; procedure StrLwr (VAR S: string);

StrLwr       PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Get address of string --
       lds   si,S             ; Point to source string
       cld                    ; Set DF to increment
       xor   ax,ax            ; Set AX=0.
       lodsb                  ; Load S[0] in AL
       mov   cx,ax            ; Save length in CX
       jcxz  ExitL            ; Quit if null string
; -- Set conversion constants --
       mov   ah,20h           ; Set lower case constant
       mov   bx,5A41h         ; Lo='A'; Hi='Z'
; -- Convert string --
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get char
       cmp   al,bh            ; Char>Z?
       ja    NextL            ;   yes, already lower case
       cmp   al,bl            ; Char<A?
       jb    NextL            ;   no, not in range
       or    al,ah            ; Convert case
       mov   [si-1],al        ; Store new char
NextL: loop  L1               ; Get next char
ExitL: mov   ds,dx            ; Restore Pascal's DS
       ret   4                ; Clear all parameters
StrLwr       ENDP



; StrUpr - Converts full string to upper case.
; procedure StrUpr (VAR S: string);

             EVEN             ; Align for speed
StrUpr       PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Get address of string --
       lds   si,S             ; Point to source string
       cld                    ; Set DF to increment
       xor   ax,ax            ; Set AX=0.
       lodsb                  ; Load S[0] in AL
       mov   cx,ax            ; Save length in CX
       jcxz  ExitU            ; Quit if null string
; -- Set conversion constants --
       mov   ah,20h           ; Set upper case constant
       mov   bx,7A61h         ; Lo='a'; Hi='z'
; -- Convert string --
       EVEN                   ; Align for speed
U1:    lodsb                  ; Get char
       cmp   al,bl            ; Char<a?
       jb    NextU            ;   yes, already upper case
       cmp   al,bh            ; Char>z?
       ja    NextU            ;   no, not in range
       xor   al,ah            ; Convert case
       mov   [si-1],al        ; Store new char
NextU: loop  U1               ; Get next char
ExitU: mov   ds,dx            ; Restore Pascal's DS
       ret   4                ; Clear all parameters
StrUpr       ENDP

CODE   ENDS

       END
