PAGE  80,132
TITLE IS  Character Classification Routines, Ver 6.20

; IS.ASM - IsAlNum,IsAlpha,IsDigit,IsDOS  ,IsFile ,
;          IsLower,IsPunct,IsReal ,IsUpper,IsXDigit
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.

DATA    SEGMENT WORD PUBLIC
        EXTRN   ChrClass:  BYTE
DATA    ENDS

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE,DS:DATA
        PUBLIC  IsAlNum,IsAlpha,IsDigit,IsDOS  ,IsFile
        PUBLIC  IsLower,IsPunct,IsReal ,IsUpper,IsXDigit


Lower   EQU  00000001b
Upper   EQU  00000010b
Digit   EQU  00000100b
Punct   EQU  00001000b
XDigit  EQU  00010100B
Real    EQU  00100100b
File    EQU  01000000b
DOS     EQU  11000000b
Alpha   EQU  00000011b
AlNum   EQU  00000111b

C       EQU  BYTE  PTR SS:[di+4]

; IsAlNum - Returns true if Char is '0'-'9', 'A'-'Z' or 'a'-'z'.
; function IsAlNum (C: char): boolean;

IsAlNum      PROC FAR
       mov   cl,AlNum         ; AlNum is classed as Upper, Lower, and Digit
       jmp   SHORT Test1      ; Test routine


; IsAlpha - Returns true if Char is 'A'-'Z' or 'a'-'z'.
; function IsAlpha (C: char): boolean;

IsAlpha      PROC FAR
       mov   cl,Alpha         ; Alpha is classed as Upper and Lower
       jmp   SHORT Test1      ; Test routine


; IsDigit - Returns true if Char is '0'-'9'.
; function IsDigit (C: char): boolean;

IsDigit      PROC FAR
       mov   cl,Digit         ; Digit is bit 2
       jmp   SHORT Test1      ; Test routine


; IsDOS - Returns true if Char is a valid DOS character:
;     ['!','#'..'*','-'..'.','0'..':','?'..'Z','^'..'{','}'..'~','\']
; function IsDOS (C: char): boolean;

IsDOS        PROC FAR
       mov   cl,DOS           ; DOS is bit 6 or 7
       jmp   SHORT Test1      ; Test routine


; IsFile - Returns true if Char is valid File name character:
;    ['!','#'..')','-'..'.','0'..'9','@'..'Z','^'..'{','}'..'~']
; function IsFile (C: char): boolean;

IsFile      PROC FAR
       mov   cl,File          ; File is bit 6
       jmp   SHORT Test1      ; Test routine


; IsLower - Returns true if Char is 'a'-'z'.
; function IsLower (C: char): boolean;

IsLower      PROC FAR
       mov   cl,Lower         ; Lower is bit 0
       jmp   SHORT Test1      ; Test routine


; IsPunct - Returns true if Char is Graph and not AlNum
; function IsPunct (C: char): boolean;

IsPunct      PROC FAR
       mov   cl,Punct         ; Punct is bit 3
       jmp   SHORT Test1      ; Test routine


; IsReal - Returns true if Char is '0'-'9', '+', '-', '.', 'e', or 'E'.
; function IsReal (C: char): boolean;

IsReal      PROC FAR
       mov   cl,Real          ; Real is bit 5 and Digit
       jmp   SHORT Test1      ; Test routine


; IsUpper - Returns true if Char is 'A'-'Z'.
; function IsUpper (C: char): boolean;

IsUpper      PROC FAR
       mov   cl,Upper         ; Upper is bit 1
       jmp   SHORT Test1      ; Test routine


; IsXDigit - Returns true if Char is '0'-'9','A'-'F', or 'a'-'f'.
; function IsXDigit (C: char): boolean;

IsXDigit     PROC FAR
       mov   cl,XDigit        ; XDigit is bit 4 and Digit
Test1: mov   di,sp            ; Set up stack base
       xor   ax,ax            ; Set AX=0
       mov   bx,ax            ; Set BX=0
       add   bl,C             ; Get character
       js    ExIs1            ; Exit if >128
       test  cl,ChrClass[bx]  ; Is it in the class?
       jz    ExIs1            ;   no, exit
       inc   ax               ;   yes, set true
ExIs1: ret   2                ; Clear parameter
IsXDigit     ENDP
IsUpper      ENDP
IsReal       ENDP
IsPunct      ENDP
IsLower      ENDP
IsFile       ENDP
IsDOS        ENDP
IsDigit      ENDP
IsAlpha      ENDP
IsAlNum      ENDP


CODE   ENDS

       END
