{
 $Id$
}
{*****************************************************************************
 *
 * Purpose:  Process Notify requests
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_noti;  {notify}

{$O+}

Interface

Uses S_String, Crosslib,
     Nw_Msg, Nw_tpl, Fm_Struct, Fm_Basic, Fm_Log, Fm_Init;

Function  Verstr ( ver : word ) : string;
Procedure NotifyReport (N:NodeType; All:boolean; Part:Boolean; nod:string);
Procedure WriteHelpMsg (Action:byte);
Procedure WriteListMsg (Include:ListType; Action:Byte);
Procedure WriteFlowMsg (Cost:Boolean;Group, Action:Byte);
Procedure WriteStatusMsg;

Implementation


Function  VerStr ( ver : word ) : String;
Var Tmp : String;
Begin
  Tmp := Int_to_str(ver);
  While length(tmp) < 3 do Tmp := '0' + Tmp;
  Verstr := First(1,tmp)+'.'+last(2,Tmp);
End;

Procedure WriteStatusMsg;
Var
  tmp : string;
Const
  sticstr : array[0..2] of string[14] =
            ('No *.tic files', 'Antique', 'Advanced');
Begin
  NotifyCR (11,'(status)');

  DoStringLn(#13'Hello '+extractwords(1,1,node.sysopname)+',');
  DoStringLn('');
  DoStringLn('These are your current settings at '+node2str(tonode));
  DoStringLn('');
  DoStringLn('Your address          : '+node2str(node.address));
  DoStringLn('My address            : '+node2str(tonode));
  If direct in node.mgrstatus then
    Begin
      DoStringLn('Tick password         : '+node.password);
      DoStringLn('Areamanager password  : '+node.mgrpassword);
    End;

  If hold in node.mgrstatus then tmp := 'Hold' else
    if crash in node.mgrstatus then tmp := 'Crash' else tmp := 'None';
  DoStringLn('Mail status           : '+tmp);

  If direct in node.mgrstatus then tmp := 'Yes' else Tmp := 'No';
  DoStringLn('Direct                : '+tmp);

  DoStringLn('Tic file mode         : '+sticstr[node.tictype]);
  if node.maxfilesize <> 0 then
    Dostringln('Max file size         : '+int_to_str(node.maxfilesize));

  if packtic in node.defstatus then tmp := 'Pack *.tic files' else
    if packfile in node.defstatus then tmp := 'Pack all files' else
      tmp := 'No packing';
  DoStringLn('Packing mode          : '+tmp);

  If tmp <> 'No packing' then
    Begin
      tmp := zipstr[node.archiver];
      DoStringLn('Archiver used         : '+tmp);
      if node.maxsize > 0 then tmp := int_to_str(node.maxsize) else tmp := 'Unlimited';
      DoStringLn('Maximum bundle size   : '+tmp);
    End;

  If node.avaraging <> 0 then
     DoStringLn('Total max file volume : '+int_to_str(node.avaraging)+' Kb') else
       DoStringLn('Total max file volume : Unlimited');

  If node.billing then
    Begin
      DoStringLn('');
      if node.credit > 0 then tmp := real_to_str(node.credit,0) else tmp := 'NONE!';
      DoStringLn('Billing credits left  : '+tmp);
      if node.credit > 0 then
        Begin
          DoStringLn('Credit low warning    : '+int_to_str(node.warnlevel));
          DoStringLn('Switch pause level    : '+int_to_str(node.stoplevel));
        End;
      If node.sendbill = 0 then tmp := 'Direct' else
        begin
          if node.sendbill = 1 then tmp := 'Weekly on ' else
            tmp := 'Monthly on ';
          case node.sendday of
            0 : tmp := 'Sunday';
            1 : tmp := 'Monday';
            2 : tmp := 'Tuesday';
            3 : tmp := 'Wednesday';
            4 : tmp := 'Thursday';
            5 : tmp := 'Friday';
            6 : tmp := 'Saturday';
          end;
        end;
      DoStringLn('Invoice send          : '+tmp);
    End Else
      DoStringLn('Billing               : Not active');


{BillGroups   : BooleanSet; }

  DoStringLn('');
  If Pause in node.Status then DoStringLn ('Your system is on PAUSE. No files will be sent!');

  Dostringln('Average amount FileMgr sends to you each month is'
       +flowstring(node.flow,node.lastmonth,0));
  Dostringln('');
  DoStringLn( 'Regards,');
  DoStringLn( SETUP.SysopName + ' ('+ Node2Str(toNode) +')'+#13);
End;



Procedure WriteFlowMsg(Cost:boolean; Group,Action:byte); {if cost = true costsharing report}
Var
  tel, X, Count, I : Word;

  Procedure WriteFlow( flow:flowtype; lastmonth:byte );
  Var
    Tmp1,
    Tmp2     : string;
    dummy    : byte;
    months   : byte;
    avbytes,
    avfiles  : longint;
  begin
    months  := 0;
    avbytes := 0;
    avfiles := 0;
    for dummy := 1 to 12 do
      begin
        if flow[dummy].bytes >= 0 then
          begin
            avbytes := avbytes + flow[dummy].bytes;
            inc (months);
          end;
        if flow[dummy].files >= 0 then avfiles := avfiles + flow[dummy].files;
      end;
    if months = 0 then
      begin
        dostringln(' No flow ');
      end else
      begin
        avbytes  := round((avbytes/months)/1024);
        avfiles  := round(avfiles/months);
        Tmp1 := int_to_str(avbytes)+'Kb in '+int_to_str(avfiles)+' files.';
        Case lastmonth of
          0 : tmp2 := '-';
          1 : tmp2 := 'January';
          2 : tmp2 := 'February';
          3 : tmp2 := 'March';
          4 : tmp2 := 'April';
          5 : tmp2 := 'May';
          6 : tmp2 := 'June';
          7 : tmp2 := 'July';
          8 : tmp2 := 'August';
          9 : tmp2 := 'September';
         10 : tmp2 := 'October';
         11 : tmp2 := 'November';
         12 : tmp2 := 'December';
        end;
        Dostringln(' Average flow over '+int_to_str(months)+' months: '+Tmp1);
        Dostringln(' Last month was: '+tmp2);
      End;
  End;

Begin
  If cost then
    Notify(action,'(cost)  ') else Notify(action,'(flow)  ');
  { for each available group }
  tel := 0;
  if cost then
    dostringln('Cost report for group '+int_to_str(group)) else
      dostringln('Flow report for group '+int_to_str(group));
  dostringln('');
  For i := 1 to 255 do
    Begin
      If group = i then
        Begin
          For x := 1 to Areaidx do
            Begin
              If afxt^[x].grp = i then
                Begin
                  Seek(af,afxt^[x].arearec);
                  Blockread(af,area,sizeof(area),count);
                  If count = sizeof(area) then
                    Begin
                      if node.groups[area.grp] then
                        begin
                          inc(tel);
                          Write(replicate(length(int_to_str(tel-1)),#8)+int_to_str(tel));
                          dostringln(area.tag+' - '+area.name);
                          if cost then
                            begin
                              if (area.costperblock <> 0) or area.incluplink then
                                begin
                                  Dostring('Costs: '+int_to_str(area.costperblock)+' cents per ');
                                  case area.block of
                                    0 : dostring('100 Kb');
                                    1 : dostring('1024 Kb');
                                    2 : dostring('file');
                                  end;
                                  if area.incluplink then dostring(' + costs uplink');
                                  if area.alllinks then dostringln(' (for all connected systems + host)')
                                    else dostringln(' (for all connected systems)');
                                  dostringln('Area has '+int_to_str(area.exportnr)+' downlinks at this moment');
                                end else
                                  Dostringln('No costs');
                            end else
                              writeflow(area.flow,area.lastmonth);
                          dostringln('');
                        end;
                      If (setup.maxmsgsize > 0) and Big_MessageText (0, setup.maxmsgsize) then
                        Begin
                          DoStringln(#13+' [continued in next message]');
                          DoStringln('--- ' + msgtearline);
                          Save_Message;
                          {new message}
                          If cost then
                            Init_Message ('F'+setup.netmailpath, true, 0, [net], fromnode, tonode,
                            'FileMgr v'+verstr(versionnr)+Build, node.sysopname, 'FileMgr cost report') else
                               Init_Message ('F'+setup.netmailpath, true, 0, [net], fromnode, tonode,
                               'FileMgr v'+verstr(versionnr)+Build, node.sysopname, 'FileMgr flow report');
                          Open_Message;
                          Set_Attrib2(node.mgrstatus);
                          Set_Attrib([privat,killsent],'F');
                          Dostringln(' [continued from previous message]'+#13);
                        End;
                    End;
                End;
            End;
        End;
    End;
  if tel <> 0 then write(replicate(length(int_to_str(i-1)),#8)+expand(' ',10),#13);
  notifycr(action,'');
End;


Procedure WriteHelpMsg(Action:byte);
VAR
  ext   : boolean;
  Name  : String[30];
  TMP   : Text;
  Line  : String;
  x     : byte;
begin
  NotifyCr(action,'(help) ');

  name := extractwords(1,1,node.sysopname);
  dostringln('Hello ' + Name + ',' +#13);

  ext := false;
  if strip('B',' ',setup.helptplmsg) <> '' then ext := true;
  if ext then
    begin
      Assign (TMP, setup.helptplmsg);
      {$I-} Reset (TMP); {$I+}
      if IOresult = 0 then
        close(tmp) else ext := false;
    end;

  if ext then
    begin
      x := 1;
      while not samerec(setup.address[x],tonode,sizeof(tonode)) and (x < 21) do inc(x);
      if x = 21 then x := 1;

      empty_Tpl( setup.helptplmsg, false, x, node.sysopname);
    end else
    begin
      DoStringLn( 'This is how to use FileMgr :'+#13);

      DoStringLn( 'Send a NETMAIL message to ''FileMgr'', at address ' + Node2Str(toNode) + '. The');
      DoStringLn( '''Subject:'' (or ''Re:'' field) should start with your FileMgr Area Password.'+#13);
      DoStringLn( 'In the message body you can use the following commands:'+#13);

      DoStringLn( '[+]<areatag>       Connect yourself to a fileecho.');
      DoStringLn( '-<areatag>         Disconnect a fileecho.');
      DoStringLn( '%+                 Connect ALL groups.');
      DoStringLn( '%-                 Disconnect ALL groups.');
      DoStringLn( '%+<grouptag>       Connect yourself to a group of fileechoes.');
      DoStringLn( '%-<grouptag>       Disconnect a group of fileechoes.');
      DoStringLn( '%H[ELP]            Ask for instructions (this message)');
      DoStringLn( '%L[IST]            Request a list of available echoes.');
      DoStringLn( '%Q[UERY]           Request a list of echoes you''re connected to.');
      DoStringLn( '%U[NLINKED]        Request a list of echoes you''re not connected to.');
      DoStringLn( '%F[LOW] <grouptag> Request a full flow report of a group');
      DoStringLn( '%C[OST] <grouptag> Request a full cost report of a group');
      DoStringLn( '%TICK              Send Tick/Raid compatible *.TIC files.');
      DoStringLn( '%FILEMGR           Send FileMgr advanced *.TIC files.');
      DoStringLn( '%NONE              Don''t send *.TIC files at all.');
      DoStringLn( '%PAUSE             Put your system temporary on pause. No files will be sent.');
      DoStringLn( '%INACTIVE          Put your system temporary on pause. No files will be sent.');
      DoStringLn( '%RESUME            Start sending files to your system again.');
      DoStringLn( '%ACTIVE            Start sending files to your system again.');
      DoStringLn( '%STATUS            Ask for a statusreport (password, packmethod).');
      DoStringLn( '%COMPRESS <method> Change the compression program.');
      DoStringLn( '%COMPRESS ?        Request a list with available compression programs.');
      DoStringln( '%VOLUME <Kb''s>     Set total file volume to <Kb''s> per session.');
      DoStringLn( '%FROM <address>    Remote maintenance. Must be the first command.');
      DoStringLn( '%PWD <password>    Change your tickfile password to <password>.');
      DoStringLn( '%MGRPWD <password> Change your Filemgr manager password to <password>.');
      DoStringLn( '%REQ <file>        Request <file> to be (re)send, with a *.TIC file.');
      DoStringln( '%BUNDLESIZE <size> Maximum tick bundle size (in Kb).');
      DoStringln( '%FILESIZE <size>   Maximum individual filesize (in Kb) for any file to be sent.');
      DoStringLn( '[---]              Marks the end of your msg (optional)'+#13);
      DoStringLn( 'You can also use the -H, -L, -Q, and -U switches on the subject line.'+#13);
    end;

  DoStringLn( 'Example :'+#13);
  DoStringLn( ' '+ Replicate(60,'-'));
  DoStringLn( ' From : '+node.SysopName+', ('+Node2Str(fromNode)+')');
  DoStringLn( ' To   : FileMgr, ('+Node2Str(toNode)+')');
  DoStringLn( ' Subj : <password>');
  DoStringLn( ' '+ Replicate(60,'-'));
  DoStringLn( ' PDNPASCL');
  DoStringLn( ' -SDSRA');
  DoStringLn( ' %unlinked');
  DoStringLn( ' ' + Replicate(60,'-')+#13);

  DoStringLn( 'Regards,');
  DoStringLn( SETUP.SysopName + ' ('+ Node2Str(toNode) +')'+#13);
end;


Procedure WriteListMsg (Include:ListType; Action:Byte);
Type
  PrefixType = (RECEIVE, LISTONLY, FREE, SEND, SR );
Const
  Header : Array[LIST..UNLINKED] of String[9] = ('visible', 'active', 'unlinked');
  Cmd    : Array[LIST..UNLINKED] of String[8] = ('list','query','unlinked');
  Prefix : Array[RECEIVE..SR]   of Char = ('#','-',' ','+','*');
Var
  changed : boolean;
  cost, cblock : word;
  X     : word;
  I     : Byte;
  Disp  : Boolean;
  Nr    : Word;
  tmp   : string;

  Function InList (FromNode:NodeType; Nr:Byte; Grp:Byte; S:Booleanset) : PrefixType;
  Var k : Byte;
  Begin
    k := 1;    {vind node in systemlists}
    While (k <= NR) and (not NodeEQ(FromNode, sfxt^[k].A)) do Inc(k);
    If k <= Nr then
     Begin {gevonden}
      If (import in sfxt^[k].s) and (export in sfxt^[k].s) then InList := SR else
      If import in sfxt^[k].s then InList := RECEIVE else
      If export in sfxt^[k].s then InList := SEND;
     End Else
     Begin {niet gevonden}
       If s[grp] then InList := FREE else InList := LISTONLY;
     End;
  End;

  Procedure WriteGroup (ID : byte);
  Begin
    Seek (GF,0);
    While (not EOF(GF)) and (GROUP.groupnr <> ID) do Read(GF, GROUP);
    If GROUP.groupnr = ID then
      DoStringLn(#13+'['+int_to_str(ID)+'] '+GROUP.groupName+#13)
        Else DoStringLn(#13+'['+int_to_str(ID)+'] (no description)'+#13);
    If include = list then
      begin
        if ((group.costperblock <> 0) or group.incluplink) and node.billing then
          begin
            cost := group.costperblock;
            cblock := group.block;
            Dostring('Costs: '+int_to_str(group.costperblock)+' cents per ');
            case group.block of
              0 : dostring('100 Kb');
              1 : dostring('1024 Kb');
              2 : dostring('file');
            end;
            if group.incluplink then dostring(' + costs uplink');
            if group.alllinks then dostringln(' (for all connected systems + host)'+#13)
              else dostringln(' (for all connected systems)'+#13);
          end else
          begin
            cost := 0;
            cblock := 0;
          end;
      end;
  End;

Begin
  changed := false;
  Nr := 0;
  Notify (action,'('+Cmd[Include]+') ');
  Write(' ');

  DoStringLn('List of '+Header[Include]+' echoes for '+Node2Str(FromNode)+' :');
  DoStringLn(Replicate(Length('List of '+Header[Include]+' echoes for '+Node2Str(FromNode)+' :'),'-'));

  { for each available group }
  For i := 1 to 255 do
    Begin
      Disp := False;
      Write(replicate(length(int_to_str(i-1)),#8)+int_to_str(i));
      For x := 1 to Areaidx do
        Begin
          If afxt^[x].grp = i then
            Begin
              If ((Include = UNLINKED) and (node.groups[i])) or
                 (Include = QUERY) or
                 ((Include = LIST) and (node.Visible[i])) then
                Begin

                  If (setup.maxmsgsize > 0) and Big_MessageText (80, setup.maxmsgsize) then
                    Begin
                      DoStringln(#13+' [continued in next message]');
                      DoStringln('--- ' + msgtearline);
                      DoStringln(Orig_Line('Use %HELP for instructions',0));
                      Save_Message;
                      {new message}
                      Init_Message ('F'+setup.netmailpath,true, 0, [net], fromnode, tonode,
                       'FileMgr v'+verstr(versionnr)+Build, node.sysopname, 'FileMgr statusreport');
                      Open_Message;
                      Set_Attrib2(node.mgrstatus);
                      Set_Attrib([privat,killsent],'F');
                      Dostringln(' [continued from previous message]'+#13);
                    End;

                  GetArea(X);
                  If not (Hide in AREA.Status) then
                    Begin
                      Case Include of
                        LIST : begin
                                 seek (gf, 0);
                                 group.groupnr := 0;
                                 inc (nr);
                                 while (not eof(gf)) and (group.groupnr <> i) do read (gf, group);

                                 if Disp then
                                   begin
                                     If node.billing then
                                       begin
                                         if (area.costperblock <> cost) or ((area.block <> cblock)
                                         and (area.costperblock > 0)) then
                                           begin
                                             tmp := '';
                                             changed := true;
                                           end else tmp := ' ';
                                       end else tmp := ' ';

                                     DoStringln(Prefix[InList(FromNode,
                                       AREA.ExportNr, AREA.Grp, node.Groups)]
                                      + expand(area.TAG+tmp,21)+expand(AREA.Name,32)
                                      + flowstring(AREA.Flow, AREA.LastMonth,1))
                                   end else
                                   begin
                                     WriteGroup(AREA.Grp);

                                     If node.billing then
                                       begin
                                         if (area.costperblock <> cost) or ((area.block <> cblock)
                                         and (area.costperblock > 0)) then
                                           begin
                                             tmp := '';
                                             changed := true;
                                           end else tmp := ' ';
                                       end else tmp := ' ';

                                     Disp := True;
                                     dostringln(Prefix[InList(FromNode, AREA.ExportNr, AREA.Grp,
                                     node.Groups)] + expand(area.TAG+tmp,21)+ Expand(AREA.Name,32)
                                     + flowstring(AREA.Flow, AREA.LastMonth,1));
                                   end;
                               end;
                       QUERY : if InList (FromNode, AREA.ExportNr, AREA.Grp, node.Groups) in [RECEIVE,SEND,SR] then
                               begin
                                 if Disp then
                                   dostringln(expand(area.TAG,17)+AREA.Name) else
                                     begin
                                       WriteGroup(AREA.Grp);
                                       Disp := True;
                                       dostringln(expand(area.TAG,17)+AREA.Name);
                                     end;
                                 Inc (Nr);
                               end;
                    UNLINKED : if InList (FromNode, AREA.ExportNr, AREA.Grp, node.Groups) = FREE
                               then begin
                                 if Disp
                                   then dostringln(expand(area.TAG,17)+Expand(AREA.Name,35)
                                   + flowstring(AREA.Flow, AREA.LastMonth,1))
                                 else begin
                                   WriteGroup(AREA.Grp);
                                   Disp := True;
                                   dostringln(expand(area.TAG,17)+Expand(AREA.Name,35)
                                   + flowstring(AREA.Flow, AREA.LastMonth,1));
                                 end;
                                 Inc (Nr);
                               end;
                      end; {case}
                    end;
                end;
            end;
        end;
    end;
  write(replicate(length(int_to_str(i-1)),#8)+expand(' ',10),#13);

  If Include = LIST then
    Begin
      If Nr = 1 then
        dostring(#13 + int_to_str(Nr) + ' area listed. ') else
          dostring(#13 + int_to_str(Nr) + ' areas listed. ');
      dostringln('(flow Kb''s are averages per month)');

      If node.billing then
        begin
          if changed then
            begin
              dostringln(#13'  = area costs differ from global groups costs! Use %cost <group> for the');
              dostringln(   '     exact area costs in that group');
            end;
        end;

      dostringln(#13'A + means you are receiving only      A * means you are sending & receiving');
      dostringln('A # means you are sending only        A - means you can''t connect that area'#13);
    End Else
      dostringln(#13'Total of ' + int_to_str(Nr) + ' areas.'#13);

  notifycr(action,'');
End;


Procedure NotifyReport (N:NodeType; all:boolean; part:boolean; nod:string);
Var
  Nfxinx : Word;

  Procedure PostReport;
  Var
    Dummy : NodeType;
  Begin
    Notifycr(8,'Posting statusreport for '+Node2Str(NFXt^[NFXinx].Address)+' ');
    Dummy.Zone := 0;
    MatchAKA (Dummy, NFXt^[NFXinx].Address);

    fromnode := NFXt^[NFXinx].Address;
    tonode := dummy;

    If not noquery then
      begin
        Init_Message ('F'+setup.netmailpath,true, 0, [net], nfxt^[nfxinx].address, dummy,
                        'FileMgr v'+verstr(versionnr)+Build, node.sysopname, 'FileMgr statusreport');
        Open_Message;
        Set_Attrib2(node.mgrstatus);
        Set_Attrib([privat,killsent],'F');

        WriteListMsg (QUERY, 6);
        DoStringln('--- ' + msgtearline);
        DoStringln(Orig_Line('Use %HELP for instructions',0));
        Save_Message;
      end;

    if not nostatus then
      begin
        Init_Message ('F'+setup.netmailpath,true, 0, [net], nfxt^[nfxinx].address, dummy,
                        'FileMgr v'+verstr(versionnr)+Build, node.sysopname, 'FileMgr status');
        Open_Message;
        Set_Attrib2(node.mgrstatus);
        Set_Attrib([privat,killsent],'F');

        WriteStatusMsg;
        DoStringln('--- ' + msgtearline);
        DoStringln(Orig_Line('Use %HELP for instructions',0));
        Save_Message;
      end;

    If Remote in NODE.Status then
      Begin
        if not nohelp then
          begin
            Init_Message ('F'+setup.netmailpath,true, 0, [net], nfxt^[nfxinx].address, dummy,
                            'FileMgr v'+verstr(versionnr)+Build, node.sysopname, 'FileMgr help');
            Open_Message;
            Set_Attrib2(node.mgrstatus);
            Set_Attrib([privat,killsent],'F');
            WriteHelpMsg(6);
            DoStringln('--- ' + msgtearline);
            Save_Message;
          end;

        if not nolist then
          begin
            Init_Message ('F'+setup.netmailpath,true, 0, [net], nfxt^[nfxinx].address, dummy,
                           'FileMgr v'+verstr(versionnr)+Build, node.sysopname, 'FileMgr list report');
            Open_Message;
            Set_Attrib2(node.mgrstatus);
            Set_Attrib([privat,killsent],'F');
            WriteListMsg(LIST, 6);
            DoStringln('--- ' + msgtearline);
            DoStringln(Orig_Line('Use %HELP for instructions',0));
            Save_Message;
          end;

        if not nounlinked then
          begin
            Init_Message ('F'+setup.netmailpath,true, 0, [net], nfxt^[nfxinx].address, dummy,
                           'FileMgr v'+verstr(versionnr)+Build, node.sysopname, 'FileMgr unlinked report');
            Open_Message;
            Set_Attrib2(node.mgrstatus);
            Set_Attrib([privat,killsent],'F');
            WriteListMsg(UNLINKED, 6);
            DoStringln('--- ' + msgtearline);
            DoStringln(Orig_Line('Use %HELP for instructions',0));
            Save_Message;
          end;

      End;
  End;


Begin
  Writelogcr(6,'NOTIFY');

  If not all then
    Begin
      NFXinx := 1;
      While (NFXinx <= Nodeidx) and (Not NodeEQ(NFXt^[NFXinx].ADDRESS, N)) Do Inc(NFXinx);
      If NodeEQ(NFXt^[NFXinx].ADDRESS, N) then
        Begin
          Seek (NF, NFXt^[NFXinx].NodeRec);
          blockRead (NF, NODE, sizeof(node));
          PostReport;
        End Else NotifyCr (2,'System '+Node2Str(N)+' not found.');
    End Else
  If part then
    Begin
      Nfxinx := 1;
      While (Nfxinx <= nodeidx) do
        Begin
          Seek(nf,nfxt^[nfxinx].noderec);
          Blockread(nf,node,sizeof(node));
          If (donotify in node.status) and (first(length(nod),node2str(node.address)) = nod)
            then postreport;
          inc(nfxinx);
          writesetupcfg;
        End;
    End Else
    Begin
      NFXinx := 1;
      While (NFXinx <= Nodeidx) do
        Begin
          Seek (NF, NFXt^[NFXinx].NodeRec);
          BlockRead (NF, NODE,sizeof(node));
          if DoNotify in NODE.Status then PostReport;
          Inc(NFXinx);
          writesetupcfg;
        End;
    End;
End;


End.
