
type
   tACString = String[20];

   tStrings = array[1..numstring] of String[255];
   tStrIdx  = array[1..numString] of Word;

   tInFlag = (               { Input flags for "dReadString"                }
      inNormal,              { No case conversion is performed.             }
      inCapital,             { First letter capitallized.                   }
      inUpper,               { All characters are converted to upper case   }
      inLower,               { All characters are converted to lower case   }
      inMixed,               { Mixed case. AKA: word Auto-Capitalization    }
      inWeird,               { All vowels are lowered (ie. MiKe FRiCKeR)    }
      inWarped,              { All constants are lowered (ie. mIkE frIckEr) }
      inCool,                { Only "I"s are lowered (ie. FiEND)            }
      inHandle);             { reserved for alias format                    }

   tInChar = set of Char;

   { node configuration structure - node??.dat, single record }
   tModemRec = record
      ComDevice     : Byte;            { 0/none 1/uart 2/int14 3=fosl 4/digi }
      {$IFDEF LINUX}
      comport       : string[20];
      {$ELSE}
      ComPort       : Byte;            { device comport # }
      {$ENDIF}
      BaudRate      : LongInt;         { device baud rate }
      Parity        : Char;            { parity (n/e/o) }
      StopBits      : Byte;            { stop bits, usually 1 }
      DataBits      : Byte;            { data bits, usually 8 }
      RecvBuff      : Word;            { receive buffer size }
      SendBuff      : Word;            { transmit buffer size }
      LockedPort    : Boolean;         { locked port? }
      MultiRing     : Boolean;         { use select-ring detection }
      irqNumber     : Byte;            { com irq }
      baseAddr      : String[4];       { uart base address }

      sInit1        : String[45];
      sInit2        : String[45];
      sInit3        : String[45];
      sExitStr      : String[45];
      sAnswer       : String[45];
      sHangup       : String[45];
      sOffhook      : String[45];
      sDialPrefix   : String[45];

      rError        : String[45];
      rNoCarrier    : String[45];
      rOK           : String[45];
      rRing         : String[45];
      rBusy         : String[45];
      rNoDialTone   : String[45];

      c300          : String[45];
      c1200         : String[45];
      c2400         : String[45];
      c4800         : String[45];
      c7200         : String[45];
      c9600         : String[45];
      c14400        : String[45];
      c16800        : String[45];
      c19200        : String[45];
      c21600        : String[45];
      c24000        : String[45];
      c26400        : String[45];
      c28800        : String[45];
      c31200        : String[45];
      c33600        : String[45];
      c38400        : String[45];
      c57600        : String[45];
      c64000        : String[45];
      c115200       : String[45];

      Reserved      : array[1..1024] of Byte;
   end;

   tColorRec = record
      Fore  : Byte;
      Back  : Byte;
      Blink : Boolean;
   end;

   tColor = array[0..maxColor] of tColorRec;

   tNetAddressRec = record
      Zone          : Word;
      Net           : Word;
      Node          : Word;
      Point         : Word;
   end;

   tMacros = array[1..10] of String[255];

type tLoadOVRflag=( ovrLems, ovrLxms);
     tLoadOVR = set of tLoadOVRflag;


   { main bbs configuration structure - iniquity.dat, single record }
   tCfgRec = record
      bbsName          : String[40];   { name of bbs                         }
      SysOpName        : String[36];   { sysop's real name                   }
      DefaultCol       : tColor;       { default bbs generic colors          }

      Address          : array[1..maxAddress] of tNetAddressRec;
                                       { ^^ bbs net addresses                }
      pathData         : String[40];   { path to iniquity's data files       }
      pathText         : String[40];   { path to text/infoform files         }
      pathMenu         : String[40];   { path to menu files                  }
      pathMsgs         : String[40];   { path to message area data files     }
      pathSwap         : String[40];   { path to swapfile directory          }
      pathDoor         : String[40];   { path to door *.bat & drop files     }
      pathProt         : String[40];   { path to external protocols          }
      pathTemp         : String[40];   { path to temporary work directory    }
      pathDnld         : String[40];   { download directory - future use     }
      pathLogs         : String[40];   { path to log file directory          }

      NoBBSlogging     : Boolean;      { disable all bbs logging?            }
      LogLineChat      : Boolean;      { log line chat mode text & users?    }
      LogSplitChat     : Boolean;      { log split-screen chat text/users?   }
      LogMicroDOS      : Boolean;      { log microdos activity?              }
      pathArch         : String[40];   { path to archiver programs           }
      MultiNode        : Boolean;      { is this a multinode bbs?            }
      pathNetmail      : string[40];   { path for netmail messages }
      TimeSlices       : Boolean;      { enable multitasker time slices? }
      daemon :boolean;
   end;
(*
   tUserACflag = (
      acAnsi,
      acAvatar,
      acRip,
      acYesNoBar,
      acDeleted,
      acExpert,
      acHotKey,
      acPause,
      acQuote
   );               *)

   tScanRec = record
      scnMsg : Boolean;
      ptrMsg : LongInt;
   end;


   tMsgStatusFlag =
     (msgDeleted,
      msgSent,
      msgAnonymous,
      msgEchoMail,
      msgPrivate,
      msgForwarded);

   tNetAttribFlag =
     (nPrivate,
      nCrash,
      nReceived,
      nSent,
      nFileAttached,
      nInTransit,
      nOrphan,
      nKillSent,
      nLocal,
      nHold,
      nUnused,
      nFileRequest,
      nReturnReceiptRequest,
      nIsReturnReceipt,
      nAuditRequest,
      nFileUpdateRequest);

   tMsgInfoRec = record
      UserNum       : Word;
      Alias         : String[36];
      Realname      : String[36];
      Name          : String[36];
      UserNote      : String[40];
      Address       : tNetAddressRec;
  end;

   pMsgHeaderRec = ^tMsgHeaderRec;
   tMsgHeaderRec = record
      FromInfo      : tMsgInfoRec;
      ToInfo        : tMsgInfoRec;
      Pos           : LongInt;
      Size          : Word;
      Date          : LongInt;
      Status        : set of tMsgStatusFlag;
      Replies       : Word;
      Subject       : String[40];
      NetFlag       : set of tNetAttribFlag;
      SigPos        : Word;
      incFile       : Word;
      msgTag        : Word;
      Reserved      : array[1..54] of Byte;
   end;

   tMsgAreaFlag =
     (maUnhidden,
      maRealName,
      maPrivate,
      maMandatory,
      maAnonymous);

   tMsgAreaRec = record
      Name          : String[40];
      Filename      : String[8];
      MsgPath       : String[40];
      Sponsor       : String[36];
      Acs           : tACString;
      PostAcs       : tACString;
      MaxMsgs       : Word;
      Msgs          : Word;
      Password      : String[20];
      Flag          : set of tMsgAreaFlag;
      AreaType      : Byte;
      Origin        : Byte;
      Address       : Byte;
      qwkName       : String[16];
      AreaFormat    : Byte;  { 1 = Iniq   2 = JAM }
      Reserved      : array[1..82] of Byte;
   end;

   pMessage = ^tMessage;
   tMessage = array[1..maxMsgLines] of String[80];

   type tmaRef = array[1..maxMsgArea] of Word;
        pmaRef = ^tmaRef;

   tUserIndexRec = record
      UserName : String[36];
      RealName : String[36];
      Deleted  : Boolean;
   end;

   DateTimeRec = record
      Day,
      Hour,
      Min,
      Sec : LongInt;
   end;

   tRepAnsiBuf = array[1..maxRepeatBuf] of Char;

   tNodeRec = record
      NodeNum   : Byte;
      Username  : String[36];
      Realname  : String[36];
      Usernum   : Word;
      Sex       : Char;
      Baudrate  : LongInt;
      Login     : DateTimeRec;
      Bdate     : String[8];
      Status    : String[50];
      Data      : LongInt;
      saveplace : longint;
      race:string[16];
      subrace:string[16];
   end;
   {
   tNodeRec is now retired.
   It is replaced by a plain text file that will list each part on a line
   user^.username
   user^.sex
   user^.race
   user^.subrace
user^.saveplace will be written as a file name ending with .loc
}
   tNodePtrList = array[1..maxNode] of LongInt;
   tNodeBufList = array[1..maxNodeBuf] of Byte;

