unit ShowFile;

{ ck - added code for mci parameters }

interface

uses
   {$IFDEF OS2} Use32, {$ENDIF}
   Dos {$IFDEF LINUX}, linux {$ENDIF};

procedure sfClearPos(P : Byte; L : Byte);
procedure sfClearPosList;
procedure sfFailLight(X : Byte);
function  sfGetTextFile(Fn : String; Ft : Byte) : String;
function  sfGotoPos(P : Byte) : Boolean;
function  sfGotoPos2(P : Byte) : Boolean;
procedure sfKillRepeat;
function  sfLoadRepeat(Fn : String) : Boolean;
procedure sfLight(X : Byte);
procedure sfOkLight(X : Byte);
procedure sfSetPos(P : Byte);
function  sfShowFile(Fn : String; Ft : Byte) : Boolean;
function  sfShowRepeat(Ft : Byte) : Boolean;
function  sfShowTextFile(Fn : String; Ft : Byte) : Boolean;
procedure sfWrite(Z : Byte);

implementation

uses
   Global, Output, Input, Files, StrProc, MCIcodes, Emulate, Comm, FastIO,
   Users,{ FileArea,} {Infoform,}mudmisc,ecomm;

var mciLimit : Byte; mciPad : Boolean; mciParams : string; ValidMciParams : boolean;

const NextIsPcbColorCode : boolean = false; { added by ck for pcb color codes }

procedure sfSetPos(P : Byte);
begin
   sfPos[P].C := Col;
   sfPos[P].X := oWhereX;
   sfPos[P].Y := oWhereY;
   sfPos[P].Ok := True;
end;

procedure sfSetPos2(P : Byte);
begin
   sfPos2[P].C := Col;
   sfPos2[P].X := oWhereX;
   sfPos2[P].Y := oWhereY;
   sfPos2[P].Ok := True;
end;

function sfGotoPos(P : Byte) : Boolean;
begin
   sfGotoPos := sfPos[P].Ok;
   if not sfPos[P].Ok then Exit;
   oGotoXY(sfPos[P].X,sfPos[P].Y);
   oSetColRec(sfPos[P].C);
end;

function sfGotoPos2(P : Byte) : Boolean;
begin
   sfGotoPos2 := sfPos2[P].Ok;
   if not sfPos2[P].Ok then Exit;
   oGotoXY(sfPos2[P].X,sfPos2[P].Y);
   oSetColRec(sfPos2[P].C);
end;

procedure sfClearPos(P : Byte; L : Byte);
begin
   if not sfPos[P].Ok then Exit;
   oGotoXY(sfPos[P].X,sfPos[P].Y);
   oSetColRec(sfPos[P].C);
   oWrite(sRepeat(' ',L));
   oMoveLeft(L);
end;

procedure sfClearPosList;
var Z : Byte;
begin
   for Z := 1 to maxPos do with sfPos[Z] do
   begin
      Ok := False;
      X := 1;
      Y := 1;
{      C := User^.Color[colInfo];}
   end;
   for Z := 1 to maxPos do with sfPos2[Z] do
   begin
      Ok := False;
      X := 1;
      Y := 1;
{      C := User^.Color[colInfo];}
   end;
end;

procedure sfWrite(Z : Byte);
var s : string;
begin
   if mciPad then s := Resize(sfStr[Z],mciLimit) else
                  s := strSquish(sfStr[Z],mciLimit);
   if length(mciParams) > 0 then
    s := mciProcessParams(s,mciParams);
   oStrCtr(s);
   mciParams := '';
end;

procedure sfWriteStr(S : String);
begin
   if mciPad then oStrCtr(Resize(S,mciLimit)) else
               oStrCtr(strSquish(S,mciLimit));
end;

procedure sfLight(X : Byte);
begin
   if sfGotoPos(X) then oWriteChar('');
end;

procedure sfOkLight(X : Byte);
begin
   if sfGotoPos(X) then
   begin
      oSetBlink(False);
      oWriteChar('');
   end;
end;

procedure sfFailLight(X : Byte);
begin
   if sfGotoPos(X) then
   begin
      oSetBlink(False);
      oWriteChar('');
   end;
end;

function sfExists(fs : String; var fz : Word) : Boolean;
var z : Word; nfs : String;
begin
   fz := 0;
   sfExists := False;
   nfs := LowStr(strFilename(fs));
{   if (Cfg^.useTextLibs) and (tLibOpen) then
   begin
      z := 0;
      while (z < textLib^.numLib) and (fz = 0) do
      begin
         Inc(z);
         if nfs = textLib^.tIndex^[z].Filename then fz := z;
      end;
   end;}
   if (fz <> 0) or (fExists(fs)) then sfExists := True;
end;

function sfGetTextFile(Fn : String; Ft : Byte) : String;
var S : String; Year,Month,Day,DayOfWeek, fz : Word; I,J : Integer;
    Dot, ff : Boolean;
begin
   if ft <> ftNormal then repSize := 0;
   ansiRows := 0;
   Fn := LowStr(Fn);
   if Pos('\',Fn) = 0 then Insert(Cfg^.pathText,Fn,1);
   Dot := Pos('.',Fn) > 0;
   if not Dot then
   begin
      ff := true;
      if (sfExists(Fn+extAnsi,fz)) then Fn := Fn+extAnsi else
      if (sfExists(Fn+extAscii,fz)) then Fn := Fn+extAscii else ff := false;
      if ff then
      begin
         S := Fn;
         if sfExists(Copy(Fn,1,Length(Fn)-1)+'1',fz) then
         repeat
            I := Random(10);
            if I = 0 then Fn := S else Fn := Copy(Fn,1,Length(Fn)-1)+St(I);
         until sfExists(Fn,fz);

{         GetDate(Year,Month,Day,DayOfWeek);
         S[Length(S)-1] := Chr(DayOfWeek+48);
         if sfExists(S,fz) then Fn := S;}
      end;
   end;
   if not sfExists(Fn,fz) then sfGetTextFile := '' else sfGetTextFile := Fn;
end;

function sfShowFile(Fn : String; Ft : Byte) : Boolean;
const
   ansiBuf = 1024;
var
   aBuf : array[1..ansiBuf] of Char;
   sRead, tRead : LongInt;
   Read, topy, X : integer;
   Buf : array[1..3] of Char;
   Code, infLim, ex, ey : Byte;
   Cs : String; ec : tColorRec;
   okMci, isrip, lib, infMin : Boolean;
   fz : Word;
(*{$IFDEF LINUX} f:longint; {$ELSE}  *) F : file;(*{$ENDIF}*)
   Aborted : boolean; {added by ck}
   i : integer;
   pp:word;
   f2:string;

begin

   pp:=1;
   Aborted := false; {added by ck}
   {EnableAnsiAborting := true;}

   sfShowFile := False;
   fn := LowStr(fn);
   if user^.alternateansi then
      begin
      if fn='explore.ans' then fn:='expalt.ans';
      if fn='battle.ans' then fn:='batalt.ans';
      end;
   isrip := copy(fn,length(fn)-3,4) = extRIP;
   if detdarkterm and ((ft=ftnormal) or (ft=ftnocode)) then begin putstring('//\\'+fn+'/'+st(ft)); exit; end;
   if (pos('tempscr',fn)=0) then
   if (copy(fn,length(fn)-3,4) = extansi) then begin
      {$IFDEF LINUX} f2:='./ansi/'+fn; {$ELSE} f2:='.\ansi\'+fn; {$ENDIF} fn:=f2; end;
   infLim := 254;
   fz := 0;
   ex := 0;
   if (fn[1] = #0) and (fn[2] = #0) then fz := strToInt(Copy(fn,3,255));
   begin
(*      {$IFDEF LINUX}
      f:=fdopen (fn, open_rdonly);
      if f<>0 then exit;
      {$ELSE}*)
      Assign(F,Fn);
{      if not fopen(f,1,ffopen) then Exit;}
      {$I-}
      Reset (F,1);
      {$I+}
      if ioresult <> 0 then exit;
      lib := False;
      sRead := FileSize(F);
(*      {$ENDIF}*)
   end;
   emuAnsiInit;
   FillChar(Buf,3,0);
   Code := 0;
   tRead := 0;
   posUpdate := False;
   mciPad := False;
   mciLimit := 255;
   infMin := False;
   topY := oWhereY;
   sfShowFile := True;

{   Buf[1] := aBuf[1];
   Buf[2] := aBuf[2];
   Buf[3] := aBuf[3];}

   while (ioResult = 0) and (tRead < sRead) and (not Aborted) do {changed by ck}
   begin
(*      {$IFDEF LINUX}
       Read := fdread (f, aBuf, ansiBuf);
      {$ELSE}*)
      {$I-}
{      if lib then BlockRead(tLibFile,aBuf,ansiBuf,Read) else}
                  BlockRead(F,aBuf,ansiBuf,Read);
      {$I+}
(*      {$ENDIF}*)
      Inc(tRead,Read);
      if tRead > sRead then Dec(Read,tRead-sRead);
      for X := 1 to Read do
      begin
         Buf[1] := Buf[2];
         Buf[2] := Buf[3];
         Buf[3] := aBuf[X];
{ --- added by ck for aborting when space is pressed ------------------------------------ }
{ --- end of changes -------------------------------------------------------------------- }
{         if fxStage > 0 then oWriteAnsi(buf[1]) else}

{ ----- added by ck for pcb color codes ----------------------------------------------- }
         if NextIsPcbColorCode and not (Buf[1] = 'X') then NextIsPcbColorCode := false;
         if ((Buf[1] = 'X') and NextIsPcbColorCode) or
{ ----- end of changes ---------------------------------------------------------------- }
            (Buf[1] in [limHeader,padHeader,posHeader,rowHeader,mciHeader,ctrHeader,extHeader,ex2Header]) and
            (UpCase(Buf[2]) in ['A'..'Z','0'..'9','*']) and
            (Code = 0) and (ft <> ftNoCode) then
         begin
            okMci := Buf[1] = extHeader;
            Code := 2;
            Cs := UpStr(Buf[2])+UpStr(Buf[3]);
            case Buf[1] of
              limHeader : begin mciPad := False; mciLimit := StrToInt(Cs); end;
              padHeader : begin mciPad := True;  mciLimit := StrToInt(Cs); end;
{ --- changed by ck for pcboard color codes -------------- }
              'X'       : begin
                            oSetAttr(CS);
                            NextIsPcbColorCode := false;
                          end;
              posHeader : begin
                           if Cs[1] = 'X' then
                            begin
                            NextIsPcbColorCode := true;
                            end else oPosX(strToInt(Cs));
                          end;
{ --- end of changes ------------------------------------- }
              rowHeader : oPosY(strToInt(Cs));
              mciHeader : if mciProcessMCICode(Buf) then
                          begin;
                          mciParams := '';
                          if aBuf[X+1] = '(' then
                           begin;
                           i := X+2;
                           ValidMciParams := true;
                           while (i < Read) and (aBuf[i] <> ')') do
                             begin;
                             if aBuf[i] = '(' then
                               begin;
                               ValidMciParams := false;
                               break;
                               end else
                                mciParams := mciParams + aBuf[i];
                             inc(i,1);
                             end;
                           ValidMciParams := ValidMciParams and (aBuf[i] = ')');
                           if ValidMciParams then
                             X := i else
                             mciParams := '';
                           end;
                          if length(mciParams) > 0 then
                           mciString := mciProcessParams(mciString,mciParams);
                          sfWriteStr(mciString);
                          end else
                          begin
                             oWriteAnsi(Buf[1]);
                             Code := 0;
                          end;

              ctrHeader : if cs = '**' then
                          begin
                             ex := oWhereX;
                             ey := oWhereY;
                             ec := col;
                          end else
                          if (isrip) or (not mciProcessControlCode(Buf)) then
                          begin
                             oWriteAnsi(Buf[1]);
                             Code := 0;
                          end;
              ex2Header : if (Cs[1] in ['0'..'9']) and (Cs[2] in ['0'..'9']) then sfSetPos2(strToInt(Cs));
              extHeader :
           begin;
           mciParams := '';
           if aBuf[X+1] = '(' then
           begin;
           i := X+2;
           ValidMciParams := true;
           while (i < Read) and (aBuf[i] <> ')') do
            begin;
            if aBuf[i] = '(' then
             begin;
             ValidMciParams := false;
             break;
             end else
             mciParams := mciParams + aBuf[i];
            inc(i,1);
            end;
           ValidMciParams := ValidMciParams and (aBuf[i] = ')');
           if ValidMciParams then
             X := i else
             mciParams := '';
           end;

           case ft of
             ftLightBar : if Cs = 'HP' then sfSetPos(maxPos-1) else
                          if (Cs[1] in ['0'..'9']) and (Cs[2] in ['0'..'9']) then sfSetPos(strToInt(Cs));
           ftUserConfig : if Cs = '**' then sfSetPos(maxPos-1) else
                          if Cs = '*A' then sfSetPos(maxPos-2) else
                          if (Cs[1] in ['A'..'Z']) then
                          begin
                             userCfg[Cs[1]] := UpCase(Cs[2]);
                             sfSetPos(Ord(Cs[1])-64);
                          end;
                ftLogin : case Cs[1] of
                       'L' : case Cs[2] of
                         'N' : sfSetPos(1);
                         'P' : sfSetPos(2);
                         'I' : sfSetPos(3);
                         'H' : sfSetPos(4);
                       end;
                    end;
              ftFsHeader : if Cs = 'MT' then sfSetPos(1) else
                           if Cs = 'SN' then sfSetPos(2) else
                           if Cs = 'RN' then sfSetPos(3) else
                           if Cs = 'DT' then sfSetPos(4) else
                           if Cs = 'TI' then sfSetPos(5) else
                           if Cs = 'CM' then sfSetPos(6) else
                           if Cs = 'TL' then sfSetPos(7) else
                           if Cs = 'BL' then sfSetPos(8) else
                           if Cs = 'AN' then sfSetPos(9) else
                           if Cs = 'AS' then sfSetPos(10) else
                           if Cs = 'IN' then sfSetPos(11) else
                           if Cs = 'LN' then sfSetPos(12) else
                           if Cs = 'CN' then sfSetPos(13) else
                           if Cs = 'SL' then sfSetPos(14);
               ftTopLine : if Cs = 'TL' then sfSetPos(1) else
                           if Cs = 'TC' then TwoColumnList := true;
             ftMsgHeader : if Cs = 'TI' then sfWrite(1) else
                           if Cs = 'DT' then sfWrite(2) else
                           if Cs = 'SN' then sfWrite(3) else
                           if Cs = 'RN' then sfWrite(4) else
                           if Cs = 'MT' then sfWrite(5) else
                           if Cs = 'MN' then sfWrite(6) else
                           if Cs = 'MA' then sfWrite(7) else
                           if Cs = 'RP' then sfWrite(8) else
                           if Cs = 'ST' then sfWrite(9) else
                           if Cs = 'UN' then sfWrite(10) else
                           if Cs = 'TL' then sfSetPos(11);
               end;
              end;
              else begin oWriteAnsi(Buf[1]); okMci := False; end;
            end;
         end else if Code = 0 then oWriteAnsi(Buf[1]) else Dec(Code);
{         Buf[1] := Buf[2];
         Buf[2] := Buf[3];
         Buf[3] := aBuf[X];}
      end;
   end;
   if Code = 0 then oWriteAnsi(Buf[2]) else Dec(Code);
   if (Code = 0) and (Buf[3] <> #26) then oWriteAnsi(Buf[3]);
   if ex <> 0 then
   begin
      oGotoXY(ex,ey);
      oSetColRec(ec);
   end;
   ioUpdatePos;
{  if not Lib then Close(F);
   sfSetPos(maxPos);
   Read := oWhereY-topy;
   if read < 1 then ansiRows := 0 else ansiRows := read; }

   if not Lib then(* {$IFDEF LINUX} fdclose(f); {$ELSE}*) Close(F);(*{$ENDIF}*)
   sfSetPos(maxPos);
   Read := oWhereY;
   if Read < topY then topY := 1;
   Read := {oWhereY-topy} Read-topY+1;
   if Read < 0 then Read := 0;
   ansiRows := Read;

   if ft <> ftNoCode then FillChar(sfStr,SizeOf(sfStr),0);
{   intextfx := false;}
   if Aborted then oPromptKey;

end;

function sfShowTextFile(Fn : String; Ft : Byte) : Boolean;
var fz : Word; f2:string;
begin
   sfshowfile(fn,ft);
end;

function sfLoadRepeat(Fn : String) : Boolean;
var Z : LongInt; fz : Word; F : file; lib : boolean;
begin
   sfLoadRepeat := False;
   repSize := 0;
   Fn := sfGetTextFile(Fn,0);
   if Fn = '' then Exit;
   if not sfExists(Fn,fz) then Exit;
{   if fz > 0 then
   begin
      Seek(tLibFile,textLib^.tIndex^[fz].filePos);
      Z := textLib^.tIndex^[fz].fileSize;
      lib := True;
   end else}
   begin
      Assign(F,Fn);
      {$I-}
      Reset(F,1);
      {$I+}
      if ioResult <> 0 then Exit;
      Z := FileSize(F);
      lib := False;
   end;
   if Z > maxRepeatBuf then Z := maxRepeatBuf;
   if Z = 0 then Exit;
   GetMem(repAnsi,Z);
   repSize := Z;
   {$I-}
{   if lib then BlockRead(tLibFile,repAnsi^,Z) else}
               BlockRead(F,repAnsi^,Z);
   {$I+}
   if not lib then Close(F);
   sfLoadRepeat := repSize > 0;
end;

procedure sfKillRepeat;
begin
   if repSize > 0 then FreeMem(repAnsi,repSize);
end;

function sfShowRepeat(Ft : Byte) : Boolean;
var Buf : array[1..3] of Char; X : Word;
    Code, topY, ex, ey : Byte; ec : tColorRec;
    Cs : String;
    okMci : Boolean;

    i         : integer;

begin
   sfShowRepeat := False;
   if repSize < 1 then Exit;
   emuANSIinit;
   FillChar(Buf,3,0);
   Code := 0;
   ex := 0;
   posUpdate := False;
   mciPad := False;
   mciLimit := 255;
   mciParams := '';
   for X := 1 to repSize do
   begin
      Move(Buf[2],Buf[1],2);
      Buf[3] := repAnsi^[X];
      if Buf[1] <> #0 then
      if ((Buf[1] in [limHeader,padHeader,posHeader,rowHeader,mciHeader,ctrHeader,extHeader]) or
         ((Buf[1] = 'X') and NextIsPcbColorCode)) and
         (UpCase(Buf[2]) in ['A'..'Z','0'..'9','*']) then
      begin
         okMci := Buf[1] = extHeader;
         Code := 2;
         Cs := UpStr(Buf[2])+UpStr(Buf[3]);
         case Buf[1] of
           limHeader : begin mciPad := False; mciLimit := StrToInt(Cs); end;
           padHeader : begin mciPad := True;  mciLimit := StrToInt(Cs); end;
           'X'       : if NextIsPcbColorCode then
                       begin;
                       oSetAttr(CS);
                       NextIsPcbColorCode := false;
                       end else begin oWriteANSi(Buf[1]); okMci := False; end;
           posHeader : begin;
                       if Cs[1] = 'X' then NextIsPcbColorCode := true
                       else oPosX(strToInt(Cs));
                       end;
           rowHeader : oPosY(strToInt(Cs));
           mciHeader : begin;
                       mciParams := '';
                       if repAnsi^[X+1] = '(' then
                       begin;
                        i := X+2;
                        ValidMciParams := true;
                        while (i < repSize) and (repAnsi^[i] <> ')') do
                         begin;
                         if repAnsi^[i] = '(' then
                         begin;
                           ValidMciParams := false;
                           break;
                         end else
                         mciParams := mciParams + repAnsi^[i];
                         inc(i,1);
                         end;
                         ValidMciParams := ValidMciParams and (repAnsi^[i] = ')');
                         if ValidMciParams then
                          X := i else
                          mciParams := '';
                       end;
                       if mciProcessMCICode(Buf) then sfWriteStr(mciString) else
                       begin oWriteANSi(Buf[1]); Code := 0; end;
                       end;
{           ctrHeader : if copy(buf,2,2) = '**' then
                       begin ec := col; ex := oWhereX; ey := oWhereY; end else
                       if not mciProcessControlCode(Buf) then
                       begin oWriteANSi(Buf[1]); Code := 0; end;}
           extHeader :
           begin;
           mciParams := '';
           if repAnsi^[X+1] = '(' then
           begin;
           i := X+2;
           ValidMciParams := true;
           while (i < repSize) and (repAnsi^[i] <> ')') do
            begin;
            if repAnsi^[i] = '(' then
             begin;
             ValidMciParams := false;
             break;
             end else
             mciParams := mciParams + repAnsi^[i];
            inc(i,1);
            end;
           ValidMciParams := ValidMciParams and (repAnsi^[i] = ')');
           if ValidMciParams then
             X := i else
             mciParams := '';
           end;
            case Ft of
               ftBBSlist : if Cs = 'BN' then sfWrite(1) else
                           if Cs = 'PN' then sfWrite(2) else
                           if Cs = 'SN' then sfWrite(3) else
                           if Cs = 'BR' then sfWrite(4) else
                           if Cs = 'SF' then sfWrite(5) else
                           if Cs = 'ST' then sfWrite(6) else
                           if Cs = 'IN' then sfWrite(7) else
                           if Cs = 'NM' then sfWrite(8);
             ftLastCalls : if Cs = 'CN' then sfWrite(1) else
                           if Cs = 'UN' then sfWrite(2) else
                           if Cs = 'NM' then sfWrite(3) else
                           if Cs = 'LO' then sfWrite(4) else
                           if Cs = 'BR' then sfWrite(5) else
                           if Cs = 'DT' then sfWrite(6) else
                           if Cs = 'TI' then sfWrite(7) else
                           if Cs = 'NU' then sfWrite(8) else
                           if Cs = 'AC' then sfWrite(9);
              ftUserList : if Cs = 'ID' then sfWrite(1) else
                           if Cs = 'UN' then sfWrite(2) else
                           if Cs = 'RN' then sfWrite(3) else
                           if Cs = 'LC' then sfWrite(4) else
                           if Cs = 'UC' then sfWrite(5) else
                           if Cs = 'SL' then sfWrite(6) else
                           if Cs = 'DS' then sfWrite(7) else
                           if Cs = 'NT' then sfWrite(8) else
                           if Cs = 'LO' then sfWrite(9) else
                           if Cs = 'BR' then sfWrite(10) else
                           if Cs = 'SX' then sfWrite(11) else
                           if Cs = 'AC' then sfWrite(12);
             ftListMarea : if Cs = 'AT' then sfWrite(1) else
                           if Cs = 'AN' then sfWrite(2) else
                           if Cs = 'NM' then sfWrite(3) else
                           if Cs = 'SP' then sfWrite(4) else
                           if Cs = 'T2' then sfWrite(5) else
                           if Cs = 'N2' then sfWrite(6) else
                           if Cs = 'M2' then sfWrite(7) else
                           if Cs = 'P2' then sfWrite(8);
             ftListFarea : if Cs = 'AT' then sfWrite(1) else
                           if Cs = 'AN' then sfWrite(2) else
                           if Cs = 'NF' then sfWrite(3) else
                           if Cs = 'SP' then sfWrite(4) else
                           if Cs = 'T2' then sfWrite(5) else
                           if Cs = 'N2' then sfWrite(6) else
                           if Cs = 'F2' then sfWrite(7) else
                           if Cs = 'P2' then sfWrite(8);
              ftListMail : if Cs = 'MT' then sfWrite(1) else
                           if Cs = 'SN' then sfWrite(2) else
                           if Cs = 'RN' then sfWrite(3) else
                           if Cs = 'TI' then sfWrite(4) else
                           if Cs = 'DT' then sfWrite(5) else
                           if Cs = 'MN' then sfWrite(6);
               ftListMsg : if Cs = 'MN' then sfWrite(1) else
                           if Cs = 'SN' then sfWrite(2) else
                           if Cs = 'RN' then sfWrite(3) else
                           if Cs = 'TI' then sfWrite(4) else
                           if Cs = 'DT' then sfWrite(5) else
                           if Cs = 'MT' then sfWrite(6);
              ftListProt : if Cs = 'KY' then sfWrite(1) else
                           if Cs = 'PN' then sfWrite(2) else
                           if Cs = 'PT' then sfWrite(3) else
                           if Cs = 'NM' then sfWrite(4);
                  ftConf : if Cs = 'CK' then sfWrite(1) else
                           if Cs = 'CN' then sfWrite(2);
              ftArchiver : if Cs = 'NM' then sfWrite(1) else
                           if Cs = 'FN' then sfWrite(2) else
                           if Cs = 'SU' then sfWrite(3) else
                           if Cs = 'SC' then sfWrite(4) else
                           if Cs = 'RA' then sfWrite(5) else
                           if Cs = 'CM' then sfWrite(6) else
                           if Cs = 'DT' then sfWrite(7) else
                           if Cs = 'TI' then sfWrite(8);
              ftNodeList : if Cs = 'ND' then sfWrite(1) else
                           if Cs = 'UN' then sfWrite(2) else
                           if Cs = 'RN' then sfWrite(3) else
                           if Cs = 'ID' then sfWrite(4) else
                           if Cs = 'BR' then sfWrite(5) else
                           if Cs = 'TO' then sfWrite(6) else
                           if Cs = 'ST' then sfWrite(7) else
                           if Cs = 'SX' then sfWrite(8) else
                           if Cs = 'AG' then sfWrite(9);
               ftHiScore : if Cs = 'NM' then sfWrite(1) else
                           if Cs = 'UN' then sfWrite(2) else
                           if Cs = 'LV' then sfWrite(3) else
                           if Cs = 'LN' then sfWrite(4) else
                           if Cs = 'SC' then sfWrite(5);
               ftHistory : if Cs = 'DT' then sfWrite(1) else
                           if Cs = 'CA' then sfWrite(2) else
                           if Cs = 'NU' then sfWrite(3) else
                           if Cs = 'PO' then sfWrite(4) else
                           if Cs = 'EM' then sfWrite(5) else
                           if Cs = 'UL' then sfWrite(6) else
                           if Cs = 'DL' then sfWrite(7) else
                           if Cs = 'UK' then sfWrite(8) else
                           if Cs = 'DK' then sfWrite(9);
              ftInfoList : if Cs = 'NM' then sfWrite(1) else
                           if Cs = 'DS' then sfWrite(2) else
                           if Cs = 'ST' then sfWrite(3) else
                           if Cs = 'CP' then sfWrite(4);
               ftCmdHelp : if Cs = 'KY' then sfWrite(1) else
                           if Cs = 'HL' then sfWrite(2) else
                           if Cs = 'DS' then sfWrite(3);
       ftVotingQuestions : if Cs = 'QN' then sfWrite(1) else
                           if Cs = 'QD' then sfWrite(2);
         ftVotingAnswers : if Cs = 'AN' then sfWrite(1) else
                           if Cs = 'AD' then sfWrite(2) else
                           if Cs = 'AR' then sfWrite(3) else
                           if Cs = 'AP' then sfWrite(4);
                  else begin oWriteANSi(Buf[1]); okMci := False; end;
           end;
                       end;
         end;
      end else if Code = 0 then oWriteANSi(Buf[1]) else Dec(Code);
   end;
   if Code = 0 then oWriteANSi(Buf[2]) else Dec(Code);
   if (Code = 0) and (Buf[3] <> #26) then oWriteANSi(Buf[3]);
   if ex <> 0 then
   begin
      oGotoXY(ex,ey);
      oSetColRec(ec);
   end;
   ioUpdatePos;
   sfShowRepeat := True;
end;

end.
