program MsgAConv;

{$M 32768, 0, 655360}

uses MkOpen, MkMsgAbs, MkMsgJam, Crt, Global;

var
    DeleteAfter : boolean;
    Email       : boolean;

function UpStr(s:string): string;
var
  ns : string;
  i : integer;
begin
  for i := 1 to length(s) do
    ns[i] := upcase(s[i]);
  ns[0] := s[0];  { copy the length byte }
  UpStr := ns;
end;

function IntToStr(I:longint):string;
var s:string;
begin;
Str(I,s);
IntTostr:=s;
end;

function StrToInt(s:string):longint;
var code:integer;
    i:longint;
begin;
Val(S,i,Code);
StrToInt:=i;
end;

PROCEDURE WritePipe(InStr: string);
VAR
   S : String Absolute InStr;
   I,
   Err : Integer;
   Col : byte;

BEGIN
   I := 1;
   REPEAT
      IF (S[I] = '|') THEN
       BEGIN
          Val(COPY(S,I+1,2),Col,Err);
          IF (Err = 0) AND (Col IN [0..22]) THEN
             IF Col IN [0..15] THEN TextColor(Col)
             ELSE IF Col IN [16..22] THEN TextBackground(Col - 16);
          Inc(I,2);
       END
      ELSE
       Write(S[I]);
      Inc(I);
   UNTIL (I > Length(S));
END;

function maReadStr(var F : file) : String;
var C : Char; Len : Byte; S : String;
begin
   S := '';
   BlockRead(F,C,1);
   Len := Ord(C);
   S[0] := Chr(Len);
   BlockRead(F,S[1],Len);
   maReadStr := S;
end;

function maLoadMessage(var Mr : tMessage; var Head : tMsgHeaderRec; M : Word; mArea : tMsgAreaRec) : Boolean;
var F : file; HF : file of tMsgHeaderRec; N, s : Word;
begin
   maLoadMessage := False;
   Assign(HF,Cfg^.pathMsgs+mArea.Filename+extMsgHead);
   Assign(F,Cfg^.pathMsgs+mArea.Filename+extMsgData);
   {$I-}
   Reset(HF);
   {$I+}
   if ioResult <> 0 then Exit;
   if M > FileSize(HF) then
   begin
      Close(HF);
      Exit;
   end;
   Seek(HF,M-1);
   Read(HF,Head);
   Close(HF);
   {$I-}
   Reset(F,1);
   {$I+}
   if ioResult <> 0 then Exit;
   if Head.Pos > FileSize(F) then
   begin
      Close(F);
      Exit;
   end;
   Seek(F,Head.Pos-1);
   FillChar(Mr,SizeOf(Mr),0);
   s := Head.Size;
   if s > maxMsgLines then s := maxMsgLines;
   Head.Size := s;
   for N := 1 to s do Mr[N] := maReadStr(F);
   Close(F);
   maLoadMessage := True;
end;

procedure DeleteOldFiles(A : tMsgAreaRec);
 procedure DeleteFile(filename : string);
 var f : file;
 begin;
  assign(f, filename);
  {$I-}
  reset(f);
  {$I+}
  if ioResult = 0 then
   begin;
    close(f);
    erase(f);
   end;
 end;

begin;
gotoxy(1,wherey); ClrEol;
WritePipe('|07:|15d|12e|04lete old files|08: '+A.Name);
DeleteFile(cfg^.pathMsgs+A.FileName+extMsgData);
DeleteFile(cfg^.pathMsgs+A.FileName+extMsgHead);
DeleteFile(cfg^.pathMsgs+A.FileName+extMsgScan);
end;

(*procedure UpdatePointers(ma : AbsMsgPtr; A : tMsgAreaRec);
var f : file of tUserRec;
    NumUsers : Integer;
    i        : integer;
    sf       : file of tScanRec;
    scanRec  : tScanRec;
    PercentDone : integer;
begin;
assign(f,cfg.pathData+'users.dat');
reset(f);
NumUsers := fileSize(f) - 1;
close(f);

Assign(sf,Cfg.pathMsgs+A.Filename+extMsgScan);
{$I-}
Reset(sf);
{$I+}
if ioResult <> 0 then Exit;

for i := 1 to NumUsers do
 begin;
  Seek(sf,i-1);
  read(sf,scanRec);
  ma^.SetLastReadDate(i,scanRec.ptrMsg);
  if NumUsers = 0 then
   PercentDone := 0 else
   PercentDone := (i * 100) div NumUsers;
  gotoxy(1,wherey);
  WritePipe('|07:|15l|10a|02st read pointers|08: '+A.Name+
            ' |01(|09'+IntToStr(PercentDone)+'%|01)');
  end;
Close(sf);
end;*)

{procedure ConvertArea(A : tMsgAreaRec);
var Msg : tMessage;
    ma  : AbsMsgPtr;
    i,j : integer;
    Head: tMsgHeaderRec;
    MsgAreaId : string;
    PercentDone : integer;

begin;
MsgAreaId := 'J' + Cfg.pathMsgs + A.FileName;
if OpenOrCreateMsgArea(ma,MsgAreaId) then
 begin;
  for i := 1 to A.Msgs do
   begin;
   if maLoadMessage(Msg,Head,i,A) then
    begin;
     ma^.StartNewMsg;
     ma^.SetHeader(Head);
     ma^.SetMailType(mmtEchomail);
     ma^.SetEcho(true);
     ma^.SetRcvd(true);
     ma^.SetLocal(false);
     ma^.SetSent(true);
     if Head.Size > 0 then
      begin;
       for j := 1 to Head.Size do
        ma^.DoStringLn(Msg[j]);
       ma^.WriteMsg;
      end;
    end;
   if A.Msgs = 0 then
    PercentDone := 0 else
    PercentDone := (i * 100) div A.Msgs;
   gotoxy(1,wherey);
   WritePipe('|07:|15i|09n|01iq -> jam|08: '+A.Name+' |01(|09'+IntToStr(PercentDone)+'%|01)');
   end;
  if (not Email) then
   UpdatePointers(ma,A);
  DeleteOldFiles(A);
  gotoxy(1,wherey); ClrEol;
  WritePipe('|07:|15c|13o|05nverted|08: '+A.Name);
  CloseMsgArea(ma);
 end;
end;}

procedure ConvertArea(var mArea : tMsgAreaRec; OldFormat : Word);
var MsgAreaId : string;
    OldMa,
    NewMa     : AbsMsgPtr;
    i         : Integer;
    Head      : tMsgHeaderRec;
    s         : string;

begin;
 if mArea.AreaFormat <> 1 then mArea.AreaFormat := 2;
 if mArea.AreaFormat = OldFormat then Exit;
 case OldFormat of
  1 :  MsgAreaId := 'I';
  else MsgAreaId := 'J';
  end;
 MsgAreaId := MsgAreaId + cfg^.pathMsgs + mArea.FileName;

 if OpenOrCreateMsgArea(OldMa,MsgAreaId) then
  begin;
   MsgAreaId := GetMsgAreaId(mArea);
   if OpenOrCreateMsgArea(NewMa,MsgAreaId) then
    begin;
     mArea.Msgs := OldMa^.GetHighMsgNum;
     for i := 1 to mArea.Msgs do
      begin;
       OldMa^.SeekFirst(i);
       if OldMa^.SeekFound then
        begin;
         OldMa^.MsgStartup;
         OldMa^.MsgTxtStartUp;
         NewMa^.StartNewMsg;
         OldMa^.GetHeader(Head); NewMa^.SetHeader(Head);
{         NewMa^.SetMailType(mmtEchomail);
         NewMa^.SetEcho(true);
         NewMa^.SetRcvd(true);
         NewMa^.SetLocal(false);
         NewMa^.SetSent(true);}
         s := OldMa^.GetString(255);
         while (not OldMa^.EOM) do
          begin;
           NewMa^.DoStringLn(s);
           s := OldMa^.GetString(255);
          end;
        NewMa^.DoStringLn(s);
        NewMa^.WriteMsg;
        end;
      end;
     for i := 1 to numUsers do
      NewMa^.SetLastRead(i,OldMa^.GetLastRead(i));
     OldMa^.CloseMsgBase;
     OldMa^.DeleteMsgBase;
     DoneMsgPtr(OldMa);
     CloseMsgArea(NewMa);
    end;
   end;
end;


const DefaultFormat = 1;

var CfgFile : file of tCfgRec;
    maFile  : file of tMsgAreaRec;
    A       : tMsgAreaRec;
    ConvertToJAM : boolean;
    ConvertToIniq: boolean;
    i            : integer;
    UserFile     : file of tUserRec;

 procedure ConvertAreas;
 var OldFormat : Integer;
  begin;
  for i := 1 to fileSize(maFile) do
   begin;
    if keypressed then if readkey = #27 then halt(1);
    seek(maFile,i-1);
    read(maFile,A);
    OldFormat := A.AreaFormat;
    A.AreaFormat := DefaultFormat;
    if ConvertToJam then
     begin;
      A.AreaFormat := 2;
      WritePipe('|07:|15i|09n|01iq -> jam|08: '+A.Name);
      ConvertArea(A,OldFormat);
      gotoxy(1,wherey); clreol;
     end else
    if ConvertToIniq then
     begin;
      A.AreaFormat := 1;
      WritePipe('|07:|15j|09a|01m -> iniq|08: '+A.Name);
      ConvertArea(A,OldFormat);
      gotoxy(1,wherey); clreol;
     end;
    seek(maFile,i-1);
    write(maFile,A);
    WritePipe('|07:|15c|13o|05nverted|08: '+A.Name+#13#10);
   end;
  end;

begin;
Clrscr;
ConvertToJam := false;
WritePipe('|15Convert iniquity msg areas list to 1.00a27 format - |07by ck(idt)'#13#10);
WritePipe('|09|01|09|01|09|01|08|01|08|01|08'+
          ''#13#10);

if UpStr(ParamStr(1)) = 'JAM' then
 ConvertToJam := true else
if UpStr(ParamStr(1)) = 'INIQ' then
 ConvertToIniq := true;

assign(CfgFile,'iniquity.dat');
{$I-}
reset(CfgFile);
{$I+}

if (ioResult <> 0) then
 begin;
   WritePipe('|15iniquity.dat |07not found in current directory'#13#10);
   halt(1);
 end;
new(cfg);
read(CfgFile,Cfg^);
close(CfgFile);

assign(UserFile,cfg^.pathData+'users.dat');
reset(UserFile);
NumUsers := fileSize(UserFile) - 1;
close(UserFile);

assign(maFile,Cfg^.pathData+'email.dat'); reset(maFile); Email := true;
ConvertAreas;
close(maFile);

assign(maFile,Cfg^.pathData+'msgarea.dat'); reset(maFile); Email := false;
ConvertAreas;
close(maFile);

dispose(cfg);
end.