{$IFDEF OVERLAY} {$O+} {$ENDIF}
unit MCIcodes;

{ ck - added code for mci parameters }

interface

function mciProcess(S : String; Len : Byte) : String;
function mciProcessControlCode(C : String) : Boolean;
function mciProcessMCICode(C : String) : Boolean;
function mciProcessParams(s,Params : String) : String;

implementation

uses
   Crt, Global, Output, StrProc, Misc, DateTime, Input;

function mciProcessControlCode(C : String) : Boolean;
begin
   mciProcessControlCode := False;
   if (Length(C) <> 3) or (C[1] <> ctrHeader) then Exit;
   Delete(C,1,1);
   C := UpStr(C);
   mciProcessControlCode := True;
   case C[1] of
     '0' : case C[2] of
             '0' : oSetFore(0);
             '1' : oSetFore(1);
             '2' : oSetFore(2);
             '3' : oSetFore(3);
             '4' : oSetFore(4);
             '5' : oSetFore(5);
             '6' : oSetFore(6);
             '7' : oSetFore(7);
             '8' : oSetFore(8);
             '9' : oSetFore(9);
           end;
     '1' : case C[2] of
             '0' : oSetFore(10);
             '1' : oSetFore(11);
             '2' : oSetFore(12);
             '3' : oSetFore(13);
             '4' : oSetFore(14);
             '5' : oSetFore(15);
             '6' : oSetBack(0);
             '7' : oSetBack(1);
             '8' : oSetBack(2);
             '9' : oSetBack(3);
           end;
     '2' : case C[2] of
             '0' : oSetBack(4);
             '1' : oSetBack(5);
             '2' : oSetBack(6);
             '3' : oSetBack(7);
           end;
     'A' : case C[2] of
              'S' : saveCol := Col;
              'L' : oSetColRec(saveCol);
{              'D' : EnableAnsiAborting := false;}
           end;
     'B' : case C[2] of
             '0' : oSetBack(0);
             '1' : oSetBack(1);
             '2' : oSetBack(2);
             '3' : oSetBack(3);
             '4' : oSetBack(4);
             '5' : oSetBack(5);
             '6' : oSetBack(6);
             '7' : oSetBack(7);
           end;
     'C' : case C[2] of
              'B' : oMoveDown(25);
              'D' : oMoveDown(1);
              'E' : oMoveRight(80);
        {      'H' : oMoveLeft(80);}
              'L' : oMoveLeft(1);
              'R' : oMoveRight(1);
              'S' : oClrScr;
              'T' : oMoveUp(25);
              'U' : oMoveUp(1);
              'Z' : oClrEol;
           end;
     'D' : case C[2] of
              'E' : Delay(750);
              'H' : Delay(500);
              'M' : Delay(100);
              'S' : Delay(1000);
           end;
     'H' : case C[2] of
              'C' : oGotoXY(1,1);
           end;
     'L' : case C[2] of
              'C' : oRestoreCursor;
              'F' : oWrite(#13#10);
           end;
     'P' : case C[2] of
              'A' : oPromptKey;
              'K' : iReadKey;
              'S' : oPause;
           end;
     'S' : case C[2] of
              'C' : oSaveCursor;
           end;
     'U' : case C[2] of
              '0' : oSetCol(colError);
              '1' : oSetCol(colText);
              '2' : oSetCol(colTextLo);
              '3' : oSetCol(colTextHi);
              '4' : oSetCol(colInfo);
              '5' : oSetCol(colInfoLo);
              '6' : oSetCol(colInfoHi);
              '7' : oSetCol(colItem);
              '8' : oSetCol(colItemSel);
              '9' : oSetCol(colBorder);
           end;
     else mciProcessControlCode := False;
   end;
end;

function mciProcessMCICode(C : String) : Boolean;
var S : String;
begin
   mciProcessMCIcode := False;
   S := '';
   C := UpStr(C);
   if (Length(C) <> 3) or (C[1] <> mciHeader) then Exit;
   mciProcessMCIcode := True;
   Delete(C,1,1);
   case C[1] of
     'A' : case C[2] of
         '1'..'6' : if User^.AutoSigLns >= StrToInt(C[2]) then
                    S := User^.AutoSig[StrToInt(C[2])] else S := '';
              'L' : S := St(User^.AutoSigLns);
           end;
     'B' : case C[2] of
              'N' : S := Cfg^.BBSname;
           end;
     'D' : case C[2] of
              'T' : S := dtDateString;
           end;
     'E' : case C[2] of
              'M' : S := mEmulation(User^);
           end;
     'I' : case C[2] of
              'D' : S := St(User^.Number);
              'N' : S := bbsTitle;
              'S' : S := inputString;
              'V' : S := bbsVersion;
           end;
     'L' : case C[2] of
              'A' : {if tLibOpen then S := textLib^.Author else }S := 'n/a';
              'C' : S := User^.LastCall;
              'D' : {if tLibOpen then S := textLib^.Desc else} S := 'n/a';
              'O' : S := User^.Location;
           end;
     'M' : case C[2] of
              'A' : S := mArea^.Name;
              'W' : S := St(User^.EmailWaiting);
           end;
     'N' : case C[2] of
              'D' : S := St(node);
           end;
     'P' : case C[2] of
              'A' : {S := true;} opause;

              'L' : S := St(24);
           end;
     'R' : case C[2] of
              'N' : S := User^.RealName;
              'T' : S := ripTerm;
           end;
     'S' : case C[2] of
              'R' : S := Cfg^.SysOpName;
           end;
     'T' : case C[2] of
              'I' : S := dtTimeStr12;
              'L' : S := St(mTimeLeft('M'));
              'M' : S := dtTimeStr24;
              'U' : S := Stc(numUsers);
           end;
     'U' : case C[2] of
              'E' : S := Stc(User^.Email);
              'I' : S := mInitials(User^.Username);
              'N' : S := User^.UserName;
              'O' : S := User^.UserNote;
              'P' : S := Stc(User^.Posts);
           end;
     'V' : case C[2] of
              'L' : S := bbsVerLong;
           end;
    else begin mciProcessMCIcode := False; S := mciHeader+C; end;
   end;
   if S = '' then
    begin;
      mciProcessMCICode := False;
      S := mciHeader+C;
    end;
   mciString := S;
end;

function mciProcess(S : String; Len : Byte) : String;
var Cd : String; N : Byte;
    i : byte;
begin
   mciProcess := '';
   N := 0;
   if S = '' then Exit;
   while N < Length(S) do
   begin
      Inc(N);
      if S[N] = mciHeader then
      begin
         if mciProcessMCICode(Copy(S,N,3)) then
         begin
            Delete(S,N,3);
            if Len <> 0 then mciString := strSquish(mciString,Len);
            Insert(mciString,S,N);
            Dec(N);
         end;
      end;
   end;
   mciProcess := S;
end;

function GetWord(num : byte; s : string) : string;
var i : byte;
    wordnum : byte;
    tempstr : string;
begin;
wordnum := 1;
tempstr := '';

i := 1;
while s[i] = ' ' do inc(i,1);

for i := i to length(s) do
    begin;
    if (s[i]=' ') and(s[i-1]<>' ') then inc(wordnum, 1) else
       if (wordnum = num) and (s[i]<>' ') then tempstr := tempstr + s[i];
    end;
GetWord := tempstr;
end;

function GetNumber(s : string; pos : byte) : string;
var i : byte;
    tempstr : string;
begin;
i := pos;
tempstr := '';

while (s[i] in ['0','1'..'9']) and (i <= length(s)) do
 begin;
 tempstr := tempstr + s[i];
 inc(i,1);
 end;
GetNumber := tempstr;
end;

function mciProcessParams(s,Params : String) : String;
var i : byte;
    CodePos : byte;
    TempStr : String;
    Result  : String;
    Color   : String[2];

    IgnoreColorInsertCodes : boolean;

begin;
i := 1;
Result := s;
IgnoreColorInsertCodes := pos('|',Result) > 0;

repeat
case Params[i] of
     'm' : begin;
           TempStr := GetNumber(params, i+1);
           Result := Resize(Result,StrToInt(TempStr));
           inc(i, length(TempStr));
           end;
     'f' : begin;
           inc(i, 1);
           case params[i] of
                'U': Result := UpStr(Result);
                'l': Result := strLow(Result);
                'C': Result := strMixed(Result);
                'w': Result := strWierd(Result);
                '3': Result := str31337(Result);
                end;
            inc(i,1);
           end;
     'c' : begin;
            CodePos := 1;
            repeat
             color := GetNumber(params, i+1);
             inc(i, length(color)+1);
             if length(color) = 1 then color := '0' + color;
             if not IgnoreColorInsertCodes then
              insert('|'+color,Result,CodePos);
             inc(CodePos,4);
            until (params[i] <> ',') or (i > length(params));
           end;
     'w' : begin;
           TempStr := GetNumber(params, i+1);
           Result := GetWord(StrToInt(TempStr), Result);
           inc(i, length(tempstr));
           end;
     else; inc(i, 1);
     end;
until (i>=length(params));

mciProcessParams := Result;
end;

end.
