/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.string;

/**
 * Gives the ability to alter the state of a {@link org.ckkloverdos.string.IToStringAware}
 * implementation, just before the {@link org.ckkloverdos.string.IToStringAware#toStringAware(ToString)}
 * call is performed. The state is automatically restored by {@link org.ckkloverdos.string.ToString}, so
 * that you do not have to use {@link ToString#save()}/{@link org.ckkloverdos.string.ToString#restore(ToString)}
 * in your client code.
 *
 * <p/>
 * For example, when we want to ensure that our instance will be printed in a single line, no matter what
 * the multiline state of the running {@link org.ckkloverdos.string.ToString} instance is, then we should
 * implement <code>IPrepareToStringAware</code> like this:
 * <pre>
 * public void prepareToStringAware(ToString ts)
 * {
 *   ts.setSingleline();
 * }
 * </pre>
 * @author Christos KK Loverdos
 */
public interface IPrepareToStringAware extends IToStringAware
{
    public void prepareToStringAware(ToString ts);
}
