/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.resource;

/**
 * Represents a context where resources may live. Class loaders and file systems
 * provide two such (overlapping actually) contexts.
 *
 * <p/>
 * Contexts may form hierarchies (trees), as designated by the {@link #getParent()}
 * method. Resources are first resolved locally in a context, and if not found then
 * the parent context is consulted.
 * 
 * @author Christos KK Loverdos
 * @see org.ckkloverdos.resource.FileResourceContext
 * @see org.ckkloverdos.resource.ClassLoaderResourceContext
 */
public interface IResourceContext
{
    /**
     * Returns the parent context.
     */
    public IResourceContext getParent();

    /**
     * Returns the resource with the given name or null if not found either in this context
     * or in the parent context.
     * @param name
     * @return the resource if found or {@link org.ckkloverdos.resource.EmptyResource#INSTANCE} otherwise.
     */
    public IResource getResource(String name);

    /**
     * Returns the resource with the given name that lives in this context, without consulting
     * the parent context on failure.
     * @param name
     * @return the resource if found or {@link org.ckkloverdos.resource.EmptyResource#INSTANCE} otherwise.
     */
    public IResource getLocalResource(String name);
}